/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.slg.ros2.transformers.stimuli;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.model.InterProcessStimulus;
import org.eclipse.app4mc.slg.commons.m2t.transformers.SLGTranslationUnit;
import org.eclipse.app4mc.slg.ros2.generators.RosInterProcessStimulusGenerator;
import org.eclipse.app4mc.slg.ros2.transformers.RosBaseTransformer;
import org.eclipse.app4mc.slg.ros2.transformers.utils.Utils;
import org.eclipse.app4mc.transformation.util.OutputBuffer;

@Singleton
public class RosInterProcessStimulusTransformer
extends RosBaseTransformer {
    @Inject
    private OutputBuffer outputBuffer;
    private final Map<List<Object>, SLGTranslationUnit> transformCache = new HashMap<List<Object>, SLGTranslationUnit>();

    @Override
    public Map<List<Object>, SLGTranslationUnit> getCache() {
        return this.transformCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SLGTranslationUnit transform(InterProcessStimulus stimulus) {
        SLGTranslationUnit tu;
        ArrayList<InterProcessStimulus> key = new ArrayList<InterProcessStimulus>(Arrays.asList(stimulus));
        Map<List<Object>, SLGTranslationUnit> map = this.transformCache;
        synchronized (map) {
            if (this.transformCache.containsKey(key)) {
                return this.transformCache.get(key);
            }
            tu = this.createTranslationUnit(stimulus);
            this.transformCache.put(key, tu);
        }
        if (tu.isValid()) {
            this.doTransform(tu);
        }
        return tu;
    }

    private SLGTranslationUnit createTranslationUnit(InterProcessStimulus stimulus) {
        if (stimulus == null) {
            return new SLGTranslationUnit("UNSPECIFIED INTER PROCESS STIMULUS");
        }
        String basePath = "services";
        String moduleName = String.valueOf(stimulus.getName()) + "_service";
        String call = "";
        return new SLGTranslationUnit(basePath, moduleName, call);
    }

    @Override
    public String getSrcFile(SLGTranslationUnit tu) {
        return String.valueOf(Utils.toIdlCompliantName(tu.getModuleName())) + ".srv";
    }

    @Override
    public String getSrcPath(SLGTranslationUnit tu) {
        return String.valueOf(tu.getModulePath()) + "/srv/" + this.getSrcFile(tu);
    }

    @Override
    public boolean srcAppend(SLGTranslationUnit tu, String str) {
        return this.outputBuffer.appendTo("OTHER", this.getSrcPath(tu), str);
    }

    private void doTransform(SLGTranslationUnit tu) {
        this.genFiles(tu);
    }

    private void genFiles(SLGTranslationUnit tu) {
        this.srcAppend(tu, RosInterProcessStimulusGenerator.toSrvFile());
        this.outputBuffer.appendTo("OTHER", String.valueOf(tu.getModulePath()) + "/CMakeLists.txt", RosInterProcessStimulusGenerator.toCMake());
        this.outputBuffer.appendTo("OTHER", String.valueOf(tu.getModulePath()) + "/package.xml", RosInterProcessStimulusGenerator.toPackageXML(tu.getModuleName()));
    }
}

