/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.slg.ros2.transformers.sw;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import org.eclipse.app4mc.amalthea.model.ActivityGraphItem;
import org.eclipse.app4mc.amalthea.model.Group;
import org.eclipse.app4mc.amalthea.model.ITaggable;
import org.eclipse.app4mc.amalthea.model.InterProcessStimulus;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableCall;
import org.eclipse.app4mc.amalthea.model.Stimulus;
import org.eclipse.app4mc.amalthea.model.Tag;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.slg.commons.m2t.transformers.SLGTranslationUnit;
import org.eclipse.app4mc.slg.commons.m2t.transformers.sw.TaskTransformer;
import org.eclipse.app4mc.slg.ros2.generators.RosLabelGenerator;
import org.eclipse.app4mc.slg.ros2.transformers.stimuli.RosInterProcessStimulusTransformer;
import org.eclipse.app4mc.slg.ros2.transformers.sw.RosLabelTransformer;
import org.eclipse.app4mc.slg.ros2.transformers.sw.RosRunnableCache;
import org.eclipse.app4mc.slg.ros2.transformers.sw.RosRunnableTransformer;
import org.eclipse.app4mc.slg.ros2.transformers.sw.RosTaskCache;

@Singleton
public class RosTaskTransformer
extends TaskTransformer {
    @Inject
    private RosLabelTransformer rosLabelTransformer;
    @Inject
    private RosRunnableTransformer rosRunnableTransformer;
    @Inject
    private RosRunnableCache rosRunnableCache;
    @Inject
    private RosInterProcessStimulusTransformer rosInterProcessStimulusTransformer;
    @Inject
    private RosTaskCache rosTaskCache;

    protected void genFiles(SLGTranslationUnit tu, Task task) {
        LinkedHashSet<String> includes = new LinkedHashSet<String>();
        LinkedList<String> initCalls = new LinkedList<String>();
        LinkedList<String> stepCalls = new LinkedList<String>();
        ArrayList<Stimulus> stimuli = new ArrayList<Stimulus>();
        ArrayList<String> publishers = new ArrayList<String>();
        ArrayList<String> clientDeclarations = new ArrayList<String>();
        ArrayList<String> clientInits = new ArrayList<String>();
        if (task != null && task.getActivityGraph() != null) {
            for (ActivityGraphItem item : task.getActivityGraph().getItems()) {
                if (item instanceof RunnableCall) {
                    RunnableCall runnableCall = (RunnableCall)item;
                    Runnable runnable = runnableCall.getRunnable();
                    SLGTranslationUnit runnableTU = this.rosRunnableTransformer.transform(runnable);
                    RosRunnableCache.RunnableStore runnableStore = this.rosRunnableCache.getStore(runnableTU);
                    includes.add(this.getIncFile(runnableTU));
                    if (this.hasTagNamed((ITaggable)runnableCall, "initialize")) {
                        initCalls.add(runnableStore.getNodeCall());
                    } else {
                        stepCalls.add(runnableStore.getNodeCall());
                    }
                    publishers.addAll(runnableStore.getPublishers());
                    clientDeclarations.addAll(runnableStore.getClientDeclarations());
                    clientInits.addAll(runnableStore.getClientInits());
                    continue;
                }
                if (!(item instanceof Group)) continue;
                Group group = (Group)item;
                for (ActivityGraphItem groupitem : group.getItems()) {
                    if (!(groupitem instanceof RunnableCall)) continue;
                    RunnableCall runnableCall = (RunnableCall)groupitem;
                    Runnable runnable = runnableCall.getRunnable();
                    SLGTranslationUnit runnableTU = this.rosRunnableTransformer.transform(runnable);
                    RosRunnableCache.RunnableStore runnableStore = this.rosRunnableCache.getStore(runnableTU);
                    includes.add(this.getIncFile(runnableTU));
                    if (this.hasTagNamed((ITaggable)runnableCall, "initialize")) {
                        initCalls.add(runnableStore.getNodeCall());
                        continue;
                    }
                    stepCalls.add(runnableStore.getNodeCall());
                }
            }
        }
        for (SLGTranslationUnit labelTU : this.rosLabelTransformer.getCache().values()) {
            includes.add(this.getIncFile(labelTU));
            initCalls.add(RosLabelGenerator.initCall(labelTU.getCall()));
        }
        if (task != null) {
            for (Stimulus stimulus : task.getStimuli()) {
                if (!(stimulus instanceof InterProcessStimulus)) continue;
                String name = stimulus.getName();
                includes.add(String.valueOf(name) + "_service/srv/" + name + "_service.hpp");
                this.rosInterProcessStimulusTransformer.transform((InterProcessStimulus)stimulus);
            }
            stimuli.addAll((Collection<Stimulus>)task.getStimuli());
        }
        this.rosTaskCache.storeValues(tu, task, stimuli, includes, initCalls, stepCalls, publishers, clientDeclarations, clientInits);
    }

    private boolean hasTagNamed(ITaggable element, String name) {
        for (Tag tag : element.getTags()) {
            if (!tag.getName().equals(name)) continue;
            return true;
        }
        return false;
    }
}

