/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.transformation.transformers;

import java.nio.file.Paths;
import java.util.Map;
import org.eclipse.app4mc.transformation.transformers.IRootTransformer;
import org.eclipse.app4mc.transformation.util.PropertyUtil;
import org.eclipse.app4mc.util.sessionlog.SessionLogger;
import org.eclipse.emf.ecore.resource.ResourceSet;

public abstract class Model2ModelRootTransformer
implements IRootTransformer {
    protected SessionLogger logger;
    private String inputFolder;
    private String outputFolder;
    private String transformationKey;

    protected void activate(Map<String, ?> properties) {
        this.inputFolder = PropertyUtil.getProperty("input_models_folder", properties);
        this.transformationKey = PropertyUtil.getProperty("transformation", properties);
        String m2mOutputFolder = PropertyUtil.getProperty("m2m_output_folder", properties);
        this.outputFolder = Paths.get(m2mOutputFolder, this.transformationKey).toString();
    }

    public String getInputFolder() {
        return this.inputFolder;
    }

    public String getOutputFolder() {
        return this.outputFolder;
    }

    public String getTransformationKey() {
        return this.transformationKey;
    }

    public void setSessionLogger(SessionLogger logger) {
        this.logger = logger;
    }

    public abstract void m2mTransformation();

    public abstract ResourceSet getOutputResourceSet();
}

