/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters110.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters110.utils.HelperUtils_103_110;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class SwConverter
implements IConverter {
    private final HelperUtils_103_110 helper = HelperUtils_103_110.getInstance();
    private final Logger logger = LogManager.getLogger((String)"org.eclipse.app4mc.amalthea.modelmigration");

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) throws Exception {
        this.logger.info((Object)("Migration from itea.103 to itea.110 : Executing SW converter for model file : " + targetFile.getName()));
        Document root = fileName_documentsMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.helper.updateNameSpaces_to_110(rootElement);
        this.updateLabelAccessStatistic(rootElement);
        fileName_documentsMap.put(targetFile.getCanonicalFile(), root);
    }

    private void updateLabelAccessStatistic(Element rootElement) {
        List labelAccessElements = this.helper.getXpathResult(rootElement, ".//runnableItems[@xsi:type=\"sw:LabelAccess\"]", Element.class, new Namespace[]{this.helper.getNS_110("sw"), this.helper.getGenericNS("xsi")});
        this.updateLabelAccessElements(labelAccessElements);
        labelAccessElements = this.helper.getXpathResult(rootElement, ".//runnableItem[@xsi:type=\"sw:LabelAccess\"]", Element.class, new Namespace[]{this.helper.getNS_110("sw"), this.helper.getGenericNS("xsi")});
        this.updateLabelAccessElements(labelAccessElements);
    }

    private void updateLabelAccessElements(List<Element> labelAccessElements) {
        for (Element labelAccessElement : labelAccessElements) {
            Element labelAccessStatisticElement;
            Attribute labelAccessEnumAttribute = labelAccessElement.getAttribute("access");
            String labelAccessTypeValue = "read";
            if (labelAccessEnumAttribute != null) {
                labelAccessTypeValue = labelAccessEnumAttribute.getValue();
            }
            if ((labelAccessStatisticElement = labelAccessElement.getChild("statistic")) == null) continue;
            Element readElement = labelAccessStatisticElement.getChild("read");
            Element writeElement = labelAccessStatisticElement.getChild("write");
            Element cacheMissesElement = labelAccessStatisticElement.getChild("readCacheMisses");
            if (labelAccessTypeValue.equals("read") && readElement != null) {
                if (writeElement != null) {
                    writeElement.detach();
                }
                readElement.setName("value");
            } else if (labelAccessTypeValue.equals("write") && writeElement != null) {
                if (readElement != null) {
                    readElement.detach();
                }
                writeElement.setName("value");
            }
            if (cacheMissesElement == null) continue;
            cacheMissesElement.setName("cacheMisses");
        }
    }
}

