/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.dialogs.openmapping;

import org.eclipse.app4mc.multicore.dialogs.AbstractGroup;
import org.eclipse.app4mc.multicore.dialogs.openmapping.OMSolverSettingsGroup;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class OMMappingAlgorithmGroup
extends AbstractGroup {
    protected final AbstractGroup groupSolverSettings;
    private final IPropertyChangeListener listener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            OMMappingAlgorithmGroup.this.groupSolverSettings.setEnabled(OMMappingAlgorithmGroup.this.checkSolverSettingsVisibility(event.getNewValue().toString()));
        }
    };

    public OMMappingAlgorithmGroup(Composite parent, IPreferenceStore store) {
        super(parent, store);
        GridLayout layout = new GridLayout(1, false);
        this.group.setText("Select mapping algorithm");
        this.group.setLayoutData((Object)new GridData(768));
        this.group.setLayout((Layout)layout);
        String[][] options = new String[][]{{"Load balancing for DFG", "0"}, {"ILP based load balancing", "1"}, {"Energy efficient mapping (Experimental!)", "2"}, {"GA based load balancing", "3"}, {"GA based load balancing with constraints optimization", "4"}};
        ComboFieldEditor comboBox = new ComboFieldEditor("org.eclipse.app4mc.multicore.openmapping.mappingAlgorithm", "", options, (Composite)this.group);
        comboBox.setPropertyChangeListener(this.listener);
        this.addField((FieldEditor)comboBox);
        this.groupSolverSettings = new OMSolverSettingsGroup(parent, store);
    }

    protected boolean checkSolverSettingsVisibility(String mapAlg) {
        switch (mapAlg) {
            case "1": 
            case "2": {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean store() {
        return super.store() && this.groupSolverSettings.store();
    }

    @Override
    public boolean loadDefault() {
        boolean success = true;
        String currMapAlg = this.store.getDefaultString("org.eclipse.app4mc.multicore.openmapping.mappingAlgorithm");
        success &= super.loadDefault();
        this.groupSolverSettings.setEnabled(this.checkSolverSettingsVisibility(currMapAlg));
        return success &= this.groupSolverSettings.loadDefault();
    }

    @Override
    public boolean load() {
        boolean success = true;
        String currMapAlg = this.store.getString("org.eclipse.app4mc.multicore.openmapping.mappingAlgorithm");
        success &= super.load();
        this.groupSolverSettings.setEnabled(this.checkSolverSettingsVisibility(currMapAlg));
        return success &= this.groupSolverSettings.load();
    }
}

