/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.partitioning.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.app4mc.amalthea.model.ASILType;
import org.eclipse.app4mc.amalthea.model.Activation;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.ProcessPrototype;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.amalthea.model.TaskRunnableCall;
import org.eclipse.app4mc.multicore.partitioning.utils.Helper;
import org.eclipse.app4mc.multicore.partitioning.utils.PartLog;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;

public class AsilToPP {
    private final SWModel swm;

    public AsilToPP(SWModel Swm) {
        this.swm = Swm;
    }

    public void createPPsFromASILs() {
        ASILType[] aSILTypeArray = ASILType.values();
        int n = aSILTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ASILType at = aSILTypeArray[n2];
            if (this.RunnableRefsASIL(at)) {
                ProcessPrototype pp = AmaltheaFactory.eINSTANCE.createProcessPrototype();
                pp.setName(at.getName());
                for (Runnable r : this.getAsilRunnables(at)) {
                    TaskRunnableCall trc = AmaltheaFactory.eINSTANCE.createTaskRunnableCall();
                    trc.setRunnable(r);
                    pp.getRunnableCalls().add((Object)trc);
                }
                if (pp.getRunnableCalls().size() > 0) {
                    this.swm.getProcessPrototypes().add((Object)pp);
                }
            }
            ++n2;
        }
        if (!new Helper().tRCsAreConsist(this.swm)) {
            PartLog.getInstance().log("There are runnables called more than once", null);
        }
    }

    public void createPPsFromASILsSplit() {
        BasicEList newPPs = new BasicEList();
        for (ProcessPrototype pp : this.swm.getProcessPrototypes()) {
            ASILType at = null;
            Iterator it = pp.getRunnableCalls().iterator();
            while (it.hasNext()) {
                TaskRunnableCall trc = (TaskRunnableCall)it.next();
                Runnable r = trc.getRunnable();
                if (at == null && r.getAsilLevel() != null) {
                    at = r.getAsilLevel();
                    continue;
                }
                if (at == null || r.getAsilLevel() == null || at.equals((Object)r.getAsilLevel())) continue;
                TaskRunnableCall trcnew = AmaltheaFactory.eINSTANCE.createTaskRunnableCall();
                trcnew.setRunnable(trc.getRunnable());
                if (!this.newPPsContains((EList<ProcessPrototype>)newPPs, r.getAsilLevel(), r.getFirstActivation())) {
                    ProcessPrototype ppNew = AmaltheaFactory.eINSTANCE.createProcessPrototype();
                    ppNew.setName("ASIL-" + r.getAsilLevel().toString());
                    if (r.getFirstActivation() != null) {
                        ppNew.setName(String.valueOf(ppNew.getName()) + "_" + r.getFirstActivation().getName());
                    }
                    ppNew.getRunnableCalls().add((Object)trcnew);
                    newPPs.add((Object)ppNew);
                    it.remove();
                    continue;
                }
                this.addTrcToNewAsilPP((EList<ProcessPrototype>)newPPs, trcnew);
                it.remove();
            }
        }
        this.swm.getProcessPrototypes().addAll((Collection)newPPs);
    }

    public void createPPsFromASILsSplitEach() {
        BasicEList newPPs = new BasicEList();
        Iterator ppit = this.swm.getProcessPrototypes().iterator();
        while (ppit.hasNext()) {
            ProcessPrototype pp = (ProcessPrototype)ppit.next();
            ArrayList asils = new ArrayList();
            List asiltrcs = pp.getRunnableCalls().stream().distinct().filter(trc -> trc.getRunnable().getAsilLevel() != null && trc.getRunnable().getAsilLevel().toString() != "_undefined_").collect(Collectors.toList());
            asiltrcs.stream().forEach(trc -> {
                boolean bl = asils.add(trc.getRunnable().getAsilLevel());
            });
            List asilsd = asils.stream().distinct().collect(Collectors.toList());
            for (ASILType at : asilsd) {
                ProcessPrototype ppa = AmaltheaFactory.eINSTANCE.createProcessPrototype();
                ppa.setName(String.valueOf(pp.getName()) + "_" + at.getName());
                ppa.setActivation(pp.getActivation());
                ppa.getRunnableCalls().addAll((Collection)asiltrcs.stream().filter(trc -> trc.getRunnable().getAsilLevel().equals((Object)at)).collect(Collectors.toList()));
                pp.getRunnableCalls().removeAll((Collection)ppa.getRunnableCalls());
                if (pp.getRunnableCalls().size() < 1) {
                    ppit.remove();
                }
                newPPs.add((Object)ppa);
            }
        }
        this.swm.getProcessPrototypes().addAll((Collection)newPPs);
    }

    private void addTrcToNewAsilPP(EList<ProcessPrototype> newPPs, TaskRunnableCall trcnew) {
        for (ProcessPrototype pp : newPPs) {
            Runnable r;
            if (pp.getRunnableCalls().get(0) == null || !(r = ((TaskRunnableCall)pp.getRunnableCalls().get(0)).getRunnable()).getAsilLevel().equals((Object)trcnew.getRunnable().getAsilLevel())) continue;
            pp.getRunnableCalls().add((Object)trcnew);
            break;
        }
    }

    private boolean newPPsContains(EList<ProcessPrototype> newPPs, ASILType asilLevel, Activation activation) {
        for (ProcessPrototype pp : newPPs) {
            TaskRunnableCall trc;
            if (pp.getRunnableCalls().size() <= 0 || !(trc = (TaskRunnableCall)pp.getRunnableCalls().get(0)).getRunnable().getAsilLevel().equals((Object)asilLevel) || !trc.getRunnable().getFirstActivation().equals(activation)) continue;
            return true;
        }
        return false;
    }

    private EList<Runnable> getAsilRunnables(ASILType at) {
        BasicEList asilruns = new BasicEList();
        for (Runnable r : this.swm.getRunnables()) {
            if (!r.getAsilLevel().equals((Object)at)) continue;
            asilruns.add((Object)r);
        }
        return asilruns;
    }

    private boolean RunnableRefsASIL(ASILType at) {
        for (Runnable r : this.swm.getRunnables()) {
            if (r.getAsilLevel() == null || "_undefined_" == r.getAsilLevel().getName() || !r.getAsilLevel().equals((Object)at)) continue;
            return true;
        }
        return false;
    }
}

