/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.util;

import java.math.BigInteger;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.Deviation;
import org.eclipse.app4mc.amalthea.model.Instructions;
import org.eclipse.app4mc.amalthea.model.InstructionsConstant;
import org.eclipse.app4mc.amalthea.model.InstructionsDeviation;
import org.eclipse.app4mc.amalthea.model.LongObject;
import org.eclipse.app4mc.amalthea.model.RunnableInstructions;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.TimeUnit;
import org.eclipse.app4mc.amalthea.model.WeibullEstimators;
import org.eclipse.app4mc.amalthea.model.util.TimeUtil;

public class FactoryUtil {
    public static Time createTime(int value, String unit) {
        TimeUnit tu = null;
        if (unit.toLowerCase().equals("ps")) {
            tu = TimeUnit.PS;
        }
        if (unit.toLowerCase().equals("ns")) {
            tu = TimeUnit.NS;
        }
        if (unit.toLowerCase().equals("us")) {
            tu = TimeUnit.US;
        }
        if (unit.toLowerCase().equals("ms")) {
            tu = TimeUnit.MS;
        }
        if (unit.toLowerCase().equals("s")) {
            tu = TimeUnit.S;
        }
        if (tu == null) {
            tu = TimeUnit.MS;
        }
        return TimeUtil.adjustTimeUnit(BigInteger.valueOf(value), tu);
    }

    public static Time createTime(BigInteger value, String unit) {
        TimeUnit tu = null;
        if (unit.toLowerCase().equals("ps")) {
            tu = TimeUnit.PS;
        }
        if (unit.toLowerCase().equals("ns")) {
            tu = TimeUnit.NS;
        }
        if (unit.toLowerCase().equals("us")) {
            tu = TimeUnit.US;
        }
        if (unit.toLowerCase().equals("ms")) {
            tu = TimeUnit.MS;
        }
        if (unit.toLowerCase().equals("s")) {
            tu = TimeUnit.S;
        }
        if (tu == null) {
            tu = TimeUnit.MS;
        }
        return TimeUtil.adjustTimeUnit(new BigInteger(value.toByteArray()), tu);
    }

    public static Time createTime(String timeString) {
        Pattern p = Pattern.compile("(\\d+)(s|ms|us|ns|ps)");
        Matcher m = p.matcher(timeString);
        if (m.matches()) {
            String value = m.group(1);
            String unit = m.group(2);
            return FactoryUtil.createTime(Integer.parseInt(value), unit);
        }
        return null;
    }

    public static Time createTime(Time inputTime) {
        Time time = AmaltheaFactory.eINSTANCE.createTime();
        time.setValue(inputTime.getValue());
        time.setUnit(inputTime.getUnit());
        return time;
    }

    public static Time createTime(long instructionCount, float ipc, long frequency) {
        double cycles = (double)instructionCount / (double)ipc;
        List<TimeUnit> units = TimeUtil.getTimeUnitList();
        int timeUnitIndex = units.indexOf((Object)TimeUnit.S);
        while (frequency % 1000L == 0L && frequency > 0L) {
            ++timeUnitIndex;
            frequency /= 1000L;
        }
        double runtime = cycles / (double)frequency;
        return TimeUtil.adjustTimeUnit(runtime, units.get(timeUnitIndex));
    }

    public static Deviation<LongObject> createWeibullDeviation(long min, long avg, long max, float promille) {
        Deviation<LongObject> result = AmaltheaFactory.eINSTANCE.createDeviation();
        result.setDistribution(FactoryUtil.createWeibullEstimator(avg, promille));
        LongObject uB = AmaltheaFactory.eINSTANCE.createLongObject();
        uB.setValue(max);
        LongObject lB = AmaltheaFactory.eINSTANCE.createLongObject();
        lB.setValue(min);
        result.setUpperBound(uB);
        result.setLowerBound(lB);
        return result;
    }

    public static WeibullEstimators<LongObject> createWeibullEstimator(long avgR, float promille) {
        WeibullEstimators<LongObject> weibull = AmaltheaFactory.eINSTANCE.createWeibullEstimators();
        LongObject mean = AmaltheaFactory.eINSTANCE.createLongObject();
        mean.setValue(avgR);
        weibull.setMean(mean);
        if (promille > 0.0f) {
            weibull.setPRemainPromille(promille);
        }
        return weibull;
    }

    public static InstructionsDeviation createInstructionWeibullDeviation(long min, long avg, long max, float promille) {
        InstructionsDeviation instdev = AmaltheaFactory.eINSTANCE.createInstructionsDeviation();
        instdev.setDeviation(FactoryUtil.createWeibullDeviation(min, avg, max, promille));
        return instdev;
    }

    public static InstructionsConstant createInstructionConstant(long instr) {
        InstructionsConstant iConst = AmaltheaFactory.eINSTANCE.createInstructionsConstant();
        iConst.setValue(instr);
        return iConst;
    }

    public static RunnableInstructions createRunnableInstructions(Instructions instDev) {
        RunnableInstructions runInstr = AmaltheaFactory.eINSTANCE.createRunnableInstructions();
        runInstr.setDefault(instDev);
        return runInstr;
    }
}

