/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.util;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.math3.special.Gamma;
import org.eclipse.app4mc.amalthea.model.AbstractTime;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.ArrivalCurveStimulus;
import org.eclipse.app4mc.amalthea.model.BetaDistribution;
import org.eclipse.app4mc.amalthea.model.Boundaries;
import org.eclipse.app4mc.amalthea.model.CallSequence;
import org.eclipse.app4mc.amalthea.model.Core;
import org.eclipse.app4mc.amalthea.model.CoreType;
import org.eclipse.app4mc.amalthea.model.CustomStimulus;
import org.eclipse.app4mc.amalthea.model.Deviation;
import org.eclipse.app4mc.amalthea.model.Distribution;
import org.eclipse.app4mc.amalthea.model.EventStimulus;
import org.eclipse.app4mc.amalthea.model.GaussDistribution;
import org.eclipse.app4mc.amalthea.model.Instructions;
import org.eclipse.app4mc.amalthea.model.InstructionsConstant;
import org.eclipse.app4mc.amalthea.model.InstructionsDeviation;
import org.eclipse.app4mc.amalthea.model.InterProcessStimulus;
import org.eclipse.app4mc.amalthea.model.InterProcessTrigger;
import org.eclipse.app4mc.amalthea.model.LongObject;
import org.eclipse.app4mc.amalthea.model.ModeLabel;
import org.eclipse.app4mc.amalthea.model.ModeLiteral;
import org.eclipse.app4mc.amalthea.model.PeriodicStimulus;
import org.eclipse.app4mc.amalthea.model.PeriodicSyntheticStimulus;
import org.eclipse.app4mc.amalthea.model.Process;
import org.eclipse.app4mc.amalthea.model.RelativePeriodicStimulus;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableInstructions;
import org.eclipse.app4mc.amalthea.model.RunnableItem;
import org.eclipse.app4mc.amalthea.model.SingleStimulus;
import org.eclipse.app4mc.amalthea.model.Stimulus;
import org.eclipse.app4mc.amalthea.model.TaskRunnableCall;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.TimeUnit;
import org.eclipse.app4mc.amalthea.model.UniformDistribution;
import org.eclipse.app4mc.amalthea.model.VariableRateStimulus;
import org.eclipse.app4mc.amalthea.model.WeibullDistribution;
import org.eclipse.app4mc.amalthea.model.WeibullEstimators;
import org.eclipse.app4mc.amalthea.model.WeibullParameters;
import org.eclipse.app4mc.amalthea.model.util.DeploymentUtil;
import org.eclipse.app4mc.amalthea.model.util.FactoryUtil;
import org.eclipse.app4mc.amalthea.model.util.HardwareUtil;
import org.eclipse.app4mc.amalthea.model.util.ModelUtil;
import org.eclipse.app4mc.amalthea.model.util.SoftwareUtil;
import org.eclipse.app4mc.amalthea.model.util.TimeUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;

public class RuntimeUtil {
    public static Long getInstructionCountForProcess(Process process, TimeType execTimeType, CoreType coreType, EMap<ModeLabel, ModeLiteral> modes) {
        List<Runnable> runnables = SoftwareUtil.getRunnableList(process, modes);
        long instructionCount = 0L;
        for (Runnable runnable : runnables) {
            instructionCount += RuntimeUtil.getInstructionCountForRunnable(runnable, execTimeType, coreType, modes).longValue();
        }
        return instructionCount;
    }

    public static Long getInstructionCountForRunnable(Runnable runnable, TimeType execTimeType, CoreType coreType, EMap<ModeLabel, ModeLiteral> modes) {
        List<Instructions> instructionElements = SoftwareUtil.getInstructionsList(runnable, coreType, modes);
        return RuntimeUtil.getInstructionCountForInstructionList(instructionElements, execTimeType);
    }

    private static Long getInstructionCountForInstructionList(List<Instructions> instructionElements, TimeType execTimeType) {
        long instructionCount = 0L;
        for (Instructions inst : instructionElements) {
            instructionCount += RuntimeUtil.getInstructionCountForInstruction(inst, execTimeType).longValue();
        }
        return instructionCount;
    }

    private static Long getInstructionCountForInstruction(Instructions instruction, TimeType execTimeType) {
        if (instruction instanceof InstructionsDeviation) {
            InstructionsDeviation instDeviation = (InstructionsDeviation)instruction;
            switch (execTimeType) {
                case ACET: {
                    return RuntimeUtil.getMean(instDeviation.getDeviation().getDistribution(), instDeviation.getDeviation().getLowerBound().getValue(), instDeviation.getDeviation().getUpperBound().getValue());
                }
                case BCET: {
                    return instDeviation.getDeviation().getLowerBound().getValue();
                }
                case WCET: {
                    return instDeviation.getDeviation().getUpperBound().getValue();
                }
            }
        } else if (instruction instanceof InstructionsConstant) {
            return ((InstructionsConstant)instruction).getValue();
        }
        return 0L;
    }

    public static HashMap<CoreType, Long> getInstructionCountExtendedForProcess(Process process, TimeType execTimeType, EMap<ModeLabel, ModeLiteral> modes) {
        HashMap<CoreType, Long> coreTypeToIcMap = new HashMap<CoreType, Long>();
        for (Runnable runnable : SoftwareUtil.getRunnableList(process, modes)) {
            HashMap<CoreType, Long> map = RuntimeUtil.getInstructionCountExtendedForRunnable(runnable, execTimeType, modes);
            for (CoreType ct : map.keySet()) {
                Long ic = 0L;
                if (coreTypeToIcMap.get(ct) != null) {
                    ic = coreTypeToIcMap.get(ct);
                }
                ic = ic + map.get(ct);
                coreTypeToIcMap.put(ct, ic);
            }
        }
        return coreTypeToIcMap;
    }

    public static HashMap<CoreType, Long> getInstructionCountExtendedForRunnable(Runnable runnable, TimeType execTimeType, EMap<ModeLabel, ModeLiteral> modes) {
        HashMap<CoreType, Long> coreTypeToIcMap = new HashMap<CoreType, Long>();
        for (RunnableInstructions runnableInstruction : SoftwareUtil.getRunnableInstructionsList(runnable, modes)) {
            if (runnableInstruction.getExtended() != null) {
                for (CoreType ct : runnableInstruction.getExtended().keySet()) {
                    Long ic = 0L;
                    if (coreTypeToIcMap.get(ct) != null) {
                        ic = coreTypeToIcMap.get(ct);
                    }
                    ic = ic + RuntimeUtil.getInstructionCountForInstruction((Instructions)runnableInstruction.getExtended().get((Object)ct), execTimeType);
                    coreTypeToIcMap.put(ct, ic);
                }
            }
            if (runnableInstruction.getDefault() == null) continue;
            Long ic = 0L;
            if (coreTypeToIcMap.get(null) != null) {
                ic = coreTypeToIcMap.get(null);
            }
            ic = ic + RuntimeUtil.getInstructionCountForInstruction(runnableInstruction.getDefault(), execTimeType);
            coreTypeToIcMap.put(null, ic);
        }
        return coreTypeToIcMap;
    }

    public static Time getExecutionTimeForProcess(Process process, TimeType execTimeType, Core core, EMap<ModeLabel, ModeLiteral> modes) {
        List<Runnable> runnables = SoftwareUtil.getRunnableList(process, modes);
        Time executionTime = AmaltheaFactory.eINSTANCE.createTime();
        executionTime.setValue(new BigInteger("0"));
        executionTime.setUnit(TimeUnit.MS);
        for (Runnable runnable : runnables) {
            if (runnable == null) continue;
            executionTime = TimeUtil.addTimes(executionTime, RuntimeUtil.getExecutionTimeForRunnable(runnable, execTimeType, core, modes));
        }
        return executionTime;
    }

    public static Time getExecutionTimeForRunnable(Runnable runnable, TimeType execTimeType, Core core, EMap<ModeLabel, ModeLiteral> modes) {
        long instructionCount = RuntimeUtil.getInstructionCountForRunnable(runnable, execTimeType, core.getCoreType(), modes);
        float ipc = core.getCoreType().getInstructionsPerCycle();
        long frequency = HardwareUtil.getFrequencyOfCore(core);
        Time executionTime = FactoryUtil.createTime(instructionCount, ipc, frequency);
        return executionTime;
    }

    public static HashMap<Core, Time> getExecutionTimeExtendedForProcess(Amalthea model, Process process, TimeType execTimeType, EMap<ModeLabel, ModeLiteral> modes) {
        HashMap<Core, Time> executionTimes = new HashMap<Core, Time>();
        List<Runnable> runnables = SoftwareUtil.getRunnableList(process, modes);
        for (Runnable runnable : runnables) {
            if (runnable == null) continue;
            Map<Core, Time> map = RuntimeUtil.getExecutionTimeExtendedForRunnable(model, runnable, execTimeType, modes);
            for (Core c : map.keySet()) {
                Time executionTime = executionTimes.get(c);
                if (executionTime == null) {
                    executionTime = FactoryUtil.createTime("0ms");
                }
                executionTime = TimeUtil.addTimes(executionTime, map.get(c));
                executionTimes.put(c, executionTime);
            }
        }
        return executionTimes;
    }

    public static Map<Core, Time> getExecutionTimeExtendedForRunnable(Amalthea model, Runnable runnable, TimeType execTimeType, EMap<ModeLabel, ModeLiteral> modes) {
        HashMap<Core, Time> executionTimes = new HashMap<Core, Time>();
        HashMap<CoreType, Long> coreTypeToInstructionCountMap = RuntimeUtil.getInstructionCountExtendedForRunnable(runnable, execTimeType, modes);
        for (CoreType ct : coreTypeToInstructionCountMap.keySet()) {
            List<Core> coreWithGivenCoreType = HardwareUtil.getAllCoresForCoreType(model, ct);
            for (Core core : coreWithGivenCoreType) {
                executionTimes.put(core, RuntimeUtil.getExecutionTimeForInstructionCount(coreTypeToInstructionCountMap.get(ct), core, null));
            }
        }
        return executionTimes;
    }

    public static Time getExecutionTimeForInstructionCount(long instructionCount, Core core, EMap<ModeLabel, ModeLiteral> modes) {
        float ipc = core.getCoreType().getInstructionsPerCycle();
        long frequency = HardwareUtil.getFrequencyOfCore(core);
        Time executionTime = FactoryUtil.createTime(instructionCount, ipc, frequency);
        return executionTime;
    }

    public static double getCoreUtilization(Core core, Amalthea model, TimeType tt, EMap<ModeLabel, ModeLiteral> modes) {
        double utilization = 0.0;
        for (Process proc : DeploymentUtil.getProcessesMappedToCore(core, model)) {
            utilization += RuntimeUtil.getProcessUtilization(proc, core, model, tt, modes);
        }
        return utilization;
    }

    public static Map<Core, Double> getProcessUtilization(Process process, Amalthea model, TimeType tt, EMap<ModeLabel, ModeLiteral> modes) {
        HashMap<Core, Double> utilizations = new HashMap<Core, Double>();
        Set<Core> cores = DeploymentUtil.getAssignedCoreForProcess(process, model);
        for (Core core : cores) {
            double utilization = RuntimeUtil.getProcessUtilization(process, core, model, tt, modes);
            utilizations.put(core, utilization);
        }
        return utilizations;
    }

    public static double getProcessUtilization(Process process, Core core, Amalthea model, TimeType tt, EMap<ModeLabel, ModeLiteral> modes) {
        double utilization = 0.0;
        List<Time> periods = RuntimeUtil.getPeriodsOfProcess(model, process, tt, modes);
        Time time = RuntimeUtil.getExecutionTimeForProcess(process, tt, core, modes);
        if (time.getValue().compareTo(new BigInteger("0")) < 0) {
            System.err.println("execTime " + TimeUtil.timeToString(time));
        }
        for (Time period : periods) {
            if (period == null || period.getValue().intValue() == 0) continue;
            utilization += TimeUtil.divideTimes(time, period);
        }
        return utilization;
    }

    public static double getProcessUtilization(Process process, Time period, Core core, Amalthea model, TimeType tt, EMap<ModeLabel, ModeLiteral> modes) {
        Time time = RuntimeUtil.getExecutionTimeForProcess(process, tt, core, modes);
        double utilization = TimeUtil.divideTimes(time, period);
        return utilization;
    }

    public static Map<Process, Double> getCumulativeProcessUtilizations(Amalthea model, TimeType tt, EMap<ModeLabel, ModeLiteral> modes) {
        HashMap<Process, Double> utilizations = new HashMap<Process, Double>();
        ArrayList<Process> procs = new ArrayList<Process>();
        procs.addAll((Collection<Process>)model.getSwModel().getTasks());
        procs.addAll((Collection<Process>)model.getSwModel().getIsrs());
        for (Process proc : procs) {
            Map<Core, Double> processUtilization = RuntimeUtil.getProcessUtilization(proc, model, tt, modes);
            double util = 0.0;
            for (Core c : processUtilization.keySet()) {
                util += processUtilization.get(c).doubleValue();
            }
            utilizations.put(proc, util);
        }
        return utilizations;
    }

    public static Map<Process, List<Time>> getPeriodsOfAllProcesses(Amalthea model, TimeType tt, EMap<ModeLabel, ModeLiteral> modes) {
        HashMap<Process, List<Time>> result = new HashMap<Process, List<Time>>();
        ArrayList<Process> processes = new ArrayList<Process>();
        processes.addAll((Collection<Process>)model.getSwModel().getTasks());
        processes.addAll((Collection<Process>)model.getSwModel().getIsrs());
        for (Process process : processes) {
            List<Time> periods = RuntimeUtil.getPeriodsOfProcess(model, process, tt, modes);
            result.put(process, periods);
        }
        return result;
    }

    public static List<Time> getPeriodsOfProcess(Amalthea model, Process process, TimeType tt, EMap<ModeLabel, ModeLiteral> modes) {
        ArrayList<Time> result = new ArrayList<Time>();
        for (Stimulus stimulus : process.getStimuli()) {
            if (stimulus instanceof PeriodicStimulus) {
                PeriodicStimulus p = (PeriodicStimulus)stimulus;
                result.add(p.getRecurrence());
                continue;
            }
            if (stimulus instanceof ArrivalCurveStimulus) {
                switch (tt) {
                    case ACET: {
                        break;
                    }
                    case BCET: {
                        break;
                    }
                    case WCET: {
                        break;
                    }
                }
                continue;
            }
            if (stimulus instanceof CustomStimulus) {
                switch (tt) {
                    case ACET: {
                        break;
                    }
                    case BCET: {
                        break;
                    }
                    case WCET: {
                        break;
                    }
                }
                continue;
            }
            if (stimulus instanceof EventStimulus) {
                switch (tt) {
                    case ACET: {
                        break;
                    }
                    case BCET: {
                        break;
                    }
                    case WCET: {
                        break;
                    }
                }
                continue;
            }
            if (stimulus instanceof InterProcessStimulus) {
                Map<Process, Long> triggeringProcesses;
                InterProcessStimulus ip = (InterProcessStimulus)stimulus;
                long ipPrescaler = 1L;
                if (ip.getCounter() != null) {
                    ipPrescaler = ip.getCounter().getPrescaler();
                }
                if ((triggeringProcesses = RuntimeUtil.getTriggeringProcesses(model, ip, modes)).containsKey(process)) {
                    triggeringProcesses.remove(process);
                }
                for (Process triggeringProcess : triggeringProcesses.keySet()) {
                    List<Time> periods = RuntimeUtil.getPeriodsOfProcess(model, triggeringProcess, tt, modes);
                    for (Time t : periods) {
                        long ipaPrescaler = triggeringProcesses.get(triggeringProcess);
                        result.add(TimeUtil.multiplyTime(t, ipaPrescaler * ipPrescaler));
                    }
                }
                continue;
            }
            if (stimulus instanceof VariableRateStimulus) {
                VariableRateStimulus cfr_ignored_0 = (VariableRateStimulus)stimulus;
                Object time = null;
                switch (tt) {
                    case ACET: {
                        break;
                    }
                }
                if (time == null) continue;
                result.add((Time)time);
                continue;
            }
            if (stimulus instanceof SingleStimulus) {
                switch (tt) {
                    case ACET: {
                        break;
                    }
                    case BCET: {
                        break;
                    }
                    case WCET: {
                        break;
                    }
                }
                continue;
            }
            if (stimulus instanceof RelativePeriodicStimulus) {
                RelativePeriodicStimulus rp = (RelativePeriodicStimulus)stimulus;
                Time time = null;
                switch (tt) {
                    case ACET: {
                        if (rp.getNextOccurrence() == null) break;
                        time = RuntimeUtil.getMean(rp.getNextOccurrence());
                        break;
                    }
                    case BCET: {
                        if (rp.getNextOccurrence() == null) break;
                        time = rp.getNextOccurrence().getUpperBound();
                        break;
                    }
                    case WCET: {
                        if (rp.getNextOccurrence() == null) break;
                        time = rp.getNextOccurrence().getLowerBound();
                        break;
                    }
                }
                if (time == null) continue;
                result.add(time);
                continue;
            }
            if (!(stimulus instanceof PeriodicSyntheticStimulus)) continue;
            switch (tt) {
                case ACET: {
                    break;
                }
                case BCET: {
                    break;
                }
                case WCET: {
                    break;
                }
            }
        }
        Collections.sort(result);
        return result;
    }

    public static Map<Process, Long> getTriggeringProcesses(Amalthea model, InterProcessStimulus ip, EMap<ModeLabel, ModeLiteral> modes) {
        HashMap<Process, Long> result = new HashMap<Process, Long>();
        for (InterProcessTrigger interProcessTrigger : ip.getExplicitTriggers()) {
            Process parentProcess = ModelUtil.getParentContainer(interProcessTrigger, Process.class);
            if (interProcessTrigger.getCounter() != null) {
                result.put(parentProcess, interProcessTrigger.getCounter().getPrescaler());
                continue;
            }
            result.put(parentProcess, 1L);
        }
        return result;
    }

    public static HashMap<Stimulus, Long> getTriggeredStimuli(Process process, EMap<ModeLabel, ModeLiteral> modes) {
        HashMap<Stimulus, Long> stimuliMap = new HashMap<Stimulus, Long>();
        List<InterProcessTrigger> interProcessTriggers = SoftwareUtil.collectCalls(process, modes, s -> s instanceof InterProcessTrigger).stream().map(s -> (InterProcessTrigger)s).collect(Collectors.toList());
        interProcessTriggers.forEach(ipa -> {
            if (ipa.getCounter() != null) {
                stimuliMap.put(ipa.getStimulus(), ipa.getCounter().getPrescaler());
            } else {
                stimuliMap.put(ipa.getStimulus(), 1L);
            }
        });
        return stimuliMap;
    }

    public static Map<Process, List<Time>> getProcessesWithRelativePeriodicStimulus(Amalthea model, TimeType tt) {
        HashSet<Process> processes = new HashSet<Process>();
        processes.addAll((Collection<Process>)model.getSwModel().getTasks());
        processes.addAll((Collection<Process>)model.getSwModel().getIsrs());
        Map<Process, List<Time>> result = processes.stream().collect(Collectors.toMap(p -> p, p -> p.getStimuli().stream().filter(s -> s instanceof RelativePeriodicStimulus).map(s -> RuntimeUtil.getActivationTimeFromDeviation(((RelativePeriodicStimulus)s).getNextOccurrence(), tt)).collect(Collectors.toList())));
        return result;
    }

    private static Time getActivationTimeFromDeviation(Deviation<Time> deviation, TimeType tt) {
        switch (tt) {
            case ACET: {
                return RuntimeUtil.getMean(deviation);
            }
            case BCET: {
                return deviation.getUpperBound();
            }
            case WCET: {
                return deviation.getLowerBound();
            }
        }
        return null;
    }

    public static Map<Process, List<Deviation<Time>>> getProcessesWithRelativePeriodicStimulus(Amalthea model) {
        ArrayList<Process> processes = new ArrayList<Process>();
        processes.addAll((Collection<Process>)model.getSwModel().getTasks());
        processes.addAll((Collection<Process>)model.getSwModel().getIsrs());
        processes.stream().filter(p -> p.getStimuli().stream().filter(s -> s instanceof RelativePeriodicStimulus).collect(Collectors.toList()).size() > 0);
        Map<Process, List<Deviation<Time>>> result = processes.stream().collect(Collectors.toMap(p -> p, p -> p.getStimuli().stream().filter(s -> s instanceof RelativePeriodicStimulus).map(s -> ((RelativePeriodicStimulus)s).getNextOccurrence()).collect(Collectors.toList())));
        return result;
    }

    public static <T> Map<Process, Map<Stimulus, Long>> getPlainTriggersForModel(Amalthea model, Function<Stimulus, Boolean> filter) {
        HashMap<Process, Map<Stimulus, Long>> map = new HashMap<Process, Map<Stimulus, Long>>();
        ArrayList<Process> processes = new ArrayList<Process>();
        processes.addAll((Collection<Process>)model.getSwModel().getTasks());
        processes.addAll((Collection<Process>)model.getSwModel().getIsrs());
        for (Process p : processes) {
            Map<Stimulus, Long> plainTriggerForProcess = RuntimeUtil.getPlainTriggerForProcess(model, p, 1L, filter);
            if (plainTriggerForProcess == null || plainTriggerForProcess.isEmpty()) continue;
            map.put(p, plainTriggerForProcess);
        }
        return map;
    }

    public static <T> Map<Stimulus, Long> getPlainTriggerForProcess(Amalthea model, Process process, long depthCounter, Function<Stimulus, Boolean> filter) {
        HashMap<Stimulus, Long> map = new HashMap<Stimulus, Long>();
        for (Stimulus stimulus : process.getStimuli()) {
            Stimulus p;
            if (filter != null && !filter.apply(stimulus).booleanValue()) continue;
            if (stimulus instanceof PeriodicStimulus) {
                p = (PeriodicStimulus)stimulus;
                map.put(p, depthCounter);
                continue;
            }
            if (stimulus instanceof ArrivalCurveStimulus) {
                p = (ArrivalCurveStimulus)stimulus;
                map.put(p, depthCounter);
                continue;
            }
            if (stimulus instanceof CustomStimulus) {
                p = (CustomStimulus)stimulus;
                map.put(p, depthCounter);
                continue;
            }
            if (stimulus instanceof EventStimulus) {
                p = (EventStimulus)stimulus;
                map.put(p, depthCounter);
                continue;
            }
            if (stimulus instanceof InterProcessStimulus) {
                InterProcessStimulus ip = (InterProcessStimulus)stimulus;
                long ipPrescaler = 1L;
                if (ip.getCounter() != null) {
                    ipPrescaler = ip.getCounter().getPrescaler();
                }
                Map<Process, Long> triggeringProcesses = RuntimeUtil.getTriggeringProcesses(model, ip, null);
                for (Process triggeringProcess : triggeringProcesses.keySet()) {
                    if (triggeringProcess.equals(process)) continue;
                    long ipaPrescaler = triggeringProcesses.get(triggeringProcess);
                    Map<Stimulus, Long> plainTriggerForProcess = RuntimeUtil.getPlainTriggerForProcess(model, triggeringProcess, depthCounter * ipaPrescaler * ipPrescaler, filter);
                    map.putAll(plainTriggerForProcess);
                }
                continue;
            }
            if (stimulus instanceof VariableRateStimulus) {
                p = (VariableRateStimulus)stimulus;
                map.put(p, depthCounter);
                continue;
            }
            if (stimulus instanceof SingleStimulus) {
                p = (SingleStimulus)stimulus;
                map.put(p, depthCounter);
                continue;
            }
            if (stimulus instanceof RelativePeriodicStimulus) {
                RelativePeriodicStimulus s = (RelativePeriodicStimulus)stimulus;
                map.put(s, depthCounter);
                continue;
            }
            if (!(stimulus instanceof PeriodicSyntheticStimulus)) continue;
            p = (PeriodicSyntheticStimulus)stimulus;
            map.put(p, depthCounter);
        }
        return map;
    }

    public static boolean periodicStimulusFilter(Stimulus stimulus) {
        return stimulus instanceof PeriodicStimulus;
    }

    public static boolean sporadicStimulusFilter(Stimulus stimulus) {
        return stimulus instanceof RelativePeriodicStimulus;
    }

    public static boolean customStimulusFilter(Stimulus stimulus) {
        return stimulus instanceof CustomStimulus;
    }

    public static Time getMean(Deviation<? extends Time> deviation) {
        return RuntimeUtil.getMean(deviation.getDistribution(), deviation.getLowerBound(), deviation.getUpperBound());
    }

    public static Time getMean(Distribution<? extends Time> distribution2, Time lowerBound, Time upperBound) {
        Time mean = null;
        Distribution<? extends Time> distribution = distribution2;
        if (distribution instanceof BetaDistribution) {
            BetaDistribution bd = (BetaDistribution)distribution;
            double m = 1.0 / (1.0 + bd.getBeta() / bd.getAlpha());
            mean = TimeUtil.addTimes(lowerBound, TimeUtil.multiplyTime(TimeUtil.subtractTimes(upperBound, lowerBound), m));
        } else if (!(distribution instanceof Boundaries)) {
            if (distribution instanceof GaussDistribution) {
                GaussDistribution gd = (GaussDistribution)distribution;
                mean = gd.getMean() == null || !(gd.getMean() instanceof AbstractTime) ? TimeUtil.multiplyTime(TimeUtil.addTimes(lowerBound, upperBound), 0.5) : (Time)gd.getMean();
            } else if (distribution instanceof UniformDistribution) {
                mean = TimeUtil.multiplyTime(TimeUtil.addTimes(lowerBound, upperBound), 0.5);
            } else if (distribution instanceof WeibullDistribution) {
                WeibullDistribution wd = (WeibullDistribution)distribution;
                if (wd instanceof WeibullEstimators) {
                    WeibullEstimators we = (WeibullEstimators)wd;
                    mean = (Time)we.getMean();
                } else if (wd instanceof WeibullParameters) {
                    WeibullParameters wp = (WeibullParameters)wd;
                    double m = 1.0 / wp.getLambda() * Gamma.gamma((double)(1.0 + 1.0 / wp.getKappa()));
                    mean = TimeUtil.addTimes(lowerBound, TimeUtil.multiplyTime(TimeUtil.subtractTimes(upperBound, lowerBound), m));
                }
            }
        }
        return mean;
    }

    public static <T> long getMean(Distribution<T> distribution, long lowerBound, long upperBound) {
        long mean = 0L;
        if (distribution instanceof BetaDistribution) {
            BetaDistribution bd = (BetaDistribution)distribution;
            double m = 1.0 / (1.0 + bd.getBeta() / bd.getAlpha());
            mean = lowerBound + (long)((double)(upperBound - lowerBound) * m);
        } else if (!(distribution instanceof Boundaries)) {
            if (distribution instanceof GaussDistribution) {
                GaussDistribution gd = (GaussDistribution)distribution;
                mean = gd.getMean() == null || !(gd.getMean() instanceof LongObject) ? (upperBound + lowerBound) / 2L : ((LongObject)gd.getMean()).getValue();
            } else if (distribution instanceof UniformDistribution) {
                mean = (upperBound + lowerBound) / 2L;
            } else if (distribution instanceof WeibullDistribution) {
                WeibullDistribution wd = (WeibullDistribution)distribution;
                if (wd instanceof WeibullEstimators) {
                    WeibullEstimators we = (WeibullEstimators)wd;
                    if (we.getMean() instanceof LongObject) {
                        mean = ((LongObject)we.getMean()).getValue();
                    } else if (we.getMean() instanceof String) {
                        mean = Long.parseLong(we.getMean().toString());
                    }
                } else if (wd instanceof WeibullParameters) {
                    WeibullParameters wp = (WeibullParameters)wd;
                    double m = 1.0 / wp.getLambda() * Gamma.gamma((double)(1.0 + 1.0 / wp.getKappa()));
                    mean = lowerBound + (long)((double)(upperBound - lowerBound) * m);
                }
            }
        }
        return mean;
    }

    public static <T> void setMean(Distribution<T> distribution, long l) {
        if (distribution instanceof GaussDistribution) {
            GaussDistribution gd = (GaussDistribution)distribution;
            if (gd.getMean() instanceof LongObject) {
                ((LongObject)gd.getMean()).setValue(l);
            }
        } else if (!(distribution instanceof UniformDistribution) && distribution instanceof WeibullDistribution) {
            WeibullDistribution wd = (WeibullDistribution)distribution;
            if (wd instanceof WeibullEstimators) {
                WeibullEstimators we = (WeibullEstimators)wd;
                if (we.getMean() instanceof LongObject) {
                    ((LongObject)we.getMean()).setValue(l);
                } else {
                    boolean cfr_ignored_0 = we.getMean() instanceof String;
                }
            } else {
                boolean cfr_ignored_1 = wd instanceof WeibullParameters;
            }
        }
    }

    public static List<CoreType> getCoreTypesWithSpecifiedInstructionsOfRunnable(Runnable runnable, EMap<ModeLabel, ModeLiteral> modes) {
        ArrayList<CoreType> coreTypes = new ArrayList<CoreType>();
        EList<RunnableItem> runnableItems = SoftwareUtil.collectRunnableItems(runnable, modes);
        for (RunnableItem ri : runnableItems) {
            if (!(ri instanceof RunnableInstructions)) continue;
            RunnableInstructions runnableInstruction = (RunnableInstructions)ri;
            coreTypes.addAll(runnableInstruction.getExtended().keySet());
        }
        return coreTypes;
    }

    public static void addRuntimeToRunnable(Runnable runnable, RunnableInstructions instructions) {
        runnable.getRunnableItems().add((Object)instructions);
    }

    public static Runnable addRuntimeToProcessAsNewRunnable(Process process, RunnableInstructions instructions, String runnableName, PositionType positon) {
        Runnable run = AmaltheaFactory.eINSTANCE.createRunnable();
        run.setName(runnableName);
        run.getRunnableItems().add((Object)instructions);
        TaskRunnableCall tCall = AmaltheaFactory.eINSTANCE.createTaskRunnableCall();
        tCall.setRunnable(run);
        CallSequence cs = AmaltheaFactory.eINSTANCE.createCallSequence();
        cs.getCalls().add((Object)tCall);
        cs.setName("Call " + runnableName);
        if (positon.equals((Object)PositionType.FIRST)) {
            process.getCallGraph().getGraphEntries().add(0, (Object)cs);
        } else {
            process.getCallGraph().getGraphEntries().add((Object)cs);
        }
        return run;
    }

    public static void clearRuntimeOfRunnable(Runnable runnable, CoreType coreType, EMap<ModeLabel, ModeLiteral> modes) {
        List<Instructions> instructionElements = SoftwareUtil.getInstructionsList(runnable, coreType, modes);
        instructionElements.remove(null);
        if (coreType == null) {
            for (Instructions instr : instructionElements) {
                runnable.getRunnableItems().remove((Object)instr.eContainer());
            }
        } else {
            for (Instructions instr : instructionElements) {
                if (instr.eContainer() instanceof RunnableInstructions) continue;
                ((RunnableInstructions)instr.eContainer().eContainer()).getExtended().removeKey((Object)instr);
            }
        }
    }

    public static void clearRuntimeOfProcess(Process process, CoreType coreType, EMap<ModeLabel, ModeLiteral> modes) {
        List<Runnable> runnables = SoftwareUtil.getRunnableList(process, modes);
        for (Runnable runnable : runnables) {
            RuntimeUtil.clearRuntimeOfRunnable(runnable, coreType, modes);
        }
    }

    public static void clearRuntimeOfModel(Amalthea model, CoreType coreType, EMap<ModeLabel, ModeLiteral> modes) {
        ArrayList<Process> processes = new ArrayList<Process>();
        processes.addAll((Collection<Process>)model.getSwModel().getTasks());
        processes.addAll((Collection<Process>)model.getSwModel().getIsrs());
        for (Process process : processes) {
            RuntimeUtil.clearRuntimeOfProcess(process, coreType, modes);
        }
    }

    public static void setRuntimeOfRunnable(Runnable runnable, RunnableInstructions instructions, CoreType coreType, EMap<ModeLabel, ModeLiteral> modes) {
        RuntimeUtil.clearRuntimeOfRunnable(runnable, coreType, modes);
        RuntimeUtil.addRuntimeToRunnable(runnable, instructions);
    }

    public static LongObject getInstructionCountForTime(Core core, Time time) {
        LongObject instructions = AmaltheaFactory.eINSTANCE.createLongObject();
        double ipc = core.getCoreType().getInstructionsPerCycle();
        long frequency = HardwareUtil.getFrequencyOfCore(core);
        int power = TimeUnit.VALUES.indexOf((Object)time.getUnit()) - TimeUnit.VALUES.indexOf((Object)TimeUnit.S);
        double factor = Math.pow(1000.0, power);
        if (factor < 1.0) {
            factor = 1.0 / factor;
        }
        double multi = factor / (double)frequency;
        double ticks = time.getValue().doubleValue() / multi;
        instructions.setValue((long)(ticks / ipc));
        return instructions;
    }

    public static enum PositionType {
        FIRST,
        LAST;

    }

    public static enum TimeType {
        BCET,
        ACET,
        WCET;

    }
}

