/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.app4mc.amalthea.model.CallSequence;
import org.eclipse.app4mc.amalthea.model.CallSequenceItem;
import org.eclipse.app4mc.amalthea.model.ClearEvent;
import org.eclipse.app4mc.amalthea.model.ExecutionNeed;
import org.eclipse.app4mc.amalthea.model.GraphEntryBase;
import org.eclipse.app4mc.amalthea.model.Group;
import org.eclipse.app4mc.amalthea.model.HwFeature;
import org.eclipse.app4mc.amalthea.model.Label;
import org.eclipse.app4mc.amalthea.model.LabelAccess;
import org.eclipse.app4mc.amalthea.model.LabelAccessEnum;
import org.eclipse.app4mc.amalthea.model.LabelAccessStatistic;
import org.eclipse.app4mc.amalthea.model.MinAvgMaxStatistic;
import org.eclipse.app4mc.amalthea.model.ModeLabel;
import org.eclipse.app4mc.amalthea.model.ModeLiteral;
import org.eclipse.app4mc.amalthea.model.ModeSwitch;
import org.eclipse.app4mc.amalthea.model.ModeSwitchEntry;
import org.eclipse.app4mc.amalthea.model.Need;
import org.eclipse.app4mc.amalthea.model.NumericStatistic;
import org.eclipse.app4mc.amalthea.model.ProbabilitySwitch;
import org.eclipse.app4mc.amalthea.model.ProbabilitySwitchEntry;
import org.eclipse.app4mc.amalthea.model.Process;
import org.eclipse.app4mc.amalthea.model.ProcessingUnitDefinition;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableCall;
import org.eclipse.app4mc.amalthea.model.RunnableItem;
import org.eclipse.app4mc.amalthea.model.RunnableModeSwitch;
import org.eclipse.app4mc.amalthea.model.RunnableProbabilitySwitch;
import org.eclipse.app4mc.amalthea.model.ServerCall;
import org.eclipse.app4mc.amalthea.model.SetEvent;
import org.eclipse.app4mc.amalthea.model.SingleValueStatistic;
import org.eclipse.app4mc.amalthea.model.TaskRunnableCall;
import org.eclipse.app4mc.amalthea.model.WaitEvent;
import org.eclipse.app4mc.amalthea.model.util.ModelUtil;
import org.eclipse.app4mc.amalthea.model.util.RuntimeUtil;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;

public class SoftwareUtil {
    public static EList<CallSequenceItem> collectCalls(Process process) {
        return SoftwareUtil.collectCalls(process, null, null);
    }

    public static EList<CallSequenceItem> collectCalls(Process process, EMap<ModeLabel, ModeLiteral> modes) {
        return SoftwareUtil.collectCalls(process, modes, null);
    }

    public static EList<CallSequenceItem> collectCalls(Process process, EMap<ModeLabel, ModeLiteral> modes, Function<CallSequenceItem, Boolean> filter) {
        BasicEList itemList = new BasicEList();
        if (process.getCallGraph() != null) {
            SoftwareUtil.collectCallSequenceItems(process.getCallGraph().getGraphEntries(), modes, filter, (List<CallSequenceItem>)itemList);
        }
        return itemList;
    }

    private static void collectCallSequenceItems(EList<GraphEntryBase> input, EMap<ModeLabel, ModeLiteral> modes, Function<CallSequenceItem, Boolean> filter, List<CallSequenceItem> itemList) {
        for (GraphEntryBase entry : input) {
            if (entry instanceof ProbabilitySwitch) {
                ProbabilitySwitch propSwitch = (ProbabilitySwitch)entry;
                for (ProbabilitySwitchEntry pse : propSwitch.getEntries()) {
                    SoftwareUtil.collectCallSequenceItems(pse.getItems(), modes, filter, itemList);
                }
                continue;
            }
            if (entry instanceof ModeSwitch) {
                ModeSwitch modeSwitch = (ModeSwitch)entry;
                boolean includeDefault = true;
                for (ModeSwitchEntry mse : modeSwitch.getEntries()) {
                    if (modes == null) {
                        SoftwareUtil.collectCallSequenceItems(mse.getItems(), modes, filter, itemList);
                        continue;
                    }
                    if (!mse.getCondition().isSatisfiedBy(modes)) continue;
                    SoftwareUtil.collectCallSequenceItems(mse.getItems(), modes, filter, itemList);
                    includeDefault = false;
                }
                if (!includeDefault || modeSwitch.getDefaultEntry() == null) continue;
                SoftwareUtil.collectCallSequenceItems(modeSwitch.getDefaultEntry().getItems(), modes, filter, itemList);
                continue;
            }
            if (!(entry instanceof CallSequence)) continue;
            for (CallSequenceItem item : ((CallSequence)entry).getCalls()) {
                if (filter != null && !filter.apply(item).booleanValue()) continue;
                itemList.add(item);
            }
        }
    }

    public static EList<RunnableItem> collectRunnableItems(Runnable runnable) {
        return SoftwareUtil.collectRunnableItems(runnable, null, null);
    }

    public static EList<RunnableItem> collectRunnableItems(Runnable runnable, EMap<ModeLabel, ModeLiteral> modes) {
        return SoftwareUtil.collectRunnableItems(runnable, modes, null);
    }

    public static EList<RunnableItem> collectRunnableItems(Runnable runnable, EMap<ModeLabel, ModeLiteral> modes, Function<RunnableItem, Boolean> filter) {
        BasicEList itemList = new BasicEList();
        SoftwareUtil.collectRunnableItems(runnable.getRunnableItems(), modes, filter, (List<RunnableItem>)itemList);
        return itemList;
    }

    private static void collectRunnableItems(EList<RunnableItem> input, EMap<ModeLabel, ModeLiteral> modes, Function<RunnableItem, Boolean> filter, List<RunnableItem> itemList) {
        for (RunnableItem item : input) {
            if (item instanceof Group) {
                SoftwareUtil.collectRunnableItems(((Group)item).getItems(), modes, filter, itemList);
                continue;
            }
            if (item instanceof RunnableProbabilitySwitch) {
                RunnableProbabilitySwitch propSwitch = (RunnableProbabilitySwitch)item;
                for (ProbabilitySwitchEntry pse : propSwitch.getEntries()) {
                    SoftwareUtil.collectRunnableItems(pse.getItems(), modes, filter, itemList);
                }
                continue;
            }
            if (item instanceof RunnableModeSwitch) {
                RunnableModeSwitch modeSwitch = (RunnableModeSwitch)item;
                boolean includeDefault = true;
                for (ModeSwitchEntry mse : modeSwitch.getEntries()) {
                    if (modes == null) {
                        SoftwareUtil.collectRunnableItems(mse.getItems(), modes, filter, itemList);
                        continue;
                    }
                    if (!mse.getCondition().isSatisfiedBy(modes)) continue;
                    SoftwareUtil.collectRunnableItems(mse.getItems(), modes, filter, itemList);
                    includeDefault = false;
                }
                if (!includeDefault || modeSwitch.getDefaultEntry() == null) continue;
                SoftwareUtil.collectRunnableItems(modeSwitch.getDefaultEntry().getItems(), modes, filter, itemList);
                continue;
            }
            if (filter != null && !filter.apply(item).booleanValue()) continue;
            itemList.add(item);
        }
    }

    public static Set<Label> getAccessedLabelSet(Runnable runnable, EMap<ModeLabel, ModeLiteral> modes) {
        ArrayList<RunnableItem> runItem = new ArrayList<RunnableItem>();
        runItem.addAll((Collection<RunnableItem>)SoftwareUtil.collectRunnableItems(runnable, modes));
        HashSet<Label> result = new HashSet<Label>();
        for (RunnableItem ri : runItem) {
            if (!(ri instanceof LabelAccess)) continue;
            result.add(((LabelAccess)ri).getData());
        }
        return result;
    }

    public static Set<Label> getWriteLabelSet(Runnable runnable, EMap<ModeLabel, ModeLiteral> modes) {
        ArrayList<RunnableItem> runItem = new ArrayList<RunnableItem>();
        runItem.addAll((Collection<RunnableItem>)SoftwareUtil.collectRunnableItems(runnable, modes));
        HashSet<Label> result = new HashSet<Label>();
        for (RunnableItem ri : runItem) {
            if (!(ri instanceof LabelAccess) || !((LabelAccess)ri).getAccess().equals((Object)LabelAccessEnum.WRITE)) continue;
            result.add(((LabelAccess)ri).getData());
        }
        return result;
    }

    public static List<LabelAccess> getWriteLabelAccessList(Runnable runnable, EMap<ModeLabel, ModeLiteral> modes) {
        ArrayList<RunnableItem> runItem = new ArrayList<RunnableItem>();
        runItem.addAll((Collection<RunnableItem>)SoftwareUtil.collectRunnableItems(runnable, modes));
        ArrayList<LabelAccess> result = new ArrayList<LabelAccess>();
        for (RunnableItem ri : runItem) {
            if (!(ri instanceof LabelAccess) || !((LabelAccess)ri).getAccess().equals((Object)LabelAccessEnum.WRITE)) continue;
            result.add((LabelAccess)ri);
        }
        return result;
    }

    public static Set<Label> getReadLabelSet(Runnable runnable, EMap<ModeLabel, ModeLiteral> modes) {
        ArrayList<RunnableItem> runItem = new ArrayList<RunnableItem>();
        runItem.addAll((Collection<RunnableItem>)SoftwareUtil.collectRunnableItems(runnable, modes));
        HashSet<Label> result = new HashSet<Label>();
        for (RunnableItem ri : runItem) {
            if (!(ri instanceof LabelAccess) || !((LabelAccess)ri).getAccess().equals((Object)LabelAccessEnum.READ)) continue;
            result.add(((LabelAccess)ri).getData());
        }
        return result;
    }

    public static List<LabelAccess> getReadLabelAccessesList(Runnable runnable, EMap<ModeLabel, ModeLiteral> modes) {
        ArrayList<RunnableItem> runItem = new ArrayList<RunnableItem>();
        runItem.addAll((Collection<RunnableItem>)SoftwareUtil.collectRunnableItems(runnable, modes));
        ArrayList<LabelAccess> result = new ArrayList<LabelAccess>();
        for (RunnableItem ri : runItem) {
            if (!(ri instanceof LabelAccess) || !((LabelAccess)ri).getAccess().equals((Object)LabelAccessEnum.READ)) continue;
            result.add((LabelAccess)ri);
        }
        return result;
    }

    public static List<LabelAccess> getLabelAccessList(Runnable runnable, EMap<ModeLabel, ModeLiteral> modes) {
        ArrayList<LabelAccess> result = new ArrayList<LabelAccess>();
        ArrayList<RunnableItem> runItem = new ArrayList<RunnableItem>();
        runItem.addAll((Collection<RunnableItem>)SoftwareUtil.collectRunnableItems(runnable, modes));
        for (RunnableItem ri : runItem) {
            if (!(ri instanceof LabelAccess)) continue;
            result.add((LabelAccess)ri);
        }
        return result;
    }

    public static Map<Label, List<LabelAccess>> getLabelToLabelAccessMap(Runnable runnable, EMap<ModeLabel, ModeLiteral> modes) {
        HashMap<Label, List<LabelAccess>> result = new HashMap<Label, List<LabelAccess>>();
        ArrayList<RunnableItem> runItem = new ArrayList<RunnableItem>();
        runItem.addAll((Collection<RunnableItem>)SoftwareUtil.collectRunnableItems(runnable, modes));
        for (RunnableItem ri : runItem) {
            if (!(ri instanceof LabelAccess)) continue;
            Label label = ((LabelAccess)ri).getData();
            if (result.get(label) == null) {
                result.put(label, new ArrayList());
            }
            ((List)result.get(label)).add((LabelAccess)ri);
        }
        return result;
    }

    public static Map<Label, List<LabelAccessStatistic>> getLabelAccessStatisticsMap(Runnable runnable, EMap<ModeLabel, ModeLiteral> modes) {
        HashMap<Label, List<LabelAccessStatistic>> result = new HashMap<Label, List<LabelAccessStatistic>>();
        ArrayList<RunnableItem> runItem = new ArrayList<RunnableItem>();
        runItem.addAll((Collection<RunnableItem>)SoftwareUtil.collectRunnableItems(runnable, modes));
        for (RunnableItem ri : runItem) {
            if (!(ri instanceof LabelAccess) || ((LabelAccess)ri).getStatistic() == null) continue;
            LabelAccess la = (LabelAccess)ri;
            if (!result.containsKey(la.getData())) {
                result.put(la.getData(), new ArrayList());
            }
            ((List)result.get(la.getData())).add(la.getStatistic());
        }
        return result;
    }

    public static Map<Label, List<LabelAccessStatistic>> getReadLabelAccessStatisticsMap(Runnable runnable, EMap<ModeLabel, ModeLiteral> modes) {
        HashMap<Label, List<LabelAccessStatistic>> result = new HashMap<Label, List<LabelAccessStatistic>>();
        ArrayList<RunnableItem> runItem = new ArrayList<RunnableItem>();
        runItem.addAll((Collection<RunnableItem>)SoftwareUtil.collectRunnableItems(runnable, modes));
        for (RunnableItem ri : runItem) {
            if (!(ri instanceof LabelAccess) || ((LabelAccess)ri).getStatistic() == null || !((LabelAccess)ri).getAccess().equals((Object)LabelAccessEnum.READ)) continue;
            LabelAccess la = (LabelAccess)ri;
            if (!result.containsKey(la.getData())) {
                result.put(la.getData(), new ArrayList());
            }
            ((List)result.get(la.getData())).add(la.getStatistic());
        }
        return result;
    }

    public static Map<Label, List<LabelAccessStatistic>> getWriteLabelAccessStatisticsMap(Runnable runnable, EMap<ModeLabel, ModeLiteral> modes) {
        HashMap<Label, List<LabelAccessStatistic>> result = new HashMap<Label, List<LabelAccessStatistic>>();
        ArrayList<RunnableItem> runItem = new ArrayList<RunnableItem>();
        runItem.addAll((Collection<RunnableItem>)SoftwareUtil.collectRunnableItems(runnable, modes));
        for (RunnableItem ri : runItem) {
            if (!(ri instanceof LabelAccess) || ((LabelAccess)ri).getStatistic() == null || !((LabelAccess)ri).getAccess().equals((Object)LabelAccessEnum.WRITE)) continue;
            LabelAccess la = (LabelAccess)ri;
            if (!result.containsKey(la.getData())) {
                result.put(la.getData(), new ArrayList());
            }
            ((List)result.get(la.getData())).add(la.getStatistic());
        }
        return result;
    }

    public static Set<Label> getAccessedLabelSet(Process process, EMap<ModeLabel, ModeLiteral> modes) {
        HashSet<Label> result = new HashSet<Label>();
        for (Runnable r : SoftwareUtil.getRunnableList(process, modes)) {
            result.addAll(SoftwareUtil.getAccessedLabelSet(r, modes));
        }
        return result;
    }

    public static Set<Label> getWriteLabelSet(Process process, EMap<ModeLabel, ModeLiteral> modes) {
        HashSet<Label> result = new HashSet<Label>();
        for (Runnable r : SoftwareUtil.getRunnableList(process, modes)) {
            result.addAll(SoftwareUtil.getWriteLabelSet(r, modes));
        }
        return result;
    }

    public static Set<Label> getReadLabelSet(Process process, EMap<ModeLabel, ModeLiteral> modes) {
        HashSet<Label> result = new HashSet<Label>();
        for (Runnable r : SoftwareUtil.getRunnableList(process, modes)) {
            result.addAll(SoftwareUtil.getReadLabelSet(r, modes));
        }
        return result;
    }

    public static List<LabelAccess> getLabelAccessList(Process process, EMap<ModeLabel, ModeLiteral> modes) {
        ArrayList<LabelAccess> result = new ArrayList<LabelAccess>();
        for (Runnable r : SoftwareUtil.getRunnableList(process, modes)) {
            result.addAll(SoftwareUtil.getLabelAccessList(r, modes));
        }
        return result;
    }

    public static Map<Label, List<LabelAccess>> getLabelToLabelAccessMap(Process process, EMap<ModeLabel, ModeLiteral> modes) {
        HashMap<Label, List<LabelAccess>> result = new HashMap<Label, List<LabelAccess>>();
        for (Runnable r : SoftwareUtil.getRunnableList(process, modes)) {
            Map<Label, List<LabelAccess>> labelToLabelAccessMap = SoftwareUtil.getLabelToLabelAccessMap(r, modes);
            for (Label label : labelToLabelAccessMap.keySet()) {
                if (!result.containsKey(label)) {
                    result.put(label, new ArrayList());
                }
                result.get(label).addAll((Collection<LabelAccess>)labelToLabelAccessMap.get(label));
            }
        }
        return result;
    }

    public static Map<Label, List<LabelAccessStatistic>> getLabelAccessStatisticsMap(Process process, EMap<ModeLabel, ModeLiteral> modes) {
        HashMap<Label, List<LabelAccessStatistic>> result = new HashMap<Label, List<LabelAccessStatistic>>();
        for (Runnable r : SoftwareUtil.getRunnableList(process, modes)) {
            Map<Label, List<LabelAccessStatistic>> labelToLabelAccessMap = SoftwareUtil.getLabelAccessStatisticsMap(r, modes);
            for (Label l : labelToLabelAccessMap.keySet()) {
                if (!result.containsKey(l)) {
                    result.put(l, new ArrayList());
                }
                result.get(l).addAll((Collection<LabelAccessStatistic>)labelToLabelAccessMap.get(l));
            }
        }
        return result;
    }

    public static Map<Label, List<LabelAccessStatistic>> getReadLabelAccessStatisticsMap(Process process, EMap<ModeLabel, ModeLiteral> modes) {
        HashMap<Label, List<LabelAccessStatistic>> result = new HashMap<Label, List<LabelAccessStatistic>>();
        for (Runnable r : SoftwareUtil.getRunnableList(process, modes)) {
            Map<Label, List<LabelAccessStatistic>> readLabelAccessStatisticsMap = SoftwareUtil.getReadLabelAccessStatisticsMap(r, modes);
            for (Label l : readLabelAccessStatisticsMap.keySet()) {
                if (!result.containsKey(l)) {
                    result.put(l, new ArrayList());
                }
                result.get(l).addAll((Collection<LabelAccessStatistic>)readLabelAccessStatisticsMap.get(l));
            }
        }
        return result;
    }

    public static Map<Label, List<LabelAccessStatistic>> getWriteLabelAccessStatisticsMap(Process process, EMap<ModeLabel, ModeLiteral> modes) {
        HashMap<Label, List<LabelAccessStatistic>> result = new HashMap<Label, List<LabelAccessStatistic>>();
        for (Runnable r : SoftwareUtil.getRunnableList(process, modes)) {
            Map<Label, List<LabelAccessStatistic>> writeLabelAcessStatisticsMap = SoftwareUtil.getWriteLabelAccessStatisticsMap(r, modes);
            for (Label l : writeLabelAcessStatisticsMap.keySet()) {
                if (!result.containsKey(l)) {
                    result.put(l, new ArrayList());
                }
                result.get(l).addAll((Collection<LabelAccessStatistic>)writeLabelAcessStatisticsMap.get(l));
            }
        }
        return result;
    }

    public static float getLabelReadCount(Label label, Process process, EMap<ModeLabel, ModeLiteral> modes, RuntimeUtil.TimeType timeType) {
        float reads = 0.0f;
        if (timeType == null) {
            timeType = RuntimeUtil.TimeType.ACET;
        }
        for (Runnable r : SoftwareUtil.getRunnableList(process, modes)) {
            List<LabelAccess> readLabelAccessesOfRunnable = SoftwareUtil.getReadLabelAccessesList(r, modes);
            for (LabelAccess la : readLabelAccessesOfRunnable) {
                NumericStatistic statistic = la.getStatistic().getValue();
                if (statistic instanceof SingleValueStatistic) {
                    SingleValueStatistic svs = (SingleValueStatistic)statistic;
                    reads += svs.getValue();
                    continue;
                }
                if (!(statistic instanceof MinAvgMaxStatistic)) continue;
                MinAvgMaxStatistic stat = (MinAvgMaxStatistic)statistic;
                switch (timeType) {
                    case ACET: {
                        reads += stat.getAvg();
                        break;
                    }
                    case BCET: {
                        reads += (float)stat.getMin();
                        break;
                    }
                    case WCET: {
                        reads += (float)stat.getMax();
                    }
                }
            }
        }
        return reads;
    }

    public static float getLabelWriteCount(Label label, Process process, EMap<ModeLabel, ModeLiteral> modes, RuntimeUtil.TimeType timeType) {
        float writes = 0.0f;
        if (timeType == null) {
            timeType = RuntimeUtil.TimeType.ACET;
        }
        for (Runnable r : SoftwareUtil.getRunnableList(process, modes)) {
            List<LabelAccess> writeLabelAccessesOfRunnable = SoftwareUtil.getWriteLabelAccessList(r, modes);
            for (LabelAccess la : writeLabelAccessesOfRunnable) {
                NumericStatistic statistic = la.getStatistic().getValue();
                if (statistic instanceof SingleValueStatistic) {
                    SingleValueStatistic svs = (SingleValueStatistic)statistic;
                    writes += svs.getValue();
                    continue;
                }
                if (!(statistic instanceof MinAvgMaxStatistic)) continue;
                MinAvgMaxStatistic stat = (MinAvgMaxStatistic)statistic;
                switch (timeType) {
                    case ACET: {
                        writes += stat.getAvg();
                        break;
                    }
                    case BCET: {
                        writes += (float)stat.getMin();
                        break;
                    }
                    case WCET: {
                        writes += (float)stat.getMax();
                    }
                }
            }
        }
        return writes;
    }

    public static List<Runnable> getRunnableList(Process process, EMap<ModeLabel, ModeLiteral> modes) {
        ArrayList<Runnable> result = new ArrayList<Runnable>();
        EList<CallSequenceItem> callItems = SoftwareUtil.collectCalls(process, modes);
        for (CallSequenceItem call : callItems) {
            if (!(call instanceof TaskRunnableCall)) continue;
            result.add(((TaskRunnableCall)call).getRunnable());
        }
        return result;
    }

    public static Set<Runnable> getRunnableSet(Process process, EMap<ModeLabel, ModeLiteral> modes) {
        return new HashSet<Runnable>(SoftwareUtil.getRunnableList(process, modes));
    }

    public static float getLabelAccessCountFromStatistics(LabelAccess labelAcc, RuntimeUtil.TimeType accType) {
        float accesses = 1.0f;
        if (labelAcc.getStatistic() == null) {
            return 1.0f;
        }
        if (labelAcc.getStatistic().getValue() instanceof SingleValueStatistic) {
            accesses = ((SingleValueStatistic)labelAcc.getStatistic().getValue()).getValue();
        } else if (labelAcc.getStatistic().getValue() instanceof MinAvgMaxStatistic) {
            switch (accType) {
                case ACET: {
                    accesses = ((MinAvgMaxStatistic)labelAcc.getStatistic().getValue()).getAvg();
                    break;
                }
                case BCET: {
                    accesses = ((MinAvgMaxStatistic)labelAcc.getStatistic().getValue()).getMin();
                    break;
                }
                case WCET: {
                    accesses = ((MinAvgMaxStatistic)labelAcc.getStatistic().getValue()).getMax();
                    break;
                }
                default: {
                    accesses = ((MinAvgMaxStatistic)labelAcc.getStatistic().getValue()).getAvg();
                }
            }
        }
        return accesses;
    }

    public static List<Runnable> getReaderListOfLabel(Label label, EMap<ModeLabel, ModeLiteral> modes) {
        ArrayList<Runnable> result = new ArrayList<Runnable>();
        for (LabelAccess la : label.getLabelAccesses()) {
            if (!la.getAccess().equals((Object)LabelAccessEnum.READ)) continue;
            Runnable run = ModelUtil.getParentContainer(la, Runnable.class);
            if (modes != null && !modes.isEmpty() && !SoftwareUtil.collectRunnableItems(run, modes).contains((Object)la)) continue;
            result.add(ModelUtil.getParentContainer(la, Runnable.class));
        }
        return result;
    }

    public static List<SetEvent> collectSetEvents(Process process, EMap<ModeLabel, ModeLiteral> modes) {
        ArrayList<SetEvent> result = new ArrayList<SetEvent>();
        for (CallSequenceItem call : SoftwareUtil.collectEventsOfProcess(process, modes)) {
            if (!(call instanceof SetEvent)) continue;
            result.add((SetEvent)call);
        }
        return result;
    }

    public static List<ClearEvent> collectClearEvents(Process process, EMap<ModeLabel, ModeLiteral> modes) {
        ArrayList<ClearEvent> result = new ArrayList<ClearEvent>();
        for (CallSequenceItem call : SoftwareUtil.collectEventsOfProcess(process, modes)) {
            if (!(call instanceof ClearEvent)) continue;
            result.add((ClearEvent)call);
        }
        return result;
    }

    public static List<WaitEvent> collectWaitEvents(Process process, EMap<ModeLabel, ModeLiteral> modes) {
        ArrayList<WaitEvent> result = new ArrayList<WaitEvent>();
        for (CallSequenceItem call : SoftwareUtil.collectEventsOfProcess(process, modes)) {
            if (!(call instanceof WaitEvent)) continue;
            result.add((WaitEvent)call);
        }
        return result;
    }

    public static List<CallSequenceItem> collectEventsOfProcess(Process process, EMap<ModeLabel, ModeLiteral> modes) {
        ArrayList<CallSequenceItem> result = new ArrayList<CallSequenceItem>();
        EList<CallSequenceItem> calls = SoftwareUtil.collectCalls(process, modes);
        for (CallSequenceItem call : calls) {
            if (!(call instanceof ClearEvent) && !(call instanceof SetEvent) && !(call instanceof WaitEvent)) continue;
            result.add(call);
        }
        return result;
    }

    public static Set<Runnable> getReadersSetOfLabel(Label label, EMap<ModeLabel, ModeLiteral> modes) {
        return new HashSet<Runnable>(SoftwareUtil.getReaderListOfLabel(label, modes));
    }

    public static List<Runnable> getWriterListOfLabel(Label label, EMap<ModeLabel, ModeLiteral> modes) {
        ArrayList<Runnable> result = new ArrayList<Runnable>();
        for (LabelAccess la : label.getLabelAccesses()) {
            if (!la.getAccess().equals((Object)LabelAccessEnum.WRITE)) continue;
            Runnable run = ModelUtil.getParentContainer(la, Runnable.class);
            if (modes != null && !modes.isEmpty() && !SoftwareUtil.collectRunnableItems(run, modes).contains((Object)la)) continue;
            result.add(ModelUtil.getParentContainer(la, Runnable.class));
        }
        return result;
    }

    public static Set<Runnable> getWriterSetOfLabel(Label label, EMap<ModeLabel, ModeLiteral> modes) {
        return new HashSet<Runnable>(SoftwareUtil.getWriterListOfLabel(label, modes));
    }

    public static List<Label> getInterTaskCommunication(Process sender, Process receiver, EMap<ModeLabel, ModeLiteral> modes) {
        ArrayList<Label> result = new ArrayList<Label>();
        result.addAll(SoftwareUtil.getWriteLabelSet(sender, modes));
        result.retainAll(SoftwareUtil.getReadLabelSet(receiver, modes));
        return result;
    }

    public static List<Process> getProcesses(Runnable runnable, EMap<ModeLabel, ModeLiteral> modes) {
        ArrayList<Process> result = new ArrayList<Process>();
        for (TaskRunnableCall trc : runnable.getTaskRunnableCalls()) {
            Process proc = ModelUtil.getParentContainer(trc, Process.class);
            if (modes != null && !modes.isEmpty()) {
                if (!SoftwareUtil.getRunnableList(proc, modes).contains(runnable)) continue;
                result.add(proc);
                continue;
            }
            result.add(proc);
        }
        return result;
    }

    public static List<Runnable> getRunnableCallParents(Runnable runnable, EMap<ModeLabel, ModeLiteral> modes) {
        ArrayList<Runnable> result = new ArrayList<Runnable>();
        for (RunnableCall rc : runnable.getRunnableCalls()) {
            Runnable run = ModelUtil.getParentContainer(rc, Runnable.class);
            if (modes != null && !modes.isEmpty()) {
                EList<RunnableItem> runItems = SoftwareUtil.collectRunnableItems(run, modes);
                if (runItems == null || !runItems.isEmpty()) continue;
                for (RunnableItem runItem : runItems) {
                    if (!(runItem instanceof RunnableCall) || !((RunnableCall)runItem).getRunnable().equals(runnable)) continue;
                    result.add(run);
                }
                continue;
            }
            result.add(run);
        }
        return result;
    }

    public static List<Runnable> getCalledRunnables(Runnable runnable, EMap<ModeLabel, ModeLiteral> modes) {
        ArrayList<Runnable> result = new ArrayList<Runnable>();
        EList<RunnableItem> collectRunnableItems = SoftwareUtil.collectRunnableItems(runnable, modes);
        for (RunnableItem runItem : collectRunnableItems) {
            if (!(runItem instanceof RunnableCall)) continue;
            result.add(((RunnableCall)runItem).getRunnable());
        }
        return result;
    }

    public static List<ExecutionNeed> getExecutionNeedsList(Runnable runnable, EMap<ModeLabel, ModeLiteral> modes) {
        ArrayList<ExecutionNeed> result = new ArrayList<ExecutionNeed>();
        EList<RunnableItem> runnableItems = SoftwareUtil.collectRunnableItems(runnable, modes);
        for (RunnableItem ri : runnableItems) {
            if (!(ri instanceof ExecutionNeed)) continue;
            result.add((ExecutionNeed)ri);
        }
        return result;
    }

    public static List<ExecutionNeed> getExecutionNeedsList(Process process, EMap<ModeLabel, ModeLiteral> modes) {
        ArrayList<ExecutionNeed> result = new ArrayList<ExecutionNeed>();
        List<Runnable> runnableSet = SoftwareUtil.getRunnableList(process, modes);
        for (Runnable run : runnableSet) {
            result.addAll(SoftwareUtil.getExecutionNeedsList(run, modes));
        }
        return result;
    }

    public static List<Map.Entry<String, Need>> getExecutionNeedEntryList(Process process, ProcessingUnitDefinition puDefinition, List<HwFeature> hwFeatures, EMap<ModeLabel, ModeLiteral> modes) {
        List<Runnable> runnables = SoftwareUtil.getRunnableList(process, modes);
        ArrayList<Map.Entry<String, Need>> result = new ArrayList<Map.Entry<String, Need>>();
        for (Runnable runnable : runnables) {
            result.addAll(SoftwareUtil.getExecutionNeedEntryList(runnable, puDefinition, hwFeatures, modes));
        }
        return result;
    }

    public static List<Map.Entry<String, Need>> getExecutionNeedEntryList(Runnable runnable, ProcessingUnitDefinition puDefinition, List<HwFeature> hwFeatures, EMap<ModeLabel, ModeLiteral> modes) {
        ArrayList<Map.Entry<String, Need>> result = new ArrayList<Map.Entry<String, Need>>();
        if (puDefinition == null || hwFeatures == null) {
            return result;
        }
        EList<RunnableItem> runnableItems = SoftwareUtil.collectRunnableItems(runnable, modes);
        for (RunnableItem ri : runnableItems) {
            if (!(ri instanceof ExecutionNeed)) continue;
            ExecutionNeed runnableExecutionNeed = (ExecutionNeed)ri;
            if (runnableExecutionNeed.getExtended().get((Object)puDefinition) != null) {
                for (Map.Entry needEntry : (EMap)runnableExecutionNeed.getExtended().get((Object)puDefinition)) {
                    for (HwFeature feature : hwFeatures) {
                        if (!feature.getContainingCategory().getName().equals(needEntry.getKey()) || !puDefinition.getFeatures().contains((Object)feature)) continue;
                        result.add(needEntry);
                    }
                }
                continue;
            }
            if (runnableExecutionNeed.getDefault() == null) continue;
            for (Map.Entry needEntry : runnableExecutionNeed.getDefault()) {
                for (HwFeature feature : hwFeatures) {
                    if (!feature.getContainingCategory().getName().equals(needEntry.getKey()) || !puDefinition.getFeatures().contains((Object)feature)) continue;
                    result.add(needEntry);
                }
            }
        }
        return result;
    }

    public static Set<ServerCall> getServerCallSet(Process process, EMap<ModeLabel, ModeLiteral> modes) {
        HashSet<ServerCall> result = new HashSet<ServerCall>();
        for (Runnable r : SoftwareUtil.getRunnableList(process, modes)) {
            result.addAll(SoftwareUtil.getServerCallSet(r, modes));
        }
        return result;
    }

    public static Set<ServerCall> getServerCallSet(Runnable runnable, EMap<ModeLabel, ModeLiteral> modes) {
        ArrayList<RunnableItem> runItem = new ArrayList<RunnableItem>();
        runItem.addAll((Collection<RunnableItem>)SoftwareUtil.collectRunnableItems(runnable, modes));
        HashSet<ServerCall> result = new HashSet<ServerCall>();
        for (RunnableItem ri : runItem) {
            if (!(ri instanceof ServerCall)) continue;
            result.add((ServerCall)ri);
        }
        return result;
    }
}

