/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.sphinx.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.HWModel;
import org.eclipse.app4mc.amalthea.model.provider.HWModelItemProvider;
import org.eclipse.app4mc.amalthea.sphinx.ui.hw.container.HwDefinitionIP;
import org.eclipse.app4mc.amalthea.sphinx.ui.hw.container.HwDomainIP;
import org.eclipse.app4mc.amalthea.sphinx.ui.hw.container.HwFeatureIP;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ViewerNotification;

public class ExtendedHWModelItemProvider
extends HWModelItemProvider {
    protected HwFeatureIP hwFeatureIP;
    protected HwDefinitionIP hwDefinitionIP;
    protected HwDomainIP hwDomainIP;

    public ExtendedHWModelItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public Object getHwFeatures(HWModel hwModel) {
        if (this.hwFeatureIP == null) {
            this.hwFeatureIP = new HwFeatureIP(this.adapterFactory, hwModel);
        }
        return this.hwFeatureIP;
    }

    public Object getHwDefinitions(HWModel hwModel) {
        if (this.hwDefinitionIP == null) {
            this.hwDefinitionIP = new HwDefinitionIP(this.adapterFactory, hwModel);
        }
        return this.hwDefinitionIP;
    }

    public Object getHwDomains(HWModel hwModel) {
        if (this.hwDomainIP == null) {
            this.hwDomainIP = new HwDomainIP(this.adapterFactory, hwModel);
        }
        return this.hwDomainIP;
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        super.getChildrenFeatures(object);
        this.childrenFeatures.remove(AmaltheaPackage.eINSTANCE.getHWModel_FeatureCategories());
        this.childrenFeatures.remove(AmaltheaPackage.eINSTANCE.getHWModel_Definitions());
        this.childrenFeatures.remove(AmaltheaPackage.eINSTANCE.getHWModel_Domains());
        return this.childrenFeatures;
    }

    public Collection<?> getChildren(Object object) {
        ArrayList<Object> children = new ArrayList<Object>(super.getChildren(object));
        HWModel hwModel = (HWModel)object;
        if (!hwModel.getFeatureCategories().isEmpty()) {
            children.add(0, this.getHwFeatures(hwModel));
        }
        if (!hwModel.getDomains().isEmpty()) {
            children.add(0, this.getHwDomains(hwModel));
        }
        if (!hwModel.getDefinitions().isEmpty()) {
            children.add(0, this.getHwDefinitions(hwModel));
        }
        return children;
    }

    protected Command createAddCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection, int index) {
        return this.createWrappedCommand(super.createAddCommand(domain, owner, feature, collection, index), owner, feature);
    }

    protected Command createRemoveCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection) {
        return this.createWrappedCommand(super.createRemoveCommand(domain, owner, feature, collection), owner, feature);
    }

    protected Command createWrappedCommand(Command command, final EObject owner, final EStructuralFeature feature) {
        if (feature.getFeatureID() == 2 || feature.getFeatureID() == 1 || feature.getFeatureID() == 4) {
            return new CommandWrapper(command){

                public Collection<?> getAffectedObjects() {
                    Set<Object> affected = super.getAffectedObjects();
                    if (affected.contains(owner)) {
                        if (feature.getFeatureID() == 2) {
                            affected = Collections.singleton(ExtendedHWModelItemProvider.this.getHwFeatures((HWModel)owner));
                        } else if (feature.getFeatureID() == 1) {
                            affected = Collections.singleton(ExtendedHWModelItemProvider.this.getHwDefinitions((HWModel)owner));
                        } else if (feature.getFeatureID() == 4) {
                            affected = Collections.singleton(ExtendedHWModelItemProvider.this.getHwDomains((HWModel)owner));
                        }
                    }
                    return affected;
                }
            };
        }
        return command;
    }

    public void dispose() {
        if (this.hwFeatureIP != null) {
            this.hwFeatureIP.dispose();
        }
        if (this.hwDefinitionIP != null) {
            this.hwDefinitionIP.dispose();
        }
        if (this.hwDomainIP != null) {
            this.hwDomainIP.dispose();
        }
        super.dispose();
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(HWModel.class)) {
            case 1: 
            case 2: 
            case 4: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }
}

