/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.partitioning.handlers;

import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.multicore.partitioning.PartitioningPlugin;
import org.eclipse.app4mc.multicore.partitioning.algorithms.PartitioningJob;
import org.eclipse.app4mc.multicore.partitioning.specs.PartitioningModelDescriptionBuilder;
import org.eclipse.app4mc.multicore.partitioning.utils.Helper;
import org.eclipse.app4mc.multicore.partitioning.utils.PartLog;
import org.eclipse.app4mc.multicore.sharelibs.SelectionUtil;
import org.eclipse.app4mc.multicore.sharelibs.UniversalHandler;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.ModelDescription;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.preference.IPreferenceStore;

public class PartitioningHandler
extends AbstractHandler {
    private IPreferenceStore store = PartitioningPlugin.getDefault().getPreferenceStore();

    public PartitioningHandler() {
        this.store = PartitioningPlugin.getDefault().getPreferenceStore();
    }

    public PartitioningHandler(IPreferenceStore store) {
        this.store = store;
    }

    public IPreferenceStore getPreferenceStore() {
        return this.store;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        UniversalHandler uh = UniversalHandler.getInstance();
        PartLog.getInstance().setLogName("PrePartitioning");
        uh.clearModelCheckerView();
        PartLog.getInstance().setEnableTargetConsoleLog(this.store.getBoolean("org.eclipse.app4mc.multicore.partitioning.debug"));
        IFile file = SelectionUtil.getSelectedFile((ExecutionEvent)event);
        uh.dropCache();
        URI uriSwModel = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        uh.readModels(uriSwModel, true);
        Amalthea amodels = AmaltheaFactory.eINSTANCE.createAmalthea();
        amodels = new Helper().setAllModels(amodels, uh);
        ModelDescription modelChecker = PartitioningModelDescriptionBuilder.ofInput(null);
        boolean modelOk = modelChecker.checkModel(uriSwModel);
        if (!modelOk) {
            modelChecker.logToView();
            modelChecker.openMessageBox();
            return null;
        }
        PartitioningJob part = new PartitioningJob("Partitioning", amodels, this.store, file);
        part.schedule();
        try {
            part.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        modelChecker.logToView();
        modelChecker.openMessageBox();
        return null;
    }
}

