/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.dialogs.openmapping.handlers;

import org.eclipse.app4mc.multicore.openmapping.algorithms.AbstractMappingAlgorithm;
import org.eclipse.app4mc.multicore.sharelibs.UniversalHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;

public class PerformMappingJob
extends Job {
    private final AbstractMappingAlgorithm mappingAlgorithm;
    private final URI pathSwModel;
    private final URI pathHwModel;
    private final URI path;

    public PerformMappingJob(AbstractMappingAlgorithm mappingAlgorithm, URI pathSwModel, URI pathPcModel, URI pathHwModel, URI path) {
        super("Mapping Job");
        this.mappingAlgorithm = mappingAlgorithm;
        this.pathSwModel = pathSwModel;
        this.pathHwModel = pathHwModel;
        this.path = path;
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask("Performing mapping...", 3);
        monitor.subTask("Reading models");
        if (!this.readModels()) {
            return Status.CANCEL_STATUS;
        }
        monitor.worked(1);
        monitor.subTask("Solving ILP model");
        if (!this.solve()) {
            return Status.CANCEL_STATUS;
        }
        monitor.worked(1);
        monitor.subTask("Writing models");
        if (!this.writeModels()) {
            return Status.CANCEL_STATUS;
        }
        monitor.worked(1);
        monitor.done();
        return Status.OK_STATUS;
    }

    private boolean readModels() {
        UniversalHandler.getInstance().readModels(this.pathSwModel, true);
        if (UniversalHandler.getInstance().getSwModel() == null) {
            UniversalHandler.getInstance().logCon("There seems to be no software model in the specified file.\nExiting...");
            return false;
        }
        if (UniversalHandler.getInstance().getConstraintsModel() == null) {
            UniversalHandler.getInstance().logCon("There seems to be no software model in the specified file.\nExiting...");
            return false;
        }
        if (UniversalHandler.getInstance().getStimuliModel() == null) {
            UniversalHandler.getInstance().logCon("There seems to be no stimulation model in the specified file.\nExiting...");
            return false;
        }
        if (UniversalHandler.getInstance().getCommonElements() != null) {
            UniversalHandler.getInstance().logCon("CommonElements Model set.");
        }
        if (UniversalHandler.getInstance().getPropertyConstraintsModel() != null) {
            UniversalHandler.getInstance().logCon("PropertyConstraints Model set.");
        }
        this.mappingAlgorithm.setAmaltheaSwModel(UniversalHandler.getInstance().getCentralModel());
        UniversalHandler.getInstance().dropCache();
        UniversalHandler.getInstance().readModels(this.pathHwModel, true);
        if (UniversalHandler.getInstance().getHwModel() == null) {
            UniversalHandler.getInstance().logCon("There seems to be no hardware model in the specified file.\nExiting...");
            return false;
        }
        this.mappingAlgorithm.setAmaltheaHwModel(UniversalHandler.getInstance().getCentralModel());
        return true;
    }

    private boolean solve() {
        this.mappingAlgorithm.calculateMapping();
        return true;
    }

    private boolean writeModels() {
        if (this.mappingAlgorithm.getAmaltheaOutputModel().getOsModel() == null) {
            UniversalHandler.getInstance().logCon("An error occured during the OSModel creation process");
            UniversalHandler.getInstance().logCon("Check the error logs for further details");
            return false;
        }
        if (this.mappingAlgorithm.getAmaltheaOutputModel().getMappingModel() == null) {
            UniversalHandler.getInstance().logCon("An error occured during the mapping creation process");
            UniversalHandler.getInstance().logCon("Check the error logs for further details");
            return false;
        }
        UniversalHandler.getInstance().logCon(this.path.toString());
        UniversalHandler.getInstance().writeModel(this.path, (EObject)this.mappingAlgorithm.getAmaltheaOutputModel());
        return true;
    }
}

