/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters083.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters083.impl.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters083.utils.HelperUtils_082_083;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class SwConverter
extends AbstractConverter {
    public SwConverter() {
        this.helper = HelperUtils_082_083.getInstance();
        this.logger = LogManager.getLogger((String)"org.eclipse.app4mc.amalthea.modelmigration");
    }

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) throws Exception {
        this.logger.info((Object)("Migration from 0.8.2 to 0.8.3  : Executing Component model converter for model file : " + targetFile.getName()));
        Document root = fileName_documentsMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.migrateModeSwitchElements(rootElement);
        this.migrateVariableRateActivationElements(rootElement);
        fileName_documentsMap.put(targetFile.getCanonicalFile(), root);
    }

    private void migrateVariableRateActivationElements(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("./swModel/activations[@xsi:type=\"am:VariableRateActivation\"]");
        List variableRateActivationElements = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi"), this.helper.getNS_083("am")});
        for (Element element : variableRateActivationElements) {
            element.removeChildren("activationDeviation");
        }
    }

    private void migrateModeSwitchElements(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("./swModel/isrs/callGraph/graphEntries[@xsi:type=\"am:ModeSwitch\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/tasks/callGraph/graphEntries[@xsi:type=\"am:ModeSwitch\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/isrs/callGraph/graphEntries//items[@xsi:type=\"am:ModeSwitch\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/tasks/callGraph/graphEntries//items[@xsi:type=\"am:ModeSwitch\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/runnables//runnableItems[@xsi:type=\"am:RunnableModeSwitch\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/runnables//items[@xsi:type=\"am:RunnableModeSwitch\"]");
        List modeSwitchElements = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi"), this.helper.getNS_083("am")});
        this.updateModeSwitchElement(modeSwitchElements);
    }

    private void updateModeSwitchElement(List<Element> modeSwitchElements) {
        for (Element modeSwitchElement : modeSwitchElements) {
            boolean isLocalModeLabelUsed = false;
            String modeLabelValue = null;
            Attribute valueProviderAttribute = modeSwitchElement.getAttribute("valueProvider");
            Element valueProviderChild = modeSwitchElement.getChild("valueProvider");
            if (valueProviderAttribute != null) {
                isLocalModeLabelUsed = true;
                modeLabelValue = valueProviderAttribute.getValue();
                modeSwitchElement.removeAttribute(valueProviderAttribute);
            } else if (valueProviderChild != null) {
                modeLabelValue = valueProviderChild.getAttributeValue("href");
                modeSwitchElement.removeContent((Content)valueProviderChild);
            }
            List entriesElements = modeSwitchElement.getChildren("entries");
            for (Element entriesElement : entriesElements) {
                String[] split;
                boolean isLocalLiteralsUsed = false;
                Attribute valuesAttribute = entriesElement.getAttribute("values");
                List valuesElements = entriesElement.getChildren("values");
                ArrayList<String> literals = new ArrayList<String>();
                if (valuesAttribute != null) {
                    isLocalLiteralsUsed = true;
                    String value = valuesAttribute.getValue();
                    String[] stringArray = split = value.split("\\s+");
                    int n = split.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String string = stringArray[n2];
                        literals.add(string);
                        ++n2;
                    }
                    entriesElement.removeAttribute(valuesAttribute);
                } else if (valuesElements != null) {
                    split = valuesElements.iterator();
                    while (split.hasNext()) {
                        Element valueElement = (Element)split.next();
                        String attributeValue = valueElement.getAttributeValue("href");
                        if (attributeValue == null) continue;
                        literals.add(attributeValue);
                    }
                    entriesElement.removeChildren("values");
                }
                Element conditionElement = new Element("condition");
                for (String literal : literals) {
                    Element entriesElementInsideConditionElement = new Element("entries");
                    entriesElementInsideConditionElement.setAttribute("type", "am:ModeValue", this.helper.getGenericNS("xsi"));
                    if (modeLabelValue != null) {
                        if (isLocalModeLabelUsed) {
                            entriesElementInsideConditionElement.setAttribute("valueProvider", modeLabelValue);
                        } else {
                            Element valueProviderElement = new Element("valueProvider");
                            entriesElementInsideConditionElement.addContent((Content)valueProviderElement);
                        }
                    }
                    if (isLocalLiteralsUsed) {
                        entriesElementInsideConditionElement.setAttribute("value", literal);
                    } else {
                        Element valueElement = new Element("value");
                        valueElement.setAttribute("href", literal);
                        entriesElementInsideConditionElement.addContent((Content)valueElement);
                    }
                    conditionElement.addContent((Content)entriesElementInsideConditionElement);
                }
                entriesElement.addContent((Content)conditionElement);
            }
        }
    }
}

