/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validation.checks.impl;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.app4mc.amalthea.model.AbstractTime;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.DataRate;
import org.eclipse.app4mc.amalthea.model.DataRateUnit;
import org.eclipse.app4mc.amalthea.model.DataSize;
import org.eclipse.app4mc.amalthea.model.DataSizeUnit;
import org.eclipse.app4mc.amalthea.model.Deviation;
import org.eclipse.app4mc.amalthea.model.Frequency;
import org.eclipse.app4mc.amalthea.model.FrequencyUnit;
import org.eclipse.app4mc.amalthea.model.IAnnotatable;
import org.eclipse.app4mc.amalthea.model.IReferable;
import org.eclipse.app4mc.amalthea.model.LongObject;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.TimeUnit;
import org.eclipse.app4mc.amalthea.model.WeibullEstimators;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.AbstractValidatorImpl;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IEObjectHelper;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IssueCreator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class BasicCheckValidatorImpl
extends AbstractValidatorImpl {
    public BasicCheckValidatorImpl(IssueCreator issueCreator) {
        super(issueCreator);
    }

    public BasicCheckValidatorImpl(IssueCreator issueCreator, IEObjectHelper objectHelper) {
        super(issueCreator, objectHelper);
    }

    public void checkDuplicateUniqueNames(Amalthea model) {
        HashMap<String, IReferable> visitedObjects = new HashMap<String, IReferable>();
        for (IReferable element : this.getObjectHelper().getAllInstancesAndInheritedOf((EObject)model, IReferable.class)) {
            if (Strings.isNullOrEmpty((String)element.getName())) continue;
            String id = element.getUniqueName();
            if (visitedObjects.containsKey(id)) {
                IReferable firstElement = visitedObjects.put(id, null);
                if (firstElement != null) {
                    this.issueCreator.issue((EObject)firstElement, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getINamed_Name(), new Object[]{firstElement.eClass().getName(), firstElement.getName()});
                }
                this.issueCreator.issue((EObject)element, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getINamed_Name(), new Object[]{element.eClass().getName(), element.getName()});
                continue;
            }
            visitedObjects.put(id, element);
        }
    }

    public void checkReferableNames(Amalthea model) {
        for (IReferable element : this.getObjectHelper().getAllInstancesAndInheritedOf((EObject)model, IReferable.class)) {
            if (!Strings.isNullOrEmpty((String)element.getName())) continue;
            this.issueCreator.issue((EObject)element, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getINamed_Name(), new Object[]{this.getObjectHelper().getClassName((EObject)element)});
        }
    }

    public void checkForCustomPropertyDuplicateKey(Amalthea model) {
        HashMap<String, Boolean> visitedKeys = new HashMap<String, Boolean>();
        for (IAnnotatable element : this.getObjectHelper().getAllInstancesAndInheritedOf((EObject)model, IAnnotatable.class)) {
            visitedKeys.clear();
            for (Map.Entry entry : element.getCustomProperties().entrySet()) {
                String key = (String)entry.getKey();
                if (visitedKeys.containsKey(key)) {
                    if (!((Boolean)visitedKeys.get(key)).booleanValue()) continue;
                    this.issueCreator.issue((EObject)element, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getCustomProperty_Key(), new Object[]{this.getObjectHelper().getClassName((EObject)element), this.getObjectHelper().getName((EObject)element), key});
                    visitedKeys.put(key, false);
                    continue;
                }
                visitedKeys.put(key, true);
            }
        }
    }

    public void checkUnits(Amalthea model) {
        for (AbstractTime element : this.getObjectHelper().getAllInstancesAndInheritedOf((EObject)model, AbstractTime.class)) {
            if (element.getUnit() != TimeUnit._UNDEFINED_) continue;
            this.issueCreator.issue((EObject)element, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getAbstractTime_Unit(), new Object[]{this.getObjectHelper().getClassName((EObject)element), this.getObjectHelper().getName(element.eContainer())});
        }
        for (AbstractTime element : this.getObjectHelper().getAllInstancesOf((EObject)model, Frequency.class)) {
            if (element.getUnit() != FrequencyUnit._UNDEFINED_) continue;
            this.issueCreator.issue((EObject)element, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getFrequency_Unit(), new Object[]{this.getObjectHelper().getClassName((EObject)element), this.getObjectHelper().getName(element.eContainer())});
        }
        for (AbstractTime element : this.getObjectHelper().getAllInstancesOf((EObject)model, DataSize.class)) {
            if (element.getUnit() != DataSizeUnit._UNDEFINED_) continue;
            this.issueCreator.issue((EObject)element, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getDataSize_Unit(), new Object[]{this.getObjectHelper().getClassName((EObject)element), this.getObjectHelper().getName(element.eContainer())});
        }
        for (AbstractTime element : this.getObjectHelper().getAllInstancesOf((EObject)model, DataRate.class)) {
            if (element.getUnit() != DataRateUnit._UNDEFINED_) continue;
            this.issueCreator.issue((EObject)element, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getDataRate_Unit(), new Object[]{this.getObjectHelper().getClassName((EObject)element), this.getObjectHelper().getName(element.eContainer())});
        }
    }

    public void checkTimeRanges(Amalthea model) {
        for (Time element : this.getObjectHelper().getAllInstancesOf((EObject)model, Time.class)) {
            boolean found;
            EClass eClass;
            EStructuralFeature eFeature;
            if (element.getValue().signum() > 0 || (eFeature = element.eContainingFeature()) == null || (eClass = eFeature.getEContainingClass()) == null) continue;
            int classID = eClass.getClassifierID();
            int featureID = eFeature.getFeatureID();
            if (element.getValue().signum() <= 0) {
                found = false;
                if (!found) {
                    boolean bl = found = classID == 239 && featureID == 8;
                }
                if (!found) {
                    boolean bl = found = classID == 329 && featureID == 6;
                }
                if (!found) {
                    boolean bl = found = classID == 253 && featureID == 4;
                }
                if (!found) {
                    boolean bl = found = classID == 252 && featureID == 4;
                }
                if (!found) {
                    boolean bl = found = classID == 255 && featureID == 2;
                }
                if (found) {
                    this.issueCreator.issue((EObject)element, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getAbstractTime_Value(), new Object[]{eClass.getName(), this.getObjectHelper().getName(element.eContainer()), eFeature.getName(), "greater than zero"});
                }
            }
            if (element.getValue().signum() >= 0) continue;
            found = false;
            if (!found) {
                boolean bl = found = classID == 329 && featureID == 7;
            }
            if (!found) {
                boolean bl = found = classID == 329 && featureID == 4;
            }
            if (!found) {
                boolean bl = found = classID == 329 && featureID == 5;
            }
            if (!found) {
                boolean bl = found = classID == 332 && featureID == 4;
            }
            if (!found) {
                boolean bl = found = classID == 332 && featureID == 5;
            }
            if (!found) {
                boolean bl = found = classID == 289 && featureID == 8;
            }
            if (!found) {
                boolean bl = found = classID == 239 && featureID == 7;
            }
            if (!found) continue;
            this.issueCreator.issue((EObject)element, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getAbstractTime_Value(), new Object[]{eClass.getName(), this.getObjectHelper().getName(element.eContainer()), eFeature.getName(), "positive or zero"});
        }
    }

    public void checkWeibullParameters(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            Deviation dev;
            EObject elem = (EObject)amaIter.next();
            if (!elem.eClass().getInstanceClass().equals(AmaltheaPackage.eINSTANCE.getDeviation().getInstanceClass()) || (dev = (Deviation)elem).getDistribution() == null || !dev.getDistribution().eClass().getInstanceClass().equals(AmaltheaPackage.eINSTANCE.getWeibullEstimators().getInstanceClass())) continue;
            long lowerBoundValue = ((LongObject)dev.getLowerBound()).getValue();
            long upperBoundValue = ((LongObject)dev.getUpperBound()).getValue();
            long meanValue = ((LongObject)((WeibullEstimators)dev.getDistribution()).getMean()).getValue();
            if (lowerBoundValue != upperBoundValue && lowerBoundValue != meanValue && upperBoundValue != meanValue) continue;
            this.issueCreator.issue((EObject)dev, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getDeviation_Distribution(), new Object[]{lowerBoundValue, upperBoundValue});
        }
    }
}

