/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.execution.ui.simmenu.wizards;

import java.util.List;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.MalformedModelException;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMAllocation;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

public class SWTAllocationTable
extends TableViewer {
    public SWTAllocationTable(Composite parent, List<OMAllocation> model) {
        super(parent, 68354);
        this.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.setInput(model);
        this.setupColumns();
        this.refresh();
    }

    private void setupColumns() {
        Table table = this.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableViewerColumn colTask = new TableViewerColumn((TableViewer)this, 0);
        colTask.getColumn().setWidth(100);
        colTask.getColumn().setText("Task");
        colTask.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                OMAllocation alloc = (OMAllocation)element;
                return alloc.getTask().getTaskRef().getName();
            }
        });
        TableViewerColumn colInst = new TableViewerColumn((TableViewer)this, 0);
        colInst.getColumn().setWidth(150);
        colInst.getColumn().setText("Instructions");
        colInst.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                OMAllocation alloc = (OMAllocation)element;
                return Long.toString(alloc.getTask().getInstructionCount());
            }
        });
        TableViewerColumn colPeriod = new TableViewerColumn((TableViewer)this, 0);
        colPeriod.getColumn().setWidth(150);
        colPeriod.getColumn().setText("Period (ps)");
        colPeriod.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                OMAllocation alloc = (OMAllocation)element;
                return Long.toString(alloc.getTask().getPeriod());
            }
        });
        TableViewerColumn colCore = new TableViewerColumn((TableViewer)this, 0);
        colCore.getColumn().setWidth(100);
        colCore.getColumn().setText("Core");
        colCore.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                OMAllocation alloc = (OMAllocation)element;
                return alloc.getCore().getCoreRef().getName();
            }
        });
        TableViewerColumn colWCET = new TableViewerColumn((TableViewer)this, 0);
        colWCET.getColumn().setWidth(150);
        colWCET.getColumn().setText("WCET (ps)");
        colWCET.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                OMAllocation alloc = (OMAllocation)element;
                try {
                    return Long.toString(alloc.calculateProcessingTime());
                }
                catch (MalformedModelException e) {
                    e.printStackTrace();
                    return "Malformed Model";
                }
            }
        });
        TableViewerColumn colEP = new TableViewerColumn((TableViewer)this, 0);
        colEP.getColumn().setWidth(100);
        colEP.getColumn().setText("WCET/P");
        colEP.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                OMAllocation alloc = (OMAllocation)element;
                try {
                    double x = alloc.calculateProcessingTime();
                }
                catch (MalformedModelException e) {
                    e.printStackTrace();
                    return "Malformed Model";
                }
                return String.format("%1$,.4f", x /= (double)alloc.getTask().getPeriod());
            }
        });
    }
}

