/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.openmapping.model.specs;

import java.math.BigInteger;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.PeriodicStimulus;
import org.eclipse.app4mc.amalthea.model.Stimulus;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.model.TimeUnit;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.ModelSpec;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.logger.EntrySeverityLevel;
import org.eclipse.emf.common.util.EList;

public class ModelSpecTaskPeriodicStimuli
extends ModelSpec {
    public static ModelSpecTaskPeriodicStimuli build() {
        ModelSpecTaskPeriodicStimuli spec = new ModelSpecTaskPeriodicStimuli();
        spec.name = spec.specType = "Tasks' Periodic Stimuli";
        return spec;
    }

    protected boolean checkSpec(Amalthea model) {
        boolean cond = true;
        for (Task task : model.getSwModel().getTasks()) {
            EList stimList = task.getStimuli();
            for (Stimulus stim : stimList) {
                if (!(stim instanceof PeriodicStimulus)) continue;
                PeriodicStimulus per = (PeriodicStimulus)stim;
                if (per.getRecurrence() == null) {
                    this.log("Periodic Stimulus " + per.getName() + " doesn't have a Recurrence set.");
                    cond &= false;
                    continue;
                }
                if (per.getRecurrence().getUnit() == TimeUnit._UNDEFINED_) {
                    this.log("Periodic Stimulus " + per.getName() + " has a Recurrence without Unit set.");
                    cond &= false;
                }
                if (!per.getRecurrence().getValue().equals(BigInteger.ZERO)) continue;
                this.log("Periodic Stimulus " + per.getName() + " has a Recurrence without Value set.");
                cond &= false;
            }
        }
        return cond;
    }

    public ModelSpecTaskPeriodicStimuli setSeverity(EntrySeverityLevel severity) {
        this.severity = severity;
        return this;
    }
}

