/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.openmapping.model.specs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.CallGraph;
import org.eclipse.app4mc.amalthea.model.CallSequence;
import org.eclipse.app4mc.amalthea.model.CallSequenceItem;
import org.eclipse.app4mc.amalthea.model.ExecutionNeed;
import org.eclipse.app4mc.amalthea.model.GraphEntryBase;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableItem;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.model.TaskRunnableCall;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.ModelSpec;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.logger.EntrySeverityLevel;

public class ModelSpecTaskRunnableInstructions
extends ModelSpec {
    public static ModelSpecTaskRunnableInstructions build() {
        ModelSpecTaskRunnableInstructions spec = new ModelSpecTaskRunnableInstructions();
        spec.name = spec.specType = "Tasks' Runnables have instructions";
        return spec;
    }

    private CallSequence findCallSequence(CallGraph cg) {
        for (GraphEntryBase ge : cg.getGraphEntries()) {
            if (!(ge instanceof CallSequence)) continue;
            return (CallSequence)ge;
        }
        return null;
    }

    private List<Runnable> getRunnables(Amalthea model) {
        ArrayList<Runnable> list = new ArrayList<Runnable>();
        for (Task task : model.getSwModel().getTasks()) {
            for (CallSequenceItem csi : this.findCallSequence(task.getCallGraph()).getCalls()) {
                if (!(csi instanceof TaskRunnableCall)) continue;
                list.add(((TaskRunnableCall)csi).getRunnable());
            }
        }
        return list;
    }

    private boolean checkInstruction(Runnable run) {
        boolean found = false;
        for (RunnableItem item : run.getRunnableItems()) {
            if (!(item instanceof ExecutionNeed)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.log("Runnable " + run.getName() + " doesn't have instructions set.");
            return false;
        }
        return true;
    }

    protected boolean checkSpec(Amalthea model) {
        boolean cond = true;
        for (Runnable run : this.getRunnables(model)) {
            cond &= this.checkInstruction(run);
        }
        return cond;
    }

    public ModelSpecTaskRunnableInstructions setSeverity(EntrySeverityLevel severity) {
        this.severity = severity;
        return this;
    }
}

