/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea._import.atdb.wizard;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.WizardResourceImportPage;

public class ImportPage
extends WizardResourceImportPage {
    private Text sourceNameField;

    protected ImportPage(IStructuredSelection selection) {
        this("atdbImportPage", selection);
        this.setTitle("Import Model");
        this.setMessage("Select an existing ATDB File for Model Creation");
    }

    protected ImportPage(String name, IStructuredSelection selection) {
        super(name, selection);
    }

    protected void createSourceGroup(Composite parent) {
        Composite sourceContainerGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        sourceContainerGroup.setLayout((Layout)layout);
        sourceContainerGroup.setFont(parent.getFont());
        sourceContainerGroup.setLayoutData((Object)new GridData(768));
        Label groupLabel = new Label(sourceContainerGroup, 0);
        groupLabel.setText("From directory:");
        groupLabel.setFont(parent.getFont());
        this.sourceNameField = new Text(sourceContainerGroup, 2056);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.sourceNameField.setLayoutData((Object)data);
        this.sourceNameField.setFont(parent.getFont());
        Button sourceBrowseButton = new Button(sourceContainerGroup, 8);
        sourceBrowseButton.setText("Browse...");
        sourceBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportPage.this.selectFile();
                ImportPage.this.update();
            }
        });
        sourceBrowseButton.setLayoutData((Object)new GridData(256));
        sourceBrowseButton.setFont(parent.getFont());
        this.setButtonLayoutData(sourceBrowseButton);
    }

    protected ITreeContentProvider getFileProvider() {
        return null;
    }

    protected ITreeContentProvider getFolderProvider() {
        return null;
    }

    protected boolean determinePageCompletion() {
        boolean result = super.determinePageCompletion();
        String path = this.sourceNameField.getText();
        File file = new File(path);
        return result &= file.exists();
    }

    private void selectFile() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
        fileDialog.setText("Select file");
        fileDialog.setFilterExtensions(new String[]{"*.atdb"});
        String open = fileDialog.open();
        if (open != null) {
            this.sourceNameField.setText(open);
            this.update();
        }
    }

    protected void update() {
        this.setPageComplete(this.determinePageCompletion());
    }

    protected String getSource() {
        return this.sourceNameField.getText();
    }

    protected IContainer getTargetContainer() {
        return this.getSpecifiedContainer();
    }
}

