/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.atdb.metrics;

import java.sql.SQLException;
import java.util.List;
import org.eclipse.app4mc.atdb.metrics.DatabaseAccess;
import org.eclipse.app4mc.atdb.metrics.Messages;
import org.eclipse.app4mc.atdb.metrics.MetricViewerContentProvider;
import org.eclipse.app4mc.atdb.metrics.MetricViewerLabelProvider;
import org.eclipse.app4mc.atdb.metrics.Process;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class MetricViewer
extends EditorPart
implements IEditorPart {
    protected DatabaseAccess dbAccess;
    private List<Process> processes;
    private String timestampUnit;
    private TreeViewer treeViewer;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        if (input instanceof FileEditorInput) {
            FileEditorInput fei = (FileEditorInput)input;
            IFile dbFile = fei.getFile();
            this.dbAccess = new DatabaseAccess();
            try {
                this.dbAccess.connectToDatabase(dbFile);
                this.processes = this.dbAccess.loadProcesses();
                if (this.treeViewer != null) {
                    this.treeViewer.setInput(this.processes);
                }
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)site.getShell(), (String)Messages.MetricViewer_fileErrorTitle, (String)String.format(Messages.MetricViewer_fileErrorMessage, fei.getName()));
                e.printStackTrace();
            }
            this.loadTimestampUnit();
        }
    }

    private void loadTimestampUnit() {
        try {
            this.timestampUnit = this.dbAccess.readTimestampUnit();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (this.timestampUnit == null) {
            this.timestampUnit = "?";
        }
    }

    public void createPartControl(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 65536);
        this.treeViewer.getTree().setHeaderVisible(true);
        this.treeViewer.getTree().setLinesVisible(true);
        TreeViewerColumn cName = new TreeViewerColumn(this.treeViewer, 0);
        cName.getColumn().setText(Messages.MetricViewer_nameColumnTitle);
        cName.getColumn().setWidth(200);
        TreeViewerColumn cMin = new TreeViewerColumn(this.treeViewer, 131072);
        cMin.getColumn().setText(String.format(Messages.MetricViewer_minimumColumnTitle, this.timestampUnit));
        cMin.getColumn().setWidth(200);
        TreeViewerColumn cAvg = new TreeViewerColumn(this.treeViewer, 131072);
        cAvg.getColumn().setText(String.format(Messages.MetricViewer_averageColumnTitle, this.timestampUnit));
        cAvg.getColumn().setWidth(200);
        TreeViewerColumn cMax = new TreeViewerColumn(this.treeViewer, 131072);
        cMax.getColumn().setText(String.format(Messages.MetricViewer_maximumColumnTitle, this.timestampUnit));
        cMax.getColumn().setWidth(200);
        this.treeViewer.setContentProvider((IContentProvider)new MetricViewerContentProvider(this));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new MetricViewerLabelProvider());
        if (this.processes != null) {
            this.treeViewer.setInput(this.processes);
        }
    }

    public void setFocus() {
        Control viewerControl = this.treeViewer.getControl();
        if (!viewerControl.isDisposed()) {
            viewerControl.forceFocus();
        }
    }

    public void dispose() {
        try {
            this.dbAccess.closeDatabaseConnection();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        super.dispose();
    }
}

