/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.dialogs;

import java.util.ArrayList;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

public abstract class AbstractGroup {
    protected Group group;
    protected IPreferenceStore store;
    protected ArrayList<FieldEditor> fields;

    public AbstractGroup(Composite parent, IPreferenceStore store) {
        this.group = new Group(parent, 16);
        this.fields = new ArrayList();
        this.store = store;
    }

    public boolean store() {
        for (FieldEditor field : this.fields) {
            field.store();
        }
        return true;
    }

    public boolean loadDefault() {
        for (FieldEditor field : this.fields) {
            field.loadDefault();
        }
        return true;
    }

    public boolean load() {
        for (FieldEditor field : this.fields) {
            field.load();
        }
        return true;
    }

    public void addField(FieldEditor field) {
        this.fields.add(field);
        field.setPreferenceStore(this.store);
    }

    public void setEnabled(boolean enabled) {
        for (FieldEditor field : this.fields) {
            field.setEnabled(enabled, (Composite)this.group);
        }
        this.group.setEnabled(enabled);
    }

    public boolean update() {
        return true;
    }
}

