/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.openmapping.algorithms.helper;

import com.google.common.collect.HashMultimap;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.app4mc.multicore.openmapping.model.OMAnnotationElement;
import org.eclipse.app4mc.multicore.openmapping.model.OMCore;
import org.eclipse.app4mc.multicore.openmapping.model.OMTask;

public class ConstraintBuilder {
    private HashMultimap<OMAnnotationElement, OMCore> mTagToCore = HashMultimap.create();
    private HashMultimap<OMTask, OMCore> mTaskToCore = HashMultimap.create();

    public boolean fetchAllocationConstraints(List<OMTask> taskList, List<OMCore> coreList) {
        for (OMCore c : coreList) {
            if (c.getAnnotationElement().size() <= 0) continue;
            Stream sTags = c.getAnnotationElement().stream();
            sTags.forEach(item -> {
                boolean bl = this.mTagToCore.put(item, (Object)c);
            });
        }
        for (OMTask t : taskList) {
            if (t.getValidAnnotationElements().size() > 0) {
                t.getValidAnnotationElements().forEach(tag -> {
                    Set<OMCore> cores = this.getCoresByAnnotationElement((OMAnnotationElement)tag);
                    this.mTaskToCore.putAll((Object)t, cores);
                });
            } else {
                this.mTaskToCore.putAll((Object)t, coreList);
            }
            if (t.getInvalidAnnotationElements().size() > 0) {
                t.getInvalidAnnotationElements().forEach(tag -> {
                    Set<OMCore> cores = this.getCoresByAnnotationElement((OMAnnotationElement)tag);
                    if (cores != null && cores.size() > 0) {
                        cores.forEach(core -> {
                            boolean bl = this.mTaskToCore.remove((Object)t, core);
                        });
                    }
                });
            }
            System.out.println("---- VALID CORES FOR " + t.getTaskRef().getName() + " ----");
            this.mTaskToCore.get((Object)t).forEach(core -> System.out.print("|" + core + "|\n"));
        }
        return true;
    }

    private Set<OMCore> getCoresByAnnotationElement(OMAnnotationElement element) {
        return this.mTagToCore.get((Object)element);
    }

    public HashMultimap<OMTask, OMCore> getValidAllocationMap() {
        return this.mTaskToCore;
    }

    public Set<OMCore> getValidAlocationTargets(OMTask task) {
        return this.mTaskToCore.get((Object)task);
    }
}

