/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.openmapping.model;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.HashMap;
import org.eclipse.app4mc.multicore.openmapping.model.OMCore;
import org.eclipse.app4mc.multicore.openmapping.model.OMScheduler;
import org.eclipse.app4mc.multicore.openmapping.model.OMTask;

public class OMAllocation {
    private final OMTask task;
    private final OMCore core;
    private final OMScheduler scheduler;
    private final HashMap<String, Object> attributeList = new HashMap();

    public OMAllocation(OMTask task, OMCore core) {
        this.task = task;
        this.core = core;
        this.scheduler = null;
    }

    public OMTask getTask() {
        return this.task;
    }

    public OMCore getCore() {
        return this.core;
    }

    public OMScheduler getScheduler() {
        return this.scheduler;
    }

    public void addAttribute(String key, Object value) {
        this.attributeList.put(key, value);
    }

    public Object getAttribute(String key) {
        return this.attributeList.get(key);
    }

    public long calculateProcessingTime() {
        BigDecimal ips = BigDecimal.valueOf(this.core.getInstructionsPerSecond());
        BigDecimal ins = BigDecimal.valueOf(this.task.getInstructionCount());
        BigDecimal psps = BigDecimal.valueOf(1000000000000L);
        BigDecimal computationTime = psps.multiply(ins).divide(ips, 5, RoundingMode.CEILING).divide(BigDecimal.valueOf(this.task.getRecursionFactor()), MathContext.DECIMAL128);
        return computationTime.longValue();
    }
}

