/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.openmapping.model;

import java.util.ArrayList;
import org.eclipse.app4mc.amalthea.model.CoreClassifier;
import org.eclipse.app4mc.amalthea.model.ProcessingUnit;
import org.eclipse.app4mc.amalthea.model.Tag;
import org.eclipse.app4mc.multicore.openmapping.model.OMAnnotationElement;
import org.eclipse.app4mc.multicore.openmapping.model.OMCoreClassifier;
import org.eclipse.app4mc.multicore.openmapping.model.OMTag;

public class OMCore {
    private final ProcessingUnit coreRef;
    private long instructionsPerSecond = -1L;
    private ArrayList<OMAnnotationElement> referrableAnnotationElements = new ArrayList();

    public OMCore(ProcessingUnit coreRef) {
        this.coreRef = coreRef;
        this.referrableAnnotationElements = this.addAnnotatableElements();
    }

    private ArrayList<OMAnnotationElement> addAnnotatableElements() {
        ArrayList<OMAnnotationElement> out = new ArrayList<OMAnnotationElement>();
        if (this.coreRef.getTags().size() > 0) {
            this.coreRef.getTags().stream().forEach(tag -> {
                boolean bl = out.add(new OMTag((Tag)tag));
            });
        }
        if (this.coreRef.getDefinition() != null) {
            if (this.coreRef.getDefinition().getTags().size() > 0) {
                this.coreRef.getDefinition().getTags().stream().forEach(tag -> {
                    boolean bl = out.add(new OMTag((Tag)tag));
                });
            }
            if (this.coreRef.getDefinition().getClassifiers().size() > 0) {
                this.coreRef.getDefinition().getClassifiers().stream().forEach(coreClassifier -> {
                    boolean bl = out.add(new OMCoreClassifier((CoreClassifier)coreClassifier));
                });
            }
        }
        return out;
    }

    public long getInstructionsPerSecond() {
        if (this.instructionsPerSecond >= 0L) {
            return this.instructionsPerSecond;
        }
        return 1L;
    }

    public ProcessingUnit getCoreRef() {
        return this.coreRef;
    }

    public ArrayList<OMAnnotationElement> getAnnotationElement() {
        return this.referrableAnnotationElements;
    }

    public String toString() {
        return this.coreRef.getUniqueName();
    }
}

