/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.execution.logic.systemproxy.scheduler;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.eclipse.app4mc.multicore.execution.logic.systemproxy.scheduler.ISchedulerAlgorithm;
import org.eclipse.app4mc.multicore.execution.logic.systemproxy.scheduler.algo.CooperativeEDFAlgo;
import org.eclipse.app4mc.multicore.execution.logic.systemproxy.scheduler.algo.PreemptiveEDFAlgo;
import org.eclipse.app4mc.multicore.execution.logic.systemproxy.scheduler.algo.PreemptiveRMSAlgo;

public class SchedulerAlgorithmRegister {
    static Map<String, Supplier<ISchedulerAlgorithm>> factoryMap = new HashMap<String, Supplier<ISchedulerAlgorithm>>();

    static {
        factoryMap.put("Cooperative EDF", SchedulerAlgorithmRegister::createCooperativeEDF);
        factoryMap.put("Preemptive RMS", SchedulerAlgorithmRegister::createPreemptiveRMS);
        factoryMap.put("Preemptive EDF", SchedulerAlgorithmRegister::createPreemptiveEDF);
    }

    public static void update(String name, Supplier<ISchedulerAlgorithm> algoFactory) {
        factoryMap.put(name, algoFactory);
    }

    public static String[] schedulerList() {
        return factoryMap.keySet().toArray(new String[factoryMap.keySet().size()]);
    }

    public static ISchedulerAlgorithm create(String name) {
        Supplier<ISchedulerAlgorithm> sup = SchedulerAlgorithmRegister.schedulerFactoryByName(name);
        if (sup != null) {
            return sup.get();
        }
        return null;
    }

    public static Supplier<ISchedulerAlgorithm> schedulerFactoryByName(String name) {
        return factoryMap.get(name);
    }

    public static ISchedulerAlgorithm createCooperativeEDF() {
        return new CooperativeEDFAlgo();
    }

    public static ISchedulerAlgorithm createPreemptiveRMS() {
        return new PreemptiveRMSAlgo();
    }

    public static ISchedulerAlgorithm createPreemptiveEDF() {
        return new PreemptiveEDFAlgo();
    }
}

