/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.partitioning.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.ConstraintsModel;
import org.eclipse.app4mc.amalthea.model.LabelAccessEnum;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableEntityGroup;
import org.eclipse.app4mc.amalthea.model.RunnableOrderType;
import org.eclipse.app4mc.amalthea.model.RunnableSequencingConstraint;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.multicore.partitioning.utils.PartLog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CheckLabels {
    private ConstraintsModel CM;
    private SWModel swm;

    public SWModel getSwm() {
        return this.swm;
    }

    public void setSwm(SWModel swm) {
        this.swm = swm;
    }

    public void setCMModel(ConstraintsModel cm) {
        this.CM = cm;
    }

    public ConstraintsModel getCMModel() {
        return this.CM;
    }

    public IStatus run(IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.beginTask("Performing label access analysis...", this.swm.getRunnables().size());
        }
        PartLog.getInstance().setLogName("RSC Generation");
        AmaltheaFactory factory = AmaltheaFactory.eINSTANCE;
        if (this.CM == null) {
            this.CM = factory.createConstraintsModel();
        }
        HashMap deps = new HashMap();
        this.swm.getLabels().stream().forEach(l -> {
            Set lars = l.getLabelAccesses().stream().filter(la -> la.getAccess().equals((Object)LabelAccessEnum.READ)).collect(Collectors.toSet());
            Set laws = l.getLabelAccesses().stream().filter(lac -> lac.getAccess().equals((Object)LabelAccessEnum.WRITE)).collect(Collectors.toSet());
            if (lars.size() > 0 && laws.size() > 0) {
                laws.stream().forEach(law -> {
                    Runnable key = (Runnable)law.eContainer();
                    lars.stream().forEach(lar -> {
                        Runnable value = (Runnable)lar.eContainer();
                        if (key != null && value != null && !key.equals(value)) {
                            if (!deps.containsKey(key)) {
                                ArrayList<Runnable> tmp = new ArrayList<Runnable>();
                                tmp.add(value);
                                deps.put(key, tmp);
                            } else if (!((List)deps.get(key)).contains(value)) {
                                ((List)deps.get(key)).add(value);
                            }
                        }
                    });
                });
            }
        });
        deps.keySet().stream().forEach(key -> ((List)deps.get(key)).stream().forEach(value -> {
            RunnableSequencingConstraint RSC = factory.createRunnableSequencingConstraint();
            RSC.setOrderType(RunnableOrderType.SUCCESSOR);
            RunnableEntityGroup prg1 = factory.createRunnableEntityGroup();
            RunnableEntityGroup prg2 = factory.createRunnableEntityGroup();
            prg1.getRunnables().add(key);
            prg2.getRunnables().add(value);
            RSC.getRunnableGroups().add((Object)prg1);
            RSC.getRunnableGroups().add((Object)prg2);
            RSC.setName(String.valueOf(key.getName()) + "-->" + value.getName());
            this.CM.getRunnableSequencingConstraints().add((Object)RSC);
        }));
        PartLog.getInstance().log("Label Access Analysis finished and created " + this.CM.getRunnableSequencingConstraints().size() + " RunnableSequencingConstraints.");
        return Status.OK_STATUS;
    }
}

