/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters110.utils;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.utils.AbstractAttributeRefCacheBuilder;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.eclipse.app4mc.amalthea.converters110.utils.HelperUtils_103_110;
import org.eclipse.app4mc.amalthea.converters110.utils.SchedulerCacheEnum;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class SchedulerCacheBuilder
extends AbstractAttributeRefCacheBuilder {
    public SchedulerCacheBuilder() {
        this.helper = HelperUtils_103_110.getInstance();
    }

    public void buildCache(Map<File, Document> fileName_documentsMap) {
        for (File targetFile : fileName_documentsMap.keySet()) {
            this.getCacheMap().put(targetFile, new HashMap());
            Document rootDocument = fileName_documentsMap.get(targetFile);
            this.populate_All_UUID_Elements(targetFile, rootDocument, ".//osModel/scheduler | .//os:OSModel/scheduler", SchedulerCacheEnum.UUID_SCHEDULER_ELEMENT.name(), new Namespace[]{this.helper.getNS_103("os")});
            Map<String, List<Attribute>> uriFragment_schedulerRefAttribsMap = this.getAllSchedulerAttributes_containing_URIFragments(rootDocument);
            ((Map)this.getCacheMap().get(targetFile)).put(SchedulerCacheEnum.URIFRAGMENT_SCHEDULER_REFS_ATRIBUTES.name(), uriFragment_schedulerRefAttribsMap);
            Map<String, Element> uriFragment_SchedulerMap = this.getAllSchedulerElements_referred_by_URIFragments(targetFile, rootDocument);
            ((Map)this.getCacheMap().get(targetFile)).put(SchedulerCacheEnum.URIFRAGMENT_SCHEDULER_ELEMENT.name(), uriFragment_SchedulerMap);
            this.populateAllHREFSchedulerAttributes_having_legacy_URI_refs(targetFile, rootDocument);
            this.populate_AllElements_referred_by_hrefURIFragments(targetFile, rootDocument, fileName_documentsMap);
        }
    }

    public void updateURIFragments_in_Cache(Map<File, Document> fileName_documentsMap) {
        for (File targetFile : fileName_documentsMap.keySet()) {
            Map cache_file_specific_Map = (Map)this.getCacheMap().get(targetFile);
            BiMap biMap_urifragments_new_old = (BiMap)cache_file_specific_Map.get(SchedulerCacheEnum.URI_FRAGMENT_NEW_OLD.name());
            if (biMap_urifragments_new_old == null) {
                biMap_urifragments_new_old = HashBiMap.create();
                cache_file_specific_Map.put(SchedulerCacheEnum.URI_FRAGMENT_NEW_OLD.name(), biMap_urifragments_new_old);
            }
            biMap_urifragments_new_old.clear();
            Map urifragment_element_map = (Map)cache_file_specific_Map.get(SchedulerCacheEnum.URIFRAGMENT_SCHEDULER_ELEMENT.name());
            for (String old_uriFragment : urifragment_element_map.keySet()) {
                Element element = (Element)urifragment_element_map.get(old_uriFragment);
                String updated_uriFragment = this.helper.getURIFragment(element, ModelVersion._110);
                biMap_urifragments_new_old.put((Object)updated_uriFragment, (Object)old_uriFragment);
            }
            Map hrefurifragment_element_map = (Map)cache_file_specific_Map.get(SchedulerCacheEnum.HREF_URIFRAGMENT_SCHEDULER_ELEMENT.name());
            for (String old_href_uriFragment : hrefurifragment_element_map.keySet()) {
                Element element = (Element)hrefurifragment_element_map.get(old_href_uriFragment);
                String updated_uriFragment_part2 = this.helper.getURIFragment(element, ModelVersion._110);
                String[] split = old_href_uriFragment.split("#");
                biMap_urifragments_new_old.put((Object)(String.valueOf(split[0]) + "#" + updated_uriFragment_part2), (Object)old_href_uriFragment);
            }
        }
    }

    private void populate_AllElements_referred_by_hrefURIFragments(File targetFile, Document rootDocument, Map<File, Document> fileName_documentsMap) {
        this.populate_AllElements_referred_by_hrefURIFragments(targetFile, rootDocument, fileName_documentsMap, SchedulerCacheEnum.HREF_URIFRAGMENT_SCHEDULER_REFS_ATRIBUTES.name(), SchedulerCacheEnum.HREF_URIFRAGMENT_SCHEDULER_ELEMENT.name());
    }

    private void populateAllHREFSchedulerAttributes_having_legacy_URI_refs(File targetFile, Document rootDocument) {
        this.populateAllHREF_ElementAttributes_having_legacy_URI_refs(targetFile, rootDocument, ".//scheduler/@href[contains(., \"/\")]", SchedulerCacheEnum.HREF_URIFRAGMENT_SCHEDULER_REFS_ATRIBUTES.name(), new Namespace[0]);
    }

    private Map<String, List<Attribute>> getAllSchedulerAttributes_containing_URIFragments(Document rootDocument) {
        return this.getAllAttributes_containing_URIFragments(rootDocument, ".//@scheduler[contains(., \"/\")]", new Namespace[0]);
    }

    private Map<String, Element> getAllSchedulerElements_referred_by_URIFragments(File targetFile, Document rootDocument) {
        return this.getAllElements_referred_by_URIFragments(targetFile, rootDocument, SchedulerCacheEnum.URIFRAGMENT_SCHEDULER_REFS_ATRIBUTES.name());
    }
}

