/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters070.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters070.utils.HelperUtils_111_070;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class ComponentsConverter
implements IConverter {
    private final HelperUtils_111_070 helper = HelperUtils_111_070.getInstance();
    private final Logger logger = LogManager.getLogger((String)"org.eclipse.app4mc.amalthea.modelmigration");

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) throws Exception {
        this.logger.info((Object)("Migration from itea.111 to 0.7.0 : Executing Components converter for model file : " + targetFile.getName()));
        Document root = fileName_documentsMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.update_FInterfacePort(rootElement);
        fileName_documentsMap.put(targetFile.getCanonicalFile(), root);
    }

    private void update_FInterfacePort(Element rootElement) {
        List francaInterfacePorts = this.helper.getXpathResult(rootElement, ".//components/ports[(@xsi:type=\"components:FInterfacePort\")]|/components:ComponentsModel/components/ports[(@xsi:type=\"components:FInterfacePort\")]", Element.class, new Namespace[]{this.helper.getNS_111("components"), this.helper.getGenericNS("xsi")});
        for (Element port : francaInterfacePorts) {
            Element francaInterfaceRef;
            Attribute attribute = port.getAttribute("kind");
            if (attribute != null) {
                if (attribute.getValue().equals("PROVIDES")) {
                    attribute.setValue("provides");
                } else if (attribute.getValue().equals("REQUIRES")) {
                    attribute.setValue("requires");
                }
            }
            if ((francaInterfaceRef = port.getChild("interface")) == null) continue;
            String fInterfaceRefString = francaInterfaceRef.getAttributeValue("href");
            Element customPropertyElement = new Element("customProperties");
            customPropertyElement.setAttribute("id", EcoreUtil.generateUUID(), this.helper.getGenericNS("xmi"));
            customPropertyElement.setAttribute("key", "Franca interface");
            Element value_customPropertyElement = new Element("value");
            value_customPropertyElement.setAttribute("type", "common:StringObject", this.helper.getGenericNS("xsi"));
            value_customPropertyElement.setAttribute("id", EcoreUtil.generateUUID(), this.helper.getGenericNS("xmi"));
            value_customPropertyElement.setAttribute("value", fInterfaceRefString);
            customPropertyElement.addContent((Content)value_customPropertyElement);
            port.addContent((Content)customPropertyElement);
            francaInterfaceRef.detach();
        }
    }
}

