/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.ui.jobs;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.app4mc.amalthea.converters.common.utils.AbstractHelper;
import org.eclipse.app4mc.amalthea.converters.ui.utils.MigrationInputFile;
import org.eclipse.app4mc.amalthea.converters.ui.utils.MigrationSettings;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class ModelLoaderJob
extends Job {
    private final MigrationSettings migrationSettings;
    private final List<File> inputModels;
    private final AbstractHelper helper;
    private final Logger logger = LogManager.getLogger((String)"org.eclipse.app4mc.amalthea.modelmigration");

    public ModelLoaderJob(String name, MigrationSettings migrationSettings, List<File> inputModels, AbstractHelper helper) {
        super(name);
        this.migrationSettings = migrationSettings;
        this.inputModels = inputModels;
        this.helper = helper;
    }

    protected IStatus run(IProgressMonitor monitor) {
        int size = this.inputModels.size();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)size);
        HashMap<File, MigrationInputFile> modelFilesMap = new HashMap<File, MigrationInputFile>();
        subMonitor.setTaskName("Loading selected model files ...");
        try {
            this.populateModels(modelFilesMap, this.inputModels, subMonitor);
        }
        catch (Exception e1) {
            this.logger.error((Object)e1.getMessage(), (Throwable)e1);
            return new Status(8, "unknown", 1, e1.getMessage(), (Throwable)e1);
        }
        this.migrationSettings.getMigModelFiles().addAll(modelFilesMap.values());
        return Status.OK_STATUS;
    }

    private void populateModels(Map<File, MigrationInputFile> modelFilesMap, List<File> inputModelFiles, SubMonitor subMonitor) throws Exception {
        HashMap loaded_documents_map = new HashMap();
        for (File file : inputModelFiles) {
            this.helper.buildXMLDocumentsMap(file, loaded_documents_map);
            subMonitor.worked(1);
        }
        Set filesForMigration = loaded_documents_map.keySet();
        for (File inputFile : filesForMigration) {
            Document xmlDocument = (Document)loaded_documents_map.get(inputFile);
            MigrationInputFile migModelFile = new MigrationInputFile(this.migrationSettings);
            migModelFile.setFile(inputFile);
            migModelFile.setSelectedFile(inputModelFiles.contains(inputFile));
            migModelFile.setDocument(xmlDocument);
            this.setModelFileVersion(migModelFile, xmlDocument);
            modelFilesMap.put(inputFile, migModelFile);
        }
    }

    @Deprecated
    void populateModels(Map<File, MigrationInputFile> modelFilesMap, File inputFile, boolean isRefFileAndNotSelected) throws Exception {
        if (!modelFilesMap.containsKey(inputFile)) {
            MigrationInputFile migModelFile = new MigrationInputFile(this.migrationSettings);
            migModelFile.setFile(inputFile);
            migModelFile.setSelectedFile(!isRefFileAndNotSelected);
            Document xmlDocument = this.helper.loadFile(inputFile.getAbsolutePath());
            migModelFile.setDocument(xmlDocument);
            this.setModelFileVersion(migModelFile, xmlDocument);
            modelFilesMap.put(inputFile, migModelFile);
            List hrefs = this.helper.getXpathResult(migModelFile.getDocument().getRootElement(), ".//@href", Attribute.class, new Namespace[0]);
            HashSet<String> referredFilePaths = new HashSet<String>();
            for (Attribute attribute : hrefs) {
                String value = attribute.getValue();
                int index = value.lastIndexOf("#");
                if (index == -1) continue;
                String fileName = value.substring(0, index);
                referredFilePaths.add(fileName);
            }
            for (String relativePath : referredFilePaths) {
                File canonicalFile;
                File referredFile;
                if (relativePath == null || relativePath.length() <= 0 || !(referredFile = new File(String.valueOf(migModelFile.getFile().getParent()) + File.separator + relativePath)).exists()) continue;
                boolean isRefFileSelected = this.inputModels.contains(canonicalFile = referredFile.getCanonicalFile());
                this.populateModels(modelFilesMap, canonicalFile, !isRefFileSelected);
            }
        }
    }

    private void setModelFileVersion(MigrationInputFile migModelFile, Document document) {
        Element rootElement = document.getRootElement();
        Namespace namespace = rootElement.getNamespace();
        if (this.helper.isNS_AvailableIn_103(namespace)) {
            migModelFile.setModelVersion("itea.103");
        } else if (this.helper.isNS_AvailableIn_110(namespace)) {
            migModelFile.setModelVersion("itea.110");
        } else if (this.helper.isNS_AvailableIn_111(namespace)) {
            migModelFile.setModelVersion("itea.111");
        } else if (this.helper.isNS_AvailableIn_070(namespace)) {
            migModelFile.setModelVersion("0.7.0");
        } else if (this.helper.isNS_AvailableIn_071(namespace)) {
            migModelFile.setModelVersion("0.7.1");
        } else if (this.helper.isNS_AvailableIn_072(namespace)) {
            migModelFile.setModelVersion("0.7.2");
        } else if (this.helper.isNS_AvailableIn_080(namespace)) {
            migModelFile.setModelVersion("0.8.0");
        } else if (this.helper.isNS_AvailableIn_081(namespace)) {
            migModelFile.setModelVersion("0.8.1");
        } else if (this.helper.isNS_AvailableIn_082(namespace)) {
            migModelFile.setModelVersion("0.8.2");
        } else if (this.helper.isNS_AvailableIn_083(namespace)) {
            migModelFile.setModelVersion("0.8.3");
        } else if (this.helper.isNS_AvailableIn_090(namespace)) {
            migModelFile.setModelVersion("0.9.0");
        } else if (this.helper.isNS_AvailableIn_091(namespace)) {
            migModelFile.setModelVersion("0.9.1");
        } else {
            migModelFile.setModelVersion("invalid");
        }
    }

    public boolean belongsTo(Object family) {
        if (family != null && family.equals("AMALTHEA_MODEL_MIGRATION")) {
            return true;
        }
        return super.belongsTo(family);
    }
}

