/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.partitioning.specs;

import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.ExecutionNeed;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableItem;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.ModelSpec;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.logger.EntrySeverityLevel;

public class ModelSpecRunnableInstructions
extends ModelSpec {
    public static ModelSpecRunnableInstructions build() {
        ModelSpecRunnableInstructions spec = new ModelSpecRunnableInstructions();
        spec.name = spec.specType = "Runnables have instructions";
        return spec;
    }

    private boolean checkInstruction(Runnable run) {
        boolean found = false;
        for (RunnableItem item : run.getRunnableItems()) {
            if (!(item instanceof ExecutionNeed)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.log("Runnable " + run.getName() + " doesn't have instructions set.");
            return false;
        }
        return true;
    }

    protected boolean checkSpec(Amalthea model) {
        boolean cond = true;
        for (Runnable run : model.getSwModel().getRunnables()) {
            cond &= this.checkInstruction(run);
        }
        return cond;
    }

    public ModelSpecRunnableInstructions setSeverity(EntrySeverityLevel severity) {
        this.severity = severity;
        return this;
    }
}

