/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.sphinx.ui.editors.search;

import java.util.HashMap;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.app4mc.amalthea.model.AmaltheaIndex;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.amalthea.sphinx.ui.editors.messages.Messages;
import org.eclipse.app4mc.amalthea.sphinx.ui.editors.search.ModelSearchResult;
import org.eclipse.app4mc.amalthea.sphinx.ui.editors.search.SearchMatch;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.sphinx.emf.ui.util.EcoreUIUtil;
import org.eclipse.ui.IEditorInput;

public class ModelHitCollector
implements ISearchQuery {
    private final ModelSearchResult searchResult = new ModelSearchResult(this);
    private final Pattern namePattern;
    private final Class<INamed> filterClass;
    private final boolean fileScope;
    private final EObject model;
    private final IEditorInput editorInput;

    public ModelHitCollector(Pattern pattern, Class<INamed> filter, boolean isFileScope, EObject model, IEditorInput input) {
        this.namePattern = pattern;
        this.filterClass = filter;
        this.fileScope = isFileScope;
        this.model = model;
        this.editorInput = input;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        this.searchResult.removeAll();
        Set resultSet = AmaltheaIndex.getElements((Notifier)this.model, (Pattern)this.namePattern, this.filterClass);
        HashMap<Resource, IEditorInput> editorInputMap = new HashMap<Resource, IEditorInput>();
        for (INamed element : resultSet) {
            if (this.model.eResource() == element.eResource()) {
                this.searchResult.addMatch(new SearchMatch(element, 0, 0, this.editorInput));
                continue;
            }
            if (this.fileScope) continue;
            IEditorInput input = (IEditorInput)editorInputMap.get(element.eResource());
            if (input == null) {
                input = EcoreUIUtil.createURIEditorInput((Object)element.eResource());
                editorInputMap.put(element.eResource(), input);
            }
            this.searchResult.addMatch(new SearchMatch(element, 0, 0, input));
        }
        return Status.OK_STATUS;
    }

    public String getLabel() {
        return Messages.ModelHitCollector_label;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        return this.searchResult;
    }
}

