/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.openmapping.model.specs;

import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.CallGraph;
import org.eclipse.app4mc.amalthea.model.CallSequence;
import org.eclipse.app4mc.amalthea.model.CallSequenceItem;
import org.eclipse.app4mc.amalthea.model.GraphEntryBase;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.model.TaskRunnableCall;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.ModelSpec;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.logger.EntrySeverityLevel;

public class ModelSpecTaskRunnableCall
extends ModelSpec {
    public static ModelSpecTaskRunnableCall build() {
        ModelSpecTaskRunnableCall spec = new ModelSpecTaskRunnableCall();
        spec.name = spec.specType = "Task has Runnable Calls";
        return spec;
    }

    private CallSequence findCallSequence(CallGraph cg) {
        for (GraphEntryBase ge : cg.getGraphEntries()) {
            if (!(ge instanceof CallSequence)) continue;
            return (CallSequence)ge;
        }
        return null;
    }

    private boolean checkRunnableCalls(Task task, CallSequence cs) {
        boolean cond = true;
        int amountTask = 0;
        for (CallSequenceItem csi : cs.getCalls()) {
            if (!(csi instanceof TaskRunnableCall)) continue;
            TaskRunnableCall trc = (TaskRunnableCall)csi;
            if (trc.getRunnable() == null) {
                this.log("Task " + task.getName() + " has a call without a valid Runnable reference.");
                cond &= false;
                continue;
            }
            ++amountTask;
        }
        if (amountTask == 0) {
            this.log("Task " + task.getName() + " has a Call Sequence without any Calls set.");
            cond &= false;
        }
        return cond;
    }

    protected boolean checkSpec(Amalthea model) {
        boolean cond = true;
        for (Task task : model.getSwModel().getTasks()) {
            CallGraph cg = task.getCallGraph();
            if (cg == null) {
                this.log("Task " + task.getName() + " doesn't have a CallGraph set.");
                cond &= false;
                continue;
            }
            CallSequence cs = this.findCallSequence(cg);
            if (cs == null) {
                this.log("Task " + task.getName() + " doesn't have a Call Sequence set.");
                cond &= false;
                continue;
            }
            if (cs.getCalls().size() == 0) {
                this.log("Task " + task.getName() + " has a Call Sequence without any Calls set.");
                cond &= false;
                continue;
            }
            cond &= this.checkRunnableCalls(task, cs);
        }
        return cond;
    }

    public ModelSpecTaskRunnableCall setSeverity(EntrySeverityLevel severity) {
        this.severity = severity;
        return this;
    }
}

