/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.dialogs.generic;

import org.eclipse.app4mc.multicore.dialogs.AbstractGroup;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class OutputGroup
extends AbstractGroup {
    private ProjectDirectoryFieldEditor outputDirectory;
    private final RadioGroupFieldEditor radioOutputDirectory;
    private final String radioPreferenceName;
    private final String pathPreferenceName;
    private final IPropertyChangeListener listener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            OutputGroup.this.outputRadioEnable(event.getNewValue().toString());
        }
    };

    public OutputGroup(Composite parent, String radioPreferenceName, String pathPreferenceName, IPreferenceStore store) {
        super(parent, store);
        GridLayout layout = new GridLayout(3, false);
        GridData gridData = new GridData(768);
        this.radioPreferenceName = radioPreferenceName;
        this.pathPreferenceName = pathPreferenceName;
        this.group.setText("Output");
        this.group.setLayoutData((Object)gridData);
        this.group.setLayout((Layout)layout);
        gridData.widthHint = 200;
        String[][] options = new String[][]{{"Default location ({ProjectRoot}/" + store.getDefaultString(pathPreferenceName) + ")", "0"}, {"Relative location", "1"}, {"Absolute location", "2"}};
        this.radioOutputDirectory = new RadioGroupFieldEditor(radioPreferenceName, "Output Location: ", 1, options, (Composite)this.group);
        this.addField((FieldEditor)this.radioOutputDirectory);
        this.radioOutputDirectory.fillIntoGrid((Composite)this.group, 3);
        this.radioOutputDirectory.setPropertyChangeListener(this.listener);
        this.outputDirectory = new ProjectDirectoryFieldEditor(pathPreferenceName, "Path: ", this.group);
        this.addField((FieldEditor)this.outputDirectory);
    }

    protected void outputRadioEnable(String value) {
        switch (value) {
            case "0": {
                this.outputDirectory.setStringValue(this.store.getDefaultString(this.pathPreferenceName));
                this.outputDirectory.setEnabled(false, (Composite)this.group);
                break;
            }
            case "2": {
                this.outputDirectory.setEnabled(true, (Composite)this.group);
                this.outputDirectory.setChangeEnabled(true);
                break;
            }
            case "1": {
                this.outputDirectory.setEnabled(true, (Composite)this.group);
                this.outputDirectory.setChangeEnabled(false);
                break;
            }
            default: {
                this.outputDirectory.setEnabled(false, (Composite)this.group);
            }
        }
    }

    @Override
    public boolean loadDefault() {
        boolean success = super.loadDefault();
        String radioOutputChoice = this.store.getDefaultString(this.radioPreferenceName);
        this.outputRadioEnable(radioOutputChoice);
        return success;
    }

    @Override
    public boolean load() {
        boolean success = super.load();
        String radioOutputChoice = this.store.getString(this.radioPreferenceName);
        this.outputRadioEnable(radioOutputChoice);
        return success;
    }

    public Group getGroup() {
        return this.group;
    }

    private class ProjectDirectoryFieldEditor
    extends DirectoryFieldEditor {
        public ProjectDirectoryFieldEditor(String preOutputPath, String string, Group group) {
            super(preOutputPath, string, (Composite)group);
        }

        public void setChangeEnabled(boolean enabled) {
            Group group = OutputGroup.this.getGroup();
            this.getChangeControl((Composite)group).setEnabled(enabled);
        }
    }
}

