/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters090.impl;

import com.google.common.collect.Iterables;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters090.impl.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters090.utils.HWCacheBuilder;
import org.eclipse.app4mc.amalthea.converters090.utils.HWTransformationCache;
import org.eclipse.app4mc.amalthea.converters090.utils.HelperUtils_083_090;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class HwReferencesConverter
extends AbstractConverter {
    private List<ICache> caches;
    private HWTransformationCache hwTransformationCache;

    public HwReferencesConverter() {
        this.helper = HelperUtils_083_090.getInstance();
        this.logger = LogManager.getLogger((String)"org.eclipse.app4mc.amalthea.modelmigration");
    }

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) throws Exception {
        this.logger.info((Object)("Migration from 0.8.3 to 0.9.0  : Executing \"HW model references converter\" for model file : " + targetFile.getName()));
        this.caches = caches;
        Document root = fileName_documentsMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.hwTransformationCache = this.getHWTransformationCache();
        this.updateReferencesInModel(rootElement);
        fileName_documentsMap.put(targetFile.getCanonicalFile(), root);
    }

    private void updateReferencesInModel(Element rootElement) {
        this.migrateTargetMemory(rootElement);
        this.migratePhysicalSectionConstraint(rootElement);
        this.migrateMemoryMapping(rootElement);
        this.migratePhysicalSectionMapping(rootElement);
        this.migrateTargetCore(rootElement);
        this.migrateEvents(rootElement);
        this.migrateSchedulerAllocation(rootElement);
        this.migrateTaskAllocation(rootElement);
        this.migrateRunnableInstructionsEntry(rootElement);
        this.migrateCPUPercentageRequirementLimit(rootElement);
    }

    private void migrateRunnableInstructionsEntry(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("./swModel/runnables//*[@xsi:type=\"am:RunnableInstructions\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/operatingSystems/taskSchedulers/computationItems[@xsi:type=\"am:RunnableInstructions\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/operatingSystems/interruptControllers/computationItems[@xsi:type=\"am:RunnableInstructions\"]");
        List runnableInstructionsEntries = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi")});
        if (runnableInstructionsEntries.size() > 0 && !this.hwTransformationCache.new_feature_categories_Map.containsKey("Instructions")) {
            this.checkAndCreateHWFeatureCategory(rootElement);
        }
        for (Element runnableInstruction : runnableInstructionsEntries) {
            Element parentElementOfRunnableInstruction = runnableInstruction.getParentElement();
            String tagName = runnableInstruction.getName();
            int indexOfRunnableInstructions = parentElementOfRunnableInstruction.indexOf((Content)runnableInstruction);
            Element executionNeedElement = new Element(tagName);
            executionNeedElement.setAttribute("type", "am:ExecutionNeed", this.helper.getGenericNS("xsi"));
            this.migrateValueOfRunnableInstructions(runnableInstruction, executionNeedElement, "default");
            List oldExtendedElements = runnableInstruction.getChildren("extended");
            for (Element oldExtendedElement : oldExtendedElements) {
                Element newExtendedSubElement = new Element("extended");
                Map coresMap = this.helper.getMultipleElementsNameandTypeFromAttributeOrChildeElement("key", oldExtendedElement);
                for (String coreName : coresMap.keySet()) {
                    Element puReference = new Element("key");
                    puReference.setAttribute("href", "amlt:/#" + this.helper.encodeNameForReference(coreName) + "?type=ProcessingUnitDefinition");
                    newExtendedSubElement.addContent((Content)puReference);
                }
                this.migrateValueOfRunnableInstructions(oldExtendedElement, newExtendedSubElement, "value");
                executionNeedElement.addContent((Content)newExtendedSubElement);
            }
            parentElementOfRunnableInstruction.addContent(indexOfRunnableInstructions, (Content)executionNeedElement);
            runnableInstruction.detach();
        }
    }

    private void checkAndCreateHWFeatureCategory(Element rootElement) {
        Element hwModelEleemnt = rootElement.getChild("hwModel");
        if (hwModelEleemnt == null) {
            hwModelEleemnt = new Element("hwModel");
            rootElement.addContent((Content)hwModelEleemnt);
        }
        Element featureCategoriesElement = new Element("featureCategories");
        featureCategoriesElement.setAttribute("name", "Instructions");
        featureCategoriesElement.setAttribute("featureType", "performance");
        hwModelEleemnt.addContent((Content)featureCategoriesElement);
    }

    private void migrateValueOfRunnableInstructions(Element runnableInstruction, Element executionNeedElement, String valueTagName) {
        String oldElement_defaultType;
        Element oldDefaultElement = runnableInstruction.getChild(valueTagName);
        if (oldDefaultElement != null && (oldElement_defaultType = oldDefaultElement.getAttributeValue("type", this.helper.getGenericNS("xsi"))) != null) {
            if (oldElement_defaultType.equals("am:InstructionsConstant")) {
                String oldDefault_value = oldDefaultElement.getAttributeValue("value");
                if (oldDefault_value != null) {
                    Element newDefaultSubElement = new Element(valueTagName);
                    if (valueTagName.equals("default")) {
                        newDefaultSubElement.setAttribute("key", "Instructions");
                    } else {
                        Element newKeyElement = new Element("key");
                        newKeyElement.setAttribute("href", "amlt:/#Instructions?type=HwFeatureCategory");
                        newDefaultSubElement.addContent((Content)newKeyElement);
                    }
                    Element newValueElement = new Element("value");
                    newValueElement.setAttribute("type", "am:NeedConstant", this.helper.getGenericNS("xsi"));
                    newValueElement.setAttribute("value", oldDefault_value);
                    newDefaultSubElement.addContent((Content)newValueElement);
                    executionNeedElement.addContent((Content)newDefaultSubElement);
                }
            } else if (oldElement_defaultType.equals("am:InstructionsDeviation")) {
                Element newDefaultSubElement = new Element(valueTagName);
                if (valueTagName.equals("default")) {
                    newDefaultSubElement.setAttribute("key", "Instructions");
                } else {
                    Element newKeyElement = new Element("key");
                    newKeyElement.setAttribute("href", "amlt:/#Instructions?type=HwFeatureCategory");
                    newDefaultSubElement.addContent((Content)newKeyElement);
                }
                Element newValueElement = new Element("value");
                newValueElement.setAttribute("type", "am:NeedDeviation", this.helper.getGenericNS("xsi"));
                Element oldDeviationElement = oldDefaultElement.getChild("deviation");
                if (oldDeviationElement != null) {
                    Element newDeviationElement = oldDeviationElement.clone();
                    newDeviationElement.detach();
                    newValueElement.addContent((Content)newDeviationElement);
                }
                newDefaultSubElement.addContent((Content)newValueElement);
                executionNeedElement.addContent((Content)newDefaultSubElement);
            }
        }
    }

    private void migrateEvents(Element rootElement) {
        Element eventModel = rootElement.getChild("eventModel");
        if (eventModel != null) {
            List events = eventModel.getChildren("events");
            for (Element event : events) {
                Map coresMap = this.helper.getMultipleElementsNameandTypeFromAttributeOrChildeElement("core", event);
                event.removeChildren("core");
                event.removeAttribute("core");
                for (String coreName : coresMap.keySet()) {
                    Element memoryElement = new Element("processingUnit");
                    memoryElement.setAttribute("href", "amlt:/#" + this.helper.encodeNameForReference(coreName) + "?type=ProcessingUnit");
                    event.addContent((Content)memoryElement);
                }
            }
        }
    }

    private void migrateTaskAllocation(Element rootElement) {
        Element mappingModel = rootElement.getChild("mappingModel");
        if (mappingModel != null) {
            List taskAllocations = mappingModel.getChildren("taskAllocation");
            for (Element taskAllocation : taskAllocations) {
                Map coresMap = this.helper.getMultipleElementsNameandTypeFromAttributeOrChildeElement("coreAffinity", taskAllocation);
                taskAllocation.removeChildren("coreAffinity");
                taskAllocation.removeAttribute("coreAffinity");
                for (String coreName : coresMap.keySet()) {
                    Element processingUnitElement = new Element("affinity");
                    processingUnitElement.setAttribute("href", "amlt:/#" + this.helper.encodeNameForReference(coreName) + "?type=ProcessingUnit");
                    taskAllocation.addContent((Content)processingUnitElement);
                }
            }
        }
    }

    private void migrateSchedulerAllocation(Element rootElement) {
        Element mappingModel = rootElement.getChild("mappingModel");
        if (mappingModel != null) {
            List schedulerAllocations = mappingModel.getChildren("schedulerAllocation");
            for (Element schedulerAllocation : schedulerAllocations) {
                Element memoryElement;
                Map coresMap = this.helper.getMultipleElementsNameandTypeFromAttributeOrChildeElement("responsibility", schedulerAllocation);
                schedulerAllocation.removeChildren("responsibility");
                schedulerAllocation.removeAttribute("responsibility");
                for (String coreName : coresMap.keySet()) {
                    memoryElement = new Element("responsibility");
                    memoryElement.setAttribute("href", "amlt:/#" + coreName + "?type=ProcessingUnit");
                    schedulerAllocation.addContent((Content)memoryElement);
                }
                coresMap = this.helper.getMultipleElementsNameandTypeFromAttributeOrChildeElement("executingCore", schedulerAllocation);
                schedulerAllocation.removeChildren("executingCore");
                schedulerAllocation.removeAttribute("executingCore");
                for (String coreName : coresMap.keySet()) {
                    memoryElement = new Element("executingPU");
                    memoryElement.setAttribute("href", "amlt:/#" + coreName + "?type=ProcessingUnit");
                    schedulerAllocation.addContent((Content)memoryElement);
                }
            }
        }
    }

    private void migratePhysicalSectionMapping(Element rootElement) {
        Element mappingModel = rootElement.getChild("mappingModel");
        if (mappingModel != null) {
            List physicalSectionMappings = mappingModel.getChildren("physicalSectionMapping");
            for (Element physicalSectionMapping : physicalSectionMappings) {
                Map memoriesMap = this.helper.getMultipleElementsNameandTypeFromAttributeOrChildeElement("memory", physicalSectionMapping);
                physicalSectionMapping.removeChildren("memory");
                physicalSectionMapping.removeAttribute("memory");
                for (String memoryName : memoriesMap.keySet()) {
                    if (this.hwTransformationCache.new_memories_Map.containsKey(memoryName)) {
                        Element memoryElement = new Element("memory");
                        memoryElement.setAttribute("href", "amlt:/#" + memoryName + "?type=Memory");
                        physicalSectionMapping.addContent((Content)memoryElement);
                        continue;
                    }
                    if (!this.hwTransformationCache.new_caches_Map.containsKey(memoryName)) continue;
                    this.helper.logger.warn((Object)("In 0.8.3, Memory : \"" + memoryName + "\" referred as a Target element in AffinityConstraint is no longer a valid Target element. \r\n -- As in 0.9.0 -> this Memory element is transformed to Cache "));
                }
            }
        }
    }

    private void migrateMemoryMapping(Element rootElement) {
        Element mappingModel = rootElement.getChild("mappingModel");
        if (mappingModel != null) {
            List memoryMappings = mappingModel.getChildren("memoryMapping");
            for (Element memroyMapping : memoryMappings) {
                Map memoriesMap = this.helper.getMultipleElementsNameandTypeFromAttributeOrChildeElement("memory", memroyMapping);
                memroyMapping.removeChildren("memory");
                memroyMapping.removeAttribute("memory");
                for (String memoryName : memoriesMap.keySet()) {
                    if (this.hwTransformationCache.new_memories_Map.containsKey(memoryName)) {
                        Element memoryElement = new Element("memory");
                        memoryElement.setAttribute("href", "amlt:/#" + memoryName + "?type=Memory");
                        memroyMapping.addContent((Content)memoryElement);
                        continue;
                    }
                    if (!this.hwTransformationCache.new_caches_Map.containsKey(memoryName)) continue;
                    this.helper.logger.warn((Object)("In 0.8.3, Memory : \"" + memoryName + "\" referred as a Target element in AffinityConstraint is no longer a valid Target element. \r\n -- As in 0.9.0 -> this Memory element is transformed to Cache "));
                }
            }
        }
    }

    private void migratePhysicalSectionConstraint(Element rootElement) {
        Element constraintsModel = rootElement.getChild("constraintsModel");
        if (constraintsModel != null) {
            List physicalSectionConstraints = constraintsModel.getChildren("physicalSectionConstraints");
            for (Element physicalSectionContraint : physicalSectionConstraints) {
                Map memoriesMap = this.helper.getMultipleElementsNameandTypeFromAttributeOrChildeElement("memories", physicalSectionContraint);
                physicalSectionContraint.removeChildren("memories");
                physicalSectionContraint.removeAttribute("memories");
                for (String memoryName : memoriesMap.keySet()) {
                    if (this.hwTransformationCache.new_memories_Map.containsKey(memoryName)) {
                        Element memoryElement = new Element("memories");
                        memoryElement.setAttribute("href", "amlt:/#" + memoryName + "?type=Memory");
                        physicalSectionContraint.addContent((Content)memoryElement);
                        continue;
                    }
                    if (!this.hwTransformationCache.new_caches_Map.containsKey(memoryName)) continue;
                    this.helper.logger.warn((Object)("In 0.8.3, Memory : \"" + memoryName + "\" referred as a Target element in AffinityConstraint is no longer a valid Target element. \r\n -- As in 0.9.0 -> this Memory element is transformed to Cache "));
                }
            }
        }
    }

    private void migrateCPUPercentageRequirementLimit(Element rootElement) {
        Element constraintsModel = rootElement.getChild("constraintsModel");
        if (constraintsModel != null) {
            List requirements = constraintsModel.getChildren("requirements");
            for (Element requirement : requirements) {
                List limitElements = requirement.getChildren("limit");
                for (Element limitElement : limitElements) {
                    String limitElementType = limitElement.getAttributeValue("type", this.helper.getGenericNS("xsi"));
                    if (limitElementType == null || !limitElementType.equals("am:CPUPercentageRequirementLimit")) continue;
                    Map complexNodesMap = this.helper.getMultipleElementsNameandTypeFromAttributeOrChildeElement("hardwareContext", limitElement);
                    limitElement.removeChildren("hardwareContext");
                    limitElement.removeAttribute("hardwareContext");
                    for (String complexNodeName : complexNodesMap.keySet()) {
                        String complexNodeType = (String)complexNodesMap.get(complexNodeName);
                        if (complexNodeType != null && complexNodeType.equals("Core")) {
                            Element puElement = new Element("hardwareContext");
                            puElement.setAttribute("href", "amlt:/#" + complexNodeName + "?type=ProcessingUnit");
                            limitElement.addContent((Content)puElement);
                            continue;
                        }
                        this.helper.logger.warn((Object)("As per 0.9.0 : Only ProcessingUnit element can be referred inside CPUPercentageRequirementLimit as a hardwareContext.\r\n Reference of : " + complexNodeName + " of type :" + complexNodeType + " is removed : as it is not valid as per 0.9.0"));
                    }
                }
            }
        }
    }

    private void migrateTargetMemory(Element rootElement) {
        Element constraintsModel = rootElement.getChild("constraintsModel");
        if (constraintsModel != null) {
            List affinityConstraints = constraintsModel.getChildren("affinityConstraints");
            for (Element affinityConstraint : affinityConstraints) {
                List targetMemories = affinityConstraint.getChildren("target");
                for (Element targetMemory : targetMemories) {
                    String elementType = targetMemory.getAttributeValue("type", this.helper.getGenericNS("xsi"));
                    if (elementType == null || !elementType.equals("am:TargetMemory")) continue;
                    Map memoriesMap = this.helper.getMultipleElementsNameandTypeFromAttributeOrChildeElement("memories", targetMemory);
                    targetMemory.removeChildren("memories");
                    targetMemory.removeAttribute("memories");
                    for (String memoryName : memoriesMap.keySet()) {
                        if (this.hwTransformationCache.new_memories_Map.containsKey(memoryName)) {
                            Element memoryElement = new Element("memories");
                            memoryElement.setAttribute("href", "amlt:/#" + memoryName + "?type=Memory");
                            targetMemory.addContent((Content)memoryElement);
                            continue;
                        }
                        if (!this.hwTransformationCache.new_caches_Map.containsKey(memoryName)) continue;
                        this.helper.logger.warn((Object)("In 0.8.3, Memory : \"" + memoryName + "\" referred as a Target element in AffinityConstraint is no longer a valid Target element. \r\n -- As in 0.9.0 -> this Memory element is transformed to Cache "));
                    }
                }
            }
        }
    }

    private void migrateTargetCore(Element rootElement) {
        Element constraintsModel = rootElement.getChild("constraintsModel");
        if (constraintsModel != null) {
            List affinityConstraints = constraintsModel.getChildren("affinityConstraints");
            for (Element affinityConstraint : affinityConstraints) {
                List targetCores = affinityConstraint.getChildren("target");
                for (Element targetCore : targetCores) {
                    Map coresMap = this.helper.getMultipleElementsNameandTypeFromAttributeOrChildeElement("cores", targetCore);
                    targetCore.removeChildren("cores");
                    targetCore.removeAttribute("cores");
                    for (String coreName : coresMap.keySet()) {
                        Element memoryElement = new Element("cores");
                        memoryElement.setAttribute("href", "amlt:/#" + coreName + "?type=ProcessingUnit");
                        targetCore.addContent((Content)memoryElement);
                    }
                }
            }
        }
    }

    private HWTransformationCache getHWTransformationCache() {
        if (this.hwTransformationCache == null) {
            boolean isHWCacheAvailable = false;
            for (ICache cache : this.caches) {
                Map map;
                if (!(cache instanceof HWCacheBuilder)) continue;
                isHWCacheAvailable = true;
                Map cacheMap = cache.getCacheMap();
                if (cacheMap == null || cacheMap.size() <= 0 || (map = (Map)Iterables.get(cacheMap.values(), (int)0)) == null) continue;
                Object object = map.get("globalCache");
                return (HWTransformationCache)object;
            }
            if (!isHWCacheAvailable) {
                return new HWTransformationCache();
            }
        }
        return this.hwTransformationCache;
    }
}

