/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validation.checks.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.CallArgument;
import org.eclipse.app4mc.amalthea.model.DataDependency;
import org.eclipse.app4mc.amalthea.model.DirectionType;
import org.eclipse.app4mc.amalthea.model.LabelAccess;
import org.eclipse.app4mc.amalthea.model.LabelAccessEnum;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableCall;
import org.eclipse.app4mc.amalthea.model.RunnableParameter;
import org.eclipse.app4mc.amalthea.model.util.SoftwareUtil;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.AbstractValidatorImpl;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IEObjectHelper;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IssueCreator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SoftwareModelCheckValidatorImpl
extends AbstractValidatorImpl {
    public SoftwareModelCheckValidatorImpl(IssueCreator issueCreator) {
        super(issueCreator);
    }

    public SoftwareModelCheckValidatorImpl(IssueCreator issueCreator, IEObjectHelper objectHelper) {
        super(issueCreator, objectHelper);
    }

    public void checkDataDependency(DataDependency dependency) {
        List<CallArgument> localCallArguments;
        List<RunnableParameter> localParameters;
        DirectionType direction;
        RunnableParameter parameter;
        DirectionType direction2;
        LabelAccessEnum accessType;
        Runnable runnable = dependency.getContainingRunnable();
        if (runnable == null) {
            return;
        }
        EObject container = dependency.eContainer();
        if (container instanceof LabelAccess && (accessType = ((LabelAccess)container).getAccess()) != LabelAccessEnum.WRITE) {
            this.issueCreator.issue(container, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getRunnable_RunnableItems(), new Object[]{"A data dependency can only be defined for WRITE label accesses"});
        }
        if (container instanceof RunnableParameter && (direction2 = ((RunnableParameter)container).getDirection()) != DirectionType.OUT && direction2 != DirectionType.INOUT) {
            this.issueCreator.issue(container, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getRunnable_Parameters(), new Object[]{"A data dependency can only be defined for OUT/INOUT parameters"});
        }
        if (container instanceof CallArgument && (parameter = ((CallArgument)container).getParameter()) != null && (direction = parameter.getDirection()) != DirectionType.IN && direction != DirectionType.INOUT) {
            this.issueCreator.issue(container, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getRunnableCall_Arguments(), new Object[]{"A data dependency can only be defined for IN/INOUT call arguments"});
        }
        if (!(localParameters = this.getSuitableParameters(runnable)).containsAll((Collection<?>)dependency.getParameters())) {
            this.issueCreator.issue((EObject)dependency, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getDataDependency_Parameters(), new Object[]{"A data dependency can only refer to local IN/INOUT parameters"});
        }
        if (!(localCallArguments = this.getSuitableCallArguments(runnable)).containsAll((Collection<?>)dependency.getCallArguments())) {
            this.issueCreator.issue((EObject)dependency, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getDataDependency_CallArguments(), new Object[]{"A data dependency can only refer to local OUT/INOUT call arguments"});
        }
    }

    public void checkCallArgument(CallArgument argument) {
        Runnable calledRunnable = argument.getContainingCall().getRunnable();
        RunnableParameter parameter = argument.getParameter();
        if (parameter == null) {
            this.issueCreator.issue((EObject)argument, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getCallArgument_Parameter(), new Object[]{"Parameter of argument is undefined"});
            return;
        }
        if (calledRunnable == null) {
            this.issueCreator.issue((EObject)argument.getContainingCall(), (EStructuralFeature)AmaltheaPackage.eINSTANCE.getRunnableCall_Runnable(), new Object[]{"Called runnable is undefined"});
            return;
        }
        if (!calledRunnable.getParameters().contains((Object)parameter)) {
            this.issueCreator.issue((EObject)argument, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getCallArgument_Parameter(), new Object[]{"Called Runnable \"" + calledRunnable.getName() + "\" does not match Parameter \"" + parameter.toString() + "\""});
        }
    }

    private List<RunnableParameter> getSuitableParameters(Runnable runnable) {
        if (runnable == null) {
            return Collections.emptyList();
        }
        return runnable.getParameters().stream().filter(e -> e.getDirection() == DirectionType.IN || e.getDirection() == DirectionType.INOUT).collect(Collectors.toList());
    }

    private List<CallArgument> getSuitableCallArguments(Runnable runnable) {
        if (runnable == null) {
            return Collections.emptyList();
        }
        List<DirectionType> possibleDirections = Arrays.asList(DirectionType.OUT, DirectionType.INOUT);
        return SoftwareUtil.collectRunnableItems((Runnable)runnable, null, e -> e instanceof RunnableCall).stream().flatMap(e -> ((RunnableCall)e).getArguments().stream()).filter(e -> e.getParameter() != null).filter(e -> possibleDirections.contains(e.getParameter().getDirection())).collect(Collectors.toList());
    }
}

