/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.execution.logic.openmapping;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.app4mc.amalthea.model.Deviation;
import org.eclipse.app4mc.amalthea.model.ExecutionNeed;
import org.eclipse.app4mc.amalthea.model.LongObject;
import org.eclipse.app4mc.amalthea.model.Need;
import org.eclipse.app4mc.amalthea.model.NeedConstant;
import org.eclipse.app4mc.amalthea.model.NeedDeviation;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableItem;
import org.eclipse.app4mc.amalthea.model.util.InstructionsUtil;
import org.eclipse.app4mc.multicore.sharelibs.UniversalHandler;
import org.eclipse.emf.common.util.EList;

public class OMRunnable {
    private final Runnable runnableRef;
    private long instructions = -1L;
    private final List<OMRunnable> post = new LinkedList<OMRunnable>();

    public OMRunnable(Runnable ref) {
        this.runnableRef = ref;
    }

    public Runnable getRunnableRef() {
        return this.runnableRef;
    }

    public long getInstructionCount() {
        if (this.runnableRef == null) {
            return 0L;
        }
        if (this.instructions >= 0L) {
            return this.instructions;
        }
        if (this.runnableRef.getRunnableItems().size() <= 0) {
            UniversalHandler.getInstance().log("Invalid Software Model, Runnable '" + this.runnableRef.getName() + "' contains no RunnableItems.", null);
            return 0L;
        }
        this.instructions = this.parseRunnableItems((EList<RunnableItem>)this.runnableRef.getRunnableItems());
        return this.instructions;
    }

    private long parseRunnableItems(EList<RunnableItem> runnableItemsList) {
        for (RunnableItem runnableItem : runnableItemsList) {
            if (!(runnableItem instanceof ExecutionNeed)) continue;
            ExecutionNeed execNeed = (ExecutionNeed)runnableItem;
            Need abstractNeed = InstructionsUtil.getDefaultNeed((ExecutionNeed)execNeed);
            if (abstractNeed == null) {
                UniversalHandler.getInstance().log(" Unexpected SWModel.\nexecution need is not set!\nSkipping...", null);
                return 0L;
            }
            if (abstractNeed instanceof NeedConstant) {
                return this.processNeedConstant((NeedConstant)abstractNeed);
            }
            if (abstractNeed instanceof NeedDeviation) {
                return this.processNeedDeviation((NeedDeviation)abstractNeed);
            }
            UniversalHandler.getInstance().logCon("Debug Info: Skipping " + runnableItem.getClass().toString());
        }
        UniversalHandler.getInstance().log("Invalid Software Model, there has been no execution need specified.", null);
        return 0L;
    }

    private long processNeedConstant(NeedConstant needConstant) {
        if (needConstant.getValue() <= 0L) {
            UniversalHandler.getInstance().log("Invalid Software Model, NeedConstant contains an invalid value (<= 0).", null);
            return 0L;
        }
        return needConstant.getValue();
    }

    private long processNeedDeviation(NeedDeviation needDeviation) {
        Deviation deviation = needDeviation.getDeviation();
        if (deviation == null) {
            UniversalHandler.getInstance().log("Invalid Software Model, NeedDeviation has an invalid or missing containment to its Deviation.", null);
            return 0L;
        }
        Long lowerBound = ((LongObject)deviation.getLowerBound()).getValue();
        Long upperBound = ((LongObject)deviation.getUpperBound()).getValue();
        if (lowerBound <= 0L || upperBound <= 0L) {
            UniversalHandler.getInstance().log("Unexpected SWModel.\nDeviation not set properly.\nSkipping...", null);
            return 0L;
        }
        return (lowerBound + upperBound) / 2L;
    }

    public List<OMRunnable> getPost() {
        return this.post;
    }
}

