/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.editors.sirius.design.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.app4mc.amalthea.model.Label;
import org.eclipse.app4mc.amalthea.model.LabelAccess;
import org.eclipse.app4mc.amalthea.model.LabelAccessEnum;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableItem;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class RunnableService {
    public List<Label> getLabelWriteAccessesForRunnable(Runnable runnable) {
        return this.getLabelAccessesForRunnable(runnable, LabelAccessEnum.WRITE);
    }

    public List<Label> getLabelReadAccessesForRunnable(Runnable runnable) {
        return this.getLabelAccessesForRunnable(runnable, LabelAccessEnum.READ);
    }

    private List<Label> getLabelAccessesForRunnable(Runnable runnable, LabelAccessEnum accessType) {
        List<Label> result = new ArrayList<Label>();
        if (runnable != null) {
            result = this.getLabelAccessesForRunnableItems((List<RunnableItem>)runnable.getRunnableItems(), accessType);
        }
        return result;
    }

    private List<Label> getLabelAccessesForRunnableItems(List<RunnableItem> items, LabelAccessEnum accessType) {
        ArrayList<Label> result = new ArrayList<Label>();
        TreeIterator iter = EcoreUtil.getAllContents(items);
        while (iter.hasNext()) {
            EObject item = (EObject)iter.next();
            if (!(item instanceof LabelAccess) || !((LabelAccess)item).getAccess().equals((Object)accessType)) continue;
            result.add(((LabelAccess)item).getData());
        }
        return result;
    }

    public List<Runnable> getCommunicationForRunnable(Runnable runnable) {
        ArrayList<Runnable> result = new ArrayList<Runnable>();
        if (runnable != null) {
            TreeIterator iter = EcoreUtil.getAllContents((Collection)runnable.getRunnableItems());
            while (iter.hasNext()) {
                Label label;
                EObject item = (EObject)iter.next();
                if (!(item instanceof LabelAccess) || !((LabelAccess)item).getAccess().equals((Object)LabelAccessEnum.WRITE) || (label = ((LabelAccess)item).getData()) == null) continue;
                for (LabelAccess labelAccess : label.getLabelAccesses()) {
                    if (labelAccess == item || !labelAccess.getAccess().equals((Object)LabelAccessEnum.READ)) continue;
                    result.add((Runnable)labelAccess.eContainer());
                }
            }
        }
        return result;
    }
}

