/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters093.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters093.impl.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters093.utils.HelperUtils_092_093;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class StimulusConverter
extends AbstractConverter {
    private File targetFile;

    public StimulusConverter() {
        this.helper = HelperUtils_092_093.getInstance();
        this.logger = LogManager.getLogger((String)"org.eclipse.app4mc.amalthea.modelmigration");
    }

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) throws Exception {
        this.logger.info((Object)("Migration from 0.9.2 to 0.9.3 : Executing Stimulus converter for model file : " + targetFile.getName()));
        this.caches = caches;
        this.fileName_documentsMap = fileName_documentsMap;
        this.targetFile = targetFile;
        Document root = fileName_documentsMap.get(this.targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.update_Stimuli(rootElement);
    }

    private void update_Stimuli(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("./stimuliModel/stimuli");
        List stimuliElements = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getNS_093("am"), this.helper.getGenericNS("xsi")});
        for (Element stimuliElement : stimuliElements) {
            Element migratedElement;
            String stimuliType = stimuliElement.getAttributeValue("type", this.helper.getGenericNS("xsi"));
            if (stimuliType == null) continue;
            if (stimuliType.equals("am:PeriodicStimulus")) {
                Element jitter_time_deviationElement = stimuliElement.getChild("jitter");
                if (jitter_time_deviationElement == null) continue;
                migratedElement = this.migrateDeviationElement_Containing_TimeValue(jitter_time_deviationElement, "jitter");
                int indexOf = stimuliElement.indexOf((Content)jitter_time_deviationElement);
                stimuliElement.removeContent((Content)jitter_time_deviationElement);
                if (migratedElement == null) continue;
                stimuliElement.addContent(indexOf, (Content)migratedElement);
                continue;
            }
            if (stimuliType.equals("am:RelativePeriodicStimulus")) {
                Element nextOccurrence_time_deviationElement = stimuliElement.getChild("nextOccurrence");
                if (nextOccurrence_time_deviationElement == null) continue;
                migratedElement = this.migrateDeviationElement_Containing_TimeValue(nextOccurrence_time_deviationElement, "nextOccurrence");
                int indexOf = stimuliElement.indexOf((Content)nextOccurrence_time_deviationElement);
                stimuliElement.removeContent((Content)nextOccurrence_time_deviationElement);
                if (migratedElement == null) continue;
                stimuliElement.addContent(indexOf, (Content)migratedElement);
                continue;
            }
            if (!stimuliType.equals("am:VariableRateStimulus")) continue;
            Element occurrencesPerStep_double_deviationElement = stimuliElement.getChild("occurrencesPerStep");
            if (occurrencesPerStep_double_deviationElement != null) {
                migratedElement = this.migrateDeviationElement_Containing_DoubleValue(occurrencesPerStep_double_deviationElement, "occurrencesPerStep");
                int indexOf = stimuliElement.indexOf((Content)occurrencesPerStep_double_deviationElement);
                stimuliElement.removeContent((Content)occurrencesPerStep_double_deviationElement);
                if (migratedElement != null) {
                    stimuliElement.addContent(indexOf, (Content)migratedElement);
                }
            }
            Element maxIncreasePerStepElement = stimuliElement.getChild("maxIncreasePerStep");
            Element maxDecreasePerStepElement = stimuliElement.getChild("maxDecreasePerStep");
            if (maxIncreasePerStepElement != null) {
                stimuliElement.setAttribute("maxIncreasePerStep", maxIncreasePerStepElement.getAttributeValue("value"));
                stimuliElement.removeContent((Content)maxIncreasePerStepElement);
            }
            if (maxDecreasePerStepElement == null) continue;
            stimuliElement.setAttribute("maxDecreasePerStep", maxDecreasePerStepElement.getAttributeValue("value"));
            stimuliElement.removeContent((Content)maxDecreasePerStepElement);
        }
    }
}

