/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.workflow.component;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.CallSequence;
import org.eclipse.app4mc.amalthea.model.CallSequenceItem;
import org.eclipse.app4mc.amalthea.model.GraphEntryBase;
import org.eclipse.app4mc.amalthea.model.Preemption;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.model.TaskRunnableCall;
import org.eclipse.app4mc.amalthea.workflow.core.Context;
import org.eclipse.app4mc.amalthea.workflow.core.WorkflowComponent;
import org.eclipse.app4mc.amalthea.workflow.core.exception.WorkflowException;

public class AddSchedulePoints
extends WorkflowComponent {
    @Override
    protected void runInternal(Context ctx) {
        if (this.getAmaltheaModel(ctx).getSwModel() == null) {
            throw new WorkflowException("No proper SWModel available in slot " + this.getModelSlot());
        }
        if (this.getAmaltheaModel(ctx).getSwModel().getTasks().isEmpty()) {
            throw new WorkflowException("No Tasks available to check in slot " + this.getModelSlot());
        }
        this.addSchedulePointsToTasks((List<Task>)this.getAmaltheaModel(ctx).getSwModel().getTasks());
    }

    public void addSchedulePointsToTasks(List<Task> tasks) {
        for (Task task : tasks) {
            if (task.getCallGraph() == null || !task.getPreemption().equals((Object)Preemption.COOPERATIVE)) continue;
            this.log.info((Object)("Adding schedule points to cooperative Task [" + task.getName() + "]"));
            for (GraphEntryBase graphEntry : task.getCallGraph().getGraphEntries()) {
                if (!(graphEntry instanceof CallSequence)) continue;
                int index = 0;
                ArrayList<Object> tmp = new ArrayList<Object>();
                for (CallSequenceItem callSeqItem : ((CallSequence)graphEntry).getCalls()) {
                    tmp.add(callSeqItem);
                    if (callSeqItem instanceof TaskRunnableCall && index != ((CallSequence)graphEntry).getCalls().size() - 1) {
                        tmp.add(AmaltheaFactory.eINSTANCE.createSchedulePoint());
                    }
                    ++index;
                }
                ((CallSequence)graphEntry).getCalls().clear();
                ((CallSequence)graphEntry).getCalls().addAll(tmp);
            }
        }
    }
}

