/**
 * *******************************************************************************
 *  Copyright (c) 2015-2019 Robert Bosch GmbH and others.
 * 
 *  This program and the accompanying materials are made
 *  available under the terms of the Eclipse Public License 2.0
 *  which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 *  SPDX-License-Identifier: EPL-2.0
 * 
 *     Generated using Eclipse EMF
 * 
 * *******************************************************************************
 */
package org.eclipse.app4mc.amalthea.model;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * *
 * *******************************************************************************
 * Copyright (c) 2015-2019 Robert Bosch GmbH and others.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * *******************************************************************************
 * <!-- end-model-doc -->
 * @see org.eclipse.app4mc.amalthea.model.AmaltheaFactory
 * @model kind="package"
 *        annotation="http://www.eclipse.org/emf/2002/GenModel modelName='Amalthea' prefix='Amalthea' editDirectory='/org.eclipse.app4mc.amalthea.model.edit/src-gen' rootExtendsClass='org.eclipse.app4mc.amalthea.sphinx.AmaltheaExtendedEObjectImpl' providerRootExtendsClass='org.eclipse.app4mc.amalthea.sphinx.AmaltheaExtendedItemProviderAdapter' creationIcons='false' forceOverwrite='true' creationSubmenus='true' generateSchema='true' loadInitialization='false' copyrightText='*******************************************************************************\r\n Copyright (c) 2015-2019 Robert Bosch GmbH and others.\r\n\r\n This program and the accompanying materials are made\r\n available under the terms of the Eclipse Public License 2.0\r\n which is available at https://www.eclipse.org/legal/epl-2.0/\r\n\r\n SPDX-License-Identifier: EPL-2.0\r\n\r\n    Generated using Eclipse EMF\r\n\r\n*******************************************************************************' basePackage='org.eclipse.app4mc.amalthea'"
 * @generated
 */
public interface AmaltheaPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "model";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://app4mc.eclipse.org/amalthea/0.9.3";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "am";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	AmaltheaPackage eINSTANCE = org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.IAnnotatable <em>IAnnotatable</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.IAnnotatable
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getIAnnotatable()
	 * @generated
	 */
	int IANNOTATABLE = 5;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IANNOTATABLE__CUSTOM_PROPERTIES = 0;

	/**
	 * The number of structural features of the '<em>IAnnotatable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IANNOTATABLE_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>IAnnotatable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IANNOTATABLE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.BaseObjectImpl <em>Base Object</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.BaseObjectImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getBaseObject()
	 * @generated
	 */
	int BASE_OBJECT = 2;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE_OBJECT__CUSTOM_PROPERTIES = IANNOTATABLE__CUSTOM_PROPERTIES;

	/**
	 * The number of structural features of the '<em>Base Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE_OBJECT_FEATURE_COUNT = IANNOTATABLE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Base Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE_OBJECT_OPERATION_COUNT = IANNOTATABLE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.AmaltheaImpl <em>Amalthea</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getAmalthea()
	 * @generated
	 */
	int AMALTHEA = 0;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AMALTHEA__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AMALTHEA__VERSION = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Common Elements</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AMALTHEA__COMMON_ELEMENTS = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Sw Model</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AMALTHEA__SW_MODEL = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Hw Model</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AMALTHEA__HW_MODEL = BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Os Model</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AMALTHEA__OS_MODEL = BASE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Stimuli Model</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AMALTHEA__STIMULI_MODEL = BASE_OBJECT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Event Model</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AMALTHEA__EVENT_MODEL = BASE_OBJECT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Constraints Model</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AMALTHEA__CONSTRAINTS_MODEL = BASE_OBJECT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Property Constraints Model</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AMALTHEA__PROPERTY_CONSTRAINTS_MODEL = BASE_OBJECT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Mapping Model</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AMALTHEA__MAPPING_MODEL = BASE_OBJECT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Components Model</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AMALTHEA__COMPONENTS_MODEL = BASE_OBJECT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Config Model</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AMALTHEA__CONFIG_MODEL = BASE_OBJECT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Measurement Model</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AMALTHEA__MEASUREMENT_MODEL = BASE_OBJECT_FEATURE_COUNT + 12;

	/**
	 * The number of structural features of the '<em>Amalthea</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AMALTHEA_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 13;

	/**
	 * The number of operations of the '<em>Amalthea</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AMALTHEA_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.CommonElementsImpl <em>Common Elements</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.CommonElementsImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getCommonElements()
	 * @generated
	 */
	int COMMON_ELEMENTS = 1;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMON_ELEMENTS__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMON_ELEMENTS__TAGS = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Core Classifiers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMON_ELEMENTS__CORE_CLASSIFIERS = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Memory Classifiers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMON_ELEMENTS__MEMORY_CLASSIFIERS = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Common Elements</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMON_ELEMENTS_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Common Elements</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMON_ELEMENTS_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.INamed <em>INamed</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.INamed
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getINamed()
	 * @generated
	 */
	int INAMED = 7;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INAMED__NAME = 0;

	/**
	 * The number of structural features of the '<em>INamed</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INAMED_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>INamed</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INAMED_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.IReferable <em>IReferable</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.IReferable
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getIReferable()
	 * @generated
	 */
	int IREFERABLE = 8;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREFERABLE__NAME = INAMED__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREFERABLE__UNIQUE_NAME = INAMED_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>IReferable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREFERABLE_FEATURE_COUNT = INAMED_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREFERABLE___COMPUTE_UNIQUE_NAME = INAMED_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREFERABLE___BASIC_COMPUTE_UNIQUE_NAME = INAMED_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREFERABLE___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = INAMED_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREFERABLE___ENCODE__STRING = INAMED_OPERATION_COUNT + 3;

	/**
	 * The number of operations of the '<em>IReferable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IREFERABLE_OPERATION_COUNT = INAMED_OPERATION_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ReferableObjectImpl <em>Referable Object</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ReferableObjectImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getReferableObject()
	 * @generated
	 */
	int REFERABLE_OBJECT = 3;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERABLE_OBJECT__NAME = IREFERABLE__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERABLE_OBJECT__UNIQUE_NAME = IREFERABLE__UNIQUE_NAME;

	/**
	 * The number of structural features of the '<em>Referable Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERABLE_OBJECT_FEATURE_COUNT = IREFERABLE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERABLE_OBJECT___COMPUTE_UNIQUE_NAME = IREFERABLE___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERABLE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME = IREFERABLE___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERABLE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = IREFERABLE___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERABLE_OBJECT___ENCODE__STRING = IREFERABLE___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Referable Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERABLE_OBJECT_OPERATION_COUNT = IREFERABLE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ReferableBaseObjectImpl <em>Referable Base Object</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ReferableBaseObjectImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getReferableBaseObject()
	 * @generated
	 */
	int REFERABLE_BASE_OBJECT = 4;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES = IANNOTATABLE__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERABLE_BASE_OBJECT__NAME = IANNOTATABLE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERABLE_BASE_OBJECT__UNIQUE_NAME = IANNOTATABLE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Referable Base Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERABLE_BASE_OBJECT_FEATURE_COUNT = IANNOTATABLE_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERABLE_BASE_OBJECT___COMPUTE_UNIQUE_NAME = IANNOTATABLE_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME = IANNOTATABLE_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = IANNOTATABLE_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERABLE_BASE_OBJECT___ENCODE__STRING = IANNOTATABLE_OPERATION_COUNT + 3;

	/**
	 * The number of operations of the '<em>Referable Base Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERABLE_BASE_OBJECT_OPERATION_COUNT = IANNOTATABLE_OPERATION_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.ITaggable <em>ITaggable</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.ITaggable
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getITaggable()
	 * @generated
	 */
	int ITAGGABLE = 6;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITAGGABLE__TAGS = 0;

	/**
	 * The number of structural features of the '<em>ITaggable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITAGGABLE_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>ITaggable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITAGGABLE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.IDisplayName <em>IDisplay Name</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.IDisplayName
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getIDisplayName()
	 * @generated
	 */
	int IDISPLAY_NAME = 9;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDISPLAY_NAME__DISPLAY_NAME = 0;

	/**
	 * The number of structural features of the '<em>IDisplay Name</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDISPLAY_NAME_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>IDisplay Name</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDISPLAY_NAME_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TagImpl <em>Tag</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TagImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTag()
	 * @generated
	 */
	int TAG = 10;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TAG__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TAG__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TAG__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tag Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TAG__TAG_TYPE = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Tagged Objects</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TAG__TAGGED_OBJECTS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Tag</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TAG_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TAG___COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TAG___BASIC_COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TAG___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TAG___ENCODE__STRING = REFERABLE_BASE_OBJECT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Tag</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TAG_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ClassifierImpl <em>Classifier</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ClassifierImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getClassifier()
	 * @generated
	 */
	int CLASSIFIER = 11;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER__DESCRIPTION = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Classifier</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER___COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER___BASIC_COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER___ENCODE__STRING = REFERABLE_BASE_OBJECT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Classifier</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.CoreClassifierImpl <em>Core Classifier</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.CoreClassifierImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getCoreClassifier()
	 * @generated
	 */
	int CORE_CLASSIFIER = 12;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_CLASSIFIER__CUSTOM_PROPERTIES = CLASSIFIER__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_CLASSIFIER__NAME = CLASSIFIER__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_CLASSIFIER__UNIQUE_NAME = CLASSIFIER__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_CLASSIFIER__DESCRIPTION = CLASSIFIER__DESCRIPTION;

	/**
	 * The number of structural features of the '<em>Core Classifier</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_CLASSIFIER_FEATURE_COUNT = CLASSIFIER_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_CLASSIFIER___COMPUTE_UNIQUE_NAME = CLASSIFIER___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_CLASSIFIER___BASIC_COMPUTE_UNIQUE_NAME = CLASSIFIER___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_CLASSIFIER___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = CLASSIFIER___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_CLASSIFIER___ENCODE__STRING = CLASSIFIER___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Core Classifier</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_CLASSIFIER_OPERATION_COUNT = CLASSIFIER_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.MemoryClassifierImpl <em>Memory Classifier</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.MemoryClassifierImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getMemoryClassifier()
	 * @generated
	 */
	int MEMORY_CLASSIFIER = 13;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_CLASSIFIER__CUSTOM_PROPERTIES = CLASSIFIER__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_CLASSIFIER__NAME = CLASSIFIER__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_CLASSIFIER__UNIQUE_NAME = CLASSIFIER__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_CLASSIFIER__DESCRIPTION = CLASSIFIER__DESCRIPTION;

	/**
	 * The number of structural features of the '<em>Memory Classifier</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_CLASSIFIER_FEATURE_COUNT = CLASSIFIER_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_CLASSIFIER___COMPUTE_UNIQUE_NAME = CLASSIFIER___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_CLASSIFIER___BASIC_COMPUTE_UNIQUE_NAME = CLASSIFIER___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_CLASSIFIER___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = CLASSIFIER___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_CLASSIFIER___ENCODE__STRING = CLASSIFIER___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Memory Classifier</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_CLASSIFIER_OPERATION_COUNT = CLASSIFIER_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TransmissionPolicyImpl <em>Transmission Policy</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TransmissionPolicyImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTransmissionPolicy()
	 * @generated
	 */
	int TRANSMISSION_POLICY = 14;

	/**
	 * The feature id for the '<em><b>Chunk Size</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSMISSION_POLICY__CHUNK_SIZE = 0;

	/**
	 * The feature id for the '<em><b>Chunk Processing Ticks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSMISSION_POLICY__CHUNK_PROCESSING_TICKS = 1;

	/**
	 * The feature id for the '<em><b>Transmit Ratio</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSMISSION_POLICY__TRANSMIT_RATIO = 2;

	/**
	 * The number of structural features of the '<em>Transmission Policy</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSMISSION_POLICY_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Transmission Policy</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSMISSION_POLICY_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.QuantityImpl <em>Quantity</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.QuantityImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getQuantity()
	 * @generated
	 */
	int QUANTITY = 15;

	/**
	 * The number of structural features of the '<em>Quantity</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUANTITY_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Quantity</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUANTITY_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link java.lang.Comparable <em>Time Comparable</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see java.lang.Comparable
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTimeComparable()
	 * @generated
	 */
	int TIME_COMPARABLE = 16;

	/**
	 * The number of structural features of the '<em>Time Comparable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_COMPARABLE_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Time Comparable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_COMPARABLE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TimeImpl <em>Time</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TimeImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTime()
	 * @generated
	 */
	int TIME = 17;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME__VALUE = QUANTITY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Unit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME__UNIT = QUANTITY_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Time</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_FEATURE_COUNT = QUANTITY_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>To String</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME___TO_STRING = QUANTITY_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Compare To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME___COMPARE_TO__TIME = QUANTITY_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Adjust Unit</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME___ADJUST_UNIT = QUANTITY_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME___ADD__TIME = QUANTITY_OPERATION_COUNT + 3;

	/**
	 * The operation id for the '<em>Subtract</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME___SUBTRACT__TIME = QUANTITY_OPERATION_COUNT + 4;

	/**
	 * The operation id for the '<em>Multiply</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME___MULTIPLY__LONG = QUANTITY_OPERATION_COUNT + 5;

	/**
	 * The operation id for the '<em>Multiply</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME___MULTIPLY__DOUBLE = QUANTITY_OPERATION_COUNT + 6;

	/**
	 * The operation id for the '<em>Divide</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME___DIVIDE__TIME = QUANTITY_OPERATION_COUNT + 7;

	/**
	 * The number of operations of the '<em>Time</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_OPERATION_COUNT = QUANTITY_OPERATION_COUNT + 8;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.FrequencyImpl <em>Frequency</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.FrequencyImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getFrequency()
	 * @generated
	 */
	int FREQUENCY = 18;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY__VALUE = QUANTITY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Unit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY__UNIT = QUANTITY_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Frequency</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY_FEATURE_COUNT = QUANTITY_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>To String</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY___TO_STRING = QUANTITY_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Frequency</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY_OPERATION_COUNT = QUANTITY_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.VoltageImpl <em>Voltage</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.VoltageImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getVoltage()
	 * @generated
	 */
	int VOLTAGE = 19;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VOLTAGE__VALUE = QUANTITY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Unit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VOLTAGE__UNIT = QUANTITY_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Voltage</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VOLTAGE_FEATURE_COUNT = QUANTITY_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>To String</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VOLTAGE___TO_STRING = QUANTITY_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Voltage</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VOLTAGE_OPERATION_COUNT = QUANTITY_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DataSizeImpl <em>Data Size</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DataSizeImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDataSize()
	 * @generated
	 */
	int DATA_SIZE = 20;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SIZE__VALUE = QUANTITY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Unit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SIZE__UNIT = QUANTITY_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Data Size</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SIZE_FEATURE_COUNT = QUANTITY_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>To String</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SIZE___TO_STRING = QUANTITY_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Number Bits</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SIZE___GET_NUMBER_BITS = QUANTITY_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Number Bytes</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SIZE___GET_NUMBER_BYTES = QUANTITY_OPERATION_COUNT + 2;

	/**
	 * The number of operations of the '<em>Data Size</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SIZE_OPERATION_COUNT = QUANTITY_OPERATION_COUNT + 3;

	/**
	 * The meta object id for the '{@link java.lang.Comparable <em>Data Rate Comparable</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see java.lang.Comparable
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDataRateComparable()
	 * @generated
	 */
	int DATA_RATE_COMPARABLE = 21;

	/**
	 * The number of structural features of the '<em>Data Rate Comparable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_RATE_COMPARABLE_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Data Rate Comparable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_RATE_COMPARABLE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DataRateImpl <em>Data Rate</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DataRateImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDataRate()
	 * @generated
	 */
	int DATA_RATE = 22;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_RATE__VALUE = QUANTITY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Unit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_RATE__UNIT = QUANTITY_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Data Rate</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_RATE_FEATURE_COUNT = QUANTITY_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>To String</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_RATE___TO_STRING = QUANTITY_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Compare To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_RATE___COMPARE_TO__DATARATE = QUANTITY_OPERATION_COUNT + 1;

	/**
	 * The number of operations of the '<em>Data Rate</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_RATE_OPERATION_COUNT = QUANTITY_OPERATION_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.CustomPropertyImpl <em>Custom Property</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.CustomPropertyImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getCustomProperty()
	 * @generated
	 */
	int CUSTOM_PROPERTY = 23;

	/**
	 * The feature id for the '<em><b>Key</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_PROPERTY__KEY = 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_PROPERTY__VALUE = 1;

	/**
	 * The number of structural features of the '<em>Custom Property</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_PROPERTY_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Custom Property</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_PROPERTY_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ValueImpl <em>Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ValueImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getValue()
	 * @generated
	 */
	int VALUE = 24;

	/**
	 * The number of structural features of the '<em>Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VALUE_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VALUE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ListObjectImpl <em>List Object</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ListObjectImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getListObject()
	 * @generated
	 */
	int LIST_OBJECT = 25;

	/**
	 * The feature id for the '<em><b>Values</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIST_OBJECT__VALUES = VALUE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>List Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIST_OBJECT_FEATURE_COUNT = VALUE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>List Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIST_OBJECT_OPERATION_COUNT = VALUE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.StringObjectImpl <em>String Object</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.StringObjectImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getStringObject()
	 * @generated
	 */
	int STRING_OBJECT = 26;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_OBJECT__VALUE = VALUE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>String Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_OBJECT_FEATURE_COUNT = VALUE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>String Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_OBJECT_OPERATION_COUNT = VALUE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.BigIntegerObjectImpl <em>Big Integer Object</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.BigIntegerObjectImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getBigIntegerObject()
	 * @generated
	 */
	int BIG_INTEGER_OBJECT = 27;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BIG_INTEGER_OBJECT__VALUE = VALUE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Big Integer Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BIG_INTEGER_OBJECT_FEATURE_COUNT = VALUE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Big Integer Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BIG_INTEGER_OBJECT_OPERATION_COUNT = VALUE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ReferenceObjectImpl <em>Reference Object</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ReferenceObjectImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getReferenceObject()
	 * @generated
	 */
	int REFERENCE_OBJECT = 28;

	/**
	 * The feature id for the '<em><b>Value</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_OBJECT__VALUE = VALUE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Reference Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_OBJECT_FEATURE_COUNT = VALUE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Reference Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_OBJECT_OPERATION_COUNT = VALUE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.IntegerObjectImpl <em>Integer Object</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.IntegerObjectImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getIntegerObject()
	 * @generated
	 */
	int INTEGER_OBJECT = 29;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTEGER_OBJECT__VALUE = VALUE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Integer Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTEGER_OBJECT_FEATURE_COUNT = VALUE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Integer Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTEGER_OBJECT_OPERATION_COUNT = VALUE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.LongObjectImpl <em>Long Object</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.LongObjectImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getLongObject()
	 * @generated
	 */
	int LONG_OBJECT = 30;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LONG_OBJECT__VALUE = VALUE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Long Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LONG_OBJECT_FEATURE_COUNT = VALUE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Long Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LONG_OBJECT_OPERATION_COUNT = VALUE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.FloatObjectImpl <em>Float Object</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.FloatObjectImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getFloatObject()
	 * @generated
	 */
	int FLOAT_OBJECT = 31;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FLOAT_OBJECT__VALUE = VALUE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Float Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FLOAT_OBJECT_FEATURE_COUNT = VALUE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Float Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FLOAT_OBJECT_OPERATION_COUNT = VALUE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DoubleObjectImpl <em>Double Object</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DoubleObjectImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDoubleObject()
	 * @generated
	 */
	int DOUBLE_OBJECT = 32;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOUBLE_OBJECT__VALUE = VALUE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Double Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOUBLE_OBJECT_FEATURE_COUNT = VALUE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Double Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOUBLE_OBJECT_OPERATION_COUNT = VALUE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.BooleanObjectImpl <em>Boolean Object</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.BooleanObjectImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getBooleanObject()
	 * @generated
	 */
	int BOOLEAN_OBJECT = 33;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_OBJECT__VALUE = VALUE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Boolean Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_OBJECT_FEATURE_COUNT = VALUE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Boolean Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_OBJECT_OPERATION_COUNT = VALUE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.NumericStatistic <em>Numeric Statistic</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.NumericStatistic
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getNumericStatistic()
	 * @generated
	 */
	int NUMERIC_STATISTIC = 34;

	/**
	 * The number of structural features of the '<em>Numeric Statistic</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_STATISTIC_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Numeric Statistic</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_STATISTIC_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.MinAvgMaxStatisticImpl <em>Min Avg Max Statistic</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.MinAvgMaxStatisticImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getMinAvgMaxStatistic()
	 * @generated
	 */
	int MIN_AVG_MAX_STATISTIC = 35;

	/**
	 * The feature id for the '<em><b>Min</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIN_AVG_MAX_STATISTIC__MIN = NUMERIC_STATISTIC_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Avg</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIN_AVG_MAX_STATISTIC__AVG = NUMERIC_STATISTIC_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Max</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIN_AVG_MAX_STATISTIC__MAX = NUMERIC_STATISTIC_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Min Avg Max Statistic</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIN_AVG_MAX_STATISTIC_FEATURE_COUNT = NUMERIC_STATISTIC_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Min Avg Max Statistic</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIN_AVG_MAX_STATISTIC_OPERATION_COUNT = NUMERIC_STATISTIC_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.SingleValueStatisticImpl <em>Single Value Statistic</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.SingleValueStatisticImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSingleValueStatistic()
	 * @generated
	 */
	int SINGLE_VALUE_STATISTIC = 36;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_VALUE_STATISTIC__VALUE = NUMERIC_STATISTIC_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Single Value Statistic</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_VALUE_STATISTIC_FEATURE_COUNT = NUMERIC_STATISTIC_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Single Value Statistic</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_VALUE_STATISTIC_OPERATION_COUNT = NUMERIC_STATISTIC_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.ITimeDeviation <em>ITime Deviation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.ITimeDeviation
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getITimeDeviation()
	 * @generated
	 */
	int ITIME_DEVIATION = 37;

	/**
	 * The number of structural features of the '<em>ITime Deviation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITIME_DEVIATION_FEATURE_COUNT = 0;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITIME_DEVIATION___GET_LOWER_BOUND = 0;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITIME_DEVIATION___GET_UPPER_BOUND = 1;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITIME_DEVIATION___GET_AVERAGE = 2;

	/**
	 * The number of operations of the '<em>ITime Deviation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITIME_DEVIATION_OPERATION_COUNT = 3;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TimeIntervalImpl <em>Time Interval</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TimeIntervalImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTimeInterval()
	 * @generated
	 */
	int TIME_INTERVAL = 38;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_INTERVAL__LOWER_BOUND = 0;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_INTERVAL__UPPER_BOUND = 1;

	/**
	 * The number of structural features of the '<em>Time Interval</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_INTERVAL_FEATURE_COUNT = 2;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_INTERVAL___GET_AVERAGE = 0;

	/**
	 * The number of operations of the '<em>Time Interval</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_INTERVAL_OPERATION_COUNT = 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TimeConstantImpl <em>Time Constant</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TimeConstantImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTimeConstant()
	 * @generated
	 */
	int TIME_CONSTANT = 39;

	/**
	 * The feature id for the '<em><b>Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CONSTANT__VALUE = ITIME_DEVIATION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Time Constant</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CONSTANT_FEATURE_COUNT = ITIME_DEVIATION_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CONSTANT___GET_LOWER_BOUND = ITIME_DEVIATION_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CONSTANT___GET_UPPER_BOUND = ITIME_DEVIATION_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CONSTANT___GET_AVERAGE = ITIME_DEVIATION_OPERATION_COUNT + 2;

	/**
	 * The number of operations of the '<em>Time Constant</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CONSTANT_OPERATION_COUNT = ITIME_DEVIATION_OPERATION_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TimeHistogramImpl <em>Time Histogram</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TimeHistogramImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTimeHistogram()
	 * @generated
	 */
	int TIME_HISTOGRAM = 40;

	/**
	 * The feature id for the '<em><b>Entries</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_HISTOGRAM__ENTRIES = ITIME_DEVIATION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Time Histogram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_HISTOGRAM_FEATURE_COUNT = ITIME_DEVIATION_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_HISTOGRAM___GET_LOWER_BOUND = ITIME_DEVIATION_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_HISTOGRAM___GET_UPPER_BOUND = ITIME_DEVIATION_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_HISTOGRAM___GET_AVERAGE = ITIME_DEVIATION_OPERATION_COUNT + 2;

	/**
	 * The number of operations of the '<em>Time Histogram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_HISTOGRAM_OPERATION_COUNT = ITIME_DEVIATION_OPERATION_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TimeHistogramEntryImpl <em>Time Histogram Entry</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TimeHistogramEntryImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTimeHistogramEntry()
	 * @generated
	 */
	int TIME_HISTOGRAM_ENTRY = 41;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_HISTOGRAM_ENTRY__LOWER_BOUND = TIME_INTERVAL__LOWER_BOUND;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_HISTOGRAM_ENTRY__UPPER_BOUND = TIME_INTERVAL__UPPER_BOUND;

	/**
	 * The feature id for the '<em><b>Occurrences</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_HISTOGRAM_ENTRY__OCCURRENCES = TIME_INTERVAL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Time Histogram Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_HISTOGRAM_ENTRY_FEATURE_COUNT = TIME_INTERVAL_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_HISTOGRAM_ENTRY___GET_AVERAGE = TIME_INTERVAL___GET_AVERAGE;

	/**
	 * The number of operations of the '<em>Time Histogram Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_HISTOGRAM_ENTRY_OPERATION_COUNT = TIME_INTERVAL_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.BoundedTimeDistributionImpl <em>Bounded Time Distribution</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.BoundedTimeDistributionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getBoundedTimeDistribution()
	 * @generated
	 */
	int BOUNDED_TIME_DISTRIBUTION = 42;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_TIME_DISTRIBUTION__LOWER_BOUND = TIME_INTERVAL__LOWER_BOUND;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_TIME_DISTRIBUTION__UPPER_BOUND = TIME_INTERVAL__UPPER_BOUND;

	/**
	 * The number of structural features of the '<em>Bounded Time Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_TIME_DISTRIBUTION_FEATURE_COUNT = TIME_INTERVAL_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_TIME_DISTRIBUTION___GET_LOWER_BOUND = TIME_INTERVAL_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_TIME_DISTRIBUTION___GET_UPPER_BOUND = TIME_INTERVAL_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_TIME_DISTRIBUTION___GET_AVERAGE = TIME_INTERVAL_OPERATION_COUNT + 2;

	/**
	 * The number of operations of the '<em>Bounded Time Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_TIME_DISTRIBUTION_OPERATION_COUNT = TIME_INTERVAL_OPERATION_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TruncatedTimeDistributionImpl <em>Truncated Time Distribution</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TruncatedTimeDistributionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTruncatedTimeDistribution()
	 * @generated
	 */
	int TRUNCATED_TIME_DISTRIBUTION = 43;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUNCATED_TIME_DISTRIBUTION__LOWER_BOUND = ITIME_DEVIATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUNCATED_TIME_DISTRIBUTION__UPPER_BOUND = ITIME_DEVIATION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Truncated Time Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUNCATED_TIME_DISTRIBUTION_FEATURE_COUNT = ITIME_DEVIATION_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUNCATED_TIME_DISTRIBUTION___GET_LOWER_BOUND = ITIME_DEVIATION___GET_LOWER_BOUND;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUNCATED_TIME_DISTRIBUTION___GET_UPPER_BOUND = ITIME_DEVIATION___GET_UPPER_BOUND;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUNCATED_TIME_DISTRIBUTION___GET_AVERAGE = ITIME_DEVIATION___GET_AVERAGE;

	/**
	 * The number of operations of the '<em>Truncated Time Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUNCATED_TIME_DISTRIBUTION_OPERATION_COUNT = ITIME_DEVIATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TimeBoundariesImpl <em>Time Boundaries</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TimeBoundariesImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTimeBoundaries()
	 * @generated
	 */
	int TIME_BOUNDARIES = 44;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BOUNDARIES__LOWER_BOUND = BOUNDED_TIME_DISTRIBUTION__LOWER_BOUND;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BOUNDARIES__UPPER_BOUND = BOUNDED_TIME_DISTRIBUTION__UPPER_BOUND;

	/**
	 * The feature id for the '<em><b>Sampling Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BOUNDARIES__SAMPLING_TYPE = BOUNDED_TIME_DISTRIBUTION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Time Boundaries</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BOUNDARIES_FEATURE_COUNT = BOUNDED_TIME_DISTRIBUTION_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BOUNDARIES___GET_LOWER_BOUND = BOUNDED_TIME_DISTRIBUTION___GET_LOWER_BOUND;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BOUNDARIES___GET_UPPER_BOUND = BOUNDED_TIME_DISTRIBUTION___GET_UPPER_BOUND;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BOUNDARIES___GET_AVERAGE = BOUNDED_TIME_DISTRIBUTION___GET_AVERAGE;

	/**
	 * The number of operations of the '<em>Time Boundaries</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BOUNDARIES_OPERATION_COUNT = BOUNDED_TIME_DISTRIBUTION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TimeStatisticsImpl <em>Time Statistics</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TimeStatisticsImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTimeStatistics()
	 * @generated
	 */
	int TIME_STATISTICS = 45;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_STATISTICS__LOWER_BOUND = BOUNDED_TIME_DISTRIBUTION__LOWER_BOUND;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_STATISTICS__UPPER_BOUND = BOUNDED_TIME_DISTRIBUTION__UPPER_BOUND;

	/**
	 * The feature id for the '<em><b>Average</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_STATISTICS__AVERAGE = BOUNDED_TIME_DISTRIBUTION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Time Statistics</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_STATISTICS_FEATURE_COUNT = BOUNDED_TIME_DISTRIBUTION_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_STATISTICS___GET_LOWER_BOUND = BOUNDED_TIME_DISTRIBUTION___GET_LOWER_BOUND;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_STATISTICS___GET_UPPER_BOUND = BOUNDED_TIME_DISTRIBUTION___GET_UPPER_BOUND;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_STATISTICS___GET_AVERAGE = BOUNDED_TIME_DISTRIBUTION___GET_AVERAGE;

	/**
	 * The number of operations of the '<em>Time Statistics</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_STATISTICS_OPERATION_COUNT = BOUNDED_TIME_DISTRIBUTION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TimeUniformDistributionImpl <em>Time Uniform Distribution</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TimeUniformDistributionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTimeUniformDistribution()
	 * @generated
	 */
	int TIME_UNIFORM_DISTRIBUTION = 46;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_UNIFORM_DISTRIBUTION__LOWER_BOUND = BOUNDED_TIME_DISTRIBUTION__LOWER_BOUND;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_UNIFORM_DISTRIBUTION__UPPER_BOUND = BOUNDED_TIME_DISTRIBUTION__UPPER_BOUND;

	/**
	 * The number of structural features of the '<em>Time Uniform Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_UNIFORM_DISTRIBUTION_FEATURE_COUNT = BOUNDED_TIME_DISTRIBUTION_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_UNIFORM_DISTRIBUTION___GET_LOWER_BOUND = BOUNDED_TIME_DISTRIBUTION___GET_LOWER_BOUND;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_UNIFORM_DISTRIBUTION___GET_UPPER_BOUND = BOUNDED_TIME_DISTRIBUTION___GET_UPPER_BOUND;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_UNIFORM_DISTRIBUTION___GET_AVERAGE = BOUNDED_TIME_DISTRIBUTION___GET_AVERAGE;

	/**
	 * The number of operations of the '<em>Time Uniform Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_UNIFORM_DISTRIBUTION_OPERATION_COUNT = BOUNDED_TIME_DISTRIBUTION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TimeGaussDistributionImpl <em>Time Gauss Distribution</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TimeGaussDistributionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTimeGaussDistribution()
	 * @generated
	 */
	int TIME_GAUSS_DISTRIBUTION = 47;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_GAUSS_DISTRIBUTION__LOWER_BOUND = TRUNCATED_TIME_DISTRIBUTION__LOWER_BOUND;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_GAUSS_DISTRIBUTION__UPPER_BOUND = TRUNCATED_TIME_DISTRIBUTION__UPPER_BOUND;

	/**
	 * The feature id for the '<em><b>Mean</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_GAUSS_DISTRIBUTION__MEAN = TRUNCATED_TIME_DISTRIBUTION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Sd</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_GAUSS_DISTRIBUTION__SD = TRUNCATED_TIME_DISTRIBUTION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Time Gauss Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_GAUSS_DISTRIBUTION_FEATURE_COUNT = TRUNCATED_TIME_DISTRIBUTION_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_GAUSS_DISTRIBUTION___GET_LOWER_BOUND = TRUNCATED_TIME_DISTRIBUTION___GET_LOWER_BOUND;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_GAUSS_DISTRIBUTION___GET_UPPER_BOUND = TRUNCATED_TIME_DISTRIBUTION___GET_UPPER_BOUND;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_GAUSS_DISTRIBUTION___GET_AVERAGE = TRUNCATED_TIME_DISTRIBUTION_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Time Gauss Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_GAUSS_DISTRIBUTION_OPERATION_COUNT = TRUNCATED_TIME_DISTRIBUTION_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TimeWeibullEstimatorsDistributionImpl <em>Time Weibull Estimators Distribution</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TimeWeibullEstimatorsDistributionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTimeWeibullEstimatorsDistribution()
	 * @generated
	 */
	int TIME_WEIBULL_ESTIMATORS_DISTRIBUTION = 48;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_WEIBULL_ESTIMATORS_DISTRIBUTION__LOWER_BOUND = BOUNDED_TIME_DISTRIBUTION__LOWER_BOUND;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_WEIBULL_ESTIMATORS_DISTRIBUTION__UPPER_BOUND = BOUNDED_TIME_DISTRIBUTION__UPPER_BOUND;

	/**
	 * The feature id for the '<em><b>Average</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_WEIBULL_ESTIMATORS_DISTRIBUTION__AVERAGE = BOUNDED_TIME_DISTRIBUTION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>PRemain Promille</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_WEIBULL_ESTIMATORS_DISTRIBUTION__PREMAIN_PROMILLE = BOUNDED_TIME_DISTRIBUTION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Time Weibull Estimators Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_WEIBULL_ESTIMATORS_DISTRIBUTION_FEATURE_COUNT = BOUNDED_TIME_DISTRIBUTION_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_WEIBULL_ESTIMATORS_DISTRIBUTION___GET_LOWER_BOUND = BOUNDED_TIME_DISTRIBUTION___GET_LOWER_BOUND;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_WEIBULL_ESTIMATORS_DISTRIBUTION___GET_UPPER_BOUND = BOUNDED_TIME_DISTRIBUTION___GET_UPPER_BOUND;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_WEIBULL_ESTIMATORS_DISTRIBUTION___GET_AVERAGE = BOUNDED_TIME_DISTRIBUTION___GET_AVERAGE;

	/**
	 * The number of operations of the '<em>Time Weibull Estimators Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_WEIBULL_ESTIMATORS_DISTRIBUTION_OPERATION_COUNT = BOUNDED_TIME_DISTRIBUTION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TimeBetaDistributionImpl <em>Time Beta Distribution</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TimeBetaDistributionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTimeBetaDistribution()
	 * @generated
	 */
	int TIME_BETA_DISTRIBUTION = 49;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BETA_DISTRIBUTION__LOWER_BOUND = BOUNDED_TIME_DISTRIBUTION__LOWER_BOUND;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BETA_DISTRIBUTION__UPPER_BOUND = BOUNDED_TIME_DISTRIBUTION__UPPER_BOUND;

	/**
	 * The feature id for the '<em><b>Alpha</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BETA_DISTRIBUTION__ALPHA = BOUNDED_TIME_DISTRIBUTION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Beta</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BETA_DISTRIBUTION__BETA = BOUNDED_TIME_DISTRIBUTION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Time Beta Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BETA_DISTRIBUTION_FEATURE_COUNT = BOUNDED_TIME_DISTRIBUTION_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BETA_DISTRIBUTION___GET_LOWER_BOUND = BOUNDED_TIME_DISTRIBUTION___GET_LOWER_BOUND;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BETA_DISTRIBUTION___GET_UPPER_BOUND = BOUNDED_TIME_DISTRIBUTION___GET_UPPER_BOUND;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BETA_DISTRIBUTION___GET_AVERAGE = BOUNDED_TIME_DISTRIBUTION_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Time Beta Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BETA_DISTRIBUTION_OPERATION_COUNT = BOUNDED_TIME_DISTRIBUTION_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.IDiscreteValueDeviation <em>IDiscrete Value Deviation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.IDiscreteValueDeviation
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getIDiscreteValueDeviation()
	 * @generated
	 */
	int IDISCRETE_VALUE_DEVIATION = 50;

	/**
	 * The number of structural features of the '<em>IDiscrete Value Deviation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDISCRETE_VALUE_DEVIATION_FEATURE_COUNT = 0;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDISCRETE_VALUE_DEVIATION___GET_LOWER_BOUND = 0;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDISCRETE_VALUE_DEVIATION___GET_UPPER_BOUND = 1;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDISCRETE_VALUE_DEVIATION___GET_AVERAGE = 2;

	/**
	 * The number of operations of the '<em>IDiscrete Value Deviation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDISCRETE_VALUE_DEVIATION_OPERATION_COUNT = 3;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DiscreteValueIntervalImpl <em>Discrete Value Interval</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DiscreteValueIntervalImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDiscreteValueInterval()
	 * @generated
	 */
	int DISCRETE_VALUE_INTERVAL = 51;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_INTERVAL__LOWER_BOUND = 0;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_INTERVAL__UPPER_BOUND = 1;

	/**
	 * The number of structural features of the '<em>Discrete Value Interval</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_INTERVAL_FEATURE_COUNT = 2;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_INTERVAL___GET_AVERAGE = 0;

	/**
	 * The number of operations of the '<em>Discrete Value Interval</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_INTERVAL_OPERATION_COUNT = 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DiscreteValueConstantImpl <em>Discrete Value Constant</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DiscreteValueConstantImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDiscreteValueConstant()
	 * @generated
	 */
	int DISCRETE_VALUE_CONSTANT = 52;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_CONSTANT__VALUE = IDISCRETE_VALUE_DEVIATION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Discrete Value Constant</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_CONSTANT_FEATURE_COUNT = IDISCRETE_VALUE_DEVIATION_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_CONSTANT___GET_LOWER_BOUND = IDISCRETE_VALUE_DEVIATION_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_CONSTANT___GET_UPPER_BOUND = IDISCRETE_VALUE_DEVIATION_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_CONSTANT___GET_AVERAGE = IDISCRETE_VALUE_DEVIATION_OPERATION_COUNT + 2;

	/**
	 * The number of operations of the '<em>Discrete Value Constant</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_CONSTANT_OPERATION_COUNT = IDISCRETE_VALUE_DEVIATION_OPERATION_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DiscreteValueHistogramImpl <em>Discrete Value Histogram</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DiscreteValueHistogramImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDiscreteValueHistogram()
	 * @generated
	 */
	int DISCRETE_VALUE_HISTOGRAM = 53;

	/**
	 * The feature id for the '<em><b>Entries</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_HISTOGRAM__ENTRIES = IDISCRETE_VALUE_DEVIATION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Discrete Value Histogram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_HISTOGRAM_FEATURE_COUNT = IDISCRETE_VALUE_DEVIATION_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_HISTOGRAM___GET_LOWER_BOUND = IDISCRETE_VALUE_DEVIATION_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_HISTOGRAM___GET_UPPER_BOUND = IDISCRETE_VALUE_DEVIATION_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_HISTOGRAM___GET_AVERAGE = IDISCRETE_VALUE_DEVIATION_OPERATION_COUNT + 2;

	/**
	 * The number of operations of the '<em>Discrete Value Histogram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_HISTOGRAM_OPERATION_COUNT = IDISCRETE_VALUE_DEVIATION_OPERATION_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DiscreteValueHistogramEntryImpl <em>Discrete Value Histogram Entry</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DiscreteValueHistogramEntryImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDiscreteValueHistogramEntry()
	 * @generated
	 */
	int DISCRETE_VALUE_HISTOGRAM_ENTRY = 54;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_HISTOGRAM_ENTRY__LOWER_BOUND = DISCRETE_VALUE_INTERVAL__LOWER_BOUND;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_HISTOGRAM_ENTRY__UPPER_BOUND = DISCRETE_VALUE_INTERVAL__UPPER_BOUND;

	/**
	 * The feature id for the '<em><b>Occurrences</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_HISTOGRAM_ENTRY__OCCURRENCES = DISCRETE_VALUE_INTERVAL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Discrete Value Histogram Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_HISTOGRAM_ENTRY_FEATURE_COUNT = DISCRETE_VALUE_INTERVAL_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_HISTOGRAM_ENTRY___GET_AVERAGE = DISCRETE_VALUE_INTERVAL___GET_AVERAGE;

	/**
	 * The number of operations of the '<em>Discrete Value Histogram Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_HISTOGRAM_ENTRY_OPERATION_COUNT = DISCRETE_VALUE_INTERVAL_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.BoundedDiscreteValueDistributionImpl <em>Bounded Discrete Value Distribution</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.BoundedDiscreteValueDistributionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getBoundedDiscreteValueDistribution()
	 * @generated
	 */
	int BOUNDED_DISCRETE_VALUE_DISTRIBUTION = 55;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_DISCRETE_VALUE_DISTRIBUTION__LOWER_BOUND = DISCRETE_VALUE_INTERVAL__LOWER_BOUND;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_DISCRETE_VALUE_DISTRIBUTION__UPPER_BOUND = DISCRETE_VALUE_INTERVAL__UPPER_BOUND;

	/**
	 * The number of structural features of the '<em>Bounded Discrete Value Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_DISCRETE_VALUE_DISTRIBUTION_FEATURE_COUNT = DISCRETE_VALUE_INTERVAL_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_DISCRETE_VALUE_DISTRIBUTION___GET_LOWER_BOUND = DISCRETE_VALUE_INTERVAL_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_DISCRETE_VALUE_DISTRIBUTION___GET_UPPER_BOUND = DISCRETE_VALUE_INTERVAL_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_DISCRETE_VALUE_DISTRIBUTION___GET_AVERAGE = DISCRETE_VALUE_INTERVAL_OPERATION_COUNT + 2;

	/**
	 * The number of operations of the '<em>Bounded Discrete Value Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_DISCRETE_VALUE_DISTRIBUTION_OPERATION_COUNT = DISCRETE_VALUE_INTERVAL_OPERATION_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TruncatedDiscreteValueDistributionImpl <em>Truncated Discrete Value Distribution</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TruncatedDiscreteValueDistributionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTruncatedDiscreteValueDistribution()
	 * @generated
	 */
	int TRUNCATED_DISCRETE_VALUE_DISTRIBUTION = 56;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUNCATED_DISCRETE_VALUE_DISTRIBUTION__LOWER_BOUND = IDISCRETE_VALUE_DEVIATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUNCATED_DISCRETE_VALUE_DISTRIBUTION__UPPER_BOUND = IDISCRETE_VALUE_DEVIATION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Truncated Discrete Value Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUNCATED_DISCRETE_VALUE_DISTRIBUTION_FEATURE_COUNT = IDISCRETE_VALUE_DEVIATION_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUNCATED_DISCRETE_VALUE_DISTRIBUTION___GET_LOWER_BOUND = IDISCRETE_VALUE_DEVIATION___GET_LOWER_BOUND;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUNCATED_DISCRETE_VALUE_DISTRIBUTION___GET_UPPER_BOUND = IDISCRETE_VALUE_DEVIATION___GET_UPPER_BOUND;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUNCATED_DISCRETE_VALUE_DISTRIBUTION___GET_AVERAGE = IDISCRETE_VALUE_DEVIATION___GET_AVERAGE;

	/**
	 * The number of operations of the '<em>Truncated Discrete Value Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUNCATED_DISCRETE_VALUE_DISTRIBUTION_OPERATION_COUNT = IDISCRETE_VALUE_DEVIATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DiscreteValueBoundariesImpl <em>Discrete Value Boundaries</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DiscreteValueBoundariesImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDiscreteValueBoundaries()
	 * @generated
	 */
	int DISCRETE_VALUE_BOUNDARIES = 57;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_BOUNDARIES__LOWER_BOUND = BOUNDED_DISCRETE_VALUE_DISTRIBUTION__LOWER_BOUND;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_BOUNDARIES__UPPER_BOUND = BOUNDED_DISCRETE_VALUE_DISTRIBUTION__UPPER_BOUND;

	/**
	 * The feature id for the '<em><b>Sampling Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_BOUNDARIES__SAMPLING_TYPE = BOUNDED_DISCRETE_VALUE_DISTRIBUTION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Discrete Value Boundaries</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_BOUNDARIES_FEATURE_COUNT = BOUNDED_DISCRETE_VALUE_DISTRIBUTION_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_BOUNDARIES___GET_LOWER_BOUND = BOUNDED_DISCRETE_VALUE_DISTRIBUTION___GET_LOWER_BOUND;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_BOUNDARIES___GET_UPPER_BOUND = BOUNDED_DISCRETE_VALUE_DISTRIBUTION___GET_UPPER_BOUND;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_BOUNDARIES___GET_AVERAGE = BOUNDED_DISCRETE_VALUE_DISTRIBUTION___GET_AVERAGE;

	/**
	 * The number of operations of the '<em>Discrete Value Boundaries</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_BOUNDARIES_OPERATION_COUNT = BOUNDED_DISCRETE_VALUE_DISTRIBUTION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DiscreteValueStatisticsImpl <em>Discrete Value Statistics</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DiscreteValueStatisticsImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDiscreteValueStatistics()
	 * @generated
	 */
	int DISCRETE_VALUE_STATISTICS = 58;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_STATISTICS__LOWER_BOUND = BOUNDED_DISCRETE_VALUE_DISTRIBUTION__LOWER_BOUND;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_STATISTICS__UPPER_BOUND = BOUNDED_DISCRETE_VALUE_DISTRIBUTION__UPPER_BOUND;

	/**
	 * The feature id for the '<em><b>Average</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_STATISTICS__AVERAGE = BOUNDED_DISCRETE_VALUE_DISTRIBUTION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Discrete Value Statistics</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_STATISTICS_FEATURE_COUNT = BOUNDED_DISCRETE_VALUE_DISTRIBUTION_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_STATISTICS___GET_LOWER_BOUND = BOUNDED_DISCRETE_VALUE_DISTRIBUTION___GET_LOWER_BOUND;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_STATISTICS___GET_UPPER_BOUND = BOUNDED_DISCRETE_VALUE_DISTRIBUTION___GET_UPPER_BOUND;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_STATISTICS___GET_AVERAGE = BOUNDED_DISCRETE_VALUE_DISTRIBUTION___GET_AVERAGE;

	/**
	 * The number of operations of the '<em>Discrete Value Statistics</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_STATISTICS_OPERATION_COUNT = BOUNDED_DISCRETE_VALUE_DISTRIBUTION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DiscreteValueUniformDistributionImpl <em>Discrete Value Uniform Distribution</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DiscreteValueUniformDistributionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDiscreteValueUniformDistribution()
	 * @generated
	 */
	int DISCRETE_VALUE_UNIFORM_DISTRIBUTION = 59;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_UNIFORM_DISTRIBUTION__LOWER_BOUND = BOUNDED_DISCRETE_VALUE_DISTRIBUTION__LOWER_BOUND;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_UNIFORM_DISTRIBUTION__UPPER_BOUND = BOUNDED_DISCRETE_VALUE_DISTRIBUTION__UPPER_BOUND;

	/**
	 * The number of structural features of the '<em>Discrete Value Uniform Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_UNIFORM_DISTRIBUTION_FEATURE_COUNT = BOUNDED_DISCRETE_VALUE_DISTRIBUTION_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_UNIFORM_DISTRIBUTION___GET_LOWER_BOUND = BOUNDED_DISCRETE_VALUE_DISTRIBUTION___GET_LOWER_BOUND;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_UNIFORM_DISTRIBUTION___GET_UPPER_BOUND = BOUNDED_DISCRETE_VALUE_DISTRIBUTION___GET_UPPER_BOUND;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_UNIFORM_DISTRIBUTION___GET_AVERAGE = BOUNDED_DISCRETE_VALUE_DISTRIBUTION___GET_AVERAGE;

	/**
	 * The number of operations of the '<em>Discrete Value Uniform Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_UNIFORM_DISTRIBUTION_OPERATION_COUNT = BOUNDED_DISCRETE_VALUE_DISTRIBUTION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DiscreteValueGaussDistributionImpl <em>Discrete Value Gauss Distribution</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DiscreteValueGaussDistributionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDiscreteValueGaussDistribution()
	 * @generated
	 */
	int DISCRETE_VALUE_GAUSS_DISTRIBUTION = 60;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_GAUSS_DISTRIBUTION__LOWER_BOUND = TRUNCATED_DISCRETE_VALUE_DISTRIBUTION__LOWER_BOUND;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_GAUSS_DISTRIBUTION__UPPER_BOUND = TRUNCATED_DISCRETE_VALUE_DISTRIBUTION__UPPER_BOUND;

	/**
	 * The feature id for the '<em><b>Mean</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_GAUSS_DISTRIBUTION__MEAN = TRUNCATED_DISCRETE_VALUE_DISTRIBUTION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Sd</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_GAUSS_DISTRIBUTION__SD = TRUNCATED_DISCRETE_VALUE_DISTRIBUTION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Discrete Value Gauss Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_GAUSS_DISTRIBUTION_FEATURE_COUNT = TRUNCATED_DISCRETE_VALUE_DISTRIBUTION_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_GAUSS_DISTRIBUTION___GET_LOWER_BOUND = TRUNCATED_DISCRETE_VALUE_DISTRIBUTION___GET_LOWER_BOUND;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_GAUSS_DISTRIBUTION___GET_UPPER_BOUND = TRUNCATED_DISCRETE_VALUE_DISTRIBUTION___GET_UPPER_BOUND;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_GAUSS_DISTRIBUTION___GET_AVERAGE = TRUNCATED_DISCRETE_VALUE_DISTRIBUTION_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Discrete Value Gauss Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_GAUSS_DISTRIBUTION_OPERATION_COUNT = TRUNCATED_DISCRETE_VALUE_DISTRIBUTION_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DiscreteValueWeibullEstimatorsDistributionImpl <em>Discrete Value Weibull Estimators Distribution</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DiscreteValueWeibullEstimatorsDistributionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDiscreteValueWeibullEstimatorsDistribution()
	 * @generated
	 */
	int DISCRETE_VALUE_WEIBULL_ESTIMATORS_DISTRIBUTION = 61;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_WEIBULL_ESTIMATORS_DISTRIBUTION__LOWER_BOUND = BOUNDED_DISCRETE_VALUE_DISTRIBUTION__LOWER_BOUND;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_WEIBULL_ESTIMATORS_DISTRIBUTION__UPPER_BOUND = BOUNDED_DISCRETE_VALUE_DISTRIBUTION__UPPER_BOUND;

	/**
	 * The feature id for the '<em><b>Average</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_WEIBULL_ESTIMATORS_DISTRIBUTION__AVERAGE = BOUNDED_DISCRETE_VALUE_DISTRIBUTION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>PRemain Promille</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_WEIBULL_ESTIMATORS_DISTRIBUTION__PREMAIN_PROMILLE = BOUNDED_DISCRETE_VALUE_DISTRIBUTION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Discrete Value Weibull Estimators Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_WEIBULL_ESTIMATORS_DISTRIBUTION_FEATURE_COUNT = BOUNDED_DISCRETE_VALUE_DISTRIBUTION_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_WEIBULL_ESTIMATORS_DISTRIBUTION___GET_LOWER_BOUND = BOUNDED_DISCRETE_VALUE_DISTRIBUTION___GET_LOWER_BOUND;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_WEIBULL_ESTIMATORS_DISTRIBUTION___GET_UPPER_BOUND = BOUNDED_DISCRETE_VALUE_DISTRIBUTION___GET_UPPER_BOUND;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_WEIBULL_ESTIMATORS_DISTRIBUTION___GET_AVERAGE = BOUNDED_DISCRETE_VALUE_DISTRIBUTION___GET_AVERAGE;

	/**
	 * The number of operations of the '<em>Discrete Value Weibull Estimators Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_WEIBULL_ESTIMATORS_DISTRIBUTION_OPERATION_COUNT = BOUNDED_DISCRETE_VALUE_DISTRIBUTION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DiscreteValueBetaDistributionImpl <em>Discrete Value Beta Distribution</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DiscreteValueBetaDistributionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDiscreteValueBetaDistribution()
	 * @generated
	 */
	int DISCRETE_VALUE_BETA_DISTRIBUTION = 62;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_BETA_DISTRIBUTION__LOWER_BOUND = BOUNDED_DISCRETE_VALUE_DISTRIBUTION__LOWER_BOUND;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_BETA_DISTRIBUTION__UPPER_BOUND = BOUNDED_DISCRETE_VALUE_DISTRIBUTION__UPPER_BOUND;

	/**
	 * The feature id for the '<em><b>Alpha</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_BETA_DISTRIBUTION__ALPHA = BOUNDED_DISCRETE_VALUE_DISTRIBUTION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Beta</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_BETA_DISTRIBUTION__BETA = BOUNDED_DISCRETE_VALUE_DISTRIBUTION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Discrete Value Beta Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_BETA_DISTRIBUTION_FEATURE_COUNT = BOUNDED_DISCRETE_VALUE_DISTRIBUTION_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_BETA_DISTRIBUTION___GET_LOWER_BOUND = BOUNDED_DISCRETE_VALUE_DISTRIBUTION___GET_LOWER_BOUND;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_BETA_DISTRIBUTION___GET_UPPER_BOUND = BOUNDED_DISCRETE_VALUE_DISTRIBUTION___GET_UPPER_BOUND;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_BETA_DISTRIBUTION___GET_AVERAGE = BOUNDED_DISCRETE_VALUE_DISTRIBUTION_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Discrete Value Beta Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_VALUE_BETA_DISTRIBUTION_OPERATION_COUNT = BOUNDED_DISCRETE_VALUE_DISTRIBUTION_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.IContinuousValueDeviation <em>IContinuous Value Deviation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.IContinuousValueDeviation
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getIContinuousValueDeviation()
	 * @generated
	 */
	int ICONTINUOUS_VALUE_DEVIATION = 63;

	/**
	 * The number of structural features of the '<em>IContinuous Value Deviation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONTINUOUS_VALUE_DEVIATION_FEATURE_COUNT = 0;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONTINUOUS_VALUE_DEVIATION___GET_LOWER_BOUND = 0;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONTINUOUS_VALUE_DEVIATION___GET_UPPER_BOUND = 1;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONTINUOUS_VALUE_DEVIATION___GET_AVERAGE = 2;

	/**
	 * The number of operations of the '<em>IContinuous Value Deviation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICONTINUOUS_VALUE_DEVIATION_OPERATION_COUNT = 3;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ContinuousValueIntervalImpl <em>Continuous Value Interval</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ContinuousValueIntervalImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getContinuousValueInterval()
	 * @generated
	 */
	int CONTINUOUS_VALUE_INTERVAL = 64;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_INTERVAL__LOWER_BOUND = 0;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_INTERVAL__UPPER_BOUND = 1;

	/**
	 * The number of structural features of the '<em>Continuous Value Interval</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_INTERVAL_FEATURE_COUNT = 2;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_INTERVAL___GET_AVERAGE = 0;

	/**
	 * The number of operations of the '<em>Continuous Value Interval</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_INTERVAL_OPERATION_COUNT = 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ContinuousValueConstantImpl <em>Continuous Value Constant</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ContinuousValueConstantImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getContinuousValueConstant()
	 * @generated
	 */
	int CONTINUOUS_VALUE_CONSTANT = 65;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_CONSTANT__VALUE = ICONTINUOUS_VALUE_DEVIATION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Continuous Value Constant</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_CONSTANT_FEATURE_COUNT = ICONTINUOUS_VALUE_DEVIATION_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_CONSTANT___GET_LOWER_BOUND = ICONTINUOUS_VALUE_DEVIATION_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_CONSTANT___GET_UPPER_BOUND = ICONTINUOUS_VALUE_DEVIATION_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_CONSTANT___GET_AVERAGE = ICONTINUOUS_VALUE_DEVIATION_OPERATION_COUNT + 2;

	/**
	 * The number of operations of the '<em>Continuous Value Constant</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_CONSTANT_OPERATION_COUNT = ICONTINUOUS_VALUE_DEVIATION_OPERATION_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ContinuousValueHistogramImpl <em>Continuous Value Histogram</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ContinuousValueHistogramImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getContinuousValueHistogram()
	 * @generated
	 */
	int CONTINUOUS_VALUE_HISTOGRAM = 66;

	/**
	 * The feature id for the '<em><b>Entries</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_HISTOGRAM__ENTRIES = ICONTINUOUS_VALUE_DEVIATION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Continuous Value Histogram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_HISTOGRAM_FEATURE_COUNT = ICONTINUOUS_VALUE_DEVIATION_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_HISTOGRAM___GET_LOWER_BOUND = ICONTINUOUS_VALUE_DEVIATION_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_HISTOGRAM___GET_UPPER_BOUND = ICONTINUOUS_VALUE_DEVIATION_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_HISTOGRAM___GET_AVERAGE = ICONTINUOUS_VALUE_DEVIATION_OPERATION_COUNT + 2;

	/**
	 * The number of operations of the '<em>Continuous Value Histogram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_HISTOGRAM_OPERATION_COUNT = ICONTINUOUS_VALUE_DEVIATION_OPERATION_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ContinuousValueHistogramEntryImpl <em>Continuous Value Histogram Entry</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ContinuousValueHistogramEntryImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getContinuousValueHistogramEntry()
	 * @generated
	 */
	int CONTINUOUS_VALUE_HISTOGRAM_ENTRY = 67;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_HISTOGRAM_ENTRY__LOWER_BOUND = CONTINUOUS_VALUE_INTERVAL__LOWER_BOUND;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_HISTOGRAM_ENTRY__UPPER_BOUND = CONTINUOUS_VALUE_INTERVAL__UPPER_BOUND;

	/**
	 * The feature id for the '<em><b>Occurrences</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_HISTOGRAM_ENTRY__OCCURRENCES = CONTINUOUS_VALUE_INTERVAL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Continuous Value Histogram Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_HISTOGRAM_ENTRY_FEATURE_COUNT = CONTINUOUS_VALUE_INTERVAL_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_HISTOGRAM_ENTRY___GET_AVERAGE = CONTINUOUS_VALUE_INTERVAL___GET_AVERAGE;

	/**
	 * The number of operations of the '<em>Continuous Value Histogram Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_HISTOGRAM_ENTRY_OPERATION_COUNT = CONTINUOUS_VALUE_INTERVAL_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.BoundedContinuousValueDistributionImpl <em>Bounded Continuous Value Distribution</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.BoundedContinuousValueDistributionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getBoundedContinuousValueDistribution()
	 * @generated
	 */
	int BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION = 68;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION__LOWER_BOUND = CONTINUOUS_VALUE_INTERVAL__LOWER_BOUND;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION__UPPER_BOUND = CONTINUOUS_VALUE_INTERVAL__UPPER_BOUND;

	/**
	 * The number of structural features of the '<em>Bounded Continuous Value Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION_FEATURE_COUNT = CONTINUOUS_VALUE_INTERVAL_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION___GET_LOWER_BOUND = CONTINUOUS_VALUE_INTERVAL_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION___GET_UPPER_BOUND = CONTINUOUS_VALUE_INTERVAL_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION___GET_AVERAGE = CONTINUOUS_VALUE_INTERVAL_OPERATION_COUNT + 2;

	/**
	 * The number of operations of the '<em>Bounded Continuous Value Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION_OPERATION_COUNT = CONTINUOUS_VALUE_INTERVAL_OPERATION_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TruncatedContinuousValueDistributionImpl <em>Truncated Continuous Value Distribution</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TruncatedContinuousValueDistributionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTruncatedContinuousValueDistribution()
	 * @generated
	 */
	int TRUNCATED_CONTINUOUS_VALUE_DISTRIBUTION = 69;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUNCATED_CONTINUOUS_VALUE_DISTRIBUTION__LOWER_BOUND = ICONTINUOUS_VALUE_DEVIATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUNCATED_CONTINUOUS_VALUE_DISTRIBUTION__UPPER_BOUND = ICONTINUOUS_VALUE_DEVIATION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Truncated Continuous Value Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUNCATED_CONTINUOUS_VALUE_DISTRIBUTION_FEATURE_COUNT = ICONTINUOUS_VALUE_DEVIATION_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUNCATED_CONTINUOUS_VALUE_DISTRIBUTION___GET_LOWER_BOUND = ICONTINUOUS_VALUE_DEVIATION___GET_LOWER_BOUND;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUNCATED_CONTINUOUS_VALUE_DISTRIBUTION___GET_UPPER_BOUND = ICONTINUOUS_VALUE_DEVIATION___GET_UPPER_BOUND;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUNCATED_CONTINUOUS_VALUE_DISTRIBUTION___GET_AVERAGE = ICONTINUOUS_VALUE_DEVIATION___GET_AVERAGE;

	/**
	 * The number of operations of the '<em>Truncated Continuous Value Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUNCATED_CONTINUOUS_VALUE_DISTRIBUTION_OPERATION_COUNT = ICONTINUOUS_VALUE_DEVIATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ContinuousValueBoundariesImpl <em>Continuous Value Boundaries</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ContinuousValueBoundariesImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getContinuousValueBoundaries()
	 * @generated
	 */
	int CONTINUOUS_VALUE_BOUNDARIES = 70;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_BOUNDARIES__LOWER_BOUND = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION__LOWER_BOUND;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_BOUNDARIES__UPPER_BOUND = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION__UPPER_BOUND;

	/**
	 * The feature id for the '<em><b>Sampling Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_BOUNDARIES__SAMPLING_TYPE = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Continuous Value Boundaries</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_BOUNDARIES_FEATURE_COUNT = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_BOUNDARIES___GET_LOWER_BOUND = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION___GET_LOWER_BOUND;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_BOUNDARIES___GET_UPPER_BOUND = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION___GET_UPPER_BOUND;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_BOUNDARIES___GET_AVERAGE = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION___GET_AVERAGE;

	/**
	 * The number of operations of the '<em>Continuous Value Boundaries</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_BOUNDARIES_OPERATION_COUNT = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ContinuousValueStatisticsImpl <em>Continuous Value Statistics</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ContinuousValueStatisticsImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getContinuousValueStatistics()
	 * @generated
	 */
	int CONTINUOUS_VALUE_STATISTICS = 71;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_STATISTICS__LOWER_BOUND = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION__LOWER_BOUND;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_STATISTICS__UPPER_BOUND = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION__UPPER_BOUND;

	/**
	 * The feature id for the '<em><b>Average</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_STATISTICS__AVERAGE = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Continuous Value Statistics</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_STATISTICS_FEATURE_COUNT = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_STATISTICS___GET_LOWER_BOUND = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION___GET_LOWER_BOUND;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_STATISTICS___GET_UPPER_BOUND = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION___GET_UPPER_BOUND;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_STATISTICS___GET_AVERAGE = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION___GET_AVERAGE;

	/**
	 * The number of operations of the '<em>Continuous Value Statistics</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_STATISTICS_OPERATION_COUNT = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ContinuousValueUniformDistributionImpl <em>Continuous Value Uniform Distribution</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ContinuousValueUniformDistributionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getContinuousValueUniformDistribution()
	 * @generated
	 */
	int CONTINUOUS_VALUE_UNIFORM_DISTRIBUTION = 72;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_UNIFORM_DISTRIBUTION__LOWER_BOUND = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION__LOWER_BOUND;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_UNIFORM_DISTRIBUTION__UPPER_BOUND = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION__UPPER_BOUND;

	/**
	 * The number of structural features of the '<em>Continuous Value Uniform Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_UNIFORM_DISTRIBUTION_FEATURE_COUNT = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_UNIFORM_DISTRIBUTION___GET_LOWER_BOUND = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION___GET_LOWER_BOUND;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_UNIFORM_DISTRIBUTION___GET_UPPER_BOUND = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION___GET_UPPER_BOUND;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_UNIFORM_DISTRIBUTION___GET_AVERAGE = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION___GET_AVERAGE;

	/**
	 * The number of operations of the '<em>Continuous Value Uniform Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_UNIFORM_DISTRIBUTION_OPERATION_COUNT = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ContinuousValueGaussDistributionImpl <em>Continuous Value Gauss Distribution</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ContinuousValueGaussDistributionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getContinuousValueGaussDistribution()
	 * @generated
	 */
	int CONTINUOUS_VALUE_GAUSS_DISTRIBUTION = 73;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_GAUSS_DISTRIBUTION__LOWER_BOUND = TRUNCATED_CONTINUOUS_VALUE_DISTRIBUTION__LOWER_BOUND;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_GAUSS_DISTRIBUTION__UPPER_BOUND = TRUNCATED_CONTINUOUS_VALUE_DISTRIBUTION__UPPER_BOUND;

	/**
	 * The feature id for the '<em><b>Mean</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_GAUSS_DISTRIBUTION__MEAN = TRUNCATED_CONTINUOUS_VALUE_DISTRIBUTION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Sd</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_GAUSS_DISTRIBUTION__SD = TRUNCATED_CONTINUOUS_VALUE_DISTRIBUTION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Continuous Value Gauss Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_GAUSS_DISTRIBUTION_FEATURE_COUNT = TRUNCATED_CONTINUOUS_VALUE_DISTRIBUTION_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_GAUSS_DISTRIBUTION___GET_LOWER_BOUND = TRUNCATED_CONTINUOUS_VALUE_DISTRIBUTION___GET_LOWER_BOUND;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_GAUSS_DISTRIBUTION___GET_UPPER_BOUND = TRUNCATED_CONTINUOUS_VALUE_DISTRIBUTION___GET_UPPER_BOUND;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_GAUSS_DISTRIBUTION___GET_AVERAGE = TRUNCATED_CONTINUOUS_VALUE_DISTRIBUTION_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Continuous Value Gauss Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_GAUSS_DISTRIBUTION_OPERATION_COUNT = TRUNCATED_CONTINUOUS_VALUE_DISTRIBUTION_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ContinuousValueWeibullEstimatorsDistributionImpl <em>Continuous Value Weibull Estimators Distribution</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ContinuousValueWeibullEstimatorsDistributionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getContinuousValueWeibullEstimatorsDistribution()
	 * @generated
	 */
	int CONTINUOUS_VALUE_WEIBULL_ESTIMATORS_DISTRIBUTION = 74;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_WEIBULL_ESTIMATORS_DISTRIBUTION__LOWER_BOUND = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION__LOWER_BOUND;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_WEIBULL_ESTIMATORS_DISTRIBUTION__UPPER_BOUND = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION__UPPER_BOUND;

	/**
	 * The feature id for the '<em><b>Average</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_WEIBULL_ESTIMATORS_DISTRIBUTION__AVERAGE = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>PRemain Promille</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_WEIBULL_ESTIMATORS_DISTRIBUTION__PREMAIN_PROMILLE = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Continuous Value Weibull Estimators Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_WEIBULL_ESTIMATORS_DISTRIBUTION_FEATURE_COUNT = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_WEIBULL_ESTIMATORS_DISTRIBUTION___GET_LOWER_BOUND = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION___GET_LOWER_BOUND;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_WEIBULL_ESTIMATORS_DISTRIBUTION___GET_UPPER_BOUND = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION___GET_UPPER_BOUND;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_WEIBULL_ESTIMATORS_DISTRIBUTION___GET_AVERAGE = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION___GET_AVERAGE;

	/**
	 * The number of operations of the '<em>Continuous Value Weibull Estimators Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_WEIBULL_ESTIMATORS_DISTRIBUTION_OPERATION_COUNT = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ContinuousValueBetaDistributionImpl <em>Continuous Value Beta Distribution</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ContinuousValueBetaDistributionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getContinuousValueBetaDistribution()
	 * @generated
	 */
	int CONTINUOUS_VALUE_BETA_DISTRIBUTION = 75;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_BETA_DISTRIBUTION__LOWER_BOUND = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION__LOWER_BOUND;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_BETA_DISTRIBUTION__UPPER_BOUND = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION__UPPER_BOUND;

	/**
	 * The feature id for the '<em><b>Alpha</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_BETA_DISTRIBUTION__ALPHA = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Beta</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_BETA_DISTRIBUTION__BETA = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Continuous Value Beta Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_BETA_DISTRIBUTION_FEATURE_COUNT = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get Lower Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_BETA_DISTRIBUTION___GET_LOWER_BOUND = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION___GET_LOWER_BOUND;

	/**
	 * The operation id for the '<em>Get Upper Bound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_BETA_DISTRIBUTION___GET_UPPER_BOUND = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION___GET_UPPER_BOUND;

	/**
	 * The operation id for the '<em>Get Average</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_BETA_DISTRIBUTION___GET_AVERAGE = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Continuous Value Beta Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTINUOUS_VALUE_BETA_DISTRIBUTION_OPERATION_COUNT = BOUNDED_CONTINUOUS_VALUE_DISTRIBUTION_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ModeImpl <em>Mode</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ModeImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getMode()
	 * @generated
	 */
	int MODE = 76;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Literals</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE__LITERALS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Mode</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE___COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE___BASIC_COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE___ENCODE__STRING = REFERABLE_BASE_OBJECT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Mode</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ModeLiteralImpl <em>Mode Literal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ModeLiteralImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getModeLiteral()
	 * @generated
	 */
	int MODE_LITERAL = 77;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LITERAL__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LITERAL__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LITERAL__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Containing Mode</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LITERAL__CONTAINING_MODE = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Mode Literal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LITERAL_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LITERAL___BASIC_COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LITERAL___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LITERAL___ENCODE__STRING = REFERABLE_BASE_OBJECT___ENCODE__STRING;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LITERAL___COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>To String</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LITERAL___TO_STRING = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 1;

	/**
	 * The number of operations of the '<em>Mode Literal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LITERAL_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ComponentsModelImpl <em>Components Model</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ComponentsModelImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getComponentsModel()
	 * @generated
	 */
	int COMPONENTS_MODEL = 78;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENTS_MODEL__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Components</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENTS_MODEL__COMPONENTS = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Systems</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENTS_MODEL__SYSTEMS = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Components Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENTS_MODEL_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Components Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENTS_MODEL_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.ISystem <em>ISystem</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.ISystem
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getISystem()
	 * @generated
	 */
	int ISYSTEM = 79;

	/**
	 * The feature id for the '<em><b>Component Instances</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISYSTEM__COMPONENT_INSTANCES = 0;

	/**
	 * The feature id for the '<em><b>Connectors</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISYSTEM__CONNECTORS = 1;

	/**
	 * The feature id for the '<em><b>Grounded Ports</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISYSTEM__GROUNDED_PORTS = 2;

	/**
	 * The feature id for the '<em><b>Inner Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISYSTEM__INNER_PORTS = 3;

	/**
	 * The number of structural features of the '<em>ISystem</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISYSTEM_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>ISystem</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISYSTEM_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.PortImpl <em>Port</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.PortImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getPort()
	 * @generated
	 */
	int PORT = 80;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PORT__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PORT__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PORT__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PORT__TAGS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Containing Component</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PORT__CONTAINING_COMPONENT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Port</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PORT_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PORT___BASIC_COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PORT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PORT___ENCODE__STRING = REFERABLE_BASE_OBJECT___ENCODE__STRING;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PORT___COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Port</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PORT_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ComponentImpl <em>Component</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ComponentImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getComponent()
	 * @generated
	 */
	int COMPONENT = 81;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT__TAGS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Ports</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT__PORTS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Tasks</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT__TASKS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Runnables</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT__RUNNABLES = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Labels</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT__LABELS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Semaphores</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT__SEMAPHORES = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Os Events</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT__OS_EVENTS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 6;

	/**
	 * The number of structural features of the '<em>Component</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 7;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT___COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT___BASIC_COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT___ENCODE__STRING = REFERABLE_BASE_OBJECT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Component</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.CompositeImpl <em>Composite</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.CompositeImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getComposite()
	 * @generated
	 */
	int COMPOSITE = 82;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE__CUSTOM_PROPERTIES = COMPONENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE__NAME = COMPONENT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE__UNIQUE_NAME = COMPONENT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE__TAGS = COMPONENT__TAGS;

	/**
	 * The feature id for the '<em><b>Ports</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE__PORTS = COMPONENT__PORTS;

	/**
	 * The feature id for the '<em><b>Tasks</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE__TASKS = COMPONENT__TASKS;

	/**
	 * The feature id for the '<em><b>Runnables</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE__RUNNABLES = COMPONENT__RUNNABLES;

	/**
	 * The feature id for the '<em><b>Labels</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE__LABELS = COMPONENT__LABELS;

	/**
	 * The feature id for the '<em><b>Semaphores</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE__SEMAPHORES = COMPONENT__SEMAPHORES;

	/**
	 * The feature id for the '<em><b>Os Events</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE__OS_EVENTS = COMPONENT__OS_EVENTS;

	/**
	 * The feature id for the '<em><b>Component Instances</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE__COMPONENT_INSTANCES = COMPONENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Connectors</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE__CONNECTORS = COMPONENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Grounded Ports</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE__GROUNDED_PORTS = COMPONENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Inner Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE__INNER_PORTS = COMPONENT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Composite</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_FEATURE_COUNT = COMPONENT_FEATURE_COUNT + 4;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE___COMPUTE_UNIQUE_NAME = COMPONENT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE___BASIC_COMPUTE_UNIQUE_NAME = COMPONENT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = COMPONENT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE___ENCODE__STRING = COMPONENT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Composite</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_OPERATION_COUNT = COMPONENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.SystemImpl <em>System</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.SystemImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSystem()
	 * @generated
	 */
	int SYSTEM = 83;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM__TAGS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Component Instances</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM__COMPONENT_INSTANCES = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Connectors</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM__CONNECTORS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Grounded Ports</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM__GROUNDED_PORTS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Inner Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM__INNER_PORTS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>System</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 5;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM___COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM___BASIC_COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM___ENCODE__STRING = REFERABLE_BASE_OBJECT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>System</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ComponentInstanceImpl <em>Component Instance</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ComponentInstanceImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getComponentInstance()
	 * @generated
	 */
	int COMPONENT_INSTANCE = 84;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCE__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCE__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCE__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCE__TAGS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCE__TYPE = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Component Instance</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCE_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCE___COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCE___BASIC_COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCE___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCE___ENCODE__STRING = REFERABLE_BASE_OBJECT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Component Instance</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_INSTANCE_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ConnectorImpl <em>Connector</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ConnectorImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getConnector()
	 * @generated
	 */
	int CONNECTOR = 85;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTOR__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTOR__NAME = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTOR__TAGS = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Source Port</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTOR__SOURCE_PORT = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Target Port</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTOR__TARGET_PORT = BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Connector</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTOR_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>Connector</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTOR_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.QualifiedPortImpl <em>Qualified Port</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.QualifiedPortImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getQualifiedPort()
	 * @generated
	 */
	int QUALIFIED_PORT = 86;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_PORT__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Instance</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_PORT__INSTANCE = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Port</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_PORT__PORT = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Qualified Port</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_PORT_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Qualified Port</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_PORT_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.InterfacePortImpl <em>Interface Port</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.InterfacePortImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getInterfacePort()
	 * @generated
	 */
	int INTERFACE_PORT = 87;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERFACE_PORT__CUSTOM_PROPERTIES = PORT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERFACE_PORT__NAME = PORT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERFACE_PORT__UNIQUE_NAME = PORT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERFACE_PORT__TAGS = PORT__TAGS;

	/**
	 * The feature id for the '<em><b>Containing Component</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERFACE_PORT__CONTAINING_COMPONENT = PORT__CONTAINING_COMPONENT;

	/**
	 * The feature id for the '<em><b>Interface Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERFACE_PORT__INTERFACE_NAME = PORT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Kind</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERFACE_PORT__KIND = PORT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Interface Port</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERFACE_PORT_FEATURE_COUNT = PORT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERFACE_PORT___BASIC_COMPUTE_UNIQUE_NAME = PORT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERFACE_PORT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = PORT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERFACE_PORT___ENCODE__STRING = PORT___ENCODE__STRING;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERFACE_PORT___COMPUTE_UNIQUE_NAME = PORT___COMPUTE_UNIQUE_NAME;

	/**
	 * The number of operations of the '<em>Interface Port</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERFACE_PORT_OPERATION_COUNT = PORT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ConfigModelImpl <em>Config Model</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ConfigModelImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getConfigModel()
	 * @generated
	 */
	int CONFIG_MODEL = 88;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONFIG_MODEL__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Events To Trace</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONFIG_MODEL__EVENTS_TO_TRACE = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Config Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONFIG_MODEL_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Config Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONFIG_MODEL_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.EventConfigImpl <em>Event Config</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.EventConfigImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getEventConfig()
	 * @generated
	 */
	int EVENT_CONFIG = 89;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CONFIG__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CONFIG__NAME = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Event</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CONFIG__EVENT = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Event Config</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CONFIG_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Event Config</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CONFIG_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ConstraintsModelImpl <em>Constraints Model</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ConstraintsModelImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getConstraintsModel()
	 * @generated
	 */
	int CONSTRAINTS_MODEL = 90;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRAINTS_MODEL__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Event Chains</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRAINTS_MODEL__EVENT_CHAINS = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Timing Constraints</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRAINTS_MODEL__TIMING_CONSTRAINTS = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Affinity Constraints</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRAINTS_MODEL__AFFINITY_CONSTRAINTS = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Runnable Sequencing Constraints</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRAINTS_MODEL__RUNNABLE_SEQUENCING_CONSTRAINTS = BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Data Age Constraints</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRAINTS_MODEL__DATA_AGE_CONSTRAINTS = BASE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Requirements</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRAINTS_MODEL__REQUIREMENTS = BASE_OBJECT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Data Coherency Groups</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRAINTS_MODEL__DATA_COHERENCY_GROUPS = BASE_OBJECT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Data Stability Groups</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRAINTS_MODEL__DATA_STABILITY_GROUPS = BASE_OBJECT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Physical Section Constraints</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRAINTS_MODEL__PHYSICAL_SECTION_CONSTRAINTS = BASE_OBJECT_FEATURE_COUNT + 8;

	/**
	 * The number of structural features of the '<em>Constraints Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRAINTS_MODEL_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 9;

	/**
	 * The number of operations of the '<em>Constraints Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRAINTS_MODEL_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.RunnableSequencingConstraintImpl <em>Runnable Sequencing Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.RunnableSequencingConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getRunnableSequencingConstraint()
	 * @generated
	 */
	int RUNNABLE_SEQUENCING_CONSTRAINT = 91;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEQUENCING_CONSTRAINT__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEQUENCING_CONSTRAINT__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEQUENCING_CONSTRAINT__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Order Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEQUENCING_CONSTRAINT__ORDER_TYPE = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Runnable Groups</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEQUENCING_CONSTRAINT__RUNNABLE_GROUPS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Process Scope</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEQUENCING_CONSTRAINT__PROCESS_SCOPE = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Runnable Sequencing Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEQUENCING_CONSTRAINT_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEQUENCING_CONSTRAINT___COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEQUENCING_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEQUENCING_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEQUENCING_CONSTRAINT___ENCODE__STRING = REFERABLE_BASE_OBJECT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Runnable Sequencing Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEQUENCING_CONSTRAINT_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.AffinityConstraintImpl <em>Affinity Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.AffinityConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getAffinityConstraint()
	 * @generated
	 */
	int AFFINITY_CONSTRAINT = 92;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINITY_CONSTRAINT__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINITY_CONSTRAINT__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINITY_CONSTRAINT__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The number of structural features of the '<em>Affinity Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINITY_CONSTRAINT_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINITY_CONSTRAINT___COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINITY_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINITY_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINITY_CONSTRAINT___ENCODE__STRING = REFERABLE_BASE_OBJECT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Affinity Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINITY_CONSTRAINT_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.SeparationConstraintImpl <em>Separation Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.SeparationConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSeparationConstraint()
	 * @generated
	 */
	int SEPARATION_CONSTRAINT = 93;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEPARATION_CONSTRAINT__CUSTOM_PROPERTIES = AFFINITY_CONSTRAINT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEPARATION_CONSTRAINT__NAME = AFFINITY_CONSTRAINT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEPARATION_CONSTRAINT__UNIQUE_NAME = AFFINITY_CONSTRAINT__UNIQUE_NAME;

	/**
	 * The number of structural features of the '<em>Separation Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEPARATION_CONSTRAINT_FEATURE_COUNT = AFFINITY_CONSTRAINT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEPARATION_CONSTRAINT___COMPUTE_UNIQUE_NAME = AFFINITY_CONSTRAINT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEPARATION_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME = AFFINITY_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEPARATION_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = AFFINITY_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEPARATION_CONSTRAINT___ENCODE__STRING = AFFINITY_CONSTRAINT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Separation Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEPARATION_CONSTRAINT_OPERATION_COUNT = AFFINITY_CONSTRAINT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.PairingConstraintImpl <em>Pairing Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.PairingConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getPairingConstraint()
	 * @generated
	 */
	int PAIRING_CONSTRAINT = 94;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PAIRING_CONSTRAINT__CUSTOM_PROPERTIES = AFFINITY_CONSTRAINT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PAIRING_CONSTRAINT__NAME = AFFINITY_CONSTRAINT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PAIRING_CONSTRAINT__UNIQUE_NAME = AFFINITY_CONSTRAINT__UNIQUE_NAME;

	/**
	 * The number of structural features of the '<em>Pairing Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PAIRING_CONSTRAINT_FEATURE_COUNT = AFFINITY_CONSTRAINT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PAIRING_CONSTRAINT___COMPUTE_UNIQUE_NAME = AFFINITY_CONSTRAINT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PAIRING_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME = AFFINITY_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PAIRING_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = AFFINITY_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PAIRING_CONSTRAINT___ENCODE__STRING = AFFINITY_CONSTRAINT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Pairing Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PAIRING_CONSTRAINT_OPERATION_COUNT = AFFINITY_CONSTRAINT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ProcessConstraintImpl <em>Process Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ProcessConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getProcessConstraint()
	 * @generated
	 */
	int PROCESS_CONSTRAINT = 95;

	/**
	 * The feature id for the '<em><b>Target</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CONSTRAINT__TARGET = 0;

	/**
	 * The number of structural features of the '<em>Process Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CONSTRAINT_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Process Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CONSTRAINT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.RunnableConstraintImpl <em>Runnable Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.RunnableConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getRunnableConstraint()
	 * @generated
	 */
	int RUNNABLE_CONSTRAINT = 96;

	/**
	 * The feature id for the '<em><b>Target</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_CONSTRAINT__TARGET = 0;

	/**
	 * The number of structural features of the '<em>Runnable Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_CONSTRAINT_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Runnable Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_CONSTRAINT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DataConstraintImpl <em>Data Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DataConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDataConstraint()
	 * @generated
	 */
	int DATA_CONSTRAINT = 97;

	/**
	 * The feature id for the '<em><b>Target</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_CONSTRAINT__TARGET = 0;

	/**
	 * The number of structural features of the '<em>Data Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_CONSTRAINT_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Data Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_CONSTRAINT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.RunnableSeparationConstraintImpl <em>Runnable Separation Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.RunnableSeparationConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getRunnableSeparationConstraint()
	 * @generated
	 */
	int RUNNABLE_SEPARATION_CONSTRAINT = 98;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEPARATION_CONSTRAINT__CUSTOM_PROPERTIES = SEPARATION_CONSTRAINT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEPARATION_CONSTRAINT__NAME = SEPARATION_CONSTRAINT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEPARATION_CONSTRAINT__UNIQUE_NAME = SEPARATION_CONSTRAINT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Target</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEPARATION_CONSTRAINT__TARGET = SEPARATION_CONSTRAINT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Groups</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEPARATION_CONSTRAINT__GROUPS = SEPARATION_CONSTRAINT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Runnable Separation Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEPARATION_CONSTRAINT_FEATURE_COUNT = SEPARATION_CONSTRAINT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEPARATION_CONSTRAINT___COMPUTE_UNIQUE_NAME = SEPARATION_CONSTRAINT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEPARATION_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME = SEPARATION_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEPARATION_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = SEPARATION_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEPARATION_CONSTRAINT___ENCODE__STRING = SEPARATION_CONSTRAINT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Runnable Separation Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SEPARATION_CONSTRAINT_OPERATION_COUNT = SEPARATION_CONSTRAINT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ProcessSeparationConstraintImpl <em>Process Separation Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ProcessSeparationConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getProcessSeparationConstraint()
	 * @generated
	 */
	int PROCESS_SEPARATION_CONSTRAINT = 99;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_SEPARATION_CONSTRAINT__CUSTOM_PROPERTIES = SEPARATION_CONSTRAINT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_SEPARATION_CONSTRAINT__NAME = SEPARATION_CONSTRAINT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_SEPARATION_CONSTRAINT__UNIQUE_NAME = SEPARATION_CONSTRAINT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Target</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_SEPARATION_CONSTRAINT__TARGET = SEPARATION_CONSTRAINT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Groups</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_SEPARATION_CONSTRAINT__GROUPS = SEPARATION_CONSTRAINT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Process Separation Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_SEPARATION_CONSTRAINT_FEATURE_COUNT = SEPARATION_CONSTRAINT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_SEPARATION_CONSTRAINT___COMPUTE_UNIQUE_NAME = SEPARATION_CONSTRAINT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_SEPARATION_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME = SEPARATION_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_SEPARATION_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = SEPARATION_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_SEPARATION_CONSTRAINT___ENCODE__STRING = SEPARATION_CONSTRAINT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Process Separation Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_SEPARATION_CONSTRAINT_OPERATION_COUNT = SEPARATION_CONSTRAINT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DataSeparationConstraintImpl <em>Data Separation Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DataSeparationConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDataSeparationConstraint()
	 * @generated
	 */
	int DATA_SEPARATION_CONSTRAINT = 100;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SEPARATION_CONSTRAINT__CUSTOM_PROPERTIES = SEPARATION_CONSTRAINT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SEPARATION_CONSTRAINT__NAME = SEPARATION_CONSTRAINT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SEPARATION_CONSTRAINT__UNIQUE_NAME = SEPARATION_CONSTRAINT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Target</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SEPARATION_CONSTRAINT__TARGET = SEPARATION_CONSTRAINT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Groups</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SEPARATION_CONSTRAINT__GROUPS = SEPARATION_CONSTRAINT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Data Separation Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SEPARATION_CONSTRAINT_FEATURE_COUNT = SEPARATION_CONSTRAINT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SEPARATION_CONSTRAINT___COMPUTE_UNIQUE_NAME = SEPARATION_CONSTRAINT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SEPARATION_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME = SEPARATION_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SEPARATION_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = SEPARATION_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SEPARATION_CONSTRAINT___ENCODE__STRING = SEPARATION_CONSTRAINT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Data Separation Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SEPARATION_CONSTRAINT_OPERATION_COUNT = SEPARATION_CONSTRAINT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.RunnablePairingConstraintImpl <em>Runnable Pairing Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.RunnablePairingConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getRunnablePairingConstraint()
	 * @generated
	 */
	int RUNNABLE_PAIRING_CONSTRAINT = 101;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PAIRING_CONSTRAINT__CUSTOM_PROPERTIES = PAIRING_CONSTRAINT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PAIRING_CONSTRAINT__NAME = PAIRING_CONSTRAINT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PAIRING_CONSTRAINT__UNIQUE_NAME = PAIRING_CONSTRAINT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Target</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PAIRING_CONSTRAINT__TARGET = PAIRING_CONSTRAINT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Group</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PAIRING_CONSTRAINT__GROUP = PAIRING_CONSTRAINT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Runnable Pairing Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PAIRING_CONSTRAINT_FEATURE_COUNT = PAIRING_CONSTRAINT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PAIRING_CONSTRAINT___COMPUTE_UNIQUE_NAME = PAIRING_CONSTRAINT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PAIRING_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME = PAIRING_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PAIRING_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = PAIRING_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PAIRING_CONSTRAINT___ENCODE__STRING = PAIRING_CONSTRAINT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Runnable Pairing Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PAIRING_CONSTRAINT_OPERATION_COUNT = PAIRING_CONSTRAINT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ProcessPairingConstraintImpl <em>Process Pairing Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ProcessPairingConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getProcessPairingConstraint()
	 * @generated
	 */
	int PROCESS_PAIRING_CONSTRAINT = 102;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PAIRING_CONSTRAINT__CUSTOM_PROPERTIES = PAIRING_CONSTRAINT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PAIRING_CONSTRAINT__NAME = PAIRING_CONSTRAINT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PAIRING_CONSTRAINT__UNIQUE_NAME = PAIRING_CONSTRAINT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Target</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PAIRING_CONSTRAINT__TARGET = PAIRING_CONSTRAINT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Group</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PAIRING_CONSTRAINT__GROUP = PAIRING_CONSTRAINT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Process Pairing Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PAIRING_CONSTRAINT_FEATURE_COUNT = PAIRING_CONSTRAINT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PAIRING_CONSTRAINT___COMPUTE_UNIQUE_NAME = PAIRING_CONSTRAINT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PAIRING_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME = PAIRING_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PAIRING_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = PAIRING_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PAIRING_CONSTRAINT___ENCODE__STRING = PAIRING_CONSTRAINT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Process Pairing Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PAIRING_CONSTRAINT_OPERATION_COUNT = PAIRING_CONSTRAINT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DataPairingConstraintImpl <em>Data Pairing Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DataPairingConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDataPairingConstraint()
	 * @generated
	 */
	int DATA_PAIRING_CONSTRAINT = 103;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_PAIRING_CONSTRAINT__CUSTOM_PROPERTIES = PAIRING_CONSTRAINT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_PAIRING_CONSTRAINT__NAME = PAIRING_CONSTRAINT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_PAIRING_CONSTRAINT__UNIQUE_NAME = PAIRING_CONSTRAINT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Target</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_PAIRING_CONSTRAINT__TARGET = PAIRING_CONSTRAINT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Group</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_PAIRING_CONSTRAINT__GROUP = PAIRING_CONSTRAINT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Data Pairing Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_PAIRING_CONSTRAINT_FEATURE_COUNT = PAIRING_CONSTRAINT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_PAIRING_CONSTRAINT___COMPUTE_UNIQUE_NAME = PAIRING_CONSTRAINT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_PAIRING_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME = PAIRING_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_PAIRING_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = PAIRING_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_PAIRING_CONSTRAINT___ENCODE__STRING = PAIRING_CONSTRAINT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Data Pairing Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_PAIRING_CONSTRAINT_OPERATION_COUNT = PAIRING_CONSTRAINT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.RunnableConstraintTargetImpl <em>Runnable Constraint Target</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.RunnableConstraintTargetImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getRunnableConstraintTarget()
	 * @generated
	 */
	int RUNNABLE_CONSTRAINT_TARGET = 104;

	/**
	 * The number of structural features of the '<em>Runnable Constraint Target</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_CONSTRAINT_TARGET_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Runnable Constraint Target</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_CONSTRAINT_TARGET_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ProcessConstraintTargetImpl <em>Process Constraint Target</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ProcessConstraintTargetImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getProcessConstraintTarget()
	 * @generated
	 */
	int PROCESS_CONSTRAINT_TARGET = 105;

	/**
	 * The number of structural features of the '<em>Process Constraint Target</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CONSTRAINT_TARGET_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Process Constraint Target</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CONSTRAINT_TARGET_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DataConstraintTargetImpl <em>Data Constraint Target</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DataConstraintTargetImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDataConstraintTarget()
	 * @generated
	 */
	int DATA_CONSTRAINT_TARGET = 106;

	/**
	 * The number of structural features of the '<em>Data Constraint Target</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_CONSTRAINT_TARGET_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Data Constraint Target</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_CONSTRAINT_TARGET_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TargetMemoryImpl <em>Target Memory</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TargetMemoryImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTargetMemory()
	 * @generated
	 */
	int TARGET_MEMORY = 107;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_MEMORY__CUSTOM_PROPERTIES = DATA_CONSTRAINT_TARGET_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Memories</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_MEMORY__MEMORIES = DATA_CONSTRAINT_TARGET_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Target Memory</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_MEMORY_FEATURE_COUNT = DATA_CONSTRAINT_TARGET_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Target Memory</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_MEMORY_OPERATION_COUNT = DATA_CONSTRAINT_TARGET_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TargetCoreImpl <em>Target Core</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TargetCoreImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTargetCore()
	 * @generated
	 */
	int TARGET_CORE = 108;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_CORE__CUSTOM_PROPERTIES = RUNNABLE_CONSTRAINT_TARGET_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Cores</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_CORE__CORES = RUNNABLE_CONSTRAINT_TARGET_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Target Core</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_CORE_FEATURE_COUNT = RUNNABLE_CONSTRAINT_TARGET_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Target Core</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_CORE_OPERATION_COUNT = RUNNABLE_CONSTRAINT_TARGET_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TargetSchedulerImpl <em>Target Scheduler</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TargetSchedulerImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTargetScheduler()
	 * @generated
	 */
	int TARGET_SCHEDULER = 109;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_SCHEDULER__CUSTOM_PROPERTIES = RUNNABLE_CONSTRAINT_TARGET_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Schedulers</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_SCHEDULER__SCHEDULERS = RUNNABLE_CONSTRAINT_TARGET_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Target Scheduler</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_SCHEDULER_FEATURE_COUNT = RUNNABLE_CONSTRAINT_TARGET_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Target Scheduler</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_SCHEDULER_OPERATION_COUNT = RUNNABLE_CONSTRAINT_TARGET_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.LabelGroupImpl <em>Label Group</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.LabelGroupImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getLabelGroup()
	 * @generated
	 */
	int LABEL_GROUP = 110;

	/**
	 * The number of structural features of the '<em>Label Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_GROUP_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Label Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_GROUP_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.RunnableGroupImpl <em>Runnable Group</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.RunnableGroupImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getRunnableGroup()
	 * @generated
	 */
	int RUNNABLE_GROUP = 111;

	/**
	 * The number of structural features of the '<em>Runnable Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_GROUP_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Runnable Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_GROUP_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ProcessGroupImpl <em>Process Group</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ProcessGroupImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getProcessGroup()
	 * @generated
	 */
	int PROCESS_GROUP = 112;

	/**
	 * The number of structural features of the '<em>Process Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_GROUP_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Process Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_GROUP_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.LabelEntityGroupImpl <em>Label Entity Group</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.LabelEntityGroupImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getLabelEntityGroup()
	 * @generated
	 */
	int LABEL_ENTITY_GROUP = 113;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_ENTITY_GROUP__CUSTOM_PROPERTIES = LABEL_GROUP_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Labels</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_ENTITY_GROUP__LABELS = LABEL_GROUP_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Label Entity Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_ENTITY_GROUP_FEATURE_COUNT = LABEL_GROUP_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Label Entity Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_ENTITY_GROUP_OPERATION_COUNT = LABEL_GROUP_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.RunnableEntityGroupImpl <em>Runnable Entity Group</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.RunnableEntityGroupImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getRunnableEntityGroup()
	 * @generated
	 */
	int RUNNABLE_ENTITY_GROUP = 114;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_ENTITY_GROUP__CUSTOM_PROPERTIES = RUNNABLE_GROUP_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Runnables</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_ENTITY_GROUP__RUNNABLES = RUNNABLE_GROUP_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Runnable Entity Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_ENTITY_GROUP_FEATURE_COUNT = RUNNABLE_GROUP_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Runnable Entity Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_ENTITY_GROUP_OPERATION_COUNT = RUNNABLE_GROUP_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ProcessEntityGroupImpl <em>Process Entity Group</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ProcessEntityGroupImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getProcessEntityGroup()
	 * @generated
	 */
	int PROCESS_ENTITY_GROUP = 115;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_ENTITY_GROUP__CUSTOM_PROPERTIES = PROCESS_GROUP_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Processes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_ENTITY_GROUP__PROCESSES = PROCESS_GROUP_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Process Entity Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_ENTITY_GROUP_FEATURE_COUNT = PROCESS_GROUP_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Process Entity Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_ENTITY_GROUP_OPERATION_COUNT = PROCESS_GROUP_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TagGroupImpl <em>Tag Group</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TagGroupImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTagGroup()
	 * @generated
	 */
	int TAG_GROUP = 116;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TAG_GROUP__CUSTOM_PROPERTIES = RUNNABLE_GROUP_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TAG_GROUP__TAG = RUNNABLE_GROUP_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Tag Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TAG_GROUP_FEATURE_COUNT = RUNNABLE_GROUP_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Tag Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TAG_GROUP_OPERATION_COUNT = RUNNABLE_GROUP_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.AbstractEventChainImpl <em>Abstract Event Chain</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.AbstractEventChainImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getAbstractEventChain()
	 * @generated
	 */
	int ABSTRACT_EVENT_CHAIN = 117;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_CHAIN__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_CHAIN__NAME = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Stimulus</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_CHAIN__STIMULUS = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Response</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_CHAIN__RESPONSE = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Segments</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_CHAIN__SEGMENTS = BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Strands</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_CHAIN__STRANDS = BASE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Abstract Event Chain</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_CHAIN_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 5;

	/**
	 * The number of operations of the '<em>Abstract Event Chain</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_CHAIN_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.EventChainImpl <em>Event Chain</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.EventChainImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getEventChain()
	 * @generated
	 */
	int EVENT_CHAIN = 118;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN__CUSTOM_PROPERTIES = ABSTRACT_EVENT_CHAIN__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN__NAME = ABSTRACT_EVENT_CHAIN__NAME;

	/**
	 * The feature id for the '<em><b>Stimulus</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN__STIMULUS = ABSTRACT_EVENT_CHAIN__STIMULUS;

	/**
	 * The feature id for the '<em><b>Response</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN__RESPONSE = ABSTRACT_EVENT_CHAIN__RESPONSE;

	/**
	 * The feature id for the '<em><b>Segments</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN__SEGMENTS = ABSTRACT_EVENT_CHAIN__SEGMENTS;

	/**
	 * The feature id for the '<em><b>Strands</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN__STRANDS = ABSTRACT_EVENT_CHAIN__STRANDS;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN__UNIQUE_NAME = ABSTRACT_EVENT_CHAIN_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Event Chain</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_FEATURE_COUNT = ABSTRACT_EVENT_CHAIN_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN___COMPUTE_UNIQUE_NAME = ABSTRACT_EVENT_CHAIN_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN___BASIC_COMPUTE_UNIQUE_NAME = ABSTRACT_EVENT_CHAIN_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = ABSTRACT_EVENT_CHAIN_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN___ENCODE__STRING = ABSTRACT_EVENT_CHAIN_OPERATION_COUNT + 3;

	/**
	 * The number of operations of the '<em>Event Chain</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_OPERATION_COUNT = ABSTRACT_EVENT_CHAIN_OPERATION_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.SubEventChainImpl <em>Sub Event Chain</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.SubEventChainImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSubEventChain()
	 * @generated
	 */
	int SUB_EVENT_CHAIN = 119;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUB_EVENT_CHAIN__CUSTOM_PROPERTIES = ABSTRACT_EVENT_CHAIN__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUB_EVENT_CHAIN__NAME = ABSTRACT_EVENT_CHAIN__NAME;

	/**
	 * The feature id for the '<em><b>Stimulus</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUB_EVENT_CHAIN__STIMULUS = ABSTRACT_EVENT_CHAIN__STIMULUS;

	/**
	 * The feature id for the '<em><b>Response</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUB_EVENT_CHAIN__RESPONSE = ABSTRACT_EVENT_CHAIN__RESPONSE;

	/**
	 * The feature id for the '<em><b>Segments</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUB_EVENT_CHAIN__SEGMENTS = ABSTRACT_EVENT_CHAIN__SEGMENTS;

	/**
	 * The feature id for the '<em><b>Strands</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUB_EVENT_CHAIN__STRANDS = ABSTRACT_EVENT_CHAIN__STRANDS;

	/**
	 * The number of structural features of the '<em>Sub Event Chain</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUB_EVENT_CHAIN_FEATURE_COUNT = ABSTRACT_EVENT_CHAIN_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Sub Event Chain</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUB_EVENT_CHAIN_OPERATION_COUNT = ABSTRACT_EVENT_CHAIN_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.EventChainItem <em>Event Chain Item</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.EventChainItem
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getEventChainItem()
	 * @generated
	 */
	int EVENT_CHAIN_ITEM = 120;

	/**
	 * The number of structural features of the '<em>Event Chain Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_ITEM_FEATURE_COUNT = 0;

	/**
	 * The operation id for the '<em>Get Event Chain</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_ITEM___GET_EVENT_CHAIN = 0;

	/**
	 * The number of operations of the '<em>Event Chain Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_ITEM_OPERATION_COUNT = 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.EventChainReferenceImpl <em>Event Chain Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.EventChainReferenceImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getEventChainReference()
	 * @generated
	 */
	int EVENT_CHAIN_REFERENCE = 121;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_REFERENCE__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Event Chain</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_REFERENCE__EVENT_CHAIN = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Event Chain Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_REFERENCE_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Event Chain</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_REFERENCE___GET_EVENT_CHAIN = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Event Chain Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_REFERENCE_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.EventChainContainerImpl <em>Event Chain Container</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.EventChainContainerImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getEventChainContainer()
	 * @generated
	 */
	int EVENT_CHAIN_CONTAINER = 122;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_CONTAINER__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Event Chain</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_CONTAINER__EVENT_CHAIN = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Event Chain Container</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_CONTAINER_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Event Chain</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_CONTAINER___GET_EVENT_CHAIN = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Event Chain Container</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_CONTAINER_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TimingConstraintImpl <em>Timing Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TimingConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTimingConstraint()
	 * @generated
	 */
	int TIMING_CONSTRAINT = 123;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMING_CONSTRAINT__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMING_CONSTRAINT__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMING_CONSTRAINT__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The number of structural features of the '<em>Timing Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMING_CONSTRAINT_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMING_CONSTRAINT___COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMING_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMING_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMING_CONSTRAINT___ENCODE__STRING = REFERABLE_BASE_OBJECT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Timing Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIMING_CONSTRAINT_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.PhysicalSectionConstraintImpl <em>Physical Section Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.PhysicalSectionConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getPhysicalSectionConstraint()
	 * @generated
	 */
	int PHYSICAL_SECTION_CONSTRAINT = 124;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_CONSTRAINT__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_CONSTRAINT__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_CONSTRAINT__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Section</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_CONSTRAINT__SECTION = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Memories</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_CONSTRAINT__MEMORIES = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Physical Section Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_CONSTRAINT_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_CONSTRAINT___COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_CONSTRAINT___ENCODE__STRING = REFERABLE_BASE_OBJECT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Physical Section Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_CONSTRAINT_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.SynchronizationConstraintImpl <em>Synchronization Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.SynchronizationConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSynchronizationConstraint()
	 * @generated
	 */
	int SYNCHRONIZATION_CONSTRAINT = 125;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNCHRONIZATION_CONSTRAINT__CUSTOM_PROPERTIES = TIMING_CONSTRAINT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNCHRONIZATION_CONSTRAINT__NAME = TIMING_CONSTRAINT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNCHRONIZATION_CONSTRAINT__UNIQUE_NAME = TIMING_CONSTRAINT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Multiple Occurrences Allowed</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNCHRONIZATION_CONSTRAINT__MULTIPLE_OCCURRENCES_ALLOWED = TIMING_CONSTRAINT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Tolerance</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNCHRONIZATION_CONSTRAINT__TOLERANCE = TIMING_CONSTRAINT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Synchronization Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNCHRONIZATION_CONSTRAINT_FEATURE_COUNT = TIMING_CONSTRAINT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNCHRONIZATION_CONSTRAINT___COMPUTE_UNIQUE_NAME = TIMING_CONSTRAINT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNCHRONIZATION_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME = TIMING_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNCHRONIZATION_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = TIMING_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNCHRONIZATION_CONSTRAINT___ENCODE__STRING = TIMING_CONSTRAINT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Synchronization Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNCHRONIZATION_CONSTRAINT_OPERATION_COUNT = TIMING_CONSTRAINT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.EventSynchronizationConstraintImpl <em>Event Synchronization Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.EventSynchronizationConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getEventSynchronizationConstraint()
	 * @generated
	 */
	int EVENT_SYNCHRONIZATION_CONSTRAINT = 126;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SYNCHRONIZATION_CONSTRAINT__CUSTOM_PROPERTIES = SYNCHRONIZATION_CONSTRAINT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SYNCHRONIZATION_CONSTRAINT__NAME = SYNCHRONIZATION_CONSTRAINT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SYNCHRONIZATION_CONSTRAINT__UNIQUE_NAME = SYNCHRONIZATION_CONSTRAINT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Multiple Occurrences Allowed</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SYNCHRONIZATION_CONSTRAINT__MULTIPLE_OCCURRENCES_ALLOWED = SYNCHRONIZATION_CONSTRAINT__MULTIPLE_OCCURRENCES_ALLOWED;

	/**
	 * The feature id for the '<em><b>Tolerance</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SYNCHRONIZATION_CONSTRAINT__TOLERANCE = SYNCHRONIZATION_CONSTRAINT__TOLERANCE;

	/**
	 * The feature id for the '<em><b>Events</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SYNCHRONIZATION_CONSTRAINT__EVENTS = SYNCHRONIZATION_CONSTRAINT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Event Synchronization Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SYNCHRONIZATION_CONSTRAINT_FEATURE_COUNT = SYNCHRONIZATION_CONSTRAINT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SYNCHRONIZATION_CONSTRAINT___COMPUTE_UNIQUE_NAME = SYNCHRONIZATION_CONSTRAINT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SYNCHRONIZATION_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME = SYNCHRONIZATION_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SYNCHRONIZATION_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = SYNCHRONIZATION_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SYNCHRONIZATION_CONSTRAINT___ENCODE__STRING = SYNCHRONIZATION_CONSTRAINT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Event Synchronization Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SYNCHRONIZATION_CONSTRAINT_OPERATION_COUNT = SYNCHRONIZATION_CONSTRAINT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.EventChainSynchronizationConstraintImpl <em>Event Chain Synchronization Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.EventChainSynchronizationConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getEventChainSynchronizationConstraint()
	 * @generated
	 */
	int EVENT_CHAIN_SYNCHRONIZATION_CONSTRAINT = 127;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_SYNCHRONIZATION_CONSTRAINT__CUSTOM_PROPERTIES = SYNCHRONIZATION_CONSTRAINT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_SYNCHRONIZATION_CONSTRAINT__NAME = SYNCHRONIZATION_CONSTRAINT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_SYNCHRONIZATION_CONSTRAINT__UNIQUE_NAME = SYNCHRONIZATION_CONSTRAINT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Multiple Occurrences Allowed</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_SYNCHRONIZATION_CONSTRAINT__MULTIPLE_OCCURRENCES_ALLOWED = SYNCHRONIZATION_CONSTRAINT__MULTIPLE_OCCURRENCES_ALLOWED;

	/**
	 * The feature id for the '<em><b>Tolerance</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_SYNCHRONIZATION_CONSTRAINT__TOLERANCE = SYNCHRONIZATION_CONSTRAINT__TOLERANCE;

	/**
	 * The feature id for the '<em><b>Scope</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_SYNCHRONIZATION_CONSTRAINT__SCOPE = SYNCHRONIZATION_CONSTRAINT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_SYNCHRONIZATION_CONSTRAINT__TYPE = SYNCHRONIZATION_CONSTRAINT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Event Chain Synchronization Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_SYNCHRONIZATION_CONSTRAINT_FEATURE_COUNT = SYNCHRONIZATION_CONSTRAINT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_SYNCHRONIZATION_CONSTRAINT___COMPUTE_UNIQUE_NAME = SYNCHRONIZATION_CONSTRAINT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_SYNCHRONIZATION_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME = SYNCHRONIZATION_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_SYNCHRONIZATION_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = SYNCHRONIZATION_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_SYNCHRONIZATION_CONSTRAINT___ENCODE__STRING = SYNCHRONIZATION_CONSTRAINT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Event Chain Synchronization Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_SYNCHRONIZATION_CONSTRAINT_OPERATION_COUNT = SYNCHRONIZATION_CONSTRAINT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DelayConstraintImpl <em>Delay Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DelayConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDelayConstraint()
	 * @generated
	 */
	int DELAY_CONSTRAINT = 128;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_CONSTRAINT__CUSTOM_PROPERTIES = TIMING_CONSTRAINT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_CONSTRAINT__NAME = TIMING_CONSTRAINT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_CONSTRAINT__UNIQUE_NAME = TIMING_CONSTRAINT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Mapping Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_CONSTRAINT__MAPPING_TYPE = TIMING_CONSTRAINT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Source</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_CONSTRAINT__SOURCE = TIMING_CONSTRAINT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Target</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_CONSTRAINT__TARGET = TIMING_CONSTRAINT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Upper</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_CONSTRAINT__UPPER = TIMING_CONSTRAINT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Lower</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_CONSTRAINT__LOWER = TIMING_CONSTRAINT_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Delay Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_CONSTRAINT_FEATURE_COUNT = TIMING_CONSTRAINT_FEATURE_COUNT + 5;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_CONSTRAINT___COMPUTE_UNIQUE_NAME = TIMING_CONSTRAINT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME = TIMING_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = TIMING_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_CONSTRAINT___ENCODE__STRING = TIMING_CONSTRAINT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Delay Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_CONSTRAINT_OPERATION_COUNT = TIMING_CONSTRAINT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.EventChainLatencyConstraintImpl <em>Event Chain Latency Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.EventChainLatencyConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getEventChainLatencyConstraint()
	 * @generated
	 */
	int EVENT_CHAIN_LATENCY_CONSTRAINT = 129;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_LATENCY_CONSTRAINT__CUSTOM_PROPERTIES = TIMING_CONSTRAINT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_LATENCY_CONSTRAINT__NAME = TIMING_CONSTRAINT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_LATENCY_CONSTRAINT__UNIQUE_NAME = TIMING_CONSTRAINT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Scope</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_LATENCY_CONSTRAINT__SCOPE = TIMING_CONSTRAINT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_LATENCY_CONSTRAINT__TYPE = TIMING_CONSTRAINT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Minimum</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_LATENCY_CONSTRAINT__MINIMUM = TIMING_CONSTRAINT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Maximum</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_LATENCY_CONSTRAINT__MAXIMUM = TIMING_CONSTRAINT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Event Chain Latency Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_LATENCY_CONSTRAINT_FEATURE_COUNT = TIMING_CONSTRAINT_FEATURE_COUNT + 4;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_LATENCY_CONSTRAINT___COMPUTE_UNIQUE_NAME = TIMING_CONSTRAINT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_LATENCY_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME = TIMING_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_LATENCY_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = TIMING_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_LATENCY_CONSTRAINT___ENCODE__STRING = TIMING_CONSTRAINT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Event Chain Latency Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_LATENCY_CONSTRAINT_OPERATION_COUNT = TIMING_CONSTRAINT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.RepetitionConstraintImpl <em>Repetition Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.RepetitionConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getRepetitionConstraint()
	 * @generated
	 */
	int REPETITION_CONSTRAINT = 130;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPETITION_CONSTRAINT__CUSTOM_PROPERTIES = TIMING_CONSTRAINT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPETITION_CONSTRAINT__NAME = TIMING_CONSTRAINT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPETITION_CONSTRAINT__UNIQUE_NAME = TIMING_CONSTRAINT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Event</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPETITION_CONSTRAINT__EVENT = TIMING_CONSTRAINT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Span</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPETITION_CONSTRAINT__SPAN = TIMING_CONSTRAINT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Lower</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPETITION_CONSTRAINT__LOWER = TIMING_CONSTRAINT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Upper</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPETITION_CONSTRAINT__UPPER = TIMING_CONSTRAINT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Jitter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPETITION_CONSTRAINT__JITTER = TIMING_CONSTRAINT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Period</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPETITION_CONSTRAINT__PERIOD = TIMING_CONSTRAINT_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Repetition Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPETITION_CONSTRAINT_FEATURE_COUNT = TIMING_CONSTRAINT_FEATURE_COUNT + 6;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPETITION_CONSTRAINT___COMPUTE_UNIQUE_NAME = TIMING_CONSTRAINT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPETITION_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME = TIMING_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPETITION_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = TIMING_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPETITION_CONSTRAINT___ENCODE__STRING = TIMING_CONSTRAINT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Repetition Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPETITION_CONSTRAINT_OPERATION_COUNT = TIMING_CONSTRAINT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DataAgeConstraintImpl <em>Data Age Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DataAgeConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDataAgeConstraint()
	 * @generated
	 */
	int DATA_AGE_CONSTRAINT = 131;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_CONSTRAINT__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_CONSTRAINT__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_CONSTRAINT__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_CONSTRAINT__RUNNABLE = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Label</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_CONSTRAINT__LABEL = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Data Age</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_CONSTRAINT__DATA_AGE = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Data Age Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_CONSTRAINT_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_CONSTRAINT___COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_CONSTRAINT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_CONSTRAINT___ENCODE__STRING = REFERABLE_BASE_OBJECT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Data Age Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_CONSTRAINT_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DataAgeImpl <em>Data Age</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DataAgeImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDataAge()
	 * @generated
	 */
	int DATA_AGE = 132;

	/**
	 * The number of structural features of the '<em>Data Age</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Data Age</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DataAgeCycleImpl <em>Data Age Cycle</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DataAgeCycleImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDataAgeCycle()
	 * @generated
	 */
	int DATA_AGE_CYCLE = 133;

	/**
	 * The feature id for the '<em><b>Minimum Cycle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_CYCLE__MINIMUM_CYCLE = DATA_AGE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Maximum Cycle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_CYCLE__MAXIMUM_CYCLE = DATA_AGE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Data Age Cycle</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_CYCLE_FEATURE_COUNT = DATA_AGE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Data Age Cycle</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_CYCLE_OPERATION_COUNT = DATA_AGE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DataAgeTimeImpl <em>Data Age Time</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DataAgeTimeImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDataAgeTime()
	 * @generated
	 */
	int DATA_AGE_TIME = 134;

	/**
	 * The feature id for the '<em><b>Minimum Time</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_TIME__MINIMUM_TIME = DATA_AGE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Maximum Time</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_TIME__MAXIMUM_TIME = DATA_AGE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Data Age Time</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_TIME_FEATURE_COUNT = DATA_AGE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Data Age Time</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_AGE_TIME_OPERATION_COUNT = DATA_AGE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.RequirementImpl <em>Requirement</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.RequirementImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getRequirement()
	 * @generated
	 */
	int REQUIREMENT = 135;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REQUIREMENT__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REQUIREMENT__NAME = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Severity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REQUIREMENT__SEVERITY = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Limit</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REQUIREMENT__LIMIT = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Requirement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REQUIREMENT_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Requirement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REQUIREMENT_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ProcessRequirementImpl <em>Process Requirement</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ProcessRequirementImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getProcessRequirement()
	 * @generated
	 */
	int PROCESS_REQUIREMENT = 136;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_REQUIREMENT__CUSTOM_PROPERTIES = REQUIREMENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_REQUIREMENT__NAME = REQUIREMENT__NAME;

	/**
	 * The feature id for the '<em><b>Severity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_REQUIREMENT__SEVERITY = REQUIREMENT__SEVERITY;

	/**
	 * The feature id for the '<em><b>Limit</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_REQUIREMENT__LIMIT = REQUIREMENT__LIMIT;

	/**
	 * The feature id for the '<em><b>Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_REQUIREMENT__PROCESS = REQUIREMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Process Requirement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_REQUIREMENT_FEATURE_COUNT = REQUIREMENT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Process Requirement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_REQUIREMENT_OPERATION_COUNT = REQUIREMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.RunnableRequirementImpl <em>Runnable Requirement</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.RunnableRequirementImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getRunnableRequirement()
	 * @generated
	 */
	int RUNNABLE_REQUIREMENT = 137;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_REQUIREMENT__CUSTOM_PROPERTIES = REQUIREMENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_REQUIREMENT__NAME = REQUIREMENT__NAME;

	/**
	 * The feature id for the '<em><b>Severity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_REQUIREMENT__SEVERITY = REQUIREMENT__SEVERITY;

	/**
	 * The feature id for the '<em><b>Limit</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_REQUIREMENT__LIMIT = REQUIREMENT__LIMIT;

	/**
	 * The feature id for the '<em><b>Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_REQUIREMENT__RUNNABLE = REQUIREMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Runnable Requirement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_REQUIREMENT_FEATURE_COUNT = REQUIREMENT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Runnable Requirement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_REQUIREMENT_OPERATION_COUNT = REQUIREMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ArchitectureRequirementImpl <em>Architecture Requirement</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ArchitectureRequirementImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getArchitectureRequirement()
	 * @generated
	 */
	int ARCHITECTURE_REQUIREMENT = 138;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARCHITECTURE_REQUIREMENT__CUSTOM_PROPERTIES = REQUIREMENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARCHITECTURE_REQUIREMENT__NAME = REQUIREMENT__NAME;

	/**
	 * The feature id for the '<em><b>Severity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARCHITECTURE_REQUIREMENT__SEVERITY = REQUIREMENT__SEVERITY;

	/**
	 * The feature id for the '<em><b>Limit</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARCHITECTURE_REQUIREMENT__LIMIT = REQUIREMENT__LIMIT;

	/**
	 * The feature id for the '<em><b>Component</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARCHITECTURE_REQUIREMENT__COMPONENT = REQUIREMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Architecture Requirement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARCHITECTURE_REQUIREMENT_FEATURE_COUNT = REQUIREMENT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Architecture Requirement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARCHITECTURE_REQUIREMENT_OPERATION_COUNT = REQUIREMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ProcessChainRequirementImpl <em>Process Chain Requirement</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ProcessChainRequirementImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getProcessChainRequirement()
	 * @generated
	 */
	int PROCESS_CHAIN_REQUIREMENT = 139;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_REQUIREMENT__CUSTOM_PROPERTIES = REQUIREMENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_REQUIREMENT__NAME = REQUIREMENT__NAME;

	/**
	 * The feature id for the '<em><b>Severity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_REQUIREMENT__SEVERITY = REQUIREMENT__SEVERITY;

	/**
	 * The feature id for the '<em><b>Limit</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_REQUIREMENT__LIMIT = REQUIREMENT__LIMIT;

	/**
	 * The feature id for the '<em><b>Process Chain</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_REQUIREMENT__PROCESS_CHAIN = REQUIREMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Process Chain Requirement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_REQUIREMENT_FEATURE_COUNT = REQUIREMENT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Process Chain Requirement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_REQUIREMENT_OPERATION_COUNT = REQUIREMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.RequirementLimitImpl <em>Requirement Limit</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.RequirementLimitImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getRequirementLimit()
	 * @generated
	 */
	int REQUIREMENT_LIMIT = 140;

	/**
	 * The feature id for the '<em><b>Limit Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REQUIREMENT_LIMIT__LIMIT_TYPE = 0;

	/**
	 * The number of structural features of the '<em>Requirement Limit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REQUIREMENT_LIMIT_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Requirement Limit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REQUIREMENT_LIMIT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.CPUPercentageRequirementLimitImpl <em>CPU Percentage Requirement Limit</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.CPUPercentageRequirementLimitImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getCPUPercentageRequirementLimit()
	 * @generated
	 */
	int CPU_PERCENTAGE_REQUIREMENT_LIMIT = 141;

	/**
	 * The feature id for the '<em><b>Limit Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CPU_PERCENTAGE_REQUIREMENT_LIMIT__LIMIT_TYPE = REQUIREMENT_LIMIT__LIMIT_TYPE;

	/**
	 * The feature id for the '<em><b>Metric</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CPU_PERCENTAGE_REQUIREMENT_LIMIT__METRIC = REQUIREMENT_LIMIT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Limit Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CPU_PERCENTAGE_REQUIREMENT_LIMIT__LIMIT_VALUE = REQUIREMENT_LIMIT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Hardware Context</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CPU_PERCENTAGE_REQUIREMENT_LIMIT__HARDWARE_CONTEXT = REQUIREMENT_LIMIT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>CPU Percentage Requirement Limit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CPU_PERCENTAGE_REQUIREMENT_LIMIT_FEATURE_COUNT = REQUIREMENT_LIMIT_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>CPU Percentage Requirement Limit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CPU_PERCENTAGE_REQUIREMENT_LIMIT_OPERATION_COUNT = REQUIREMENT_LIMIT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.FrequencyRequirementLimitImpl <em>Frequency Requirement Limit</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.FrequencyRequirementLimitImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getFrequencyRequirementLimit()
	 * @generated
	 */
	int FREQUENCY_REQUIREMENT_LIMIT = 142;

	/**
	 * The feature id for the '<em><b>Limit Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY_REQUIREMENT_LIMIT__LIMIT_TYPE = REQUIREMENT_LIMIT__LIMIT_TYPE;

	/**
	 * The feature id for the '<em><b>Metric</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY_REQUIREMENT_LIMIT__METRIC = REQUIREMENT_LIMIT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Limit Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY_REQUIREMENT_LIMIT__LIMIT_VALUE = REQUIREMENT_LIMIT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Frequency Requirement Limit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY_REQUIREMENT_LIMIT_FEATURE_COUNT = REQUIREMENT_LIMIT_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Frequency Requirement Limit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY_REQUIREMENT_LIMIT_OPERATION_COUNT = REQUIREMENT_LIMIT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.PercentageRequirementLimitImpl <em>Percentage Requirement Limit</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.PercentageRequirementLimitImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getPercentageRequirementLimit()
	 * @generated
	 */
	int PERCENTAGE_REQUIREMENT_LIMIT = 143;

	/**
	 * The feature id for the '<em><b>Limit Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERCENTAGE_REQUIREMENT_LIMIT__LIMIT_TYPE = REQUIREMENT_LIMIT__LIMIT_TYPE;

	/**
	 * The feature id for the '<em><b>Metric</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERCENTAGE_REQUIREMENT_LIMIT__METRIC = REQUIREMENT_LIMIT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Limit Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERCENTAGE_REQUIREMENT_LIMIT__LIMIT_VALUE = REQUIREMENT_LIMIT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Percentage Requirement Limit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERCENTAGE_REQUIREMENT_LIMIT_FEATURE_COUNT = REQUIREMENT_LIMIT_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Percentage Requirement Limit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERCENTAGE_REQUIREMENT_LIMIT_OPERATION_COUNT = REQUIREMENT_LIMIT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.CountRequirementLimitImpl <em>Count Requirement Limit</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.CountRequirementLimitImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getCountRequirementLimit()
	 * @generated
	 */
	int COUNT_REQUIREMENT_LIMIT = 144;

	/**
	 * The feature id for the '<em><b>Limit Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNT_REQUIREMENT_LIMIT__LIMIT_TYPE = REQUIREMENT_LIMIT__LIMIT_TYPE;

	/**
	 * The feature id for the '<em><b>Metric</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNT_REQUIREMENT_LIMIT__METRIC = REQUIREMENT_LIMIT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Limit Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNT_REQUIREMENT_LIMIT__LIMIT_VALUE = REQUIREMENT_LIMIT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Count Requirement Limit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNT_REQUIREMENT_LIMIT_FEATURE_COUNT = REQUIREMENT_LIMIT_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Count Requirement Limit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNT_REQUIREMENT_LIMIT_OPERATION_COUNT = REQUIREMENT_LIMIT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TimeRequirementLimitImpl <em>Time Requirement Limit</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TimeRequirementLimitImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTimeRequirementLimit()
	 * @generated
	 */
	int TIME_REQUIREMENT_LIMIT = 145;

	/**
	 * The feature id for the '<em><b>Limit Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_REQUIREMENT_LIMIT__LIMIT_TYPE = REQUIREMENT_LIMIT__LIMIT_TYPE;

	/**
	 * The feature id for the '<em><b>Metric</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_REQUIREMENT_LIMIT__METRIC = REQUIREMENT_LIMIT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Limit Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_REQUIREMENT_LIMIT__LIMIT_VALUE = REQUIREMENT_LIMIT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Time Requirement Limit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_REQUIREMENT_LIMIT_FEATURE_COUNT = REQUIREMENT_LIMIT_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Time Requirement Limit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_REQUIREMENT_LIMIT_OPERATION_COUNT = REQUIREMENT_LIMIT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DataCoherencyGroupImpl <em>Data Coherency Group</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DataCoherencyGroupImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDataCoherencyGroup()
	 * @generated
	 */
	int DATA_COHERENCY_GROUP = 146;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_COHERENCY_GROUP__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_COHERENCY_GROUP__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_COHERENCY_GROUP__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Labels</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_COHERENCY_GROUP__LABELS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Scope</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_COHERENCY_GROUP__SCOPE = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_COHERENCY_GROUP__DIRECTION = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Data Coherency Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_COHERENCY_GROUP_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_COHERENCY_GROUP___COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_COHERENCY_GROUP___BASIC_COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_COHERENCY_GROUP___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_COHERENCY_GROUP___ENCODE__STRING = REFERABLE_BASE_OBJECT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Data Coherency Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_COHERENCY_GROUP_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DataStabilityGroupImpl <em>Data Stability Group</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DataStabilityGroupImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDataStabilityGroup()
	 * @generated
	 */
	int DATA_STABILITY_GROUP = 147;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STABILITY_GROUP__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STABILITY_GROUP__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STABILITY_GROUP__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Labels</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STABILITY_GROUP__LABELS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Scope</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STABILITY_GROUP__SCOPE = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Data Stability Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STABILITY_GROUP_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STABILITY_GROUP___COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STABILITY_GROUP___BASIC_COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STABILITY_GROUP___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STABILITY_GROUP___ENCODE__STRING = REFERABLE_BASE_OBJECT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Data Stability Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STABILITY_GROUP_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DataGroupScopeImpl <em>Data Group Scope</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DataGroupScopeImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDataGroupScope()
	 * @generated
	 */
	int DATA_GROUP_SCOPE = 148;

	/**
	 * The number of structural features of the '<em>Data Group Scope</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_GROUP_SCOPE_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Data Group Scope</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_GROUP_SCOPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ProcessScopeImpl <em>Process Scope</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ProcessScopeImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getProcessScope()
	 * @generated
	 */
	int PROCESS_SCOPE = 149;

	/**
	 * The feature id for the '<em><b>Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_SCOPE__PROCESS = DATA_GROUP_SCOPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Process Scope</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_SCOPE_FEATURE_COUNT = DATA_GROUP_SCOPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Process Scope</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_SCOPE_OPERATION_COUNT = DATA_GROUP_SCOPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.RunnableScopeImpl <em>Runnable Scope</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.RunnableScopeImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getRunnableScope()
	 * @generated
	 */
	int RUNNABLE_SCOPE = 150;

	/**
	 * The feature id for the '<em><b>Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SCOPE__RUNNABLE = DATA_GROUP_SCOPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Runnable Scope</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SCOPE_FEATURE_COUNT = DATA_GROUP_SCOPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Runnable Scope</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_SCOPE_OPERATION_COUNT = DATA_GROUP_SCOPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ComponentScopeImpl <em>Component Scope</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ComponentScopeImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getComponentScope()
	 * @generated
	 */
	int COMPONENT_SCOPE = 151;

	/**
	 * The feature id for the '<em><b>Component</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_SCOPE__COMPONENT = DATA_GROUP_SCOPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Component Scope</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_SCOPE_FEATURE_COUNT = DATA_GROUP_SCOPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Component Scope</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_SCOPE_OPERATION_COUNT = DATA_GROUP_SCOPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.EventModelImpl <em>Event Model</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.EventModelImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getEventModel()
	 * @generated
	 */
	int EVENT_MODEL = 152;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_MODEL__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Events</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_MODEL__EVENTS = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Event Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_MODEL_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Event Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_MODEL_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.EventImpl <em>Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.EventImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getEvent()
	 * @generated
	 */
	int EVENT = 153;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT__TAGS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT__DESCRIPTION = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT___COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT___BASIC_COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT___ENCODE__STRING = REFERABLE_BASE_OBJECT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.EventSetImpl <em>Event Set</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.EventSetImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getEventSet()
	 * @generated
	 */
	int EVENT_SET = 154;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SET__CUSTOM_PROPERTIES = EVENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SET__NAME = EVENT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SET__UNIQUE_NAME = EVENT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SET__TAGS = EVENT__TAGS;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SET__DESCRIPTION = EVENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Events</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SET__EVENTS = EVENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Event Set</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SET_FEATURE_COUNT = EVENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SET___COMPUTE_UNIQUE_NAME = EVENT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SET___BASIC_COMPUTE_UNIQUE_NAME = EVENT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SET___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = EVENT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SET___ENCODE__STRING = EVENT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Event Set</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_SET_OPERATION_COUNT = EVENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.EntityEventImpl <em>Entity Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.EntityEventImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getEntityEvent()
	 * @generated
	 */
	int ENTITY_EVENT = 155;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_EVENT__CUSTOM_PROPERTIES = EVENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_EVENT__NAME = EVENT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_EVENT__UNIQUE_NAME = EVENT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_EVENT__TAGS = EVENT__TAGS;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_EVENT__DESCRIPTION = EVENT__DESCRIPTION;

	/**
	 * The number of structural features of the '<em>Entity Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_EVENT_FEATURE_COUNT = EVENT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_EVENT___COMPUTE_UNIQUE_NAME = EVENT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_EVENT___BASIC_COMPUTE_UNIQUE_NAME = EVENT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_EVENT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = EVENT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_EVENT___ENCODE__STRING = EVENT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Entity Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_EVENT_OPERATION_COUNT = EVENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TriggerEventImpl <em>Trigger Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TriggerEventImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTriggerEvent()
	 * @generated
	 */
	int TRIGGER_EVENT = 156;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRIGGER_EVENT__CUSTOM_PROPERTIES = ENTITY_EVENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRIGGER_EVENT__NAME = ENTITY_EVENT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRIGGER_EVENT__UNIQUE_NAME = ENTITY_EVENT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRIGGER_EVENT__TAGS = ENTITY_EVENT__TAGS;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRIGGER_EVENT__DESCRIPTION = ENTITY_EVENT__DESCRIPTION;

	/**
	 * The number of structural features of the '<em>Trigger Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRIGGER_EVENT_FEATURE_COUNT = ENTITY_EVENT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRIGGER_EVENT___COMPUTE_UNIQUE_NAME = ENTITY_EVENT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRIGGER_EVENT___BASIC_COMPUTE_UNIQUE_NAME = ENTITY_EVENT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRIGGER_EVENT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = ENTITY_EVENT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRIGGER_EVENT___ENCODE__STRING = ENTITY_EVENT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Trigger Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRIGGER_EVENT_OPERATION_COUNT = ENTITY_EVENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.CustomEventImpl <em>Custom Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.CustomEventImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getCustomEvent()
	 * @generated
	 */
	int CUSTOM_EVENT = 157;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_EVENT__CUSTOM_PROPERTIES = TRIGGER_EVENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_EVENT__NAME = TRIGGER_EVENT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_EVENT__UNIQUE_NAME = TRIGGER_EVENT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_EVENT__TAGS = TRIGGER_EVENT__TAGS;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_EVENT__DESCRIPTION = TRIGGER_EVENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Event Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_EVENT__EVENT_TYPE = TRIGGER_EVENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Explicit Triggers</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_EVENT__EXPLICIT_TRIGGERS = TRIGGER_EVENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Custom Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_EVENT_FEATURE_COUNT = TRIGGER_EVENT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_EVENT___COMPUTE_UNIQUE_NAME = TRIGGER_EVENT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_EVENT___BASIC_COMPUTE_UNIQUE_NAME = TRIGGER_EVENT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_EVENT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = TRIGGER_EVENT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_EVENT___ENCODE__STRING = TRIGGER_EVENT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Custom Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_EVENT_OPERATION_COUNT = TRIGGER_EVENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.StimulusEventImpl <em>Stimulus Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.StimulusEventImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getStimulusEvent()
	 * @generated
	 */
	int STIMULUS_EVENT = 158;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS_EVENT__CUSTOM_PROPERTIES = ENTITY_EVENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS_EVENT__NAME = ENTITY_EVENT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS_EVENT__UNIQUE_NAME = ENTITY_EVENT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS_EVENT__TAGS = ENTITY_EVENT__TAGS;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS_EVENT__DESCRIPTION = ENTITY_EVENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Entity</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS_EVENT__ENTITY = ENTITY_EVENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Stimulus Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS_EVENT_FEATURE_COUNT = ENTITY_EVENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS_EVENT___COMPUTE_UNIQUE_NAME = ENTITY_EVENT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS_EVENT___BASIC_COMPUTE_UNIQUE_NAME = ENTITY_EVENT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS_EVENT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = ENTITY_EVENT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS_EVENT___ENCODE__STRING = ENTITY_EVENT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Stimulus Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS_EVENT_OPERATION_COUNT = ENTITY_EVENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ProcessEventImpl <em>Process Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ProcessEventImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getProcessEvent()
	 * @generated
	 */
	int PROCESS_EVENT = 159;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_EVENT__CUSTOM_PROPERTIES = ENTITY_EVENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_EVENT__NAME = ENTITY_EVENT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_EVENT__UNIQUE_NAME = ENTITY_EVENT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_EVENT__TAGS = ENTITY_EVENT__TAGS;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_EVENT__DESCRIPTION = ENTITY_EVENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Event Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_EVENT__EVENT_TYPE = ENTITY_EVENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Entity</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_EVENT__ENTITY = ENTITY_EVENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Processing Unit</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_EVENT__PROCESSING_UNIT = ENTITY_EVENT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Process Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_EVENT_FEATURE_COUNT = ENTITY_EVENT_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_EVENT___COMPUTE_UNIQUE_NAME = ENTITY_EVENT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_EVENT___BASIC_COMPUTE_UNIQUE_NAME = ENTITY_EVENT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_EVENT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = ENTITY_EVENT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_EVENT___ENCODE__STRING = ENTITY_EVENT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Process Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_EVENT_OPERATION_COUNT = ENTITY_EVENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ProcessChainEventImpl <em>Process Chain Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ProcessChainEventImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getProcessChainEvent()
	 * @generated
	 */
	int PROCESS_CHAIN_EVENT = 160;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_EVENT__CUSTOM_PROPERTIES = ENTITY_EVENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_EVENT__NAME = ENTITY_EVENT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_EVENT__UNIQUE_NAME = ENTITY_EVENT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_EVENT__TAGS = ENTITY_EVENT__TAGS;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_EVENT__DESCRIPTION = ENTITY_EVENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Event Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_EVENT__EVENT_TYPE = ENTITY_EVENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Entity</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_EVENT__ENTITY = ENTITY_EVENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Processing Unit</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_EVENT__PROCESSING_UNIT = ENTITY_EVENT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Process Chain Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_EVENT_FEATURE_COUNT = ENTITY_EVENT_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_EVENT___COMPUTE_UNIQUE_NAME = ENTITY_EVENT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_EVENT___BASIC_COMPUTE_UNIQUE_NAME = ENTITY_EVENT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_EVENT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = ENTITY_EVENT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_EVENT___ENCODE__STRING = ENTITY_EVENT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Process Chain Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_EVENT_OPERATION_COUNT = ENTITY_EVENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.RunnableEventImpl <em>Runnable Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.RunnableEventImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getRunnableEvent()
	 * @generated
	 */
	int RUNNABLE_EVENT = 161;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_EVENT__CUSTOM_PROPERTIES = TRIGGER_EVENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_EVENT__NAME = TRIGGER_EVENT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_EVENT__UNIQUE_NAME = TRIGGER_EVENT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_EVENT__TAGS = TRIGGER_EVENT__TAGS;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_EVENT__DESCRIPTION = TRIGGER_EVENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Event Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_EVENT__EVENT_TYPE = TRIGGER_EVENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Entity</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_EVENT__ENTITY = TRIGGER_EVENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_EVENT__PROCESS = TRIGGER_EVENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Processing Unit</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_EVENT__PROCESSING_UNIT = TRIGGER_EVENT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Runnable Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_EVENT_FEATURE_COUNT = TRIGGER_EVENT_FEATURE_COUNT + 4;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_EVENT___COMPUTE_UNIQUE_NAME = TRIGGER_EVENT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_EVENT___BASIC_COMPUTE_UNIQUE_NAME = TRIGGER_EVENT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_EVENT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = TRIGGER_EVENT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_EVENT___ENCODE__STRING = TRIGGER_EVENT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Runnable Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_EVENT_OPERATION_COUNT = TRIGGER_EVENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.LabelEventImpl <em>Label Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.LabelEventImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getLabelEvent()
	 * @generated
	 */
	int LABEL_EVENT = 162;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_EVENT__CUSTOM_PROPERTIES = TRIGGER_EVENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_EVENT__NAME = TRIGGER_EVENT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_EVENT__UNIQUE_NAME = TRIGGER_EVENT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_EVENT__TAGS = TRIGGER_EVENT__TAGS;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_EVENT__DESCRIPTION = TRIGGER_EVENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Event Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_EVENT__EVENT_TYPE = TRIGGER_EVENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Entity</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_EVENT__ENTITY = TRIGGER_EVENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_EVENT__RUNNABLE = TRIGGER_EVENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_EVENT__PROCESS = TRIGGER_EVENT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Label Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_EVENT_FEATURE_COUNT = TRIGGER_EVENT_FEATURE_COUNT + 4;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_EVENT___COMPUTE_UNIQUE_NAME = TRIGGER_EVENT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_EVENT___BASIC_COMPUTE_UNIQUE_NAME = TRIGGER_EVENT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_EVENT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = TRIGGER_EVENT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_EVENT___ENCODE__STRING = TRIGGER_EVENT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Label Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_EVENT_OPERATION_COUNT = TRIGGER_EVENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ChannelEventImpl <em>Channel Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ChannelEventImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getChannelEvent()
	 * @generated
	 */
	int CHANNEL_EVENT = 163;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_EVENT__CUSTOM_PROPERTIES = TRIGGER_EVENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_EVENT__NAME = TRIGGER_EVENT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_EVENT__UNIQUE_NAME = TRIGGER_EVENT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_EVENT__TAGS = TRIGGER_EVENT__TAGS;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_EVENT__DESCRIPTION = TRIGGER_EVENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Event Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_EVENT__EVENT_TYPE = TRIGGER_EVENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Entity</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_EVENT__ENTITY = TRIGGER_EVENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_EVENT__RUNNABLE = TRIGGER_EVENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_EVENT__PROCESS = TRIGGER_EVENT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Channel Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_EVENT_FEATURE_COUNT = TRIGGER_EVENT_FEATURE_COUNT + 4;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_EVENT___COMPUTE_UNIQUE_NAME = TRIGGER_EVENT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_EVENT___BASIC_COMPUTE_UNIQUE_NAME = TRIGGER_EVENT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_EVENT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = TRIGGER_EVENT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_EVENT___ENCODE__STRING = TRIGGER_EVENT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Channel Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_EVENT_OPERATION_COUNT = TRIGGER_EVENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.SemaphoreEventImpl <em>Semaphore Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.SemaphoreEventImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSemaphoreEvent()
	 * @generated
	 */
	int SEMAPHORE_EVENT = 164;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_EVENT__CUSTOM_PROPERTIES = ENTITY_EVENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_EVENT__NAME = ENTITY_EVENT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_EVENT__UNIQUE_NAME = ENTITY_EVENT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_EVENT__TAGS = ENTITY_EVENT__TAGS;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_EVENT__DESCRIPTION = ENTITY_EVENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Event Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_EVENT__EVENT_TYPE = ENTITY_EVENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Entity</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_EVENT__ENTITY = ENTITY_EVENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_EVENT__RUNNABLE = ENTITY_EVENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_EVENT__PROCESS = ENTITY_EVENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Processing Unit</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_EVENT__PROCESSING_UNIT = ENTITY_EVENT_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Semaphore Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_EVENT_FEATURE_COUNT = ENTITY_EVENT_FEATURE_COUNT + 5;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_EVENT___COMPUTE_UNIQUE_NAME = ENTITY_EVENT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_EVENT___BASIC_COMPUTE_UNIQUE_NAME = ENTITY_EVENT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_EVENT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = ENTITY_EVENT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_EVENT___ENCODE__STRING = ENTITY_EVENT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Semaphore Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_EVENT_OPERATION_COUNT = ENTITY_EVENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ComponentEventImpl <em>Component Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ComponentEventImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getComponentEvent()
	 * @generated
	 */
	int COMPONENT_EVENT = 165;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_EVENT__CUSTOM_PROPERTIES = ENTITY_EVENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_EVENT__NAME = ENTITY_EVENT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_EVENT__UNIQUE_NAME = ENTITY_EVENT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_EVENT__TAGS = ENTITY_EVENT__TAGS;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_EVENT__DESCRIPTION = ENTITY_EVENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Event Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_EVENT__EVENT_TYPE = ENTITY_EVENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Entity</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_EVENT__ENTITY = ENTITY_EVENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Component Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_EVENT_FEATURE_COUNT = ENTITY_EVENT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_EVENT___COMPUTE_UNIQUE_NAME = ENTITY_EVENT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_EVENT___BASIC_COMPUTE_UNIQUE_NAME = ENTITY_EVENT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_EVENT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = ENTITY_EVENT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_EVENT___ENCODE__STRING = ENTITY_EVENT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Component Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_EVENT_OPERATION_COUNT = ENTITY_EVENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.HWModelImpl <em>HW Model</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.HWModelImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getHWModel()
	 * @generated
	 */
	int HW_MODEL = 166;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_MODEL__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Definitions</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_MODEL__DEFINITIONS = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Feature Categories</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_MODEL__FEATURE_CATEGORIES = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Structures</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_MODEL__STRUCTURES = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Domains</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_MODEL__DOMAINS = BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>HW Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_MODEL_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>HW Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_MODEL_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.HwStructureImpl <em>Hw Structure</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.HwStructureImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getHwStructure()
	 * @generated
	 */
	int HW_STRUCTURE = 167;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_STRUCTURE__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_STRUCTURE__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_STRUCTURE__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_STRUCTURE__TAGS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Structure Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_STRUCTURE__STRUCTURE_TYPE = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Ports</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_STRUCTURE__PORTS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Structures</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_STRUCTURE__STRUCTURES = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Modules</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_STRUCTURE__MODULES = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Connections</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_STRUCTURE__CONNECTIONS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Inner Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_STRUCTURE__INNER_PORTS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 6;

	/**
	 * The number of structural features of the '<em>Hw Structure</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_STRUCTURE_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 7;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_STRUCTURE___COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_STRUCTURE___BASIC_COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_STRUCTURE___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_STRUCTURE___ENCODE__STRING = REFERABLE_BASE_OBJECT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Hw Structure</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_STRUCTURE_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.HwModuleImpl <em>Hw Module</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.HwModuleImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getHwModule()
	 * @generated
	 */
	int HW_MODULE = 168;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_MODULE__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_MODULE__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_MODULE__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_MODULE__TAGS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Ports</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_MODULE__PORTS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Power Domain</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_MODULE__POWER_DOMAIN = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Frequency Domain</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_MODULE__FREQUENCY_DOMAIN = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Hw Module</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_MODULE_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_MODULE___COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_MODULE___BASIC_COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_MODULE___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_MODULE___ENCODE__STRING = REFERABLE_BASE_OBJECT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Hw Module</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_MODULE_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.HwDomainImpl <em>Hw Domain</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.HwDomainImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getHwDomain()
	 * @generated
	 */
	int HW_DOMAIN = 169;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DOMAIN__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DOMAIN__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DOMAIN__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DOMAIN__TAGS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Hw Domain</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DOMAIN_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DOMAIN___COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DOMAIN___BASIC_COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DOMAIN___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DOMAIN___ENCODE__STRING = REFERABLE_BASE_OBJECT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Hw Domain</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DOMAIN_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.FrequencyDomainImpl <em>Frequency Domain</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.FrequencyDomainImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getFrequencyDomain()
	 * @generated
	 */
	int FREQUENCY_DOMAIN = 170;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY_DOMAIN__CUSTOM_PROPERTIES = HW_DOMAIN__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY_DOMAIN__NAME = HW_DOMAIN__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY_DOMAIN__UNIQUE_NAME = HW_DOMAIN__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY_DOMAIN__TAGS = HW_DOMAIN__TAGS;

	/**
	 * The feature id for the '<em><b>Default Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY_DOMAIN__DEFAULT_VALUE = HW_DOMAIN_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Clock Gating</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY_DOMAIN__CLOCK_GATING = HW_DOMAIN_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Frequency Domain</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY_DOMAIN_FEATURE_COUNT = HW_DOMAIN_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY_DOMAIN___COMPUTE_UNIQUE_NAME = HW_DOMAIN___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY_DOMAIN___BASIC_COMPUTE_UNIQUE_NAME = HW_DOMAIN___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY_DOMAIN___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = HW_DOMAIN___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY_DOMAIN___ENCODE__STRING = HW_DOMAIN___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Frequency Domain</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FREQUENCY_DOMAIN_OPERATION_COUNT = HW_DOMAIN_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.PowerDomainImpl <em>Power Domain</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.PowerDomainImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getPowerDomain()
	 * @generated
	 */
	int POWER_DOMAIN = 171;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POWER_DOMAIN__CUSTOM_PROPERTIES = HW_DOMAIN__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POWER_DOMAIN__NAME = HW_DOMAIN__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POWER_DOMAIN__UNIQUE_NAME = HW_DOMAIN__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POWER_DOMAIN__TAGS = HW_DOMAIN__TAGS;

	/**
	 * The feature id for the '<em><b>Default Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POWER_DOMAIN__DEFAULT_VALUE = HW_DOMAIN_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Power Gating</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POWER_DOMAIN__POWER_GATING = HW_DOMAIN_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Power Domain</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POWER_DOMAIN_FEATURE_COUNT = HW_DOMAIN_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POWER_DOMAIN___COMPUTE_UNIQUE_NAME = HW_DOMAIN___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POWER_DOMAIN___BASIC_COMPUTE_UNIQUE_NAME = HW_DOMAIN___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POWER_DOMAIN___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = HW_DOMAIN___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POWER_DOMAIN___ENCODE__STRING = HW_DOMAIN___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Power Domain</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POWER_DOMAIN_OPERATION_COUNT = HW_DOMAIN_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ProcessingUnitImpl <em>Processing Unit</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ProcessingUnitImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getProcessingUnit()
	 * @generated
	 */
	int PROCESSING_UNIT = 172;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT__CUSTOM_PROPERTIES = HW_MODULE__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT__NAME = HW_MODULE__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT__UNIQUE_NAME = HW_MODULE__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT__TAGS = HW_MODULE__TAGS;

	/**
	 * The feature id for the '<em><b>Ports</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT__PORTS = HW_MODULE__PORTS;

	/**
	 * The feature id for the '<em><b>Power Domain</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT__POWER_DOMAIN = HW_MODULE__POWER_DOMAIN;

	/**
	 * The feature id for the '<em><b>Frequency Domain</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT__FREQUENCY_DOMAIN = HW_MODULE__FREQUENCY_DOMAIN;

	/**
	 * The feature id for the '<em><b>Definition</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT__DEFINITION = HW_MODULE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Access Elements</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT__ACCESS_ELEMENTS = HW_MODULE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Caches</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT__CACHES = HW_MODULE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Processing Unit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT_FEATURE_COUNT = HW_MODULE_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT___COMPUTE_UNIQUE_NAME = HW_MODULE___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT___BASIC_COMPUTE_UNIQUE_NAME = HW_MODULE___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = HW_MODULE___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT___ENCODE__STRING = HW_MODULE___ENCODE__STRING;

	/**
	 * The operation id for the '<em>Get Ports</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT___GET_PORTS = HW_MODULE_OPERATION_COUNT + 1;

	/**
	 * The number of operations of the '<em>Processing Unit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT_OPERATION_COUNT = HW_MODULE_OPERATION_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.MemoryImpl <em>Memory</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.MemoryImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getMemory()
	 * @generated
	 */
	int MEMORY = 173;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY__CUSTOM_PROPERTIES = HW_MODULE__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY__NAME = HW_MODULE__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY__UNIQUE_NAME = HW_MODULE__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY__TAGS = HW_MODULE__TAGS;

	/**
	 * The feature id for the '<em><b>Ports</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY__PORTS = HW_MODULE__PORTS;

	/**
	 * The feature id for the '<em><b>Power Domain</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY__POWER_DOMAIN = HW_MODULE__POWER_DOMAIN;

	/**
	 * The feature id for the '<em><b>Frequency Domain</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY__FREQUENCY_DOMAIN = HW_MODULE__FREQUENCY_DOMAIN;

	/**
	 * The feature id for the '<em><b>Definition</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY__DEFINITION = HW_MODULE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Mappings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY__MAPPINGS = HW_MODULE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Memory</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_FEATURE_COUNT = HW_MODULE_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY___COMPUTE_UNIQUE_NAME = HW_MODULE___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY___BASIC_COMPUTE_UNIQUE_NAME = HW_MODULE___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = HW_MODULE___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY___ENCODE__STRING = HW_MODULE___ENCODE__STRING;

	/**
	 * The operation id for the '<em>Get Ports</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY___GET_PORTS = HW_MODULE_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Memory</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_OPERATION_COUNT = HW_MODULE_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.CacheImpl <em>Cache</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.CacheImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getCache()
	 * @generated
	 */
	int CACHE = 174;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE__CUSTOM_PROPERTIES = HW_MODULE__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE__NAME = HW_MODULE__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE__UNIQUE_NAME = HW_MODULE__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE__TAGS = HW_MODULE__TAGS;

	/**
	 * The feature id for the '<em><b>Ports</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE__PORTS = HW_MODULE__PORTS;

	/**
	 * The feature id for the '<em><b>Power Domain</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE__POWER_DOMAIN = HW_MODULE__POWER_DOMAIN;

	/**
	 * The feature id for the '<em><b>Frequency Domain</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE__FREQUENCY_DOMAIN = HW_MODULE__FREQUENCY_DOMAIN;

	/**
	 * The feature id for the '<em><b>Definition</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE__DEFINITION = HW_MODULE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Cache</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_FEATURE_COUNT = HW_MODULE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE___COMPUTE_UNIQUE_NAME = HW_MODULE___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE___BASIC_COMPUTE_UNIQUE_NAME = HW_MODULE___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = HW_MODULE___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE___ENCODE__STRING = HW_MODULE___ENCODE__STRING;

	/**
	 * The operation id for the '<em>Get Ports</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE___GET_PORTS = HW_MODULE_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Cache</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_OPERATION_COUNT = HW_MODULE_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.HwFeatureCategoryImpl <em>Hw Feature Category</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.HwFeatureCategoryImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getHwFeatureCategory()
	 * @generated
	 */
	int HW_FEATURE_CATEGORY = 175;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE_CATEGORY__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE_CATEGORY__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE_CATEGORY__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Feature Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE_CATEGORY__FEATURE_TYPE = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE_CATEGORY__DESCRIPTION = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Features</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE_CATEGORY__FEATURES = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Hw Feature Category</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE_CATEGORY_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE_CATEGORY___COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE_CATEGORY___BASIC_COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE_CATEGORY___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE_CATEGORY___ENCODE__STRING = REFERABLE_BASE_OBJECT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Hw Feature Category</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE_CATEGORY_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.HwFeatureImpl <em>Hw Feature</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.HwFeatureImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getHwFeature()
	 * @generated
	 */
	int HW_FEATURE = 176;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Containing Category</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE__CONTAINING_CATEGORY = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE__VALUE = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Hw Feature</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE___BASIC_COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE___ENCODE__STRING = REFERABLE_BASE_OBJECT___ENCODE__STRING;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE___COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>To String</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE___TO_STRING = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 1;

	/**
	 * The number of operations of the '<em>Hw Feature</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_FEATURE_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.HwPortImpl <em>Hw Port</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.HwPortImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getHwPort()
	 * @generated
	 */
	int HW_PORT = 177;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PORT__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PORT__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PORT__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PORT__TAGS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Bit Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PORT__BIT_WIDTH = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Priority</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PORT__PRIORITY = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Port Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PORT__PORT_TYPE = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Port Interface</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PORT__PORT_INTERFACE = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Delegated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PORT__DELEGATED = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Connections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PORT__CONNECTIONS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 6;

	/**
	 * The number of structural features of the '<em>Hw Port</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PORT_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 7;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PORT___BASIC_COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PORT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PORT___ENCODE__STRING = REFERABLE_BASE_OBJECT___ENCODE__STRING;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PORT___COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Hw Port</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PORT_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ConnectionHandlerImpl <em>Connection Handler</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ConnectionHandlerImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getConnectionHandler()
	 * @generated
	 */
	int CONNECTION_HANDLER = 178;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER__CUSTOM_PROPERTIES = HW_MODULE__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER__NAME = HW_MODULE__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER__UNIQUE_NAME = HW_MODULE__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER__TAGS = HW_MODULE__TAGS;

	/**
	 * The feature id for the '<em><b>Ports</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER__PORTS = HW_MODULE__PORTS;

	/**
	 * The feature id for the '<em><b>Power Domain</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER__POWER_DOMAIN = HW_MODULE__POWER_DOMAIN;

	/**
	 * The feature id for the '<em><b>Frequency Domain</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER__FREQUENCY_DOMAIN = HW_MODULE__FREQUENCY_DOMAIN;

	/**
	 * The feature id for the '<em><b>Definition</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER__DEFINITION = HW_MODULE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Internal Connections</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER__INTERNAL_CONNECTIONS = HW_MODULE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Connection Handler</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER_FEATURE_COUNT = HW_MODULE_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER___COMPUTE_UNIQUE_NAME = HW_MODULE___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER___BASIC_COMPUTE_UNIQUE_NAME = HW_MODULE___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = HW_MODULE___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER___ENCODE__STRING = HW_MODULE___ENCODE__STRING;

	/**
	 * The operation id for the '<em>Get Ports</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER___GET_PORTS = HW_MODULE_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Connection Handler</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER_OPERATION_COUNT = HW_MODULE_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.HwConnectionImpl <em>Hw Connection</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.HwConnectionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getHwConnection()
	 * @generated
	 */
	int HW_CONNECTION = 179;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_CONNECTION__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_CONNECTION__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_CONNECTION__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_CONNECTION__TAGS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Read Latency</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_CONNECTION__READ_LATENCY = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Write Latency</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_CONNECTION__WRITE_LATENCY = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Data Rate</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_CONNECTION__DATA_RATE = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Port1</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_CONNECTION__PORT1 = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Port2</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_CONNECTION__PORT2 = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Internal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_CONNECTION__INTERNAL = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 6;

	/**
	 * The number of structural features of the '<em>Hw Connection</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_CONNECTION_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 7;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_CONNECTION___BASIC_COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_CONNECTION___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_CONNECTION___ENCODE__STRING = REFERABLE_BASE_OBJECT___ENCODE__STRING;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_CONNECTION___COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Ports</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_CONNECTION___GET_PORTS = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 2;

	/**
	 * The number of operations of the '<em>Hw Connection</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_CONNECTION_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.HwAccessElementImpl <em>Hw Access Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.HwAccessElementImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getHwAccessElement()
	 * @generated
	 */
	int HW_ACCESS_ELEMENT = 180;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_ELEMENT__TAGS = ITAGGABLE__TAGS;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_ELEMENT__NAME = ITAGGABLE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Source</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_ELEMENT__SOURCE = ITAGGABLE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Destination</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_ELEMENT__DESTINATION = ITAGGABLE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Access Path</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_ELEMENT__ACCESS_PATH = ITAGGABLE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Read Latency</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_ELEMENT__READ_LATENCY = ITAGGABLE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Write Latency</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_ELEMENT__WRITE_LATENCY = ITAGGABLE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Data Rate</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_ELEMENT__DATA_RATE = ITAGGABLE_FEATURE_COUNT + 6;

	/**
	 * The number of structural features of the '<em>Hw Access Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_ELEMENT_FEATURE_COUNT = ITAGGABLE_FEATURE_COUNT + 7;

	/**
	 * The number of operations of the '<em>Hw Access Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_ELEMENT_OPERATION_COUNT = ITAGGABLE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.HwDefinitionImpl <em>Hw Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.HwDefinitionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getHwDefinition()
	 * @generated
	 */
	int HW_DEFINITION = 181;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DEFINITION__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DEFINITION__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DEFINITION__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DEFINITION__TAGS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Hw Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DEFINITION_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DEFINITION___COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DEFINITION___BASIC_COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DEFINITION___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DEFINITION___ENCODE__STRING = REFERABLE_BASE_OBJECT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Hw Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DEFINITION_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ProcessingUnitDefinitionImpl <em>Processing Unit Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ProcessingUnitDefinitionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getProcessingUnitDefinition()
	 * @generated
	 */
	int PROCESSING_UNIT_DEFINITION = 182;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT_DEFINITION__CUSTOM_PROPERTIES = HW_DEFINITION__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT_DEFINITION__NAME = HW_DEFINITION__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT_DEFINITION__UNIQUE_NAME = HW_DEFINITION__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT_DEFINITION__TAGS = HW_DEFINITION__TAGS;

	/**
	 * The feature id for the '<em><b>Pu Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT_DEFINITION__PU_TYPE = HW_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Features</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT_DEFINITION__FEATURES = HW_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Classifiers</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT_DEFINITION__CLASSIFIERS = HW_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Processing Unit Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT_DEFINITION_FEATURE_COUNT = HW_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT_DEFINITION___COMPUTE_UNIQUE_NAME = HW_DEFINITION___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT_DEFINITION___BASIC_COMPUTE_UNIQUE_NAME = HW_DEFINITION___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT_DEFINITION___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = HW_DEFINITION___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT_DEFINITION___ENCODE__STRING = HW_DEFINITION___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Processing Unit Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSING_UNIT_DEFINITION_OPERATION_COUNT = HW_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ConnectionHandlerDefinitionImpl <em>Connection Handler Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ConnectionHandlerDefinitionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getConnectionHandlerDefinition()
	 * @generated
	 */
	int CONNECTION_HANDLER_DEFINITION = 183;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER_DEFINITION__CUSTOM_PROPERTIES = HW_DEFINITION__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER_DEFINITION__NAME = HW_DEFINITION__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER_DEFINITION__UNIQUE_NAME = HW_DEFINITION__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER_DEFINITION__TAGS = HW_DEFINITION__TAGS;

	/**
	 * The feature id for the '<em><b>Policy</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER_DEFINITION__POLICY = HW_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Read Latency</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER_DEFINITION__READ_LATENCY = HW_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Write Latency</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER_DEFINITION__WRITE_LATENCY = HW_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Data Rate</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER_DEFINITION__DATA_RATE = HW_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Max Burst Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER_DEFINITION__MAX_BURST_SIZE = HW_DEFINITION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Max Concurrent Transfers</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER_DEFINITION__MAX_CONCURRENT_TRANSFERS = HW_DEFINITION_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Connection Handler Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER_DEFINITION_FEATURE_COUNT = HW_DEFINITION_FEATURE_COUNT + 6;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER_DEFINITION___COMPUTE_UNIQUE_NAME = HW_DEFINITION___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER_DEFINITION___BASIC_COMPUTE_UNIQUE_NAME = HW_DEFINITION___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER_DEFINITION___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = HW_DEFINITION___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER_DEFINITION___ENCODE__STRING = HW_DEFINITION___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Connection Handler Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTION_HANDLER_DEFINITION_OPERATION_COUNT = HW_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.MemoryDefinitionImpl <em>Memory Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.MemoryDefinitionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getMemoryDefinition()
	 * @generated
	 */
	int MEMORY_DEFINITION = 184;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_DEFINITION__CUSTOM_PROPERTIES = HW_DEFINITION__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_DEFINITION__NAME = HW_DEFINITION__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_DEFINITION__UNIQUE_NAME = HW_DEFINITION__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_DEFINITION__TAGS = HW_DEFINITION__TAGS;

	/**
	 * The feature id for the '<em><b>Size</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_DEFINITION__SIZE = HW_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Access Latency</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_DEFINITION__ACCESS_LATENCY = HW_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Data Rate</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_DEFINITION__DATA_RATE = HW_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Memory Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_DEFINITION__MEMORY_TYPE = HW_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Classifiers</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_DEFINITION__CLASSIFIERS = HW_DEFINITION_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Memory Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_DEFINITION_FEATURE_COUNT = HW_DEFINITION_FEATURE_COUNT + 5;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_DEFINITION___COMPUTE_UNIQUE_NAME = HW_DEFINITION___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_DEFINITION___BASIC_COMPUTE_UNIQUE_NAME = HW_DEFINITION___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_DEFINITION___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = HW_DEFINITION___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_DEFINITION___ENCODE__STRING = HW_DEFINITION___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Memory Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_DEFINITION_OPERATION_COUNT = HW_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.CacheDefinitionImpl <em>Cache Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.CacheDefinitionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getCacheDefinition()
	 * @generated
	 */
	int CACHE_DEFINITION = 185;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_DEFINITION__CUSTOM_PROPERTIES = HW_DEFINITION__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_DEFINITION__NAME = HW_DEFINITION__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_DEFINITION__UNIQUE_NAME = HW_DEFINITION__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_DEFINITION__TAGS = HW_DEFINITION__TAGS;

	/**
	 * The feature id for the '<em><b>Size</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_DEFINITION__SIZE = HW_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Line Size</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_DEFINITION__LINE_SIZE = HW_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Access Latency</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_DEFINITION__ACCESS_LATENCY = HW_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Cache Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_DEFINITION__CACHE_TYPE = HW_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Write Strategy</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_DEFINITION__WRITE_STRATEGY = HW_DEFINITION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>NWays</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_DEFINITION__NWAYS = HW_DEFINITION_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Coherency</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_DEFINITION__COHERENCY = HW_DEFINITION_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Exclusive</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_DEFINITION__EXCLUSIVE = HW_DEFINITION_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Hit Rate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_DEFINITION__HIT_RATE = HW_DEFINITION_FEATURE_COUNT + 8;

	/**
	 * The number of structural features of the '<em>Cache Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_DEFINITION_FEATURE_COUNT = HW_DEFINITION_FEATURE_COUNT + 9;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_DEFINITION___COMPUTE_UNIQUE_NAME = HW_DEFINITION___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_DEFINITION___BASIC_COMPUTE_UNIQUE_NAME = HW_DEFINITION___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_DEFINITION___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = HW_DEFINITION___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_DEFINITION___ENCODE__STRING = HW_DEFINITION___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Cache Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_DEFINITION_OPERATION_COUNT = HW_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.HwPathImpl <em>Hw Path</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.HwPathImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getHwPath()
	 * @generated
	 */
	int HW_PATH = 186;

	/**
	 * The feature id for the '<em><b>Source</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PATH__SOURCE = 0;

	/**
	 * The feature id for the '<em><b>Destination</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PATH__DESTINATION = 1;

	/**
	 * The number of structural features of the '<em>Hw Path</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PATH_FEATURE_COUNT = 2;

	/**
	 * The operation id for the '<em>Get Containing Access Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PATH___GET_CONTAINING_ACCESS_ELEMENT = 0;

	/**
	 * The number of operations of the '<em>Hw Path</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PATH_OPERATION_COUNT = 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.HwAccessPathImpl <em>Hw Access Path</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.HwAccessPathImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getHwAccessPath()
	 * @generated
	 */
	int HW_ACCESS_PATH = 187;

	/**
	 * The feature id for the '<em><b>Source</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_PATH__SOURCE = HW_PATH__SOURCE;

	/**
	 * The feature id for the '<em><b>Destination</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_PATH__DESTINATION = HW_PATH__DESTINATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_PATH__NAME = HW_PATH_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Containing Access Element</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_PATH__CONTAINING_ACCESS_ELEMENT = HW_PATH_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Path Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_PATH__PATH_ELEMENTS = HW_PATH_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Start Address</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_PATH__START_ADDRESS = HW_PATH_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>End Address</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_PATH__END_ADDRESS = HW_PATH_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Mem Offset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_PATH__MEM_OFFSET = HW_PATH_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Hw Access Path</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_PATH_FEATURE_COUNT = HW_PATH_FEATURE_COUNT + 6;

	/**
	 * The operation id for the '<em>Get Containing Access Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_PATH___GET_CONTAINING_ACCESS_ELEMENT = HW_PATH___GET_CONTAINING_ACCESS_ELEMENT;

	/**
	 * The number of operations of the '<em>Hw Access Path</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_ACCESS_PATH_OPERATION_COUNT = HW_PATH_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.HwPathElement <em>Hw Path Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.HwPathElement
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getHwPathElement()
	 * @generated
	 */
	int HW_PATH_ELEMENT = 188;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PATH_ELEMENT__NAME = IREFERABLE__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PATH_ELEMENT__UNIQUE_NAME = IREFERABLE__UNIQUE_NAME;

	/**
	 * The number of structural features of the '<em>Hw Path Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PATH_ELEMENT_FEATURE_COUNT = IREFERABLE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PATH_ELEMENT___COMPUTE_UNIQUE_NAME = IREFERABLE___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PATH_ELEMENT___BASIC_COMPUTE_UNIQUE_NAME = IREFERABLE___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PATH_ELEMENT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = IREFERABLE___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PATH_ELEMENT___ENCODE__STRING = IREFERABLE___ENCODE__STRING;

	/**
	 * The operation id for the '<em>Get Ports</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PATH_ELEMENT___GET_PORTS = IREFERABLE_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Hw Path Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_PATH_ELEMENT_OPERATION_COUNT = IREFERABLE_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.HwDestination <em>Hw Destination</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.HwDestination
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getHwDestination()
	 * @generated
	 */
	int HW_DESTINATION = 189;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DESTINATION__NAME = IREFERABLE__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DESTINATION__UNIQUE_NAME = IREFERABLE__UNIQUE_NAME;

	/**
	 * The number of structural features of the '<em>Hw Destination</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DESTINATION_FEATURE_COUNT = IREFERABLE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DESTINATION___COMPUTE_UNIQUE_NAME = IREFERABLE___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DESTINATION___BASIC_COMPUTE_UNIQUE_NAME = IREFERABLE___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DESTINATION___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = IREFERABLE___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DESTINATION___ENCODE__STRING = IREFERABLE___ENCODE__STRING;

	/**
	 * The operation id for the '<em>Get Ports</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DESTINATION___GET_PORTS = IREFERABLE_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Hw Destination</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_DESTINATION_OPERATION_COUNT = IREFERABLE_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.MappingModelImpl <em>Mapping Model</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.MappingModelImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getMappingModel()
	 * @generated
	 */
	int MAPPING_MODEL = 190;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAPPING_MODEL__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Scheduler Allocation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAPPING_MODEL__SCHEDULER_ALLOCATION = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Runnable Allocation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAPPING_MODEL__RUNNABLE_ALLOCATION = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Task Allocation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAPPING_MODEL__TASK_ALLOCATION = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Isr Allocation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAPPING_MODEL__ISR_ALLOCATION = BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Memory Mapping</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAPPING_MODEL__MEMORY_MAPPING = BASE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Physical Section Mapping</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAPPING_MODEL__PHYSICAL_SECTION_MAPPING = BASE_OBJECT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Address Mapping Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAPPING_MODEL__ADDRESS_MAPPING_TYPE = BASE_OBJECT_FEATURE_COUNT + 6;

	/**
	 * The number of structural features of the '<em>Mapping Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAPPING_MODEL_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 7;

	/**
	 * The number of operations of the '<em>Mapping Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAPPING_MODEL_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.SchedulerAllocationImpl <em>Scheduler Allocation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.SchedulerAllocationImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSchedulerAllocation()
	 * @generated
	 */
	int SCHEDULER_ALLOCATION = 191;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER_ALLOCATION__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Scheduler</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER_ALLOCATION__SCHEDULER = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Responsibility</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER_ALLOCATION__RESPONSIBILITY = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Executing PU</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER_ALLOCATION__EXECUTING_PU = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Scheduler Allocation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER_ALLOCATION_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Scheduler Allocation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER_ALLOCATION_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TaskAllocationImpl <em>Task Allocation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TaskAllocationImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTaskAllocation()
	 * @generated
	 */
	int TASK_ALLOCATION = 192;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_ALLOCATION__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Task</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_ALLOCATION__TASK = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Scheduler</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_ALLOCATION__SCHEDULER = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Affinity</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_ALLOCATION__AFFINITY = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Scheduling Parameters</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_ALLOCATION__SCHEDULING_PARAMETERS = BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Parameter Extensions</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_ALLOCATION__PARAMETER_EXTENSIONS = BASE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Task Allocation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_ALLOCATION_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 5;

	/**
	 * The number of operations of the '<em>Task Allocation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_ALLOCATION_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ISRAllocationImpl <em>ISR Allocation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ISRAllocationImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getISRAllocation()
	 * @generated
	 */
	int ISR_ALLOCATION = 193;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR_ALLOCATION__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Isr</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR_ALLOCATION__ISR = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Controller</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR_ALLOCATION__CONTROLLER = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Priority</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR_ALLOCATION__PRIORITY = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>ISR Allocation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR_ALLOCATION_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>ISR Allocation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR_ALLOCATION_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.RunnableAllocationImpl <em>Runnable Allocation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.RunnableAllocationImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getRunnableAllocation()
	 * @generated
	 */
	int RUNNABLE_ALLOCATION = 194;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_ALLOCATION__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Scheduler</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_ALLOCATION__SCHEDULER = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Entity</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_ALLOCATION__ENTITY = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Runnable Allocation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_ALLOCATION_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Runnable Allocation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_ALLOCATION_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.MemoryMappingImpl <em>Memory Mapping</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.MemoryMappingImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getMemoryMapping()
	 * @generated
	 */
	int MEMORY_MAPPING = 195;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_MAPPING__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Abstract Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_MAPPING__ABSTRACT_ELEMENT = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Memory</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_MAPPING__MEMORY = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Memory Position Address</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_MAPPING__MEMORY_POSITION_ADDRESS = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Memory Mapping</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_MAPPING_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Memory Mapping</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_MAPPING_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.PhysicalSectionMappingImpl <em>Physical Section Mapping</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.PhysicalSectionMappingImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getPhysicalSectionMapping()
	 * @generated
	 */
	int PHYSICAL_SECTION_MAPPING = 196;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_MAPPING__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_MAPPING__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_MAPPING__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Origin</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_MAPPING__ORIGIN = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Memory</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_MAPPING__MEMORY = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Start Address</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_MAPPING__START_ADDRESS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>End Address</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_MAPPING__END_ADDRESS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Labels</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_MAPPING__LABELS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Run Entities</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_MAPPING__RUN_ENTITIES = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Physical Section Mapping</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_MAPPING_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 6;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_MAPPING___COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_MAPPING___BASIC_COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_MAPPING___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_MAPPING___ENCODE__STRING = REFERABLE_BASE_OBJECT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Physical Section Mapping</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PHYSICAL_SECTION_MAPPING_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.OSModelImpl <em>OS Model</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.OSModelImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getOSModel()
	 * @generated
	 */
	int OS_MODEL = 197;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_MODEL__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Semaphores</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_MODEL__SEMAPHORES = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Operating Systems</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_MODEL__OPERATING_SYSTEMS = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Os Overheads</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_MODEL__OS_OVERHEADS = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>OS Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_MODEL_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>OS Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_MODEL_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.OsDataConsistencyImpl <em>Os Data Consistency</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.OsDataConsistencyImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getOsDataConsistency()
	 * @generated
	 */
	int OS_DATA_CONSISTENCY = 198;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_DATA_CONSISTENCY__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_DATA_CONSISTENCY__MODE = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Data Stability</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_DATA_CONSISTENCY__DATA_STABILITY = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Non Atomic Data Coherency</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_DATA_CONSISTENCY__NON_ATOMIC_DATA_COHERENCY = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Os Data Consistency</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_DATA_CONSISTENCY_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Os Data Consistency</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_DATA_CONSISTENCY_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DataStabilityImpl <em>Data Stability</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DataStabilityImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDataStability()
	 * @generated
	 */
	int DATA_STABILITY = 199;

	/**
	 * The feature id for the '<em><b>Enabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STABILITY__ENABLED = 0;

	/**
	 * The feature id for the '<em><b>Algorithm</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STABILITY__ALGORITHM = 1;

	/**
	 * The feature id for the '<em><b>Access Multiplicity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STABILITY__ACCESS_MULTIPLICITY = 2;

	/**
	 * The feature id for the '<em><b>Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STABILITY__LEVEL = 3;

	/**
	 * The number of structural features of the '<em>Data Stability</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STABILITY_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>Data Stability</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_STABILITY_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.NonAtomicDataCoherencyImpl <em>Non Atomic Data Coherency</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.NonAtomicDataCoherencyImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getNonAtomicDataCoherency()
	 * @generated
	 */
	int NON_ATOMIC_DATA_COHERENCY = 200;

	/**
	 * The feature id for the '<em><b>Enabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NON_ATOMIC_DATA_COHERENCY__ENABLED = 0;

	/**
	 * The feature id for the '<em><b>Algorithm</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NON_ATOMIC_DATA_COHERENCY__ALGORITHM = 1;

	/**
	 * The feature id for the '<em><b>Access Multiplicity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NON_ATOMIC_DATA_COHERENCY__ACCESS_MULTIPLICITY = 2;

	/**
	 * The number of structural features of the '<em>Non Atomic Data Coherency</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NON_ATOMIC_DATA_COHERENCY_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Non Atomic Data Coherency</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NON_ATOMIC_DATA_COHERENCY_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.SemaphoreImpl <em>Semaphore</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.SemaphoreImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSemaphore()
	 * @generated
	 */
	int SEMAPHORE = 201;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Semaphore Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE__SEMAPHORE_TYPE = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Initial Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE__INITIAL_VALUE = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Max Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE__MAX_VALUE = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Priority Ceiling Protocol</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE__PRIORITY_CEILING_PROTOCOL = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Semaphore Accesses</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE__SEMAPHORE_ACCESSES = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Referring Components</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE__REFERRING_COMPONENTS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Semaphore</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 6;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE___COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE___BASIC_COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE___ENCODE__STRING = REFERABLE_BASE_OBJECT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Semaphore</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.SchedulerImpl <em>Scheduler</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.SchedulerImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getScheduler()
	 * @generated
	 */
	int SCHEDULER = 202;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Computation Items</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER__COMPUTATION_ITEMS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Scheduler Allocations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER__SCHEDULER_ALLOCATIONS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Runnable Allocations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER__RUNNABLE_ALLOCATIONS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Scheduler</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER___COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER___BASIC_COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER___ENCODE__STRING = REFERABLE_BASE_OBJECT___ENCODE__STRING;

	/**
	 * The operation id for the '<em>Get Scheduling Algorithm</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER___GET_SCHEDULING_ALGORITHM = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Scheduler</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TaskSchedulerImpl <em>Task Scheduler</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TaskSchedulerImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTaskScheduler()
	 * @generated
	 */
	int TASK_SCHEDULER = 203;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULER__CUSTOM_PROPERTIES = SCHEDULER__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULER__NAME = SCHEDULER__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULER__UNIQUE_NAME = SCHEDULER__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Computation Items</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULER__COMPUTATION_ITEMS = SCHEDULER__COMPUTATION_ITEMS;

	/**
	 * The feature id for the '<em><b>Scheduler Allocations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULER__SCHEDULER_ALLOCATIONS = SCHEDULER__SCHEDULER_ALLOCATIONS;

	/**
	 * The feature id for the '<em><b>Runnable Allocations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULER__RUNNABLE_ALLOCATIONS = SCHEDULER__RUNNABLE_ALLOCATIONS;

	/**
	 * The feature id for the '<em><b>Scheduling Algorithm</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULER__SCHEDULING_ALGORITHM = SCHEDULER_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Parent Association</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULER__PARENT_ASSOCIATION = SCHEDULER_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Child Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULER__CHILD_ASSOCIATIONS = SCHEDULER_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Task Allocations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULER__TASK_ALLOCATIONS = SCHEDULER_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Parent Scheduler</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULER__PARENT_SCHEDULER = SCHEDULER_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Child Schedulers</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULER__CHILD_SCHEDULERS = SCHEDULER_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Task Scheduler</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULER_FEATURE_COUNT = SCHEDULER_FEATURE_COUNT + 6;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULER___COMPUTE_UNIQUE_NAME = SCHEDULER___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULER___BASIC_COMPUTE_UNIQUE_NAME = SCHEDULER___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULER___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = SCHEDULER___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULER___ENCODE__STRING = SCHEDULER___ENCODE__STRING;

	/**
	 * The operation id for the '<em>Get Scheduling Algorithm</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULER___GET_SCHEDULING_ALGORITHM = SCHEDULER___GET_SCHEDULING_ALGORITHM;

	/**
	 * The number of operations of the '<em>Task Scheduler</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULER_OPERATION_COUNT = SCHEDULER_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.SchedulerAssociationImpl <em>Scheduler Association</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.SchedulerAssociationImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSchedulerAssociation()
	 * @generated
	 */
	int SCHEDULER_ASSOCIATION = 204;

	/**
	 * The feature id for the '<em><b>Child</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER_ASSOCIATION__CHILD = 0;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER_ASSOCIATION__PARENT = 1;

	/**
	 * The feature id for the '<em><b>Scheduling Parameters</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER_ASSOCIATION__SCHEDULING_PARAMETERS = 2;

	/**
	 * The feature id for the '<em><b>Parameter Extensions</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER_ASSOCIATION__PARAMETER_EXTENSIONS = 3;

	/**
	 * The number of structural features of the '<em>Scheduler Association</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER_ASSOCIATION_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>Scheduler Association</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULER_ASSOCIATION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.InterruptControllerImpl <em>Interrupt Controller</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.InterruptControllerImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getInterruptController()
	 * @generated
	 */
	int INTERRUPT_CONTROLLER = 205;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_CONTROLLER__CUSTOM_PROPERTIES = SCHEDULER__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_CONTROLLER__NAME = SCHEDULER__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_CONTROLLER__UNIQUE_NAME = SCHEDULER__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Computation Items</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_CONTROLLER__COMPUTATION_ITEMS = SCHEDULER__COMPUTATION_ITEMS;

	/**
	 * The feature id for the '<em><b>Scheduler Allocations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_CONTROLLER__SCHEDULER_ALLOCATIONS = SCHEDULER__SCHEDULER_ALLOCATIONS;

	/**
	 * The feature id for the '<em><b>Runnable Allocations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_CONTROLLER__RUNNABLE_ALLOCATIONS = SCHEDULER__RUNNABLE_ALLOCATIONS;

	/**
	 * The feature id for the '<em><b>Scheduling Algorithm</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_CONTROLLER__SCHEDULING_ALGORITHM = SCHEDULER_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Isr Allocations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_CONTROLLER__ISR_ALLOCATIONS = SCHEDULER_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Interrupt Controller</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_CONTROLLER_FEATURE_COUNT = SCHEDULER_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_CONTROLLER___COMPUTE_UNIQUE_NAME = SCHEDULER___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_CONTROLLER___BASIC_COMPUTE_UNIQUE_NAME = SCHEDULER___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_CONTROLLER___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = SCHEDULER___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_CONTROLLER___ENCODE__STRING = SCHEDULER___ENCODE__STRING;

	/**
	 * The operation id for the '<em>Get Scheduling Algorithm</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_CONTROLLER___GET_SCHEDULING_ALGORITHM = SCHEDULER___GET_SCHEDULING_ALGORITHM;

	/**
	 * The number of operations of the '<em>Interrupt Controller</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_CONTROLLER_OPERATION_COUNT = SCHEDULER_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.SchedulingParametersImpl <em>Scheduling Parameters</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.SchedulingParametersImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSchedulingParameters()
	 * @generated
	 */
	int SCHEDULING_PARAMETERS = 206;

	/**
	 * The feature id for the '<em><b>Priority</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULING_PARAMETERS__PRIORITY = 0;

	/**
	 * The feature id for the '<em><b>Min Budget</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULING_PARAMETERS__MIN_BUDGET = 1;

	/**
	 * The feature id for the '<em><b>Max Budget</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULING_PARAMETERS__MAX_BUDGET = 2;

	/**
	 * The feature id for the '<em><b>Replenishment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULING_PARAMETERS__REPLENISHMENT = 3;

	/**
	 * The number of structural features of the '<em>Scheduling Parameters</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULING_PARAMETERS_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>Scheduling Parameters</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULING_PARAMETERS_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ParameterExtensionImpl <em>Parameter Extension</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ParameterExtensionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getParameterExtension()
	 * @generated
	 */
	int PARAMETER_EXTENSION = 207;

	/**
	 * The feature id for the '<em><b>Key</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_EXTENSION__KEY = 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_EXTENSION__VALUE = 1;

	/**
	 * The number of structural features of the '<em>Parameter Extension</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_EXTENSION_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Parameter Extension</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_EXTENSION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.AlgorithmImpl <em>Algorithm</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.AlgorithmImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getAlgorithm()
	 * @generated
	 */
	int ALGORITHM = 208;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALGORITHM__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The number of structural features of the '<em>Algorithm</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALGORITHM_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Algorithm</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALGORITHM_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.InterruptSchedulingAlgorithmImpl <em>Interrupt Scheduling Algorithm</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.InterruptSchedulingAlgorithmImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getInterruptSchedulingAlgorithm()
	 * @generated
	 */
	int INTERRUPT_SCHEDULING_ALGORITHM = 209;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_SCHEDULING_ALGORITHM__CUSTOM_PROPERTIES = ALGORITHM__CUSTOM_PROPERTIES;

	/**
	 * The number of structural features of the '<em>Interrupt Scheduling Algorithm</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_SCHEDULING_ALGORITHM_FEATURE_COUNT = ALGORITHM_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Interrupt Scheduling Algorithm</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERRUPT_SCHEDULING_ALGORITHM_OPERATION_COUNT = ALGORITHM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TaskSchedulingAlgorithmImpl <em>Task Scheduling Algorithm</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TaskSchedulingAlgorithmImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTaskSchedulingAlgorithm()
	 * @generated
	 */
	int TASK_SCHEDULING_ALGORITHM = 210;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULING_ALGORITHM__CUSTOM_PROPERTIES = ALGORITHM__CUSTOM_PROPERTIES;

	/**
	 * The number of structural features of the '<em>Task Scheduling Algorithm</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULING_ALGORITHM_FEATURE_COUNT = ALGORITHM_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Task Scheduling Algorithm</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_SCHEDULING_ALGORITHM_OPERATION_COUNT = ALGORITHM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.FixedPriorityImpl <em>Fixed Priority</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.FixedPriorityImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getFixedPriority()
	 * @generated
	 */
	int FIXED_PRIORITY = 211;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FIXED_PRIORITY__CUSTOM_PROPERTIES = TASK_SCHEDULING_ALGORITHM__CUSTOM_PROPERTIES;

	/**
	 * The number of structural features of the '<em>Fixed Priority</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FIXED_PRIORITY_FEATURE_COUNT = TASK_SCHEDULING_ALGORITHM_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Fixed Priority</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FIXED_PRIORITY_OPERATION_COUNT = TASK_SCHEDULING_ALGORITHM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.FixedPriorityPreemptiveImpl <em>Fixed Priority Preemptive</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.FixedPriorityPreemptiveImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getFixedPriorityPreemptive()
	 * @generated
	 */
	int FIXED_PRIORITY_PREEMPTIVE = 212;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FIXED_PRIORITY_PREEMPTIVE__CUSTOM_PROPERTIES = FIXED_PRIORITY__CUSTOM_PROPERTIES;

	/**
	 * The number of structural features of the '<em>Fixed Priority Preemptive</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FIXED_PRIORITY_PREEMPTIVE_FEATURE_COUNT = FIXED_PRIORITY_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Fixed Priority Preemptive</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FIXED_PRIORITY_PREEMPTIVE_OPERATION_COUNT = FIXED_PRIORITY_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.FixedPriorityPreemptiveWithBudgetEnforcementImpl <em>Fixed Priority Preemptive With Budget Enforcement</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.FixedPriorityPreemptiveWithBudgetEnforcementImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getFixedPriorityPreemptiveWithBudgetEnforcement()
	 * @generated
	 */
	int FIXED_PRIORITY_PREEMPTIVE_WITH_BUDGET_ENFORCEMENT = 213;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FIXED_PRIORITY_PREEMPTIVE_WITH_BUDGET_ENFORCEMENT__CUSTOM_PROPERTIES = FIXED_PRIORITY__CUSTOM_PROPERTIES;

	/**
	 * The number of structural features of the '<em>Fixed Priority Preemptive With Budget Enforcement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FIXED_PRIORITY_PREEMPTIVE_WITH_BUDGET_ENFORCEMENT_FEATURE_COUNT = FIXED_PRIORITY_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Fixed Priority Preemptive With Budget Enforcement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FIXED_PRIORITY_PREEMPTIVE_WITH_BUDGET_ENFORCEMENT_OPERATION_COUNT = FIXED_PRIORITY_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.OSEKImpl <em>OSEK</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.OSEKImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getOSEK()
	 * @generated
	 */
	int OSEK = 214;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OSEK__CUSTOM_PROPERTIES = FIXED_PRIORITY__CUSTOM_PROPERTIES;

	/**
	 * The number of structural features of the '<em>OSEK</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OSEK_FEATURE_COUNT = FIXED_PRIORITY_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>OSEK</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OSEK_OPERATION_COUNT = FIXED_PRIORITY_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DeadlineMonotonicImpl <em>Deadline Monotonic</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DeadlineMonotonicImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDeadlineMonotonic()
	 * @generated
	 */
	int DEADLINE_MONOTONIC = 215;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEADLINE_MONOTONIC__CUSTOM_PROPERTIES = FIXED_PRIORITY__CUSTOM_PROPERTIES;

	/**
	 * The number of structural features of the '<em>Deadline Monotonic</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEADLINE_MONOTONIC_FEATURE_COUNT = FIXED_PRIORITY_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Deadline Monotonic</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEADLINE_MONOTONIC_OPERATION_COUNT = FIXED_PRIORITY_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.RateMonotonicImpl <em>Rate Monotonic</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.RateMonotonicImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getRateMonotonic()
	 * @generated
	 */
	int RATE_MONOTONIC = 216;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RATE_MONOTONIC__CUSTOM_PROPERTIES = FIXED_PRIORITY__CUSTOM_PROPERTIES;

	/**
	 * The number of structural features of the '<em>Rate Monotonic</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RATE_MONOTONIC_FEATURE_COUNT = FIXED_PRIORITY_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Rate Monotonic</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RATE_MONOTONIC_OPERATION_COUNT = FIXED_PRIORITY_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.PfairImpl <em>Pfair</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.PfairImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getPfair()
	 * @generated
	 */
	int PFAIR = 217;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PFAIR__CUSTOM_PROPERTIES = TASK_SCHEDULING_ALGORITHM__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Quant Size Ns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PFAIR__QUANT_SIZE_NS = TASK_SCHEDULING_ALGORITHM_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Pfair</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PFAIR_FEATURE_COUNT = TASK_SCHEDULING_ALGORITHM_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Pfair</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PFAIR_OPERATION_COUNT = TASK_SCHEDULING_ALGORITHM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.PfairPD2Impl <em>Pfair PD2</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.PfairPD2Impl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getPfairPD2()
	 * @generated
	 */
	int PFAIR_PD2 = 218;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PFAIR_PD2__CUSTOM_PROPERTIES = PFAIR__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Quant Size Ns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PFAIR_PD2__QUANT_SIZE_NS = PFAIR__QUANT_SIZE_NS;

	/**
	 * The number of structural features of the '<em>Pfair PD2</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PFAIR_PD2_FEATURE_COUNT = PFAIR_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Pfair PD2</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PFAIR_PD2_OPERATION_COUNT = PFAIR_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.PartlyPFairPD2Impl <em>Partly PFair PD2</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.PartlyPFairPD2Impl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getPartlyPFairPD2()
	 * @generated
	 */
	int PARTLY_PFAIR_PD2 = 219;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTLY_PFAIR_PD2__CUSTOM_PROPERTIES = PFAIR__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Quant Size Ns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTLY_PFAIR_PD2__QUANT_SIZE_NS = PFAIR__QUANT_SIZE_NS;

	/**
	 * The number of structural features of the '<em>Partly PFair PD2</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTLY_PFAIR_PD2_FEATURE_COUNT = PFAIR_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Partly PFair PD2</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTLY_PFAIR_PD2_OPERATION_COUNT = PFAIR_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.EarlyReleaseFairPD2Impl <em>Early Release Fair PD2</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.EarlyReleaseFairPD2Impl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getEarlyReleaseFairPD2()
	 * @generated
	 */
	int EARLY_RELEASE_FAIR_PD2 = 220;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EARLY_RELEASE_FAIR_PD2__CUSTOM_PROPERTIES = PFAIR__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Quant Size Ns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EARLY_RELEASE_FAIR_PD2__QUANT_SIZE_NS = PFAIR__QUANT_SIZE_NS;

	/**
	 * The number of structural features of the '<em>Early Release Fair PD2</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EARLY_RELEASE_FAIR_PD2_FEATURE_COUNT = PFAIR_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Early Release Fair PD2</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EARLY_RELEASE_FAIR_PD2_OPERATION_COUNT = PFAIR_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.PartlyEarlyReleaseFairPD2Impl <em>Partly Early Release Fair PD2</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.PartlyEarlyReleaseFairPD2Impl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getPartlyEarlyReleaseFairPD2()
	 * @generated
	 */
	int PARTLY_EARLY_RELEASE_FAIR_PD2 = 221;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTLY_EARLY_RELEASE_FAIR_PD2__CUSTOM_PROPERTIES = PFAIR__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Quant Size Ns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTLY_EARLY_RELEASE_FAIR_PD2__QUANT_SIZE_NS = PFAIR__QUANT_SIZE_NS;

	/**
	 * The number of structural features of the '<em>Partly Early Release Fair PD2</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTLY_EARLY_RELEASE_FAIR_PD2_FEATURE_COUNT = PFAIR_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Partly Early Release Fair PD2</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTLY_EARLY_RELEASE_FAIR_PD2_OPERATION_COUNT = PFAIR_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DynamicPriorityImpl <em>Dynamic Priority</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DynamicPriorityImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDynamicPriority()
	 * @generated
	 */
	int DYNAMIC_PRIORITY = 222;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_PRIORITY__CUSTOM_PROPERTIES = TASK_SCHEDULING_ALGORITHM__CUSTOM_PROPERTIES;

	/**
	 * The number of structural features of the '<em>Dynamic Priority</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_PRIORITY_FEATURE_COUNT = TASK_SCHEDULING_ALGORITHM_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Dynamic Priority</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_PRIORITY_OPERATION_COUNT = TASK_SCHEDULING_ALGORITHM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.LeastLocalRemainingExecutionTimeFirstImpl <em>Least Local Remaining Execution Time First</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.LeastLocalRemainingExecutionTimeFirstImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getLeastLocalRemainingExecutionTimeFirst()
	 * @generated
	 */
	int LEAST_LOCAL_REMAINING_EXECUTION_TIME_FIRST = 223;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEAST_LOCAL_REMAINING_EXECUTION_TIME_FIRST__CUSTOM_PROPERTIES = DYNAMIC_PRIORITY__CUSTOM_PROPERTIES;

	/**
	 * The number of structural features of the '<em>Least Local Remaining Execution Time First</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEAST_LOCAL_REMAINING_EXECUTION_TIME_FIRST_FEATURE_COUNT = DYNAMIC_PRIORITY_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Least Local Remaining Execution Time First</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEAST_LOCAL_REMAINING_EXECUTION_TIME_FIRST_OPERATION_COUNT = DYNAMIC_PRIORITY_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.EarliestDeadlineFirstImpl <em>Earliest Deadline First</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.EarliestDeadlineFirstImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getEarliestDeadlineFirst()
	 * @generated
	 */
	int EARLIEST_DEADLINE_FIRST = 224;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EARLIEST_DEADLINE_FIRST__CUSTOM_PROPERTIES = DYNAMIC_PRIORITY__CUSTOM_PROPERTIES;

	/**
	 * The number of structural features of the '<em>Earliest Deadline First</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EARLIEST_DEADLINE_FIRST_FEATURE_COUNT = DYNAMIC_PRIORITY_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Earliest Deadline First</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EARLIEST_DEADLINE_FIRST_OPERATION_COUNT = DYNAMIC_PRIORITY_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.PriorityBasedRoundRobinImpl <em>Priority Based Round Robin</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.PriorityBasedRoundRobinImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getPriorityBasedRoundRobin()
	 * @generated
	 */
	int PRIORITY_BASED_ROUND_ROBIN = 225;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIORITY_BASED_ROUND_ROBIN__CUSTOM_PROPERTIES = DYNAMIC_PRIORITY__CUSTOM_PROPERTIES;

	/**
	 * The number of structural features of the '<em>Priority Based Round Robin</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIORITY_BASED_ROUND_ROBIN_FEATURE_COUNT = DYNAMIC_PRIORITY_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Priority Based Round Robin</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIORITY_BASED_ROUND_ROBIN_OPERATION_COUNT = DYNAMIC_PRIORITY_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ReservationBasedServerImpl <em>Reservation Based Server</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ReservationBasedServerImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getReservationBasedServer()
	 * @generated
	 */
	int RESERVATION_BASED_SERVER = 226;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESERVATION_BASED_SERVER__CUSTOM_PROPERTIES = TASK_SCHEDULING_ALGORITHM__CUSTOM_PROPERTIES;

	/**
	 * The number of structural features of the '<em>Reservation Based Server</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESERVATION_BASED_SERVER_FEATURE_COUNT = TASK_SCHEDULING_ALGORITHM_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Reservation Based Server</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESERVATION_BASED_SERVER_OPERATION_COUNT = TASK_SCHEDULING_ALGORITHM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DeferrableServerImpl <em>Deferrable Server</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DeferrableServerImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDeferrableServer()
	 * @generated
	 */
	int DEFERRABLE_SERVER = 227;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFERRABLE_SERVER__CUSTOM_PROPERTIES = RESERVATION_BASED_SERVER__CUSTOM_PROPERTIES;

	/**
	 * The number of structural features of the '<em>Deferrable Server</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFERRABLE_SERVER_FEATURE_COUNT = RESERVATION_BASED_SERVER_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Deferrable Server</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFERRABLE_SERVER_OPERATION_COUNT = RESERVATION_BASED_SERVER_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.PollingPeriodicServerImpl <em>Polling Periodic Server</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.PollingPeriodicServerImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getPollingPeriodicServer()
	 * @generated
	 */
	int POLLING_PERIODIC_SERVER = 228;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLLING_PERIODIC_SERVER__CUSTOM_PROPERTIES = RESERVATION_BASED_SERVER__CUSTOM_PROPERTIES;

	/**
	 * The number of structural features of the '<em>Polling Periodic Server</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLLING_PERIODIC_SERVER_FEATURE_COUNT = RESERVATION_BASED_SERVER_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Polling Periodic Server</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLLING_PERIODIC_SERVER_OPERATION_COUNT = RESERVATION_BASED_SERVER_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.SporadicServerImpl <em>Sporadic Server</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.SporadicServerImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSporadicServer()
	 * @generated
	 */
	int SPORADIC_SERVER = 229;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPORADIC_SERVER__CUSTOM_PROPERTIES = RESERVATION_BASED_SERVER__CUSTOM_PROPERTIES;

	/**
	 * The number of structural features of the '<em>Sporadic Server</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPORADIC_SERVER_FEATURE_COUNT = RESERVATION_BASED_SERVER_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Sporadic Server</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPORADIC_SERVER_OPERATION_COUNT = RESERVATION_BASED_SERVER_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ConstantBandwidthServerImpl <em>Constant Bandwidth Server</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ConstantBandwidthServerImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getConstantBandwidthServer()
	 * @generated
	 */
	int CONSTANT_BANDWIDTH_SERVER = 230;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_BANDWIDTH_SERVER__CUSTOM_PROPERTIES = RESERVATION_BASED_SERVER__CUSTOM_PROPERTIES;

	/**
	 * The number of structural features of the '<em>Constant Bandwidth Server</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_BANDWIDTH_SERVER_FEATURE_COUNT = RESERVATION_BASED_SERVER_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Constant Bandwidth Server</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_BANDWIDTH_SERVER_OPERATION_COUNT = RESERVATION_BASED_SERVER_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ConstantBandwidthServerWithCASHImpl <em>Constant Bandwidth Server With CASH</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ConstantBandwidthServerWithCASHImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getConstantBandwidthServerWithCASH()
	 * @generated
	 */
	int CONSTANT_BANDWIDTH_SERVER_WITH_CASH = 231;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_BANDWIDTH_SERVER_WITH_CASH__CUSTOM_PROPERTIES = RESERVATION_BASED_SERVER__CUSTOM_PROPERTIES;

	/**
	 * The number of structural features of the '<em>Constant Bandwidth Server With CASH</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_BANDWIDTH_SERVER_WITH_CASH_FEATURE_COUNT = RESERVATION_BASED_SERVER_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Constant Bandwidth Server With CASH</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_BANDWIDTH_SERVER_WITH_CASH_OPERATION_COUNT = RESERVATION_BASED_SERVER_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.GroupingImpl <em>Grouping</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.GroupingImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getGrouping()
	 * @generated
	 */
	int GROUPING = 232;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GROUPING__CUSTOM_PROPERTIES = TASK_SCHEDULING_ALGORITHM__CUSTOM_PROPERTIES;

	/**
	 * The number of structural features of the '<em>Grouping</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GROUPING_FEATURE_COUNT = TASK_SCHEDULING_ALGORITHM_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Grouping</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GROUPING_OPERATION_COUNT = TASK_SCHEDULING_ALGORITHM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.UserSpecificSchedulingAlgorithmImpl <em>User Specific Scheduling Algorithm</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.UserSpecificSchedulingAlgorithmImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getUserSpecificSchedulingAlgorithm()
	 * @generated
	 */
	int USER_SPECIFIC_SCHEDULING_ALGORITHM = 233;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER_SPECIFIC_SCHEDULING_ALGORITHM__CUSTOM_PROPERTIES = TASK_SCHEDULING_ALGORITHM__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Parameter Extensions</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER_SPECIFIC_SCHEDULING_ALGORITHM__PARAMETER_EXTENSIONS = TASK_SCHEDULING_ALGORITHM_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>User Specific Scheduling Algorithm</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER_SPECIFIC_SCHEDULING_ALGORITHM_FEATURE_COUNT = TASK_SCHEDULING_ALGORITHM_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>User Specific Scheduling Algorithm</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER_SPECIFIC_SCHEDULING_ALGORITHM_OPERATION_COUNT = TASK_SCHEDULING_ALGORITHM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.PriorityBasedImpl <em>Priority Based</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.PriorityBasedImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getPriorityBased()
	 * @generated
	 */
	int PRIORITY_BASED = 234;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIORITY_BASED__CUSTOM_PROPERTIES = INTERRUPT_SCHEDULING_ALGORITHM__CUSTOM_PROPERTIES;

	/**
	 * The number of structural features of the '<em>Priority Based</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIORITY_BASED_FEATURE_COUNT = INTERRUPT_SCHEDULING_ALGORITHM_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Priority Based</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIORITY_BASED_OPERATION_COUNT = INTERRUPT_SCHEDULING_ALGORITHM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.OperatingSystemImpl <em>Operating System</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.OperatingSystemImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getOperatingSystem()
	 * @generated
	 */
	int OPERATING_SYSTEM = 235;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATING_SYSTEM__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATING_SYSTEM__NAME = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Overhead</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATING_SYSTEM__OVERHEAD = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Task Schedulers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATING_SYSTEM__TASK_SCHEDULERS = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Interrupt Controllers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATING_SYSTEM__INTERRUPT_CONTROLLERS = BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Os Data Consistency</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATING_SYSTEM__OS_DATA_CONSISTENCY = BASE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Operating System</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATING_SYSTEM_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 5;

	/**
	 * The number of operations of the '<em>Operating System</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATING_SYSTEM_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.VendorOperatingSystemImpl <em>Vendor Operating System</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.VendorOperatingSystemImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getVendorOperatingSystem()
	 * @generated
	 */
	int VENDOR_OPERATING_SYSTEM = 236;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VENDOR_OPERATING_SYSTEM__CUSTOM_PROPERTIES = OPERATING_SYSTEM__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VENDOR_OPERATING_SYSTEM__NAME = OPERATING_SYSTEM__NAME;

	/**
	 * The feature id for the '<em><b>Overhead</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VENDOR_OPERATING_SYSTEM__OVERHEAD = OPERATING_SYSTEM__OVERHEAD;

	/**
	 * The feature id for the '<em><b>Task Schedulers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VENDOR_OPERATING_SYSTEM__TASK_SCHEDULERS = OPERATING_SYSTEM__TASK_SCHEDULERS;

	/**
	 * The feature id for the '<em><b>Interrupt Controllers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VENDOR_OPERATING_SYSTEM__INTERRUPT_CONTROLLERS = OPERATING_SYSTEM__INTERRUPT_CONTROLLERS;

	/**
	 * The feature id for the '<em><b>Os Data Consistency</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VENDOR_OPERATING_SYSTEM__OS_DATA_CONSISTENCY = OPERATING_SYSTEM__OS_DATA_CONSISTENCY;

	/**
	 * The feature id for the '<em><b>Os Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VENDOR_OPERATING_SYSTEM__OS_NAME = OPERATING_SYSTEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Vendor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VENDOR_OPERATING_SYSTEM__VENDOR = OPERATING_SYSTEM_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VENDOR_OPERATING_SYSTEM__VERSION = OPERATING_SYSTEM_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Vendor Operating System</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VENDOR_OPERATING_SYSTEM_FEATURE_COUNT = OPERATING_SYSTEM_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Vendor Operating System</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VENDOR_OPERATING_SYSTEM_OPERATION_COUNT = OPERATING_SYSTEM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.OsOverheadImpl <em>Os Overhead</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.OsOverheadImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getOsOverhead()
	 * @generated
	 */
	int OS_OVERHEAD = 237;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_OVERHEAD__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_OVERHEAD__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_OVERHEAD__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Api Overhead</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_OVERHEAD__API_OVERHEAD = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Isr Category1 Overhead</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_OVERHEAD__ISR_CATEGORY1_OVERHEAD = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Isr Category2 Overhead</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_OVERHEAD__ISR_CATEGORY2_OVERHEAD = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Os Overhead</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_OVERHEAD_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_OVERHEAD___COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_OVERHEAD___BASIC_COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_OVERHEAD___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_OVERHEAD___ENCODE__STRING = REFERABLE_BASE_OBJECT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Os Overhead</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_OVERHEAD_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.OsAPIOverheadImpl <em>Os API Overhead</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.OsAPIOverheadImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getOsAPIOverhead()
	 * @generated
	 */
	int OS_API_OVERHEAD = 238;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_API_OVERHEAD__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Api Send Message</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_API_OVERHEAD__API_SEND_MESSAGE = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Api Terminate Task</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_API_OVERHEAD__API_TERMINATE_TASK = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Api Schedule</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_API_OVERHEAD__API_SCHEDULE = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Api Request Resource</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_API_OVERHEAD__API_REQUEST_RESOURCE = BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Api Release Resource</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_API_OVERHEAD__API_RELEASE_RESOURCE = BASE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Api Set Event</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_API_OVERHEAD__API_SET_EVENT = BASE_OBJECT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Api Wait Event</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_API_OVERHEAD__API_WAIT_EVENT = BASE_OBJECT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Api Clear Event</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_API_OVERHEAD__API_CLEAR_EVENT = BASE_OBJECT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Api Activate Task</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_API_OVERHEAD__API_ACTIVATE_TASK = BASE_OBJECT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Api Enforced Migration</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_API_OVERHEAD__API_ENFORCED_MIGRATION = BASE_OBJECT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Api Suspend Os Interrupts</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_API_OVERHEAD__API_SUSPEND_OS_INTERRUPTS = BASE_OBJECT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Api Resume Os Interrupts</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_API_OVERHEAD__API_RESUME_OS_INTERRUPTS = BASE_OBJECT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Api Request Spinlock</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_API_OVERHEAD__API_REQUEST_SPINLOCK = BASE_OBJECT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Api Release Spinlock</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_API_OVERHEAD__API_RELEASE_SPINLOCK = BASE_OBJECT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Api Sender Receiver Read</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_API_OVERHEAD__API_SENDER_RECEIVER_READ = BASE_OBJECT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Api Sender Receiver Write</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_API_OVERHEAD__API_SENDER_RECEIVER_WRITE = BASE_OBJECT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Api Synchronous Server Call Point</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_API_OVERHEAD__API_SYNCHRONOUS_SERVER_CALL_POINT = BASE_OBJECT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Api Ioc Read</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_API_OVERHEAD__API_IOC_READ = BASE_OBJECT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Api Ioc Write</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_API_OVERHEAD__API_IOC_WRITE = BASE_OBJECT_FEATURE_COUNT + 18;

	/**
	 * The number of structural features of the '<em>Os API Overhead</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_API_OVERHEAD_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 19;

	/**
	 * The number of operations of the '<em>Os API Overhead</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_API_OVERHEAD_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.OsISROverheadImpl <em>Os ISR Overhead</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.OsISROverheadImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getOsISROverhead()
	 * @generated
	 */
	int OS_ISR_OVERHEAD = 239;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_ISR_OVERHEAD__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Pre Execution Overhead</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_ISR_OVERHEAD__PRE_EXECUTION_OVERHEAD = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Post Execution Overhead</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_ISR_OVERHEAD__POST_EXECUTION_OVERHEAD = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Os ISR Overhead</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_ISR_OVERHEAD_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Os ISR Overhead</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_ISR_OVERHEAD_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.PropertyConstraintsModelImpl <em>Property Constraints Model</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.PropertyConstraintsModelImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getPropertyConstraintsModel()
	 * @generated
	 */
	int PROPERTY_CONSTRAINTS_MODEL = 240;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_CONSTRAINTS_MODEL__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Allocation Constraints</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_CONSTRAINTS_MODEL__ALLOCATION_CONSTRAINTS = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Mapping Constraints</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_CONSTRAINTS_MODEL__MAPPING_CONSTRAINTS = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Property Constraints Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_CONSTRAINTS_MODEL_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Property Constraints Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_CONSTRAINTS_MODEL_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.CoreAllocationConstraintImpl <em>Core Allocation Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.CoreAllocationConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getCoreAllocationConstraint()
	 * @generated
	 */
	int CORE_ALLOCATION_CONSTRAINT = 241;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_ALLOCATION_CONSTRAINT__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Core Classification</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_ALLOCATION_CONSTRAINT__CORE_CLASSIFICATION = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Core Allocation Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_ALLOCATION_CONSTRAINT_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Core Allocation Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_ALLOCATION_CONSTRAINT_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.MemoryMappingConstraintImpl <em>Memory Mapping Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.MemoryMappingConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getMemoryMappingConstraint()
	 * @generated
	 */
	int MEMORY_MAPPING_CONSTRAINT = 242;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_MAPPING_CONSTRAINT__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Memory Classification</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_MAPPING_CONSTRAINT__MEMORY_CLASSIFICATION = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Memory Mapping Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_MAPPING_CONSTRAINT_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Memory Mapping Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_MAPPING_CONSTRAINT_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ProcessAllocationConstraintImpl <em>Process Allocation Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ProcessAllocationConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getProcessAllocationConstraint()
	 * @generated
	 */
	int PROCESS_ALLOCATION_CONSTRAINT = 243;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_ALLOCATION_CONSTRAINT__CUSTOM_PROPERTIES = CORE_ALLOCATION_CONSTRAINT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Core Classification</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_ALLOCATION_CONSTRAINT__CORE_CLASSIFICATION = CORE_ALLOCATION_CONSTRAINT__CORE_CLASSIFICATION;

	/**
	 * The feature id for the '<em><b>Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_ALLOCATION_CONSTRAINT__PROCESS = CORE_ALLOCATION_CONSTRAINT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Process Allocation Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_ALLOCATION_CONSTRAINT_FEATURE_COUNT = CORE_ALLOCATION_CONSTRAINT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Process Allocation Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_ALLOCATION_CONSTRAINT_OPERATION_COUNT = CORE_ALLOCATION_CONSTRAINT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ProcessPrototypeAllocationConstraintImpl <em>Process Prototype Allocation Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ProcessPrototypeAllocationConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getProcessPrototypeAllocationConstraint()
	 * @generated
	 */
	int PROCESS_PROTOTYPE_ALLOCATION_CONSTRAINT = 244;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE_ALLOCATION_CONSTRAINT__CUSTOM_PROPERTIES = CORE_ALLOCATION_CONSTRAINT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Core Classification</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE_ALLOCATION_CONSTRAINT__CORE_CLASSIFICATION = CORE_ALLOCATION_CONSTRAINT__CORE_CLASSIFICATION;

	/**
	 * The feature id for the '<em><b>Process Prototype</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE_ALLOCATION_CONSTRAINT__PROCESS_PROTOTYPE = CORE_ALLOCATION_CONSTRAINT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Process Prototype Allocation Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE_ALLOCATION_CONSTRAINT_FEATURE_COUNT = CORE_ALLOCATION_CONSTRAINT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Process Prototype Allocation Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE_ALLOCATION_CONSTRAINT_OPERATION_COUNT = CORE_ALLOCATION_CONSTRAINT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.RunnableAllocationConstraintImpl <em>Runnable Allocation Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.RunnableAllocationConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getRunnableAllocationConstraint()
	 * @generated
	 */
	int RUNNABLE_ALLOCATION_CONSTRAINT = 245;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_ALLOCATION_CONSTRAINT__CUSTOM_PROPERTIES = CORE_ALLOCATION_CONSTRAINT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Core Classification</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_ALLOCATION_CONSTRAINT__CORE_CLASSIFICATION = CORE_ALLOCATION_CONSTRAINT__CORE_CLASSIFICATION;

	/**
	 * The feature id for the '<em><b>Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_ALLOCATION_CONSTRAINT__RUNNABLE = CORE_ALLOCATION_CONSTRAINT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Runnable Allocation Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_ALLOCATION_CONSTRAINT_FEATURE_COUNT = CORE_ALLOCATION_CONSTRAINT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Runnable Allocation Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_ALLOCATION_CONSTRAINT_OPERATION_COUNT = CORE_ALLOCATION_CONSTRAINT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.AbstractElementMappingConstraintImpl <em>Abstract Element Mapping Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.AbstractElementMappingConstraintImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getAbstractElementMappingConstraint()
	 * @generated
	 */
	int ABSTRACT_ELEMENT_MAPPING_CONSTRAINT = 246;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_ELEMENT_MAPPING_CONSTRAINT__CUSTOM_PROPERTIES = MEMORY_MAPPING_CONSTRAINT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Memory Classification</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_ELEMENT_MAPPING_CONSTRAINT__MEMORY_CLASSIFICATION = MEMORY_MAPPING_CONSTRAINT__MEMORY_CLASSIFICATION;

	/**
	 * The feature id for the '<em><b>Abstract Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_ELEMENT_MAPPING_CONSTRAINT__ABSTRACT_ELEMENT = MEMORY_MAPPING_CONSTRAINT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Abstract Element Mapping Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_ELEMENT_MAPPING_CONSTRAINT_FEATURE_COUNT = MEMORY_MAPPING_CONSTRAINT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Abstract Element Mapping Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_ELEMENT_MAPPING_CONSTRAINT_OPERATION_COUNT = MEMORY_MAPPING_CONSTRAINT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ClassificationImpl <em>Classification</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ClassificationImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getClassification()
	 * @generated
	 */
	int CLASSIFICATION = 247;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASSIFICATION__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Condition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASSIFICATION__CONDITION = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Grouping</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASSIFICATION__GROUPING = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Classification</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASSIFICATION_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Classification</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASSIFICATION_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.CoreClassificationImpl <em>Core Classification</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.CoreClassificationImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getCoreClassification()
	 * @generated
	 */
	int CORE_CLASSIFICATION = 248;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_CLASSIFICATION__CUSTOM_PROPERTIES = CLASSIFICATION__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Condition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_CLASSIFICATION__CONDITION = CLASSIFICATION__CONDITION;

	/**
	 * The feature id for the '<em><b>Grouping</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_CLASSIFICATION__GROUPING = CLASSIFICATION__GROUPING;

	/**
	 * The feature id for the '<em><b>Classifiers</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_CLASSIFICATION__CLASSIFIERS = CLASSIFICATION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Core Classification</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_CLASSIFICATION_FEATURE_COUNT = CLASSIFICATION_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Core Classification</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORE_CLASSIFICATION_OPERATION_COUNT = CLASSIFICATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.MemoryClassificationImpl <em>Memory Classification</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.MemoryClassificationImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getMemoryClassification()
	 * @generated
	 */
	int MEMORY_CLASSIFICATION = 249;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_CLASSIFICATION__CUSTOM_PROPERTIES = CLASSIFICATION__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Condition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_CLASSIFICATION__CONDITION = CLASSIFICATION__CONDITION;

	/**
	 * The feature id for the '<em><b>Grouping</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_CLASSIFICATION__GROUPING = CLASSIFICATION__GROUPING;

	/**
	 * The feature id for the '<em><b>Classifiers</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_CLASSIFICATION__CLASSIFIERS = CLASSIFICATION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Memory Classification</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_CLASSIFICATION_FEATURE_COUNT = CLASSIFICATION_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Memory Classification</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_CLASSIFICATION_OPERATION_COUNT = CLASSIFICATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.StimuliModelImpl <em>Stimuli Model</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.StimuliModelImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getStimuliModel()
	 * @generated
	 */
	int STIMULI_MODEL = 250;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULI_MODEL__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Stimuli</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULI_MODEL__STIMULI = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Clocks</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULI_MODEL__CLOCKS = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Stimuli Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULI_MODEL_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Stimuli Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULI_MODEL_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.StimulusImpl <em>Stimulus</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.StimulusImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getStimulus()
	 * @generated
	 */
	int STIMULUS = 251;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS__TAGS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Set Mode Value List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS__SET_MODE_VALUE_LIST = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Enabling Mode Value List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS__ENABLING_MODE_VALUE_LIST = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Disabling Mode Value List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS__DISABLING_MODE_VALUE_LIST = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Affected Processes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS__AFFECTED_PROCESSES = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Stimulus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 5;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS___COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS___BASIC_COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS___ENCODE__STRING = REFERABLE_BASE_OBJECT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Stimulus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STIMULUS_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ModeValueListImpl <em>Mode Value List</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ModeValueListImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getModeValueList()
	 * @generated
	 */
	int MODE_VALUE_LIST = 252;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE_LIST__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Entries</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE_LIST__ENTRIES = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Mode Value List</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE_LIST_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Mode Value List</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE_LIST_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ModeValueMapEntryImpl <em>Mode Value Map Entry</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ModeValueMapEntryImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getModeValueMapEntry()
	 * @generated
	 */
	int MODE_VALUE_MAP_ENTRY = 253;

	/**
	 * The feature id for the '<em><b>Key</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE_MAP_ENTRY__KEY = 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE_MAP_ENTRY__VALUE = 1;

	/**
	 * The number of structural features of the '<em>Mode Value Map Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE_MAP_ENTRY_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Mode Value Map Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE_MAP_ENTRY_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ModeValueDisjunctionImpl <em>Mode Value Disjunction</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ModeValueDisjunctionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getModeValueDisjunction()
	 * @generated
	 */
	int MODE_VALUE_DISJUNCTION = 254;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE_DISJUNCTION__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Entries</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE_DISJUNCTION__ENTRIES = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Mode Value Disjunction</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE_DISJUNCTION_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Is Satisfied By</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE_DISJUNCTION___IS_SATISFIED_BY__EMAP = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Mode Value Disjunction</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE_DISJUNCTION_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ModeValueDisjunctionEntryImpl <em>Mode Value Disjunction Entry</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ModeValueDisjunctionEntryImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getModeValueDisjunctionEntry()
	 * @generated
	 */
	int MODE_VALUE_DISJUNCTION_ENTRY = 255;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE_DISJUNCTION_ENTRY__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The number of structural features of the '<em>Mode Value Disjunction Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE_DISJUNCTION_ENTRY_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Is Satisfied By</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE_DISJUNCTION_ENTRY___IS_SATISFIED_BY__EMAP = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Mode Value Disjunction Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE_DISJUNCTION_ENTRY_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ModeValueImpl <em>Mode Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ModeValueImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getModeValue()
	 * @generated
	 */
	int MODE_VALUE = 256;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE__CUSTOM_PROPERTIES = MODE_VALUE_DISJUNCTION_ENTRY__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Value Provider</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE__VALUE_PROVIDER = MODE_VALUE_DISJUNCTION_ENTRY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE__VALUE = MODE_VALUE_DISJUNCTION_ENTRY_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Mode Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE_FEATURE_COUNT = MODE_VALUE_DISJUNCTION_ENTRY_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Is Satisfied By</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE___IS_SATISFIED_BY__EMAP = MODE_VALUE_DISJUNCTION_ENTRY_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Mode Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE_OPERATION_COUNT = MODE_VALUE_DISJUNCTION_ENTRY_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ModeValueConjunctionImpl <em>Mode Value Conjunction</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ModeValueConjunctionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getModeValueConjunction()
	 * @generated
	 */
	int MODE_VALUE_CONJUNCTION = 257;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE_CONJUNCTION__CUSTOM_PROPERTIES = MODE_VALUE_DISJUNCTION_ENTRY__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Entries</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE_CONJUNCTION__ENTRIES = MODE_VALUE_DISJUNCTION_ENTRY_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Mode Value Conjunction</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE_CONJUNCTION_FEATURE_COUNT = MODE_VALUE_DISJUNCTION_ENTRY_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Is Satisfied By</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE_CONJUNCTION___IS_SATISFIED_BY__EMAP = MODE_VALUE_DISJUNCTION_ENTRY_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Mode Value Conjunction</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_VALUE_CONJUNCTION_OPERATION_COUNT = MODE_VALUE_DISJUNCTION_ENTRY_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.FixedPeriodic <em>Fixed Periodic</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.FixedPeriodic
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getFixedPeriodic()
	 * @generated
	 */
	int FIXED_PERIODIC = 258;

	/**
	 * The feature id for the '<em><b>Offset</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FIXED_PERIODIC__OFFSET = 0;

	/**
	 * The feature id for the '<em><b>Recurrence</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FIXED_PERIODIC__RECURRENCE = 1;

	/**
	 * The number of structural features of the '<em>Fixed Periodic</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FIXED_PERIODIC_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Fixed Periodic</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FIXED_PERIODIC_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.PeriodicStimulusImpl <em>Periodic Stimulus</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.PeriodicStimulusImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getPeriodicStimulus()
	 * @generated
	 */
	int PERIODIC_STIMULUS = 259;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_STIMULUS__CUSTOM_PROPERTIES = STIMULUS__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_STIMULUS__NAME = STIMULUS__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_STIMULUS__UNIQUE_NAME = STIMULUS__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_STIMULUS__TAGS = STIMULUS__TAGS;

	/**
	 * The feature id for the '<em><b>Set Mode Value List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_STIMULUS__SET_MODE_VALUE_LIST = STIMULUS__SET_MODE_VALUE_LIST;

	/**
	 * The feature id for the '<em><b>Enabling Mode Value List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_STIMULUS__ENABLING_MODE_VALUE_LIST = STIMULUS__ENABLING_MODE_VALUE_LIST;

	/**
	 * The feature id for the '<em><b>Disabling Mode Value List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_STIMULUS__DISABLING_MODE_VALUE_LIST = STIMULUS__DISABLING_MODE_VALUE_LIST;

	/**
	 * The feature id for the '<em><b>Affected Processes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_STIMULUS__AFFECTED_PROCESSES = STIMULUS__AFFECTED_PROCESSES;

	/**
	 * The feature id for the '<em><b>Offset</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_STIMULUS__OFFSET = STIMULUS_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Recurrence</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_STIMULUS__RECURRENCE = STIMULUS_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Jitter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_STIMULUS__JITTER = STIMULUS_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Min Distance</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_STIMULUS__MIN_DISTANCE = STIMULUS_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Periodic Stimulus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_STIMULUS_FEATURE_COUNT = STIMULUS_FEATURE_COUNT + 4;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_STIMULUS___COMPUTE_UNIQUE_NAME = STIMULUS___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_STIMULUS___BASIC_COMPUTE_UNIQUE_NAME = STIMULUS___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_STIMULUS___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = STIMULUS___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_STIMULUS___ENCODE__STRING = STIMULUS___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Periodic Stimulus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_STIMULUS_OPERATION_COUNT = STIMULUS_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.RelativePeriodicStimulusImpl <em>Relative Periodic Stimulus</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.RelativePeriodicStimulusImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getRelativePeriodicStimulus()
	 * @generated
	 */
	int RELATIVE_PERIODIC_STIMULUS = 260;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIVE_PERIODIC_STIMULUS__CUSTOM_PROPERTIES = STIMULUS__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIVE_PERIODIC_STIMULUS__NAME = STIMULUS__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIVE_PERIODIC_STIMULUS__UNIQUE_NAME = STIMULUS__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIVE_PERIODIC_STIMULUS__TAGS = STIMULUS__TAGS;

	/**
	 * The feature id for the '<em><b>Set Mode Value List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIVE_PERIODIC_STIMULUS__SET_MODE_VALUE_LIST = STIMULUS__SET_MODE_VALUE_LIST;

	/**
	 * The feature id for the '<em><b>Enabling Mode Value List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIVE_PERIODIC_STIMULUS__ENABLING_MODE_VALUE_LIST = STIMULUS__ENABLING_MODE_VALUE_LIST;

	/**
	 * The feature id for the '<em><b>Disabling Mode Value List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIVE_PERIODIC_STIMULUS__DISABLING_MODE_VALUE_LIST = STIMULUS__DISABLING_MODE_VALUE_LIST;

	/**
	 * The feature id for the '<em><b>Affected Processes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIVE_PERIODIC_STIMULUS__AFFECTED_PROCESSES = STIMULUS__AFFECTED_PROCESSES;

	/**
	 * The feature id for the '<em><b>Offset</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIVE_PERIODIC_STIMULUS__OFFSET = STIMULUS_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Next Occurrence</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIVE_PERIODIC_STIMULUS__NEXT_OCCURRENCE = STIMULUS_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Relative Periodic Stimulus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIVE_PERIODIC_STIMULUS_FEATURE_COUNT = STIMULUS_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIVE_PERIODIC_STIMULUS___COMPUTE_UNIQUE_NAME = STIMULUS___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIVE_PERIODIC_STIMULUS___BASIC_COMPUTE_UNIQUE_NAME = STIMULUS___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIVE_PERIODIC_STIMULUS___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = STIMULUS___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIVE_PERIODIC_STIMULUS___ENCODE__STRING = STIMULUS___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Relative Periodic Stimulus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIVE_PERIODIC_STIMULUS_OPERATION_COUNT = STIMULUS_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.VariableRateStimulusImpl <em>Variable Rate Stimulus</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.VariableRateStimulusImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getVariableRateStimulus()
	 * @generated
	 */
	int VARIABLE_RATE_STIMULUS = 261;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_STIMULUS__CUSTOM_PROPERTIES = STIMULUS__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_STIMULUS__NAME = STIMULUS__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_STIMULUS__UNIQUE_NAME = STIMULUS__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_STIMULUS__TAGS = STIMULUS__TAGS;

	/**
	 * The feature id for the '<em><b>Set Mode Value List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_STIMULUS__SET_MODE_VALUE_LIST = STIMULUS__SET_MODE_VALUE_LIST;

	/**
	 * The feature id for the '<em><b>Enabling Mode Value List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_STIMULUS__ENABLING_MODE_VALUE_LIST = STIMULUS__ENABLING_MODE_VALUE_LIST;

	/**
	 * The feature id for the '<em><b>Disabling Mode Value List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_STIMULUS__DISABLING_MODE_VALUE_LIST = STIMULUS__DISABLING_MODE_VALUE_LIST;

	/**
	 * The feature id for the '<em><b>Affected Processes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_STIMULUS__AFFECTED_PROCESSES = STIMULUS__AFFECTED_PROCESSES;

	/**
	 * The feature id for the '<em><b>Step</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_STIMULUS__STEP = STIMULUS_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Occurrences Per Step</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_STIMULUS__OCCURRENCES_PER_STEP = STIMULUS_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Max Increase Per Step</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_STIMULUS__MAX_INCREASE_PER_STEP = STIMULUS_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Max Decrease Per Step</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_STIMULUS__MAX_DECREASE_PER_STEP = STIMULUS_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Scenario</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_STIMULUS__SCENARIO = STIMULUS_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Variable Rate Stimulus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_STIMULUS_FEATURE_COUNT = STIMULUS_FEATURE_COUNT + 5;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_STIMULUS___COMPUTE_UNIQUE_NAME = STIMULUS___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_STIMULUS___BASIC_COMPUTE_UNIQUE_NAME = STIMULUS___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_STIMULUS___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = STIMULUS___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_STIMULUS___ENCODE__STRING = STIMULUS___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Variable Rate Stimulus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_STIMULUS_OPERATION_COUNT = STIMULUS_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ScenarioImpl <em>Scenario</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ScenarioImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getScenario()
	 * @generated
	 */
	int SCENARIO = 262;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCENARIO__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Recurrence</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCENARIO__RECURRENCE = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Clock</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCENARIO__CLOCK = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Scenario</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCENARIO_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Scenario</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCENARIO_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.PeriodicSyntheticStimulusImpl <em>Periodic Synthetic Stimulus</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.PeriodicSyntheticStimulusImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getPeriodicSyntheticStimulus()
	 * @generated
	 */
	int PERIODIC_SYNTHETIC_STIMULUS = 263;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_SYNTHETIC_STIMULUS__CUSTOM_PROPERTIES = STIMULUS__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_SYNTHETIC_STIMULUS__NAME = STIMULUS__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_SYNTHETIC_STIMULUS__UNIQUE_NAME = STIMULUS__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_SYNTHETIC_STIMULUS__TAGS = STIMULUS__TAGS;

	/**
	 * The feature id for the '<em><b>Set Mode Value List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_SYNTHETIC_STIMULUS__SET_MODE_VALUE_LIST = STIMULUS__SET_MODE_VALUE_LIST;

	/**
	 * The feature id for the '<em><b>Enabling Mode Value List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_SYNTHETIC_STIMULUS__ENABLING_MODE_VALUE_LIST = STIMULUS__ENABLING_MODE_VALUE_LIST;

	/**
	 * The feature id for the '<em><b>Disabling Mode Value List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_SYNTHETIC_STIMULUS__DISABLING_MODE_VALUE_LIST = STIMULUS__DISABLING_MODE_VALUE_LIST;

	/**
	 * The feature id for the '<em><b>Affected Processes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_SYNTHETIC_STIMULUS__AFFECTED_PROCESSES = STIMULUS__AFFECTED_PROCESSES;

	/**
	 * The feature id for the '<em><b>Offset</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_SYNTHETIC_STIMULUS__OFFSET = STIMULUS_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Recurrence</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_SYNTHETIC_STIMULUS__RECURRENCE = STIMULUS_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Occurrence Times</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_SYNTHETIC_STIMULUS__OCCURRENCE_TIMES = STIMULUS_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Periodic Synthetic Stimulus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_SYNTHETIC_STIMULUS_FEATURE_COUNT = STIMULUS_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_SYNTHETIC_STIMULUS___COMPUTE_UNIQUE_NAME = STIMULUS___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_SYNTHETIC_STIMULUS___BASIC_COMPUTE_UNIQUE_NAME = STIMULUS___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_SYNTHETIC_STIMULUS___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = STIMULUS___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_SYNTHETIC_STIMULUS___ENCODE__STRING = STIMULUS___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Periodic Synthetic Stimulus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_SYNTHETIC_STIMULUS_OPERATION_COUNT = STIMULUS_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.CustomStimulusImpl <em>Custom Stimulus</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.CustomStimulusImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getCustomStimulus()
	 * @generated
	 */
	int CUSTOM_STIMULUS = 264;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_STIMULUS__CUSTOM_PROPERTIES = STIMULUS__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_STIMULUS__NAME = STIMULUS__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_STIMULUS__UNIQUE_NAME = STIMULUS__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_STIMULUS__TAGS = STIMULUS__TAGS;

	/**
	 * The feature id for the '<em><b>Set Mode Value List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_STIMULUS__SET_MODE_VALUE_LIST = STIMULUS__SET_MODE_VALUE_LIST;

	/**
	 * The feature id for the '<em><b>Enabling Mode Value List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_STIMULUS__ENABLING_MODE_VALUE_LIST = STIMULUS__ENABLING_MODE_VALUE_LIST;

	/**
	 * The feature id for the '<em><b>Disabling Mode Value List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_STIMULUS__DISABLING_MODE_VALUE_LIST = STIMULUS__DISABLING_MODE_VALUE_LIST;

	/**
	 * The feature id for the '<em><b>Affected Processes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_STIMULUS__AFFECTED_PROCESSES = STIMULUS__AFFECTED_PROCESSES;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_STIMULUS__DESCRIPTION = STIMULUS_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Custom Stimulus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_STIMULUS_FEATURE_COUNT = STIMULUS_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_STIMULUS___COMPUTE_UNIQUE_NAME = STIMULUS___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_STIMULUS___BASIC_COMPUTE_UNIQUE_NAME = STIMULUS___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_STIMULUS___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = STIMULUS___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_STIMULUS___ENCODE__STRING = STIMULUS___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Custom Stimulus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_STIMULUS_OPERATION_COUNT = STIMULUS_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.SingleStimulusImpl <em>Single Stimulus</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.SingleStimulusImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSingleStimulus()
	 * @generated
	 */
	int SINGLE_STIMULUS = 265;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_STIMULUS__CUSTOM_PROPERTIES = STIMULUS__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_STIMULUS__NAME = STIMULUS__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_STIMULUS__UNIQUE_NAME = STIMULUS__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_STIMULUS__TAGS = STIMULUS__TAGS;

	/**
	 * The feature id for the '<em><b>Set Mode Value List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_STIMULUS__SET_MODE_VALUE_LIST = STIMULUS__SET_MODE_VALUE_LIST;

	/**
	 * The feature id for the '<em><b>Enabling Mode Value List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_STIMULUS__ENABLING_MODE_VALUE_LIST = STIMULUS__ENABLING_MODE_VALUE_LIST;

	/**
	 * The feature id for the '<em><b>Disabling Mode Value List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_STIMULUS__DISABLING_MODE_VALUE_LIST = STIMULUS__DISABLING_MODE_VALUE_LIST;

	/**
	 * The feature id for the '<em><b>Affected Processes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_STIMULUS__AFFECTED_PROCESSES = STIMULUS__AFFECTED_PROCESSES;

	/**
	 * The feature id for the '<em><b>Occurrence</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_STIMULUS__OCCURRENCE = STIMULUS_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Single Stimulus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_STIMULUS_FEATURE_COUNT = STIMULUS_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_STIMULUS___COMPUTE_UNIQUE_NAME = STIMULUS___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_STIMULUS___BASIC_COMPUTE_UNIQUE_NAME = STIMULUS___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_STIMULUS___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = STIMULUS___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_STIMULUS___ENCODE__STRING = STIMULUS___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Single Stimulus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_STIMULUS_OPERATION_COUNT = STIMULUS_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.InterProcessStimulusImpl <em>Inter Process Stimulus</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.InterProcessStimulusImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getInterProcessStimulus()
	 * @generated
	 */
	int INTER_PROCESS_STIMULUS = 266;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_STIMULUS__CUSTOM_PROPERTIES = STIMULUS__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_STIMULUS__NAME = STIMULUS__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_STIMULUS__UNIQUE_NAME = STIMULUS__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_STIMULUS__TAGS = STIMULUS__TAGS;

	/**
	 * The feature id for the '<em><b>Set Mode Value List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_STIMULUS__SET_MODE_VALUE_LIST = STIMULUS__SET_MODE_VALUE_LIST;

	/**
	 * The feature id for the '<em><b>Enabling Mode Value List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_STIMULUS__ENABLING_MODE_VALUE_LIST = STIMULUS__ENABLING_MODE_VALUE_LIST;

	/**
	 * The feature id for the '<em><b>Disabling Mode Value List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_STIMULUS__DISABLING_MODE_VALUE_LIST = STIMULUS__DISABLING_MODE_VALUE_LIST;

	/**
	 * The feature id for the '<em><b>Affected Processes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_STIMULUS__AFFECTED_PROCESSES = STIMULUS__AFFECTED_PROCESSES;

	/**
	 * The feature id for the '<em><b>Counter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_STIMULUS__COUNTER = STIMULUS_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Explicit Triggers</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_STIMULUS__EXPLICIT_TRIGGERS = STIMULUS_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Inter Process Stimulus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_STIMULUS_FEATURE_COUNT = STIMULUS_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_STIMULUS___COMPUTE_UNIQUE_NAME = STIMULUS___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_STIMULUS___BASIC_COMPUTE_UNIQUE_NAME = STIMULUS___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_STIMULUS___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = STIMULUS___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_STIMULUS___ENCODE__STRING = STIMULUS___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Inter Process Stimulus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_STIMULUS_OPERATION_COUNT = STIMULUS_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.PeriodicBurstStimulusImpl <em>Periodic Burst Stimulus</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.PeriodicBurstStimulusImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getPeriodicBurstStimulus()
	 * @generated
	 */
	int PERIODIC_BURST_STIMULUS = 267;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BURST_STIMULUS__CUSTOM_PROPERTIES = STIMULUS__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BURST_STIMULUS__NAME = STIMULUS__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BURST_STIMULUS__UNIQUE_NAME = STIMULUS__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BURST_STIMULUS__TAGS = STIMULUS__TAGS;

	/**
	 * The feature id for the '<em><b>Set Mode Value List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BURST_STIMULUS__SET_MODE_VALUE_LIST = STIMULUS__SET_MODE_VALUE_LIST;

	/**
	 * The feature id for the '<em><b>Enabling Mode Value List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BURST_STIMULUS__ENABLING_MODE_VALUE_LIST = STIMULUS__ENABLING_MODE_VALUE_LIST;

	/**
	 * The feature id for the '<em><b>Disabling Mode Value List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BURST_STIMULUS__DISABLING_MODE_VALUE_LIST = STIMULUS__DISABLING_MODE_VALUE_LIST;

	/**
	 * The feature id for the '<em><b>Affected Processes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BURST_STIMULUS__AFFECTED_PROCESSES = STIMULUS__AFFECTED_PROCESSES;

	/**
	 * The feature id for the '<em><b>Offset</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BURST_STIMULUS__OFFSET = STIMULUS_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Recurrence</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BURST_STIMULUS__RECURRENCE = STIMULUS_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Burst Length</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BURST_STIMULUS__BURST_LENGTH = STIMULUS_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Occurrence Min Distance</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BURST_STIMULUS__OCCURRENCE_MIN_DISTANCE = STIMULUS_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Occurrence Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BURST_STIMULUS__OCCURRENCE_COUNT = STIMULUS_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Periodic Burst Stimulus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BURST_STIMULUS_FEATURE_COUNT = STIMULUS_FEATURE_COUNT + 5;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BURST_STIMULUS___COMPUTE_UNIQUE_NAME = STIMULUS___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BURST_STIMULUS___BASIC_COMPUTE_UNIQUE_NAME = STIMULUS___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BURST_STIMULUS___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = STIMULUS___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BURST_STIMULUS___ENCODE__STRING = STIMULUS___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Periodic Burst Stimulus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_BURST_STIMULUS_OPERATION_COUNT = STIMULUS_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.EventStimulusImpl <em>Event Stimulus</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.EventStimulusImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getEventStimulus()
	 * @generated
	 */
	int EVENT_STIMULUS = 268;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_STIMULUS__CUSTOM_PROPERTIES = STIMULUS__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_STIMULUS__NAME = STIMULUS__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_STIMULUS__UNIQUE_NAME = STIMULUS__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_STIMULUS__TAGS = STIMULUS__TAGS;

	/**
	 * The feature id for the '<em><b>Set Mode Value List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_STIMULUS__SET_MODE_VALUE_LIST = STIMULUS__SET_MODE_VALUE_LIST;

	/**
	 * The feature id for the '<em><b>Enabling Mode Value List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_STIMULUS__ENABLING_MODE_VALUE_LIST = STIMULUS__ENABLING_MODE_VALUE_LIST;

	/**
	 * The feature id for the '<em><b>Disabling Mode Value List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_STIMULUS__DISABLING_MODE_VALUE_LIST = STIMULUS__DISABLING_MODE_VALUE_LIST;

	/**
	 * The feature id for the '<em><b>Affected Processes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_STIMULUS__AFFECTED_PROCESSES = STIMULUS__AFFECTED_PROCESSES;

	/**
	 * The feature id for the '<em><b>Triggering Events</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_STIMULUS__TRIGGERING_EVENTS = STIMULUS_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Counter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_STIMULUS__COUNTER = STIMULUS_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Event Stimulus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_STIMULUS_FEATURE_COUNT = STIMULUS_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_STIMULUS___COMPUTE_UNIQUE_NAME = STIMULUS___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_STIMULUS___BASIC_COMPUTE_UNIQUE_NAME = STIMULUS___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_STIMULUS___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = STIMULUS___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_STIMULUS___ENCODE__STRING = STIMULUS___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Event Stimulus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_STIMULUS_OPERATION_COUNT = STIMULUS_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ArrivalCurveStimulusImpl <em>Arrival Curve Stimulus</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ArrivalCurveStimulusImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getArrivalCurveStimulus()
	 * @generated
	 */
	int ARRIVAL_CURVE_STIMULUS = 269;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRIVAL_CURVE_STIMULUS__CUSTOM_PROPERTIES = STIMULUS__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRIVAL_CURVE_STIMULUS__NAME = STIMULUS__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRIVAL_CURVE_STIMULUS__UNIQUE_NAME = STIMULUS__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRIVAL_CURVE_STIMULUS__TAGS = STIMULUS__TAGS;

	/**
	 * The feature id for the '<em><b>Set Mode Value List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRIVAL_CURVE_STIMULUS__SET_MODE_VALUE_LIST = STIMULUS__SET_MODE_VALUE_LIST;

	/**
	 * The feature id for the '<em><b>Enabling Mode Value List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRIVAL_CURVE_STIMULUS__ENABLING_MODE_VALUE_LIST = STIMULUS__ENABLING_MODE_VALUE_LIST;

	/**
	 * The feature id for the '<em><b>Disabling Mode Value List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRIVAL_CURVE_STIMULUS__DISABLING_MODE_VALUE_LIST = STIMULUS__DISABLING_MODE_VALUE_LIST;

	/**
	 * The feature id for the '<em><b>Affected Processes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRIVAL_CURVE_STIMULUS__AFFECTED_PROCESSES = STIMULUS__AFFECTED_PROCESSES;

	/**
	 * The feature id for the '<em><b>Entries</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRIVAL_CURVE_STIMULUS__ENTRIES = STIMULUS_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Arrival Curve Stimulus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRIVAL_CURVE_STIMULUS_FEATURE_COUNT = STIMULUS_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRIVAL_CURVE_STIMULUS___COMPUTE_UNIQUE_NAME = STIMULUS___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRIVAL_CURVE_STIMULUS___BASIC_COMPUTE_UNIQUE_NAME = STIMULUS___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRIVAL_CURVE_STIMULUS___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = STIMULUS___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRIVAL_CURVE_STIMULUS___ENCODE__STRING = STIMULUS___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Arrival Curve Stimulus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRIVAL_CURVE_STIMULUS_OPERATION_COUNT = STIMULUS_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ArrivalCurveEntryImpl <em>Arrival Curve Entry</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ArrivalCurveEntryImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getArrivalCurveEntry()
	 * @generated
	 */
	int ARRIVAL_CURVE_ENTRY = 270;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRIVAL_CURVE_ENTRY__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Number Of Occurrences</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRIVAL_CURVE_ENTRY__NUMBER_OF_OCCURRENCES = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Lower Time Border</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRIVAL_CURVE_ENTRY__LOWER_TIME_BORDER = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Upper Time Border</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRIVAL_CURVE_ENTRY__UPPER_TIME_BORDER = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Arrival Curve Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRIVAL_CURVE_ENTRY_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Arrival Curve Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRIVAL_CURVE_ENTRY_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ClockImpl <em>Clock</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ClockImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getClock()
	 * @generated
	 */
	int CLOCK = 271;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The number of structural features of the '<em>Clock</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK___COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK___BASIC_COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK___ENCODE__STRING = REFERABLE_BASE_OBJECT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Clock</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ClockTriangleFunctionImpl <em>Clock Triangle Function</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ClockTriangleFunctionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getClockTriangleFunction()
	 * @generated
	 */
	int CLOCK_TRIANGLE_FUNCTION = 272;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_TRIANGLE_FUNCTION__CUSTOM_PROPERTIES = CLOCK__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_TRIANGLE_FUNCTION__NAME = CLOCK__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_TRIANGLE_FUNCTION__UNIQUE_NAME = CLOCK__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Shift</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_TRIANGLE_FUNCTION__SHIFT = CLOCK_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Period</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_TRIANGLE_FUNCTION__PERIOD = CLOCK_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Max</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_TRIANGLE_FUNCTION__MAX = CLOCK_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Min</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_TRIANGLE_FUNCTION__MIN = CLOCK_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Clock Triangle Function</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_TRIANGLE_FUNCTION_FEATURE_COUNT = CLOCK_FEATURE_COUNT + 4;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_TRIANGLE_FUNCTION___COMPUTE_UNIQUE_NAME = CLOCK___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_TRIANGLE_FUNCTION___BASIC_COMPUTE_UNIQUE_NAME = CLOCK___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_TRIANGLE_FUNCTION___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = CLOCK___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_TRIANGLE_FUNCTION___ENCODE__STRING = CLOCK___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Clock Triangle Function</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_TRIANGLE_FUNCTION_OPERATION_COUNT = CLOCK_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ClockSinusFunctionImpl <em>Clock Sinus Function</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ClockSinusFunctionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getClockSinusFunction()
	 * @generated
	 */
	int CLOCK_SINUS_FUNCTION = 273;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_SINUS_FUNCTION__CUSTOM_PROPERTIES = CLOCK__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_SINUS_FUNCTION__NAME = CLOCK__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_SINUS_FUNCTION__UNIQUE_NAME = CLOCK__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Shift</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_SINUS_FUNCTION__SHIFT = CLOCK_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Period</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_SINUS_FUNCTION__PERIOD = CLOCK_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Amplitude</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_SINUS_FUNCTION__AMPLITUDE = CLOCK_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>YOffset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_SINUS_FUNCTION__YOFFSET = CLOCK_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Clock Sinus Function</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_SINUS_FUNCTION_FEATURE_COUNT = CLOCK_FEATURE_COUNT + 4;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_SINUS_FUNCTION___COMPUTE_UNIQUE_NAME = CLOCK___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_SINUS_FUNCTION___BASIC_COMPUTE_UNIQUE_NAME = CLOCK___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_SINUS_FUNCTION___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = CLOCK___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_SINUS_FUNCTION___ENCODE__STRING = CLOCK___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Clock Sinus Function</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_SINUS_FUNCTION_OPERATION_COUNT = CLOCK_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ClockMultiplierListImpl <em>Clock Multiplier List</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ClockMultiplierListImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getClockMultiplierList()
	 * @generated
	 */
	int CLOCK_MULTIPLIER_LIST = 274;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_MULTIPLIER_LIST__CUSTOM_PROPERTIES = CLOCK__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_MULTIPLIER_LIST__NAME = CLOCK__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_MULTIPLIER_LIST__UNIQUE_NAME = CLOCK__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Entries</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_MULTIPLIER_LIST__ENTRIES = CLOCK_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Clock Multiplier List</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_MULTIPLIER_LIST_FEATURE_COUNT = CLOCK_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_MULTIPLIER_LIST___COMPUTE_UNIQUE_NAME = CLOCK___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_MULTIPLIER_LIST___BASIC_COMPUTE_UNIQUE_NAME = CLOCK___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_MULTIPLIER_LIST___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = CLOCK___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_MULTIPLIER_LIST___ENCODE__STRING = CLOCK___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Clock Multiplier List</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_MULTIPLIER_LIST_OPERATION_COUNT = CLOCK_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ClockMultiplierListEntryImpl <em>Clock Multiplier List Entry</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ClockMultiplierListEntryImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getClockMultiplierListEntry()
	 * @generated
	 */
	int CLOCK_MULTIPLIER_LIST_ENTRY = 275;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_MULTIPLIER_LIST_ENTRY__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Multiplier</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_MULTIPLIER_LIST_ENTRY__MULTIPLIER = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Time</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_MULTIPLIER_LIST_ENTRY__TIME = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Clock Multiplier List Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_MULTIPLIER_LIST_ENTRY_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Clock Multiplier List Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_MULTIPLIER_LIST_ENTRY_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.SWModelImpl <em>SW Model</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.SWModelImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSWModel()
	 * @generated
	 */
	int SW_MODEL = 276;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SW_MODEL__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Isrs</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SW_MODEL__ISRS = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Tasks</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SW_MODEL__TASKS = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Runnables</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SW_MODEL__RUNNABLES = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Labels</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SW_MODEL__LABELS = BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Channels</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SW_MODEL__CHANNELS = BASE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Process Prototypes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SW_MODEL__PROCESS_PROTOTYPES = BASE_OBJECT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Sections</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SW_MODEL__SECTIONS = BASE_OBJECT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Activations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SW_MODEL__ACTIVATIONS = BASE_OBJECT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Events</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SW_MODEL__EVENTS = BASE_OBJECT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Type Definitions</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SW_MODEL__TYPE_DEFINITIONS = BASE_OBJECT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Custom Entities</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SW_MODEL__CUSTOM_ENTITIES = BASE_OBJECT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Process Chains</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SW_MODEL__PROCESS_CHAINS = BASE_OBJECT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Modes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SW_MODEL__MODES = BASE_OBJECT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Mode Labels</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SW_MODEL__MODE_LABELS = BASE_OBJECT_FEATURE_COUNT + 13;

	/**
	 * The number of structural features of the '<em>SW Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SW_MODEL_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 14;

	/**
	 * The operation id for the '<em>Mode Literal</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SW_MODEL___MODE_LITERAL__STRING_STRING = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>SW Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SW_MODEL_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.AbstractMemoryElementImpl <em>Abstract Memory Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.AbstractMemoryElementImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getAbstractMemoryElement()
	 * @generated
	 */
	int ABSTRACT_MEMORY_ELEMENT = 277;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MEMORY_ELEMENT__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MEMORY_ELEMENT__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MEMORY_ELEMENT__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MEMORY_ELEMENT__TAGS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Size</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MEMORY_ELEMENT__SIZE = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Mappings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MEMORY_ELEMENT__MAPPINGS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Abstract Memory Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MEMORY_ELEMENT___COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MEMORY_ELEMENT___BASIC_COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MEMORY_ELEMENT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MEMORY_ELEMENT___ENCODE__STRING = REFERABLE_BASE_OBJECT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Abstract Memory Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MEMORY_ELEMENT_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.AbstractProcessImpl <em>Abstract Process</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.AbstractProcessImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getAbstractProcess()
	 * @generated
	 */
	int ABSTRACT_PROCESS = 278;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_PROCESS__CUSTOM_PROPERTIES = ABSTRACT_MEMORY_ELEMENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_PROCESS__NAME = ABSTRACT_MEMORY_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_PROCESS__UNIQUE_NAME = ABSTRACT_MEMORY_ELEMENT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_PROCESS__TAGS = ABSTRACT_MEMORY_ELEMENT__TAGS;

	/**
	 * The feature id for the '<em><b>Size</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_PROCESS__SIZE = ABSTRACT_MEMORY_ELEMENT__SIZE;

	/**
	 * The feature id for the '<em><b>Mappings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_PROCESS__MAPPINGS = ABSTRACT_MEMORY_ELEMENT__MAPPINGS;

	/**
	 * The feature id for the '<em><b>Referring Components</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_PROCESS__REFERRING_COMPONENTS = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Abstract Process</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_PROCESS_FEATURE_COUNT = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_PROCESS___COMPUTE_UNIQUE_NAME = ABSTRACT_MEMORY_ELEMENT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_PROCESS___BASIC_COMPUTE_UNIQUE_NAME = ABSTRACT_MEMORY_ELEMENT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_PROCESS___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = ABSTRACT_MEMORY_ELEMENT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_PROCESS___ENCODE__STRING = ABSTRACT_MEMORY_ELEMENT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Abstract Process</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_PROCESS_OPERATION_COUNT = ABSTRACT_MEMORY_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.CustomEntityImpl <em>Custom Entity</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.CustomEntityImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getCustomEntity()
	 * @generated
	 */
	int CUSTOM_ENTITY = 279;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_ENTITY__CUSTOM_PROPERTIES = ABSTRACT_MEMORY_ELEMENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_ENTITY__NAME = ABSTRACT_MEMORY_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_ENTITY__UNIQUE_NAME = ABSTRACT_MEMORY_ELEMENT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_ENTITY__TAGS = ABSTRACT_MEMORY_ELEMENT__TAGS;

	/**
	 * The feature id for the '<em><b>Size</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_ENTITY__SIZE = ABSTRACT_MEMORY_ELEMENT__SIZE;

	/**
	 * The feature id for the '<em><b>Mappings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_ENTITY__MAPPINGS = ABSTRACT_MEMORY_ELEMENT__MAPPINGS;

	/**
	 * The feature id for the '<em><b>Type Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_ENTITY__TYPE_NAME = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Custom Entity</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_ENTITY_FEATURE_COUNT = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_ENTITY___COMPUTE_UNIQUE_NAME = ABSTRACT_MEMORY_ELEMENT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_ENTITY___BASIC_COMPUTE_UNIQUE_NAME = ABSTRACT_MEMORY_ELEMENT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_ENTITY___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = ABSTRACT_MEMORY_ELEMENT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_ENTITY___ENCODE__STRING = ABSTRACT_MEMORY_ELEMENT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Custom Entity</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_ENTITY_OPERATION_COUNT = ABSTRACT_MEMORY_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ProcessChainImpl <em>Process Chain</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ProcessChainImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getProcessChain()
	 * @generated
	 */
	int PROCESS_CHAIN = 280;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Processes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN__PROCESSES = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Process Chain</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN___COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN___BASIC_COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN___ENCODE__STRING = REFERABLE_BASE_OBJECT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Process Chain</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CHAIN_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ProcessImpl <em>Process</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ProcessImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getProcess()
	 * @generated
	 */
	int PROCESS = 281;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS__CUSTOM_PROPERTIES = ABSTRACT_PROCESS__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS__NAME = ABSTRACT_PROCESS__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS__UNIQUE_NAME = ABSTRACT_PROCESS__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS__TAGS = ABSTRACT_PROCESS__TAGS;

	/**
	 * The feature id for the '<em><b>Size</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS__SIZE = ABSTRACT_PROCESS__SIZE;

	/**
	 * The feature id for the '<em><b>Mappings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS__MAPPINGS = ABSTRACT_PROCESS__MAPPINGS;

	/**
	 * The feature id for the '<em><b>Referring Components</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS__REFERRING_COMPONENTS = ABSTRACT_PROCESS__REFERRING_COMPONENTS;

	/**
	 * The feature id for the '<em><b>Call Graph</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS__CALL_GRAPH = ABSTRACT_PROCESS_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Stimuli</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS__STIMULI = ABSTRACT_PROCESS_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Process</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_FEATURE_COUNT = ABSTRACT_PROCESS_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS___COMPUTE_UNIQUE_NAME = ABSTRACT_PROCESS___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS___BASIC_COMPUTE_UNIQUE_NAME = ABSTRACT_PROCESS___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = ABSTRACT_PROCESS___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS___ENCODE__STRING = ABSTRACT_PROCESS___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Process</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_OPERATION_COUNT = ABSTRACT_PROCESS_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.CallGraphImpl <em>Call Graph</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.CallGraphImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getCallGraph()
	 * @generated
	 */
	int CALL_GRAPH = 282;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CALL_GRAPH__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Graph Entries</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CALL_GRAPH__GRAPH_ENTRIES = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Call Graph</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CALL_GRAPH_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Call Graph</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CALL_GRAPH_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.GraphEntryBaseImpl <em>Graph Entry Base</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.GraphEntryBaseImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getGraphEntryBase()
	 * @generated
	 */
	int GRAPH_ENTRY_BASE = 283;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPH_ENTRY_BASE__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The number of structural features of the '<em>Graph Entry Base</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPH_ENTRY_BASE_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Graph Entry Base</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPH_ENTRY_BASE_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.CallSequenceImpl <em>Call Sequence</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.CallSequenceImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getCallSequence()
	 * @generated
	 */
	int CALL_SEQUENCE = 284;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CALL_SEQUENCE__CUSTOM_PROPERTIES = GRAPH_ENTRY_BASE__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CALL_SEQUENCE__NAME = GRAPH_ENTRY_BASE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Calls</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CALL_SEQUENCE__CALLS = GRAPH_ENTRY_BASE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Call Sequence</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CALL_SEQUENCE_FEATURE_COUNT = GRAPH_ENTRY_BASE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Call Sequence</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CALL_SEQUENCE_OPERATION_COUNT = GRAPH_ENTRY_BASE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ModeSwitchImpl <em>Mode Switch</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ModeSwitchImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getModeSwitch()
	 * @generated
	 */
	int MODE_SWITCH = 285;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_SWITCH__CUSTOM_PROPERTIES = GRAPH_ENTRY_BASE__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Entries</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_SWITCH__ENTRIES = GRAPH_ENTRY_BASE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Default Entry</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_SWITCH__DEFAULT_ENTRY = GRAPH_ENTRY_BASE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Mode Switch</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_SWITCH_FEATURE_COUNT = GRAPH_ENTRY_BASE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Mode Switch</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_SWITCH_OPERATION_COUNT = GRAPH_ENTRY_BASE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ModeSwitchEntryImpl <em>Mode Switch Entry</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ModeSwitchEntryImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getModeSwitchEntry()
	 * @generated
	 */
	int MODE_SWITCH_ENTRY = 286;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_SWITCH_ENTRY__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_SWITCH_ENTRY__NAME = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Condition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_SWITCH_ENTRY__CONDITION = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Items</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_SWITCH_ENTRY__ITEMS = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Mode Switch Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_SWITCH_ENTRY_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Mode Switch Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_SWITCH_ENTRY_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ModeSwitchDefaultImpl <em>Mode Switch Default</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ModeSwitchDefaultImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getModeSwitchDefault()
	 * @generated
	 */
	int MODE_SWITCH_DEFAULT = 287;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_SWITCH_DEFAULT__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Items</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_SWITCH_DEFAULT__ITEMS = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Mode Switch Default</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_SWITCH_DEFAULT_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Mode Switch Default</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_SWITCH_DEFAULT_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ProbabilitySwitchImpl <em>Probability Switch</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ProbabilitySwitchImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getProbabilitySwitch()
	 * @generated
	 */
	int PROBABILITY_SWITCH = 288;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBABILITY_SWITCH__CUSTOM_PROPERTIES = GRAPH_ENTRY_BASE__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Entries</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBABILITY_SWITCH__ENTRIES = GRAPH_ENTRY_BASE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Probability Switch</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBABILITY_SWITCH_FEATURE_COUNT = GRAPH_ENTRY_BASE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Probability Switch</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBABILITY_SWITCH_OPERATION_COUNT = GRAPH_ENTRY_BASE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ProbabilitySwitchEntryImpl <em>Probability Switch Entry</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ProbabilitySwitchEntryImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getProbabilitySwitchEntry()
	 * @generated
	 */
	int PROBABILITY_SWITCH_ENTRY = 289;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBABILITY_SWITCH_ENTRY__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Probability</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBABILITY_SWITCH_ENTRY__PROBABILITY = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Items</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBABILITY_SWITCH_ENTRY__ITEMS = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Probability Switch Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBABILITY_SWITCH_ENTRY_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Probability Switch Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROBABILITY_SWITCH_ENTRY_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.CounterImpl <em>Counter</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.CounterImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getCounter()
	 * @generated
	 */
	int COUNTER = 290;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNTER__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Prescaler</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNTER__PRESCALER = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Offset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNTER__OFFSET = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Counter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNTER_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Counter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNTER_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.CallSequenceItemImpl <em>Call Sequence Item</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.CallSequenceItemImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getCallSequenceItem()
	 * @generated
	 */
	int CALL_SEQUENCE_ITEM = 291;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CALL_SEQUENCE_ITEM__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CALL_SEQUENCE_ITEM__CONTAINING_PROCESS = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Counter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CALL_SEQUENCE_ITEM__COUNTER = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Call Sequence Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CALL_SEQUENCE_ITEM_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Call Sequence Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CALL_SEQUENCE_ITEM_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.WaitEventImpl <em>Wait Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.WaitEventImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getWaitEvent()
	 * @generated
	 */
	int WAIT_EVENT = 292;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WAIT_EVENT__CUSTOM_PROPERTIES = CALL_SEQUENCE_ITEM__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WAIT_EVENT__CONTAINING_PROCESS = CALL_SEQUENCE_ITEM__CONTAINING_PROCESS;

	/**
	 * The feature id for the '<em><b>Counter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WAIT_EVENT__COUNTER = CALL_SEQUENCE_ITEM__COUNTER;

	/**
	 * The feature id for the '<em><b>Event Mask</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WAIT_EVENT__EVENT_MASK = CALL_SEQUENCE_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Mask Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WAIT_EVENT__MASK_TYPE = CALL_SEQUENCE_ITEM_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Waiting Behaviour</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WAIT_EVENT__WAITING_BEHAVIOUR = CALL_SEQUENCE_ITEM_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Wait Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WAIT_EVENT_FEATURE_COUNT = CALL_SEQUENCE_ITEM_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Wait Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WAIT_EVENT_OPERATION_COUNT = CALL_SEQUENCE_ITEM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.SetEventImpl <em>Set Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.SetEventImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSetEvent()
	 * @generated
	 */
	int SET_EVENT = 293;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SET_EVENT__CUSTOM_PROPERTIES = CALL_SEQUENCE_ITEM__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SET_EVENT__CONTAINING_PROCESS = CALL_SEQUENCE_ITEM__CONTAINING_PROCESS;

	/**
	 * The feature id for the '<em><b>Counter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SET_EVENT__COUNTER = CALL_SEQUENCE_ITEM__COUNTER;

	/**
	 * The feature id for the '<em><b>Event Mask</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SET_EVENT__EVENT_MASK = CALL_SEQUENCE_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SET_EVENT__PROCESS = CALL_SEQUENCE_ITEM_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Set Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SET_EVENT_FEATURE_COUNT = CALL_SEQUENCE_ITEM_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Set Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SET_EVENT_OPERATION_COUNT = CALL_SEQUENCE_ITEM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ClearEventImpl <em>Clear Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ClearEventImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getClearEvent()
	 * @generated
	 */
	int CLEAR_EVENT = 294;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLEAR_EVENT__CUSTOM_PROPERTIES = CALL_SEQUENCE_ITEM__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLEAR_EVENT__CONTAINING_PROCESS = CALL_SEQUENCE_ITEM__CONTAINING_PROCESS;

	/**
	 * The feature id for the '<em><b>Counter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLEAR_EVENT__COUNTER = CALL_SEQUENCE_ITEM__COUNTER;

	/**
	 * The feature id for the '<em><b>Event Mask</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLEAR_EVENT__EVENT_MASK = CALL_SEQUENCE_ITEM_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Clear Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLEAR_EVENT_FEATURE_COUNT = CALL_SEQUENCE_ITEM_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Clear Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLEAR_EVENT_OPERATION_COUNT = CALL_SEQUENCE_ITEM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.EventMaskImpl <em>Event Mask</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.EventMaskImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getEventMask()
	 * @generated
	 */
	int EVENT_MASK = 295;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_MASK__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Events</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_MASK__EVENTS = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Event Mask</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_MASK_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Event Mask</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_MASK_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.OsEventImpl <em>Os Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.OsEventImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getOsEvent()
	 * @generated
	 */
	int OS_EVENT = 296;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_EVENT__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_EVENT__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_EVENT__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_EVENT__TAGS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Communication Overhead In Bit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_EVENT__COMMUNICATION_OVERHEAD_IN_BIT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Referring Components</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_EVENT__REFERRING_COMPONENTS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Os Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_EVENT_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_EVENT___COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_EVENT___BASIC_COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_EVENT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_EVENT___ENCODE__STRING = REFERABLE_BASE_OBJECT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Os Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OS_EVENT_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.InterProcessTriggerImpl <em>Inter Process Trigger</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.InterProcessTriggerImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getInterProcessTrigger()
	 * @generated
	 */
	int INTER_PROCESS_TRIGGER = 297;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_TRIGGER__CUSTOM_PROPERTIES = CALL_SEQUENCE_ITEM__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_TRIGGER__CONTAINING_PROCESS = CALL_SEQUENCE_ITEM__CONTAINING_PROCESS;

	/**
	 * The feature id for the '<em><b>Counter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_TRIGGER__COUNTER = CALL_SEQUENCE_ITEM__COUNTER;

	/**
	 * The feature id for the '<em><b>Stimulus</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_TRIGGER__STIMULUS = CALL_SEQUENCE_ITEM_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Inter Process Trigger</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_TRIGGER_FEATURE_COUNT = CALL_SEQUENCE_ITEM_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Inter Process Trigger</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTER_PROCESS_TRIGGER_OPERATION_COUNT = CALL_SEQUENCE_ITEM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.EnforcedMigrationImpl <em>Enforced Migration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.EnforcedMigrationImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getEnforcedMigration()
	 * @generated
	 */
	int ENFORCED_MIGRATION = 298;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENFORCED_MIGRATION__CUSTOM_PROPERTIES = CALL_SEQUENCE_ITEM__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENFORCED_MIGRATION__CONTAINING_PROCESS = CALL_SEQUENCE_ITEM__CONTAINING_PROCESS;

	/**
	 * The feature id for the '<em><b>Counter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENFORCED_MIGRATION__COUNTER = CALL_SEQUENCE_ITEM__COUNTER;

	/**
	 * The feature id for the '<em><b>Resource Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENFORCED_MIGRATION__RESOURCE_OWNER = CALL_SEQUENCE_ITEM_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Enforced Migration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENFORCED_MIGRATION_FEATURE_COUNT = CALL_SEQUENCE_ITEM_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Enforced Migration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENFORCED_MIGRATION_OPERATION_COUNT = CALL_SEQUENCE_ITEM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TaskRunnableCallImpl <em>Task Runnable Call</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TaskRunnableCallImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTaskRunnableCall()
	 * @generated
	 */
	int TASK_RUNNABLE_CALL = 299;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_RUNNABLE_CALL__CUSTOM_PROPERTIES = CALL_SEQUENCE_ITEM__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_RUNNABLE_CALL__CONTAINING_PROCESS = CALL_SEQUENCE_ITEM__CONTAINING_PROCESS;

	/**
	 * The feature id for the '<em><b>Counter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_RUNNABLE_CALL__COUNTER = CALL_SEQUENCE_ITEM__COUNTER;

	/**
	 * The feature id for the '<em><b>Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_RUNNABLE_CALL__RUNNABLE = CALL_SEQUENCE_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Statistic</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_RUNNABLE_CALL__STATISTIC = CALL_SEQUENCE_ITEM_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Task Runnable Call</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_RUNNABLE_CALL_FEATURE_COUNT = CALL_SEQUENCE_ITEM_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Task Runnable Call</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_RUNNABLE_CALL_OPERATION_COUNT = CALL_SEQUENCE_ITEM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.SchedulePointImpl <em>Schedule Point</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.SchedulePointImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSchedulePoint()
	 * @generated
	 */
	int SCHEDULE_POINT = 300;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULE_POINT__CUSTOM_PROPERTIES = CALL_SEQUENCE_ITEM__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULE_POINT__CONTAINING_PROCESS = CALL_SEQUENCE_ITEM__CONTAINING_PROCESS;

	/**
	 * The feature id for the '<em><b>Counter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULE_POINT__COUNTER = CALL_SEQUENCE_ITEM__COUNTER;

	/**
	 * The number of structural features of the '<em>Schedule Point</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULE_POINT_FEATURE_COUNT = CALL_SEQUENCE_ITEM_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Schedule Point</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEDULE_POINT_OPERATION_COUNT = CALL_SEQUENCE_ITEM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TerminateProcessImpl <em>Terminate Process</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TerminateProcessImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTerminateProcess()
	 * @generated
	 */
	int TERMINATE_PROCESS = 301;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERMINATE_PROCESS__CUSTOM_PROPERTIES = CALL_SEQUENCE_ITEM__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Process</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERMINATE_PROCESS__CONTAINING_PROCESS = CALL_SEQUENCE_ITEM__CONTAINING_PROCESS;

	/**
	 * The feature id for the '<em><b>Counter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERMINATE_PROCESS__COUNTER = CALL_SEQUENCE_ITEM__COUNTER;

	/**
	 * The number of structural features of the '<em>Terminate Process</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERMINATE_PROCESS_FEATURE_COUNT = CALL_SEQUENCE_ITEM_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Terminate Process</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERMINATE_PROCESS_OPERATION_COUNT = CALL_SEQUENCE_ITEM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TaskImpl <em>Task</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TaskImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTask()
	 * @generated
	 */
	int TASK = 302;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK__CUSTOM_PROPERTIES = PROCESS__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK__NAME = PROCESS__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK__UNIQUE_NAME = PROCESS__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK__TAGS = PROCESS__TAGS;

	/**
	 * The feature id for the '<em><b>Size</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK__SIZE = PROCESS__SIZE;

	/**
	 * The feature id for the '<em><b>Mappings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK__MAPPINGS = PROCESS__MAPPINGS;

	/**
	 * The feature id for the '<em><b>Referring Components</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK__REFERRING_COMPONENTS = PROCESS__REFERRING_COMPONENTS;

	/**
	 * The feature id for the '<em><b>Call Graph</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK__CALL_GRAPH = PROCESS__CALL_GRAPH;

	/**
	 * The feature id for the '<em><b>Stimuli</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK__STIMULI = PROCESS__STIMULI;

	/**
	 * The feature id for the '<em><b>Preemption</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK__PREEMPTION = PROCESS_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Multiple Task Activation Limit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK__MULTIPLE_TASK_ACTIVATION_LIMIT = PROCESS_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Task</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_FEATURE_COUNT = PROCESS_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK___COMPUTE_UNIQUE_NAME = PROCESS___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK___BASIC_COMPUTE_UNIQUE_NAME = PROCESS___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = PROCESS___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK___ENCODE__STRING = PROCESS___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Task</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_OPERATION_COUNT = PROCESS_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ISRImpl <em>ISR</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ISRImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getISR()
	 * @generated
	 */
	int ISR = 303;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR__CUSTOM_PROPERTIES = PROCESS__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR__NAME = PROCESS__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR__UNIQUE_NAME = PROCESS__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR__TAGS = PROCESS__TAGS;

	/**
	 * The feature id for the '<em><b>Size</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR__SIZE = PROCESS__SIZE;

	/**
	 * The feature id for the '<em><b>Mappings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR__MAPPINGS = PROCESS__MAPPINGS;

	/**
	 * The feature id for the '<em><b>Referring Components</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR__REFERRING_COMPONENTS = PROCESS__REFERRING_COMPONENTS;

	/**
	 * The feature id for the '<em><b>Call Graph</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR__CALL_GRAPH = PROCESS__CALL_GRAPH;

	/**
	 * The feature id for the '<em><b>Stimuli</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR__STIMULI = PROCESS__STIMULI;

	/**
	 * The feature id for the '<em><b>Category</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR__CATEGORY = PROCESS_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>ISR</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR_FEATURE_COUNT = PROCESS_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR___COMPUTE_UNIQUE_NAME = PROCESS___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR___BASIC_COMPUTE_UNIQUE_NAME = PROCESS___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = PROCESS___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR___ENCODE__STRING = PROCESS___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>ISR</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISR_OPERATION_COUNT = PROCESS_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ProcessPrototypeImpl <em>Process Prototype</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ProcessPrototypeImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getProcessPrototype()
	 * @generated
	 */
	int PROCESS_PROTOTYPE = 304;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE__CUSTOM_PROPERTIES = ABSTRACT_PROCESS__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE__NAME = ABSTRACT_PROCESS__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE__UNIQUE_NAME = ABSTRACT_PROCESS__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE__TAGS = ABSTRACT_PROCESS__TAGS;

	/**
	 * The feature id for the '<em><b>Size</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE__SIZE = ABSTRACT_PROCESS__SIZE;

	/**
	 * The feature id for the '<em><b>Mappings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE__MAPPINGS = ABSTRACT_PROCESS__MAPPINGS;

	/**
	 * The feature id for the '<em><b>Referring Components</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE__REFERRING_COMPONENTS = ABSTRACT_PROCESS__REFERRING_COMPONENTS;

	/**
	 * The feature id for the '<em><b>Preemption</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE__PREEMPTION = ABSTRACT_PROCESS_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>First Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE__FIRST_RUNNABLE = ABSTRACT_PROCESS_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Last Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE__LAST_RUNNABLE = ABSTRACT_PROCESS_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Access Precedence Spec</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE__ACCESS_PRECEDENCE_SPEC = ABSTRACT_PROCESS_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Order Precedence Spec</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE__ORDER_PRECEDENCE_SPEC = ABSTRACT_PROCESS_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Chained Prototypes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE__CHAINED_PROTOTYPES = ABSTRACT_PROCESS_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Activation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE__ACTIVATION = ABSTRACT_PROCESS_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Runnable Calls</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE__RUNNABLE_CALLS = ABSTRACT_PROCESS_FEATURE_COUNT + 7;

	/**
	 * The number of structural features of the '<em>Process Prototype</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE_FEATURE_COUNT = ABSTRACT_PROCESS_FEATURE_COUNT + 8;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE___COMPUTE_UNIQUE_NAME = ABSTRACT_PROCESS___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE___BASIC_COMPUTE_UNIQUE_NAME = ABSTRACT_PROCESS___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = ABSTRACT_PROCESS___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE___ENCODE__STRING = ABSTRACT_PROCESS___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Process Prototype</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_PROTOTYPE_OPERATION_COUNT = ABSTRACT_PROCESS_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ChainedProcessPrototypeImpl <em>Chained Process Prototype</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ChainedProcessPrototypeImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getChainedProcessPrototype()
	 * @generated
	 */
	int CHAINED_PROCESS_PROTOTYPE = 305;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHAINED_PROCESS_PROTOTYPE__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Prototype</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHAINED_PROCESS_PROTOTYPE__PROTOTYPE = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Apply</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHAINED_PROCESS_PROTOTYPE__APPLY = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Offset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHAINED_PROCESS_PROTOTYPE__OFFSET = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Chained Process Prototype</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHAINED_PROCESS_PROTOTYPE_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Chained Process Prototype</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHAINED_PROCESS_PROTOTYPE_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.GeneralPrecedenceImpl <em>General Precedence</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.GeneralPrecedenceImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getGeneralPrecedence()
	 * @generated
	 */
	int GENERAL_PRECEDENCE = 306;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERAL_PRECEDENCE__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Origin</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERAL_PRECEDENCE__ORIGIN = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Target</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERAL_PRECEDENCE__TARGET = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>General Precedence</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERAL_PRECEDENCE_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>General Precedence</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERAL_PRECEDENCE_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.AccessPrecedenceSpecImpl <em>Access Precedence Spec</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.AccessPrecedenceSpecImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getAccessPrecedenceSpec()
	 * @generated
	 */
	int ACCESS_PRECEDENCE_SPEC = 307;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACCESS_PRECEDENCE_SPEC__CUSTOM_PROPERTIES = GENERAL_PRECEDENCE__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Origin</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACCESS_PRECEDENCE_SPEC__ORIGIN = GENERAL_PRECEDENCE__ORIGIN;

	/**
	 * The feature id for the '<em><b>Target</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACCESS_PRECEDENCE_SPEC__TARGET = GENERAL_PRECEDENCE__TARGET;

	/**
	 * The feature id for the '<em><b>Label</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACCESS_PRECEDENCE_SPEC__LABEL = GENERAL_PRECEDENCE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Order Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACCESS_PRECEDENCE_SPEC__ORDER_TYPE = GENERAL_PRECEDENCE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Access Precedence Spec</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACCESS_PRECEDENCE_SPEC_FEATURE_COUNT = GENERAL_PRECEDENCE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Access Precedence Spec</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACCESS_PRECEDENCE_SPEC_OPERATION_COUNT = GENERAL_PRECEDENCE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.OrderPrecedenceSpecImpl <em>Order Precedence Spec</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.OrderPrecedenceSpecImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getOrderPrecedenceSpec()
	 * @generated
	 */
	int ORDER_PRECEDENCE_SPEC = 308;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORDER_PRECEDENCE_SPEC__CUSTOM_PROPERTIES = GENERAL_PRECEDENCE__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Origin</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORDER_PRECEDENCE_SPEC__ORIGIN = GENERAL_PRECEDENCE__ORIGIN;

	/**
	 * The feature id for the '<em><b>Target</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORDER_PRECEDENCE_SPEC__TARGET = GENERAL_PRECEDENCE__TARGET;

	/**
	 * The feature id for the '<em><b>Order Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORDER_PRECEDENCE_SPEC__ORDER_TYPE = GENERAL_PRECEDENCE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Order Precedence Spec</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORDER_PRECEDENCE_SPEC_FEATURE_COUNT = GENERAL_PRECEDENCE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Order Precedence Spec</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORDER_PRECEDENCE_SPEC_OPERATION_COUNT = GENERAL_PRECEDENCE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DataDependencyImpl <em>Data Dependency</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DataDependencyImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDataDependency()
	 * @generated
	 */
	int DATA_DEPENDENCY = 309;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_DEPENDENCY__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Labels</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_DEPENDENCY__LABELS = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Parameters</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_DEPENDENCY__PARAMETERS = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Call Arguments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_DEPENDENCY__CALL_ARGUMENTS = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_DEPENDENCY__CONTAINING_RUNNABLE = BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Data Dependency</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_DEPENDENCY_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>Data Dependency</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_DEPENDENCY_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.RunnableParameterImpl <em>Runnable Parameter</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.RunnableParameterImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getRunnableParameter()
	 * @generated
	 */
	int RUNNABLE_PARAMETER = 310;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PARAMETER__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PARAMETER__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PARAMETER__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PARAMETER__CONTAINING_RUNNABLE = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PARAMETER__DIRECTION = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Data Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PARAMETER__DATA_TYPE = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Depends On</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PARAMETER__DEPENDS_ON = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Runnable Parameter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PARAMETER_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PARAMETER___BASIC_COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PARAMETER___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PARAMETER___ENCODE__STRING = REFERABLE_BASE_OBJECT___ENCODE__STRING;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PARAMETER___COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>To String</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PARAMETER___TO_STRING = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 1;

	/**
	 * The number of operations of the '<em>Runnable Parameter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PARAMETER_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.RunnableImpl <em>Runnable</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.RunnableImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getRunnable()
	 * @generated
	 */
	int RUNNABLE = 311;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE__CUSTOM_PROPERTIES = ABSTRACT_MEMORY_ELEMENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE__NAME = ABSTRACT_MEMORY_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE__UNIQUE_NAME = ABSTRACT_MEMORY_ELEMENT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE__TAGS = ABSTRACT_MEMORY_ELEMENT__TAGS;

	/**
	 * The feature id for the '<em><b>Size</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE__SIZE = ABSTRACT_MEMORY_ELEMENT__SIZE;

	/**
	 * The feature id for the '<em><b>Mappings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE__MAPPINGS = ABSTRACT_MEMORY_ELEMENT__MAPPINGS;

	/**
	 * The feature id for the '<em><b>Parameters</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE__PARAMETERS = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Runnable Items</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE__RUNNABLE_ITEMS = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Activations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE__ACTIVATIONS = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Deadline</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE__DEADLINE = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Callback</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE__CALLBACK = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Service</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE__SERVICE = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Asil Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE__ASIL_LEVEL = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Section</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE__SECTION = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Runnable Calls</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE__RUNNABLE_CALLS = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Task Runnable Calls</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE__TASK_RUNNABLE_CALLS = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Referring Components</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE__REFERRING_COMPONENTS = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 10;

	/**
	 * The number of structural features of the '<em>Runnable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_FEATURE_COUNT = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 11;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE___COMPUTE_UNIQUE_NAME = ABSTRACT_MEMORY_ELEMENT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE___BASIC_COMPUTE_UNIQUE_NAME = ABSTRACT_MEMORY_ELEMENT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = ABSTRACT_MEMORY_ELEMENT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE___ENCODE__STRING = ABSTRACT_MEMORY_ELEMENT___ENCODE__STRING;

	/**
	 * The operation id for the '<em>Get First Activation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE___GET_FIRST_ACTIVATION = ABSTRACT_MEMORY_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Runnable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_OPERATION_COUNT = ABSTRACT_MEMORY_ELEMENT_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.LabelImpl <em>Label</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.LabelImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getLabel()
	 * @generated
	 */
	int LABEL = 312;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL__CUSTOM_PROPERTIES = ABSTRACT_MEMORY_ELEMENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL__NAME = ABSTRACT_MEMORY_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL__UNIQUE_NAME = ABSTRACT_MEMORY_ELEMENT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL__TAGS = ABSTRACT_MEMORY_ELEMENT__TAGS;

	/**
	 * The feature id for the '<em><b>Size</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL__SIZE = ABSTRACT_MEMORY_ELEMENT__SIZE;

	/**
	 * The feature id for the '<em><b>Mappings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL__MAPPINGS = ABSTRACT_MEMORY_ELEMENT__MAPPINGS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL__DISPLAY_NAME = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Data Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL__DATA_TYPE = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Constant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL__CONSTANT = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>BVolatile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL__BVOLATILE = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Data Stability</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL__DATA_STABILITY = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Stability Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL__STABILITY_LEVEL = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Section</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL__SECTION = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Label Accesses</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL__LABEL_ACCESSES = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Referring Components</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL__REFERRING_COMPONENTS = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The number of structural features of the '<em>Label</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_FEATURE_COUNT = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL___COMPUTE_UNIQUE_NAME = ABSTRACT_MEMORY_ELEMENT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL___BASIC_COMPUTE_UNIQUE_NAME = ABSTRACT_MEMORY_ELEMENT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = ABSTRACT_MEMORY_ELEMENT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL___ENCODE__STRING = ABSTRACT_MEMORY_ELEMENT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Label</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_OPERATION_COUNT = ABSTRACT_MEMORY_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ChannelImpl <em>Channel</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ChannelImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getChannel()
	 * @generated
	 */
	int CHANNEL = 313;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL__CUSTOM_PROPERTIES = ABSTRACT_MEMORY_ELEMENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL__NAME = ABSTRACT_MEMORY_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL__UNIQUE_NAME = ABSTRACT_MEMORY_ELEMENT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL__TAGS = ABSTRACT_MEMORY_ELEMENT__TAGS;

	/**
	 * The feature id for the '<em><b>Size</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL__SIZE = ABSTRACT_MEMORY_ELEMENT__SIZE;

	/**
	 * The feature id for the '<em><b>Mappings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL__MAPPINGS = ABSTRACT_MEMORY_ELEMENT__MAPPINGS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL__DISPLAY_NAME = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL__ELEMENT_TYPE = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Default Elements</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL__DEFAULT_ELEMENTS = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Max Elements</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL__MAX_ELEMENTS = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Channel Accesses</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL__CHANNEL_ACCESSES = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Channel</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_FEATURE_COUNT = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL___COMPUTE_UNIQUE_NAME = ABSTRACT_MEMORY_ELEMENT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL___BASIC_COMPUTE_UNIQUE_NAME = ABSTRACT_MEMORY_ELEMENT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = ABSTRACT_MEMORY_ELEMENT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL___ENCODE__STRING = ABSTRACT_MEMORY_ELEMENT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Channel</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_OPERATION_COUNT = ABSTRACT_MEMORY_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ModeLabelImpl <em>Mode Label</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ModeLabelImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getModeLabel()
	 * @generated
	 */
	int MODE_LABEL = 314;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL__CUSTOM_PROPERTIES = ABSTRACT_MEMORY_ELEMENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL__NAME = ABSTRACT_MEMORY_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL__UNIQUE_NAME = ABSTRACT_MEMORY_ELEMENT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL__TAGS = ABSTRACT_MEMORY_ELEMENT__TAGS;

	/**
	 * The feature id for the '<em><b>Size</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL__SIZE = ABSTRACT_MEMORY_ELEMENT__SIZE;

	/**
	 * The feature id for the '<em><b>Mappings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL__MAPPINGS = ABSTRACT_MEMORY_ELEMENT__MAPPINGS;

	/**
	 * The feature id for the '<em><b>Display Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL__DISPLAY_NAME = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Mode</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL__MODE = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Initial Value</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL__INITIAL_VALUE = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Mode Label</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL_FEATURE_COUNT = ABSTRACT_MEMORY_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL___COMPUTE_UNIQUE_NAME = ABSTRACT_MEMORY_ELEMENT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL___BASIC_COMPUTE_UNIQUE_NAME = ABSTRACT_MEMORY_ELEMENT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = ABSTRACT_MEMORY_ELEMENT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL___ENCODE__STRING = ABSTRACT_MEMORY_ELEMENT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Mode Label</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL_OPERATION_COUNT = ABSTRACT_MEMORY_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.SectionImpl <em>Section</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.SectionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSection()
	 * @generated
	 */
	int SECTION = 315;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECTION__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECTION__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECTION__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Asil Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECTION__ASIL_LEVEL = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Labels</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECTION__LABELS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Runnables</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECTION__RUNNABLES = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Section</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECTION_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECTION___COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECTION___BASIC_COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECTION___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECTION___ENCODE__STRING = REFERABLE_BASE_OBJECT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Section</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECTION_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.RunnableItemImpl <em>Runnable Item</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.RunnableItemImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getRunnableItem()
	 * @generated
	 */
	int RUNNABLE_ITEM = 316;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_ITEM__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_ITEM__CONTAINING_RUNNABLE = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Runnable Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_ITEM_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Runnable Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_ITEM_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ComputationItemImpl <em>Computation Item</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ComputationItemImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getComputationItem()
	 * @generated
	 */
	int COMPUTATION_ITEM = 317;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPUTATION_ITEM__CUSTOM_PROPERTIES = RUNNABLE_ITEM__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPUTATION_ITEM__CONTAINING_RUNNABLE = RUNNABLE_ITEM__CONTAINING_RUNNABLE;

	/**
	 * The number of structural features of the '<em>Computation Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPUTATION_ITEM_FEATURE_COUNT = RUNNABLE_ITEM_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Computation Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPUTATION_ITEM_OPERATION_COUNT = RUNNABLE_ITEM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ExecutionNeedImpl <em>Execution Need</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ExecutionNeedImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getExecutionNeed()
	 * @generated
	 */
	int EXECUTION_NEED = 318;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXECUTION_NEED__CUSTOM_PROPERTIES = RUNNABLE_ITEM__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXECUTION_NEED__CONTAINING_RUNNABLE = RUNNABLE_ITEM__CONTAINING_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Needs</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXECUTION_NEED__NEEDS = RUNNABLE_ITEM_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Execution Need</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXECUTION_NEED_FEATURE_COUNT = RUNNABLE_ITEM_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Execution Need</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXECUTION_NEED_OPERATION_COUNT = RUNNABLE_ITEM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.NeedEntryImpl <em>Need Entry</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.NeedEntryImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getNeedEntry()
	 * @generated
	 */
	int NEED_ENTRY = 319;

	/**
	 * The feature id for the '<em><b>Key</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NEED_ENTRY__KEY = 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NEED_ENTRY__VALUE = 1;

	/**
	 * The number of structural features of the '<em>Need Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NEED_ENTRY_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Need Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NEED_ENTRY_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TicksImpl <em>Ticks</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TicksImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTicks()
	 * @generated
	 */
	int TICKS = 320;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TICKS__CUSTOM_PROPERTIES = COMPUTATION_ITEM__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TICKS__CONTAINING_RUNNABLE = COMPUTATION_ITEM__CONTAINING_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Default</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TICKS__DEFAULT = COMPUTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Extended</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TICKS__EXTENDED = COMPUTATION_ITEM_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ticks</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TICKS_FEATURE_COUNT = COMPUTATION_ITEM_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Ticks</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TICKS_OPERATION_COUNT = COMPUTATION_ITEM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TicksEntryImpl <em>Ticks Entry</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TicksEntryImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTicksEntry()
	 * @generated
	 */
	int TICKS_ENTRY = 321;

	/**
	 * The feature id for the '<em><b>Key</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TICKS_ENTRY__KEY = 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TICKS_ENTRY__VALUE = 1;

	/**
	 * The number of structural features of the '<em>Ticks Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TICKS_ENTRY_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Ticks Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TICKS_ENTRY_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ModeLabelAccessImpl <em>Mode Label Access</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ModeLabelAccessImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getModeLabelAccess()
	 * @generated
	 */
	int MODE_LABEL_ACCESS = 322;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL_ACCESS__CUSTOM_PROPERTIES = RUNNABLE_ITEM__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL_ACCESS__CONTAINING_RUNNABLE = RUNNABLE_ITEM__CONTAINING_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Data</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL_ACCESS__DATA = RUNNABLE_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Access</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL_ACCESS__ACCESS = RUNNABLE_ITEM_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Mode Value</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL_ACCESS__MODE_VALUE = RUNNABLE_ITEM_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Mode Label Access</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL_ACCESS_FEATURE_COUNT = RUNNABLE_ITEM_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Mode Label Access</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODE_LABEL_ACCESS_OPERATION_COUNT = RUNNABLE_ITEM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.RunnableModeSwitchImpl <em>Runnable Mode Switch</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.RunnableModeSwitchImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getRunnableModeSwitch()
	 * @generated
	 */
	int RUNNABLE_MODE_SWITCH = 323;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_MODE_SWITCH__CUSTOM_PROPERTIES = RUNNABLE_ITEM__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_MODE_SWITCH__CONTAINING_RUNNABLE = RUNNABLE_ITEM__CONTAINING_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Entries</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_MODE_SWITCH__ENTRIES = RUNNABLE_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Default Entry</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_MODE_SWITCH__DEFAULT_ENTRY = RUNNABLE_ITEM_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Runnable Mode Switch</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_MODE_SWITCH_FEATURE_COUNT = RUNNABLE_ITEM_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Runnable Mode Switch</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_MODE_SWITCH_OPERATION_COUNT = RUNNABLE_ITEM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.LabelAccessImpl <em>Label Access</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.LabelAccessImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getLabelAccess()
	 * @generated
	 */
	int LABEL_ACCESS = 324;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_ACCESS__CUSTOM_PROPERTIES = COMPUTATION_ITEM__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_ACCESS__CONTAINING_RUNNABLE = COMPUTATION_ITEM__CONTAINING_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_ACCESS__TAGS = COMPUTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Data</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_ACCESS__DATA = COMPUTATION_ITEM_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Access</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_ACCESS__ACCESS = COMPUTATION_ITEM_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Statistic</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_ACCESS__STATISTIC = COMPUTATION_ITEM_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Transmission Policy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_ACCESS__TRANSMISSION_POLICY = COMPUTATION_ITEM_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Data Stability</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_ACCESS__DATA_STABILITY = COMPUTATION_ITEM_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Implementation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_ACCESS__IMPLEMENTATION = COMPUTATION_ITEM_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Depends On</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_ACCESS__DEPENDS_ON = COMPUTATION_ITEM_FEATURE_COUNT + 7;

	/**
	 * The number of structural features of the '<em>Label Access</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_ACCESS_FEATURE_COUNT = COMPUTATION_ITEM_FEATURE_COUNT + 8;

	/**
	 * The number of operations of the '<em>Label Access</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_ACCESS_OPERATION_COUNT = COMPUTATION_ITEM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ChannelAccessImpl <em>Channel Access</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ChannelAccessImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getChannelAccess()
	 * @generated
	 */
	int CHANNEL_ACCESS = 325;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_ACCESS__CUSTOM_PROPERTIES = RUNNABLE_ITEM__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_ACCESS__CONTAINING_RUNNABLE = RUNNABLE_ITEM__CONTAINING_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Data</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_ACCESS__DATA = RUNNABLE_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Elements</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_ACCESS__ELEMENTS = RUNNABLE_ITEM_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Transmission Policy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_ACCESS__TRANSMISSION_POLICY = RUNNABLE_ITEM_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Channel Access</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_ACCESS_FEATURE_COUNT = RUNNABLE_ITEM_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Channel Access</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_ACCESS_OPERATION_COUNT = RUNNABLE_ITEM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ChannelSendImpl <em>Channel Send</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ChannelSendImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getChannelSend()
	 * @generated
	 */
	int CHANNEL_SEND = 326;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_SEND__CUSTOM_PROPERTIES = CHANNEL_ACCESS__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_SEND__CONTAINING_RUNNABLE = CHANNEL_ACCESS__CONTAINING_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Data</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_SEND__DATA = CHANNEL_ACCESS__DATA;

	/**
	 * The feature id for the '<em><b>Elements</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_SEND__ELEMENTS = CHANNEL_ACCESS__ELEMENTS;

	/**
	 * The feature id for the '<em><b>Transmission Policy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_SEND__TRANSMISSION_POLICY = CHANNEL_ACCESS__TRANSMISSION_POLICY;

	/**
	 * The number of structural features of the '<em>Channel Send</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_SEND_FEATURE_COUNT = CHANNEL_ACCESS_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Channel Send</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_SEND_OPERATION_COUNT = CHANNEL_ACCESS_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ChannelReceiveImpl <em>Channel Receive</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ChannelReceiveImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getChannelReceive()
	 * @generated
	 */
	int CHANNEL_RECEIVE = 327;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_RECEIVE__CUSTOM_PROPERTIES = CHANNEL_ACCESS__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_RECEIVE__CONTAINING_RUNNABLE = CHANNEL_ACCESS__CONTAINING_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Data</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_RECEIVE__DATA = CHANNEL_ACCESS__DATA;

	/**
	 * The feature id for the '<em><b>Elements</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_RECEIVE__ELEMENTS = CHANNEL_ACCESS__ELEMENTS;

	/**
	 * The feature id for the '<em><b>Transmission Policy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_RECEIVE__TRANSMISSION_POLICY = CHANNEL_ACCESS__TRANSMISSION_POLICY;

	/**
	 * The feature id for the '<em><b>Receive Operation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_RECEIVE__RECEIVE_OPERATION = CHANNEL_ACCESS_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Data Must Be New</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_RECEIVE__DATA_MUST_BE_NEW = CHANNEL_ACCESS_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Element Index</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_RECEIVE__ELEMENT_INDEX = CHANNEL_ACCESS_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_RECEIVE__LOWER_BOUND = CHANNEL_ACCESS_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Channel Receive</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_RECEIVE_FEATURE_COUNT = CHANNEL_ACCESS_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>Channel Receive</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHANNEL_RECEIVE_OPERATION_COUNT = CHANNEL_ACCESS_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.SemaphoreAccessImpl <em>Semaphore Access</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.SemaphoreAccessImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSemaphoreAccess()
	 * @generated
	 */
	int SEMAPHORE_ACCESS = 328;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_ACCESS__CUSTOM_PROPERTIES = RUNNABLE_ITEM__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_ACCESS__CONTAINING_RUNNABLE = RUNNABLE_ITEM__CONTAINING_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Semaphore</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_ACCESS__SEMAPHORE = RUNNABLE_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Access</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_ACCESS__ACCESS = RUNNABLE_ITEM_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Waiting Behaviour</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_ACCESS__WAITING_BEHAVIOUR = RUNNABLE_ITEM_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Semaphore Access</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_ACCESS_FEATURE_COUNT = RUNNABLE_ITEM_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Semaphore Access</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEMAPHORE_ACCESS_OPERATION_COUNT = RUNNABLE_ITEM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.SenderReceiverCommunicationImpl <em>Sender Receiver Communication</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.SenderReceiverCommunicationImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSenderReceiverCommunication()
	 * @generated
	 */
	int SENDER_RECEIVER_COMMUNICATION = 329;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_COMMUNICATION__CUSTOM_PROPERTIES = RUNNABLE_ITEM__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_COMMUNICATION__CONTAINING_RUNNABLE = RUNNABLE_ITEM__CONTAINING_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Buffered</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_COMMUNICATION__BUFFERED = RUNNABLE_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Label</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_COMMUNICATION__LABEL = RUNNABLE_ITEM_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Port</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_COMMUNICATION__PORT = RUNNABLE_ITEM_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Sender Receiver Communication</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_COMMUNICATION_FEATURE_COUNT = RUNNABLE_ITEM_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Sender Receiver Communication</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_COMMUNICATION_OPERATION_COUNT = RUNNABLE_ITEM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.SenderReceiverReadImpl <em>Sender Receiver Read</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.SenderReceiverReadImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSenderReceiverRead()
	 * @generated
	 */
	int SENDER_RECEIVER_READ = 330;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_READ__CUSTOM_PROPERTIES = SENDER_RECEIVER_COMMUNICATION__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_READ__CONTAINING_RUNNABLE = SENDER_RECEIVER_COMMUNICATION__CONTAINING_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Buffered</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_READ__BUFFERED = SENDER_RECEIVER_COMMUNICATION__BUFFERED;

	/**
	 * The feature id for the '<em><b>Label</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_READ__LABEL = SENDER_RECEIVER_COMMUNICATION__LABEL;

	/**
	 * The feature id for the '<em><b>Port</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_READ__PORT = SENDER_RECEIVER_COMMUNICATION__PORT;

	/**
	 * The number of structural features of the '<em>Sender Receiver Read</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_READ_FEATURE_COUNT = SENDER_RECEIVER_COMMUNICATION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Sender Receiver Read</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_READ_OPERATION_COUNT = SENDER_RECEIVER_COMMUNICATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.SenderReceiverWriteImpl <em>Sender Receiver Write</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.SenderReceiverWriteImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSenderReceiverWrite()
	 * @generated
	 */
	int SENDER_RECEIVER_WRITE = 331;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_WRITE__CUSTOM_PROPERTIES = SENDER_RECEIVER_COMMUNICATION__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_WRITE__CONTAINING_RUNNABLE = SENDER_RECEIVER_COMMUNICATION__CONTAINING_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Buffered</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_WRITE__BUFFERED = SENDER_RECEIVER_COMMUNICATION__BUFFERED;

	/**
	 * The feature id for the '<em><b>Label</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_WRITE__LABEL = SENDER_RECEIVER_COMMUNICATION__LABEL;

	/**
	 * The feature id for the '<em><b>Port</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_WRITE__PORT = SENDER_RECEIVER_COMMUNICATION__PORT;

	/**
	 * The feature id for the '<em><b>Notified Runnables</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_WRITE__NOTIFIED_RUNNABLES = SENDER_RECEIVER_COMMUNICATION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Sender Receiver Write</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_WRITE_FEATURE_COUNT = SENDER_RECEIVER_COMMUNICATION_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Sender Receiver Write</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENDER_RECEIVER_WRITE_OPERATION_COUNT = SENDER_RECEIVER_COMMUNICATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ServerCallImpl <em>Server Call</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ServerCallImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getServerCall()
	 * @generated
	 */
	int SERVER_CALL = 332;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVER_CALL__CUSTOM_PROPERTIES = RUNNABLE_ITEM__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVER_CALL__CONTAINING_RUNNABLE = RUNNABLE_ITEM__CONTAINING_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Server Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVER_CALL__SERVER_RUNNABLE = RUNNABLE_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Port</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVER_CALL__PORT = RUNNABLE_ITEM_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Server Call</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVER_CALL_FEATURE_COUNT = RUNNABLE_ITEM_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Server Call</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVER_CALL_OPERATION_COUNT = RUNNABLE_ITEM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.SynchronousServerCallImpl <em>Synchronous Server Call</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.SynchronousServerCallImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSynchronousServerCall()
	 * @generated
	 */
	int SYNCHRONOUS_SERVER_CALL = 333;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNCHRONOUS_SERVER_CALL__CUSTOM_PROPERTIES = SERVER_CALL__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNCHRONOUS_SERVER_CALL__CONTAINING_RUNNABLE = SERVER_CALL__CONTAINING_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Server Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNCHRONOUS_SERVER_CALL__SERVER_RUNNABLE = SERVER_CALL__SERVER_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Port</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNCHRONOUS_SERVER_CALL__PORT = SERVER_CALL__PORT;

	/**
	 * The feature id for the '<em><b>Waiting Behaviour</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNCHRONOUS_SERVER_CALL__WAITING_BEHAVIOUR = SERVER_CALL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Synchronous Server Call</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNCHRONOUS_SERVER_CALL_FEATURE_COUNT = SERVER_CALL_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Synchronous Server Call</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNCHRONOUS_SERVER_CALL_OPERATION_COUNT = SERVER_CALL_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.AsynchronousServerCallImpl <em>Asynchronous Server Call</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.AsynchronousServerCallImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getAsynchronousServerCall()
	 * @generated
	 */
	int ASYNCHRONOUS_SERVER_CALL = 334;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASYNCHRONOUS_SERVER_CALL__CUSTOM_PROPERTIES = SERVER_CALL__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASYNCHRONOUS_SERVER_CALL__CONTAINING_RUNNABLE = SERVER_CALL__CONTAINING_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Server Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASYNCHRONOUS_SERVER_CALL__SERVER_RUNNABLE = SERVER_CALL__SERVER_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Port</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASYNCHRONOUS_SERVER_CALL__PORT = SERVER_CALL__PORT;

	/**
	 * The feature id for the '<em><b>Result Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASYNCHRONOUS_SERVER_CALL__RESULT_RUNNABLE = SERVER_CALL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Asynchronous Server Call</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASYNCHRONOUS_SERVER_CALL_FEATURE_COUNT = SERVER_CALL_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Asynchronous Server Call</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASYNCHRONOUS_SERVER_CALL_OPERATION_COUNT = SERVER_CALL_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.GetResultServerCallImpl <em>Get Result Server Call</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.GetResultServerCallImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getGetResultServerCall()
	 * @generated
	 */
	int GET_RESULT_SERVER_CALL = 335;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GET_RESULT_SERVER_CALL__CUSTOM_PROPERTIES = SERVER_CALL__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GET_RESULT_SERVER_CALL__CONTAINING_RUNNABLE = SERVER_CALL__CONTAINING_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Server Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GET_RESULT_SERVER_CALL__SERVER_RUNNABLE = SERVER_CALL__SERVER_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Port</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GET_RESULT_SERVER_CALL__PORT = SERVER_CALL__PORT;

	/**
	 * The feature id for the '<em><b>Blocking Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GET_RESULT_SERVER_CALL__BLOCKING_TYPE = SERVER_CALL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Get Result Server Call</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GET_RESULT_SERVER_CALL_FEATURE_COUNT = SERVER_CALL_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Get Result Server Call</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GET_RESULT_SERVER_CALL_OPERATION_COUNT = SERVER_CALL_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.RunnableProbabilitySwitchImpl <em>Runnable Probability Switch</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.RunnableProbabilitySwitchImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getRunnableProbabilitySwitch()
	 * @generated
	 */
	int RUNNABLE_PROBABILITY_SWITCH = 336;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PROBABILITY_SWITCH__CUSTOM_PROPERTIES = RUNNABLE_ITEM__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PROBABILITY_SWITCH__CONTAINING_RUNNABLE = RUNNABLE_ITEM__CONTAINING_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Entries</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PROBABILITY_SWITCH__ENTRIES = RUNNABLE_ITEM_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Runnable Probability Switch</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PROBABILITY_SWITCH_FEATURE_COUNT = RUNNABLE_ITEM_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Runnable Probability Switch</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_PROBABILITY_SWITCH_OPERATION_COUNT = RUNNABLE_ITEM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.GroupImpl <em>Group</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.GroupImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getGroup()
	 * @generated
	 */
	int GROUP = 337;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GROUP__CUSTOM_PROPERTIES = RUNNABLE_ITEM__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GROUP__CONTAINING_RUNNABLE = RUNNABLE_ITEM__CONTAINING_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GROUP__NAME = RUNNABLE_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Ordered</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GROUP__ORDERED = RUNNABLE_ITEM_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Items</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GROUP__ITEMS = RUNNABLE_ITEM_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GROUP_FEATURE_COUNT = RUNNABLE_ITEM_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GROUP_OPERATION_COUNT = RUNNABLE_ITEM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.CallArgumentImpl <em>Call Argument</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.CallArgumentImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getCallArgument()
	 * @generated
	 */
	int CALL_ARGUMENT = 338;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CALL_ARGUMENT__NAME = REFERABLE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CALL_ARGUMENT__UNIQUE_NAME = REFERABLE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Containing Call</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CALL_ARGUMENT__CONTAINING_CALL = REFERABLE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Parameter</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CALL_ARGUMENT__PARAMETER = REFERABLE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Depends On</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CALL_ARGUMENT__DEPENDS_ON = REFERABLE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Call Argument</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CALL_ARGUMENT_FEATURE_COUNT = REFERABLE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CALL_ARGUMENT___BASIC_COMPUTE_UNIQUE_NAME = REFERABLE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CALL_ARGUMENT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = REFERABLE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CALL_ARGUMENT___ENCODE__STRING = REFERABLE_OBJECT___ENCODE__STRING;

	/**
	 * The operation id for the '<em>Get Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CALL_ARGUMENT___GET_NAME = REFERABLE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CALL_ARGUMENT___COMPUTE_UNIQUE_NAME = REFERABLE_OBJECT_OPERATION_COUNT + 1;

	/**
	 * The number of operations of the '<em>Call Argument</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CALL_ARGUMENT_OPERATION_COUNT = REFERABLE_OBJECT_OPERATION_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.RunnableCallImpl <em>Runnable Call</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.RunnableCallImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getRunnableCall()
	 * @generated
	 */
	int RUNNABLE_CALL = 339;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_CALL__CUSTOM_PROPERTIES = RUNNABLE_ITEM__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_CALL__CONTAINING_RUNNABLE = RUNNABLE_ITEM__CONTAINING_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_CALL__TAGS = RUNNABLE_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_CALL__RUNNABLE = RUNNABLE_ITEM_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Arguments</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_CALL__ARGUMENTS = RUNNABLE_ITEM_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Statistic</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_CALL__STATISTIC = RUNNABLE_ITEM_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Runnable Call</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_CALL_FEATURE_COUNT = RUNNABLE_ITEM_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>Runnable Call</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_CALL_OPERATION_COUNT = RUNNABLE_ITEM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.CustomEventTriggerImpl <em>Custom Event Trigger</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.CustomEventTriggerImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getCustomEventTrigger()
	 * @generated
	 */
	int CUSTOM_EVENT_TRIGGER = 340;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_EVENT_TRIGGER__CUSTOM_PROPERTIES = RUNNABLE_ITEM__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Containing Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_EVENT_TRIGGER__CONTAINING_RUNNABLE = RUNNABLE_ITEM__CONTAINING_RUNNABLE;

	/**
	 * The feature id for the '<em><b>Event</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_EVENT_TRIGGER__EVENT = RUNNABLE_ITEM_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Custom Event Trigger</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_EVENT_TRIGGER_FEATURE_COUNT = RUNNABLE_ITEM_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Custom Event Trigger</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_EVENT_TRIGGER_OPERATION_COUNT = RUNNABLE_ITEM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.DataType <em>Data Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.DataType
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDataType()
	 * @generated
	 */
	int DATA_TYPE = 341;

	/**
	 * The number of structural features of the '<em>Data Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Data Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.CompoundType <em>Compound Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.CompoundType
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getCompoundType()
	 * @generated
	 */
	int COMPOUND_TYPE = 342;

	/**
	 * The number of structural features of the '<em>Compound Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOUND_TYPE_FEATURE_COUNT = DATA_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Compound Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOUND_TYPE_OPERATION_COUNT = DATA_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.StructImpl <em>Struct</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.StructImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getStruct()
	 * @generated
	 */
	int STRUCT = 343;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCT__CUSTOM_PROPERTIES = COMPOUND_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Entries</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCT__ENTRIES = COMPOUND_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Struct</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCT_FEATURE_COUNT = COMPOUND_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Struct</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCT_OPERATION_COUNT = COMPOUND_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.StructEntryImpl <em>Struct Entry</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.StructEntryImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getStructEntry()
	 * @generated
	 */
	int STRUCT_ENTRY = 344;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCT_ENTRY__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCT_ENTRY__NAME = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Data Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCT_ENTRY__DATA_TYPE = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Struct Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCT_ENTRY_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Struct Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRUCT_ENTRY_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ArrayImpl <em>Array</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ArrayImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getArray()
	 * @generated
	 */
	int ARRAY = 345;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY__CUSTOM_PROPERTIES = COMPOUND_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Number Elements</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY__NUMBER_ELEMENTS = COMPOUND_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Data Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY__DATA_TYPE = COMPOUND_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Array</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_FEATURE_COUNT = COMPOUND_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Array</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_OPERATION_COUNT = COMPOUND_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.PointerImpl <em>Pointer</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.PointerImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getPointer()
	 * @generated
	 */
	int POINTER = 346;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINTER__CUSTOM_PROPERTIES = COMPOUND_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Data Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINTER__DATA_TYPE = COMPOUND_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Pointer</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINTER_FEATURE_COUNT = COMPOUND_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Pointer</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINTER_OPERATION_COUNT = COMPOUND_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TypeRefImpl <em>Type Ref</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TypeRefImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTypeRef()
	 * @generated
	 */
	int TYPE_REF = 347;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_REF__CUSTOM_PROPERTIES = DATA_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Type Def</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_REF__TYPE_DEF = DATA_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Type Ref</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_REF_FEATURE_COUNT = DATA_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Type Ref</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_REF_OPERATION_COUNT = DATA_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DataPlatformMappingImpl <em>Data Platform Mapping</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DataPlatformMappingImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDataPlatformMapping()
	 * @generated
	 */
	int DATA_PLATFORM_MAPPING = 348;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_PLATFORM_MAPPING__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Platform Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_PLATFORM_MAPPING__PLATFORM_NAME = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Platform Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_PLATFORM_MAPPING__PLATFORM_TYPE = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Data Platform Mapping</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_PLATFORM_MAPPING_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Data Platform Mapping</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_PLATFORM_MAPPING_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TypeDefinitionImpl <em>Type Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TypeDefinitionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTypeDefinition()
	 * @generated
	 */
	int TYPE_DEFINITION = 349;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_DEFINITION__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_DEFINITION__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_DEFINITION__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The number of structural features of the '<em>Type Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_DEFINITION_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_DEFINITION___COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_DEFINITION___BASIC_COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_DEFINITION___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_DEFINITION___ENCODE__STRING = REFERABLE_BASE_OBJECT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Type Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_DEFINITION_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.DataTypeDefinitionImpl <em>Data Type Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.DataTypeDefinitionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDataTypeDefinition()
	 * @generated
	 */
	int DATA_TYPE_DEFINITION = 350;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE_DEFINITION__CUSTOM_PROPERTIES = TYPE_DEFINITION__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE_DEFINITION__NAME = TYPE_DEFINITION__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE_DEFINITION__UNIQUE_NAME = TYPE_DEFINITION__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Data Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE_DEFINITION__DATA_TYPE = TYPE_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Data Type Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE_DEFINITION_FEATURE_COUNT = TYPE_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE_DEFINITION___COMPUTE_UNIQUE_NAME = TYPE_DEFINITION___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE_DEFINITION___BASIC_COMPUTE_UNIQUE_NAME = TYPE_DEFINITION___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE_DEFINITION___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = TYPE_DEFINITION___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE_DEFINITION___ENCODE__STRING = TYPE_DEFINITION___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Data Type Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE_DEFINITION_OPERATION_COUNT = TYPE_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.BaseTypeDefinitionImpl <em>Base Type Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.BaseTypeDefinitionImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getBaseTypeDefinition()
	 * @generated
	 */
	int BASE_TYPE_DEFINITION = 351;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE_TYPE_DEFINITION__CUSTOM_PROPERTIES = TYPE_DEFINITION__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE_TYPE_DEFINITION__NAME = TYPE_DEFINITION__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE_TYPE_DEFINITION__UNIQUE_NAME = TYPE_DEFINITION__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Size</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE_TYPE_DEFINITION__SIZE = TYPE_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Data Mapping</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE_TYPE_DEFINITION__DATA_MAPPING = TYPE_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Base Type Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE_TYPE_DEFINITION_FEATURE_COUNT = TYPE_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE_TYPE_DEFINITION___COMPUTE_UNIQUE_NAME = TYPE_DEFINITION___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE_TYPE_DEFINITION___BASIC_COMPUTE_UNIQUE_NAME = TYPE_DEFINITION___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE_TYPE_DEFINITION___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = TYPE_DEFINITION___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE_TYPE_DEFINITION___ENCODE__STRING = TYPE_DEFINITION___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Base Type Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE_TYPE_DEFINITION_OPERATION_COUNT = TYPE_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.ActivationImpl <em>Activation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.ActivationImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getActivation()
	 * @generated
	 */
	int ACTIVATION = 352;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTIVATION__CUSTOM_PROPERTIES = REFERABLE_BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTIVATION__NAME = REFERABLE_BASE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTIVATION__UNIQUE_NAME = REFERABLE_BASE_OBJECT__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTIVATION__TAGS = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Activation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTIVATION_FEATURE_COUNT = REFERABLE_BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTIVATION___COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTIVATION___BASIC_COMPUTE_UNIQUE_NAME = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTIVATION___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = REFERABLE_BASE_OBJECT___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTIVATION___ENCODE__STRING = REFERABLE_BASE_OBJECT___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Activation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTIVATION_OPERATION_COUNT = REFERABLE_BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.PeriodicActivationImpl <em>Periodic Activation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.PeriodicActivationImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getPeriodicActivation()
	 * @generated
	 */
	int PERIODIC_ACTIVATION = 353;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_ACTIVATION__CUSTOM_PROPERTIES = ACTIVATION__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_ACTIVATION__NAME = ACTIVATION__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_ACTIVATION__UNIQUE_NAME = ACTIVATION__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_ACTIVATION__TAGS = ACTIVATION__TAGS;

	/**
	 * The feature id for the '<em><b>Min</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_ACTIVATION__MIN = ACTIVATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Max</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_ACTIVATION__MAX = ACTIVATION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Recurrence</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_ACTIVATION__RECURRENCE = ACTIVATION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Offset</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_ACTIVATION__OFFSET = ACTIVATION_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Periodic Activation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_ACTIVATION_FEATURE_COUNT = ACTIVATION_FEATURE_COUNT + 4;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_ACTIVATION___COMPUTE_UNIQUE_NAME = ACTIVATION___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_ACTIVATION___BASIC_COMPUTE_UNIQUE_NAME = ACTIVATION___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_ACTIVATION___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = ACTIVATION___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_ACTIVATION___ENCODE__STRING = ACTIVATION___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Periodic Activation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERIODIC_ACTIVATION_OPERATION_COUNT = ACTIVATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.VariableRateActivationImpl <em>Variable Rate Activation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.VariableRateActivationImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getVariableRateActivation()
	 * @generated
	 */
	int VARIABLE_RATE_ACTIVATION = 354;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_ACTIVATION__CUSTOM_PROPERTIES = ACTIVATION__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_ACTIVATION__NAME = ACTIVATION__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_ACTIVATION__UNIQUE_NAME = ACTIVATION__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_ACTIVATION__TAGS = ACTIVATION__TAGS;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_ACTIVATION__DESCRIPTION = ACTIVATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Step</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_ACTIVATION__STEP = ACTIVATION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Occurrences Per Step</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_ACTIVATION__OCCURRENCES_PER_STEP = ACTIVATION_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Variable Rate Activation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_ACTIVATION_FEATURE_COUNT = ACTIVATION_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_ACTIVATION___COMPUTE_UNIQUE_NAME = ACTIVATION___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_ACTIVATION___BASIC_COMPUTE_UNIQUE_NAME = ACTIVATION___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_ACTIVATION___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = ACTIVATION___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_ACTIVATION___ENCODE__STRING = ACTIVATION___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Variable Rate Activation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIABLE_RATE_ACTIVATION_OPERATION_COUNT = ACTIVATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.SporadicActivationImpl <em>Sporadic Activation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.SporadicActivationImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSporadicActivation()
	 * @generated
	 */
	int SPORADIC_ACTIVATION = 355;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPORADIC_ACTIVATION__CUSTOM_PROPERTIES = ACTIVATION__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPORADIC_ACTIVATION__NAME = ACTIVATION__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPORADIC_ACTIVATION__UNIQUE_NAME = ACTIVATION__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPORADIC_ACTIVATION__TAGS = ACTIVATION__TAGS;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPORADIC_ACTIVATION__DESCRIPTION = ACTIVATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Occurrence</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPORADIC_ACTIVATION__OCCURRENCE = ACTIVATION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Sporadic Activation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPORADIC_ACTIVATION_FEATURE_COUNT = ACTIVATION_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPORADIC_ACTIVATION___COMPUTE_UNIQUE_NAME = ACTIVATION___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPORADIC_ACTIVATION___BASIC_COMPUTE_UNIQUE_NAME = ACTIVATION___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPORADIC_ACTIVATION___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = ACTIVATION___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPORADIC_ACTIVATION___ENCODE__STRING = ACTIVATION___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Sporadic Activation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPORADIC_ACTIVATION_OPERATION_COUNT = ACTIVATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.SingleActivationImpl <em>Single Activation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.SingleActivationImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSingleActivation()
	 * @generated
	 */
	int SINGLE_ACTIVATION = 356;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_ACTIVATION__CUSTOM_PROPERTIES = ACTIVATION__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_ACTIVATION__NAME = ACTIVATION__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_ACTIVATION__UNIQUE_NAME = ACTIVATION__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_ACTIVATION__TAGS = ACTIVATION__TAGS;

	/**
	 * The feature id for the '<em><b>Min</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_ACTIVATION__MIN = ACTIVATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Max</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_ACTIVATION__MAX = ACTIVATION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Single Activation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_ACTIVATION_FEATURE_COUNT = ACTIVATION_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_ACTIVATION___COMPUTE_UNIQUE_NAME = ACTIVATION___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_ACTIVATION___BASIC_COMPUTE_UNIQUE_NAME = ACTIVATION___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_ACTIVATION___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = ACTIVATION___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_ACTIVATION___ENCODE__STRING = ACTIVATION___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Single Activation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_ACTIVATION_OPERATION_COUNT = ACTIVATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.EventActivationImpl <em>Event Activation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.EventActivationImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getEventActivation()
	 * @generated
	 */
	int EVENT_ACTIVATION = 357;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ACTIVATION__CUSTOM_PROPERTIES = ACTIVATION__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ACTIVATION__NAME = ACTIVATION__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ACTIVATION__UNIQUE_NAME = ACTIVATION__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ACTIVATION__TAGS = ACTIVATION__TAGS;

	/**
	 * The feature id for the '<em><b>Triggering Events</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ACTIVATION__TRIGGERING_EVENTS = ACTIVATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Counter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ACTIVATION__COUNTER = ACTIVATION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Event Activation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ACTIVATION_FEATURE_COUNT = ACTIVATION_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ACTIVATION___COMPUTE_UNIQUE_NAME = ACTIVATION___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ACTIVATION___BASIC_COMPUTE_UNIQUE_NAME = ACTIVATION___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ACTIVATION___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = ACTIVATION___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ACTIVATION___ENCODE__STRING = ACTIVATION___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Event Activation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ACTIVATION_OPERATION_COUNT = ACTIVATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.CustomActivationImpl <em>Custom Activation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.CustomActivationImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getCustomActivation()
	 * @generated
	 */
	int CUSTOM_ACTIVATION = 358;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_ACTIVATION__CUSTOM_PROPERTIES = ACTIVATION__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_ACTIVATION__NAME = ACTIVATION__NAME;

	/**
	 * The feature id for the '<em><b>Unique Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_ACTIVATION__UNIQUE_NAME = ACTIVATION__UNIQUE_NAME;

	/**
	 * The feature id for the '<em><b>Tags</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_ACTIVATION__TAGS = ACTIVATION__TAGS;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_ACTIVATION__DESCRIPTION = ACTIVATION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Custom Activation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_ACTIVATION_FEATURE_COUNT = ACTIVATION_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_ACTIVATION___COMPUTE_UNIQUE_NAME = ACTIVATION___COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_ACTIVATION___BASIC_COMPUTE_UNIQUE_NAME = ACTIVATION___BASIC_COMPUTE_UNIQUE_NAME;

	/**
	 * The operation id for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_ACTIVATION___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING = ACTIVATION___BASIC_COMPUTE_UNIQUE_NAME_WITH_PREFIX__STRING;

	/**
	 * The operation id for the '<em>Encode</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_ACTIVATION___ENCODE__STRING = ACTIVATION___ENCODE__STRING;

	/**
	 * The number of operations of the '<em>Custom Activation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_ACTIVATION_OPERATION_COUNT = ACTIVATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.LabelAccessStatisticImpl <em>Label Access Statistic</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.LabelAccessStatisticImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getLabelAccessStatistic()
	 * @generated
	 */
	int LABEL_ACCESS_STATISTIC = 359;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_ACCESS_STATISTIC__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_ACCESS_STATISTIC__VALUE = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Cache Misses</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_ACCESS_STATISTIC__CACHE_MISSES = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Label Access Statistic</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_ACCESS_STATISTIC_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Label Access Statistic</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_ACCESS_STATISTIC_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.RunEntityCallStatisticImpl <em>Run Entity Call Statistic</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.RunEntityCallStatisticImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getRunEntityCallStatistic()
	 * @generated
	 */
	int RUN_ENTITY_CALL_STATISTIC = 360;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUN_ENTITY_CALL_STATISTIC__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Statistic</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUN_ENTITY_CALL_STATISTIC__STATISTIC = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Run Entity Call Statistic</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUN_ENTITY_CALL_STATISTIC_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Run Entity Call Statistic</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUN_ENTITY_CALL_STATISTIC_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.MeasurementModelImpl <em>Measurement Model</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.MeasurementModelImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getMeasurementModel()
	 * @generated
	 */
	int MEASUREMENT_MODEL = 361;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEASUREMENT_MODEL__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Measurements</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEASUREMENT_MODEL__MEASUREMENTS = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Measurement Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEASUREMENT_MODEL_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Measurement Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEASUREMENT_MODEL_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.MeasurementImpl <em>Measurement</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.MeasurementImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getMeasurement()
	 * @generated
	 */
	int MEASUREMENT = 362;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEASUREMENT__CUSTOM_PROPERTIES = BASE_OBJECT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Runtimes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEASUREMENT__RUNTIMES = BASE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Runtime Deviation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEASUREMENT__RUNTIME_DEVIATION = BASE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Measurement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEASUREMENT_FEATURE_COUNT = BASE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Measurement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEASUREMENT_OPERATION_COUNT = BASE_OBJECT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.EventChainMeasurementImpl <em>Event Chain Measurement</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.EventChainMeasurementImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getEventChainMeasurement()
	 * @generated
	 */
	int EVENT_CHAIN_MEASUREMENT = 363;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_MEASUREMENT__CUSTOM_PROPERTIES = MEASUREMENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Runtimes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_MEASUREMENT__RUNTIMES = MEASUREMENT__RUNTIMES;

	/**
	 * The feature id for the '<em><b>Runtime Deviation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_MEASUREMENT__RUNTIME_DEVIATION = MEASUREMENT__RUNTIME_DEVIATION;

	/**
	 * The feature id for the '<em><b>Event Chain</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_MEASUREMENT__EVENT_CHAIN = MEASUREMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Event Chain Measurement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_MEASUREMENT_FEATURE_COUNT = MEASUREMENT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Event Chain Measurement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_CHAIN_MEASUREMENT_OPERATION_COUNT = MEASUREMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.TaskMeasurementImpl <em>Task Measurement</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.TaskMeasurementImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTaskMeasurement()
	 * @generated
	 */
	int TASK_MEASUREMENT = 364;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_MEASUREMENT__CUSTOM_PROPERTIES = MEASUREMENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Runtimes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_MEASUREMENT__RUNTIMES = MEASUREMENT__RUNTIMES;

	/**
	 * The feature id for the '<em><b>Runtime Deviation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_MEASUREMENT__RUNTIME_DEVIATION = MEASUREMENT__RUNTIME_DEVIATION;

	/**
	 * The feature id for the '<em><b>Task</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_MEASUREMENT__TASK = MEASUREMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Task Measurement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_MEASUREMENT_FEATURE_COUNT = MEASUREMENT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Task Measurement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TASK_MEASUREMENT_OPERATION_COUNT = MEASUREMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.impl.RunnableMeasurementImpl <em>Runnable Measurement</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.RunnableMeasurementImpl
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getRunnableMeasurement()
	 * @generated
	 */
	int RUNNABLE_MEASUREMENT = 365;

	/**
	 * The feature id for the '<em><b>Custom Properties</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_MEASUREMENT__CUSTOM_PROPERTIES = MEASUREMENT__CUSTOM_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Runtimes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_MEASUREMENT__RUNTIMES = MEASUREMENT__RUNTIMES;

	/**
	 * The feature id for the '<em><b>Runtime Deviation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_MEASUREMENT__RUNTIME_DEVIATION = MEASUREMENT__RUNTIME_DEVIATION;

	/**
	 * The feature id for the '<em><b>Runnable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_MEASUREMENT__RUNNABLE = MEASUREMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Runnable Measurement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_MEASUREMENT_FEATURE_COUNT = MEASUREMENT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Runnable Measurement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNNABLE_MEASUREMENT_OPERATION_COUNT = MEASUREMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.TimeUnit <em>Time Unit</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.TimeUnit
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTimeUnit()
	 * @generated
	 */
	int TIME_UNIT = 366;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.FrequencyUnit <em>Frequency Unit</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.FrequencyUnit
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getFrequencyUnit()
	 * @generated
	 */
	int FREQUENCY_UNIT = 367;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.VoltageUnit <em>Voltage Unit</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.VoltageUnit
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getVoltageUnit()
	 * @generated
	 */
	int VOLTAGE_UNIT = 368;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.DataSizeUnit <em>Data Size Unit</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.DataSizeUnit
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDataSizeUnit()
	 * @generated
	 */
	int DATA_SIZE_UNIT = 369;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.DataRateUnit <em>Data Rate Unit</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.DataRateUnit
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDataRateUnit()
	 * @generated
	 */
	int DATA_RATE_UNIT = 370;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.SamplingType <em>Sampling Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.SamplingType
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSamplingType()
	 * @generated
	 */
	int SAMPLING_TYPE = 371;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.InterfaceKind <em>Interface Kind</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.InterfaceKind
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getInterfaceKind()
	 * @generated
	 */
	int INTERFACE_KIND = 372;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.RunnableOrderType <em>Runnable Order Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.RunnableOrderType
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getRunnableOrderType()
	 * @generated
	 */
	int RUNNABLE_ORDER_TYPE = 373;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.SynchronizationType <em>Synchronization Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.SynchronizationType
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSynchronizationType()
	 * @generated
	 */
	int SYNCHRONIZATION_TYPE = 374;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.MappingType <em>Mapping Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.MappingType
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getMappingType()
	 * @generated
	 */
	int MAPPING_TYPE = 375;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.LatencyType <em>Latency Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.LatencyType
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getLatencyType()
	 * @generated
	 */
	int LATENCY_TYPE = 376;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.Severity <em>Severity</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.Severity
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSeverity()
	 * @generated
	 */
	int SEVERITY = 377;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.LimitType <em>Limit Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.LimitType
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getLimitType()
	 * @generated
	 */
	int LIMIT_TYPE = 378;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.TimeMetric <em>Time Metric</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.TimeMetric
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getTimeMetric()
	 * @generated
	 */
	int TIME_METRIC = 379;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.CountMetric <em>Count Metric</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.CountMetric
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getCountMetric()
	 * @generated
	 */
	int COUNT_METRIC = 380;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.PercentageMetric <em>Percentage Metric</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.PercentageMetric
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getPercentageMetric()
	 * @generated
	 */
	int PERCENTAGE_METRIC = 381;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.CPUPercentageMetric <em>CPU Percentage Metric</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.CPUPercentageMetric
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getCPUPercentageMetric()
	 * @generated
	 */
	int CPU_PERCENTAGE_METRIC = 382;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.FrequencyMetric <em>Frequency Metric</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.FrequencyMetric
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getFrequencyMetric()
	 * @generated
	 */
	int FREQUENCY_METRIC = 383;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.CoherencyDirection <em>Coherency Direction</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.CoherencyDirection
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getCoherencyDirection()
	 * @generated
	 */
	int COHERENCY_DIRECTION = 384;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.ProcessEventType <em>Process Event Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.ProcessEventType
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getProcessEventType()
	 * @generated
	 */
	int PROCESS_EVENT_TYPE = 385;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.RunnableEventType <em>Runnable Event Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.RunnableEventType
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getRunnableEventType()
	 * @generated
	 */
	int RUNNABLE_EVENT_TYPE = 386;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.LabelEventType <em>Label Event Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.LabelEventType
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getLabelEventType()
	 * @generated
	 */
	int LABEL_EVENT_TYPE = 387;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.ChannelEventType <em>Channel Event Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.ChannelEventType
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getChannelEventType()
	 * @generated
	 */
	int CHANNEL_EVENT_TYPE = 388;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.SemaphoreEventType <em>Semaphore Event Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.SemaphoreEventType
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSemaphoreEventType()
	 * @generated
	 */
	int SEMAPHORE_EVENT_TYPE = 389;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.ComponentEventType <em>Component Event Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.ComponentEventType
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getComponentEventType()
	 * @generated
	 */
	int COMPONENT_EVENT_TYPE = 390;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.MemoryType <em>Memory Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.MemoryType
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getMemoryType()
	 * @generated
	 */
	int MEMORY_TYPE = 391;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.StructureType <em>Structure Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.StructureType
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getStructureType()
	 * @generated
	 */
	int STRUCTURE_TYPE = 392;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.CacheType <em>Cache Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.CacheType
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getCacheType()
	 * @generated
	 */
	int CACHE_TYPE = 393;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.PortType <em>Port Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.PortType
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getPortType()
	 * @generated
	 */
	int PORT_TYPE = 394;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.SchedPolicy <em>Sched Policy</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.SchedPolicy
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSchedPolicy()
	 * @generated
	 */
	int SCHED_POLICY = 395;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.WriteStrategy <em>Write Strategy</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.WriteStrategy
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getWriteStrategy()
	 * @generated
	 */
	int WRITE_STRATEGY = 396;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.PuType <em>Pu Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.PuType
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getPuType()
	 * @generated
	 */
	int PU_TYPE = 397;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.PortInterface <em>Port Interface</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.PortInterface
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getPortInterface()
	 * @generated
	 */
	int PORT_INTERFACE = 398;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.HwFeatureType <em>Hw Feature Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.HwFeatureType
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getHwFeatureType()
	 * @generated
	 */
	int HW_FEATURE_TYPE = 399;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.MemoryAddressMappingType <em>Memory Address Mapping Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.MemoryAddressMappingType
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getMemoryAddressMappingType()
	 * @generated
	 */
	int MEMORY_ADDRESS_MAPPING_TYPE = 400;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.OsDataConsistencyMode <em>Os Data Consistency Mode</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.OsDataConsistencyMode
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getOsDataConsistencyMode()
	 * @generated
	 */
	int OS_DATA_CONSISTENCY_MODE = 401;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.AccessMultiplicity <em>Access Multiplicity</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.AccessMultiplicity
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getAccessMultiplicity()
	 * @generated
	 */
	int ACCESS_MULTIPLICITY = 402;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.DataStabilityLevel <em>Data Stability Level</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.DataStabilityLevel
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDataStabilityLevel()
	 * @generated
	 */
	int DATA_STABILITY_LEVEL = 403;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.SemaphoreType <em>Semaphore Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.SemaphoreType
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSemaphoreType()
	 * @generated
	 */
	int SEMAPHORE_TYPE = 404;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.Condition <em>Condition</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.Condition
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getCondition()
	 * @generated
	 */
	int CONDITION = 405;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.GroupingType <em>Grouping Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.GroupingType
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getGroupingType()
	 * @generated
	 */
	int GROUPING_TYPE = 406;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.WaitEventType <em>Wait Event Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.WaitEventType
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getWaitEventType()
	 * @generated
	 */
	int WAIT_EVENT_TYPE = 407;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.WaitingBehaviour <em>Waiting Behaviour</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.WaitingBehaviour
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getWaitingBehaviour()
	 * @generated
	 */
	int WAITING_BEHAVIOUR = 408;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.ISRCategory <em>ISR Category</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.ISRCategory
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getISRCategory()
	 * @generated
	 */
	int ISR_CATEGORY = 409;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.AccessPrecedenceType <em>Access Precedence Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.AccessPrecedenceType
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getAccessPrecedenceType()
	 * @generated
	 */
	int ACCESS_PRECEDENCE_TYPE = 410;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.OrderType <em>Order Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.OrderType
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getOrderType()
	 * @generated
	 */
	int ORDER_TYPE = 411;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.DirectionType <em>Direction Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.DirectionType
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getDirectionType()
	 * @generated
	 */
	int DIRECTION_TYPE = 412;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.LabelDataStability <em>Label Data Stability</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.LabelDataStability
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getLabelDataStability()
	 * @generated
	 */
	int LABEL_DATA_STABILITY = 413;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.ReceiveOperation <em>Receive Operation</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.ReceiveOperation
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getReceiveOperation()
	 * @generated
	 */
	int RECEIVE_OPERATION = 414;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.LabelAccessDataStability <em>Label Access Data Stability</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.LabelAccessDataStability
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getLabelAccessDataStability()
	 * @generated
	 */
	int LABEL_ACCESS_DATA_STABILITY = 415;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.LabelAccessEnum <em>Label Access Enum</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.LabelAccessEnum
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getLabelAccessEnum()
	 * @generated
	 */
	int LABEL_ACCESS_ENUM = 416;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.LabelAccessImplementation <em>Label Access Implementation</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.LabelAccessImplementation
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getLabelAccessImplementation()
	 * @generated
	 */
	int LABEL_ACCESS_IMPLEMENTATION = 417;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.SemaphoreAccessEnum <em>Semaphore Access Enum</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.SemaphoreAccessEnum
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getSemaphoreAccessEnum()
	 * @generated
	 */
	int SEMAPHORE_ACCESS_ENUM = 418;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.BlockingType <em>Blocking Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.BlockingType
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getBlockingType()
	 * @generated
	 */
	int BLOCKING_TYPE = 419;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.Preemption <em>Preemption</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.Preemption
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getPreemption()
	 * @generated
	 */
	int PREEMPTION = 420;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.ConcurrencyType <em>Concurrency Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.ConcurrencyType
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getConcurrencyType()
	 * @generated
	 */
	int CONCURRENCY_TYPE = 421;

	/**
	 * The meta object id for the '{@link org.eclipse.app4mc.amalthea.model.ASILType <em>ASIL Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.ASILType
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getASILType()
	 * @generated
	 */
	int ASIL_TYPE = 422;

	/**
	 * The meta object id for the '<em>Address</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getAddress()
	 * @generated
	 */
	int ADDRESS = 423;

	/**
	 * The meta object id for the '<em>Positive Int</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getPositiveInt()
	 * @generated
	 */
	int POSITIVE_INT = 424;

	/**
	 * The meta object id for the '<em>Positive Long</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getPositiveLong()
	 * @generated
	 */
	int POSITIVE_LONG = 425;

	/**
	 * The meta object id for the '<em>Positive Double</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.app4mc.amalthea.model.impl.AmaltheaPackageImpl#getPositiveDouble()
	 * @generated
	 */
	int POSITIVE_DOUBLE = 426;


	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.Amalthea <em>Amalthea</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Amalthea</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.Amalthea
	 * @generated
	 */
	EClass getAmalthea();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.Amalthea#getVersion <em>Version</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Version</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.Amalthea#getVersion()
	 * @see #getAmalthea()
	 * @generated
	 */
	EAttribute getAmalthea_Version();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.app4mc.amalthea.model.Amalthea#getCommonElements <em>Common Elements</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Common Elements</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.Amalthea#getCommonElements()
	 * @see #getAmalthea()
	 * @generated
	 */
	EReference getAmalthea_CommonElements();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.app4mc.amalthea.model.Amalthea#getSwModel <em>Sw Model</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Sw Model</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.Amalthea#getSwModel()
	 * @see #getAmalthea()
	 * @generated
	 */
	EReference getAmalthea_SwModel();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.app4mc.amalthea.model.Amalthea#getHwModel <em>Hw Model</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Hw Model</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.Amalthea#getHwModel()
	 * @see #getAmalthea()
	 * @generated
	 */
	EReference getAmalthea_HwModel();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.app4mc.amalthea.model.Amalthea#getOsModel <em>Os Model</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Os Model</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.Amalthea#getOsModel()
	 * @see #getAmalthea()
	 * @generated
	 */
	EReference getAmalthea_OsModel();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.app4mc.amalthea.model.Amalthea#getStimuliModel <em>Stimuli Model</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Stimuli Model</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.Amalthea#getStimuliModel()
	 * @see #getAmalthea()
	 * @generated
	 */
	EReference getAmalthea_StimuliModel();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.app4mc.amalthea.model.Amalthea#getEventModel <em>Event Model</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Event Model</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.Amalthea#getEventModel()
	 * @see #getAmalthea()
	 * @generated
	 */
	EReference getAmalthea_EventModel();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.app4mc.amalthea.model.Amalthea#getConstraintsModel <em>Constraints Model</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Constraints Model</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.Amalthea#getConstraintsModel()
	 * @see #getAmalthea()
	 * @generated
	 */
	EReference getAmalthea_ConstraintsModel();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.app4mc.amalthea.model.Amalthea#getPropertyConstraintsModel <em>Property Constraints Model</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Property Constraints Model</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.Amalthea#getPropertyConstraintsModel()
	 * @see #getAmalthea()
	 * @generated
	 */
	EReference getAmalthea_PropertyConstraintsModel();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.app4mc.amalthea.model.Amalthea#getMappingModel <em>Mapping Model</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Mapping Model</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.Amalthea#getMappingModel()
	 * @see #getAmalthea()
	 * @generated
	 */
	EReference getAmalthea_MappingModel();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.app4mc.amalthea.model.Amalthea#getComponentsModel <em>Components Model</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Components Model</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.Amalthea#getComponentsModel()
	 * @see #getAmalthea()
	 * @generated
	 */
	EReference getAmalthea_ComponentsModel();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.app4mc.amalthea.model.Amalthea#getConfigModel <em>Config Model</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Config Model</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.Amalthea#getConfigModel()
	 * @see #getAmalthea()
	 * @generated
	 */
	EReference getAmalthea_ConfigModel();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.app4mc.amalthea.model.Amalthea#getMeasurementModel <em>Measurement Model</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Measurement Model</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.Amalthea#getMeasurementModel()
	 * @see #getAmalthea()
	 * @generated
	 */
	EReference getAmalthea_MeasurementModel();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.CommonElements <em>Common Elements</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Common Elements</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.CommonElements
	 * @generated
	 */
	EClass getCommonElements();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.app4mc.amalthea.model.CommonElements#getTags <em>Tags</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Tags</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.CommonElements#getTags()
	 * @see #getCommonElements()
	 * @generated
	 */
	EReference getCommonElements_Tags();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.app4mc.amalthea.model.CommonElements#getCoreClassifiers <em>Core Classifiers</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Core Classifiers</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.CommonElements#getCoreClassifiers()
	 * @see #getCommonElements()
	 * @generated
	 */
	EReference getCommonElements_CoreClassifiers();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.app4mc.amalthea.model.CommonElements#getMemoryClassifiers <em>Memory Classifiers</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Memory Classifiers</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.CommonElements#getMemoryClassifiers()
	 * @see #getCommonElements()
	 * @generated
	 */
	EReference getCommonElements_MemoryClassifiers();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.BaseObject <em>Base Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Base Object</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.BaseObject
	 * @generated
	 */
	EClass getBaseObject();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.ReferableObject <em>Referable Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Referable Object</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ReferableObject
	 * @generated
	 */
	EClass getReferableObject();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.ReferableBaseObject <em>Referable Base Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Referable Base Object</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ReferableBaseObject
	 * @generated
	 */
	EClass getReferableBaseObject();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.IAnnotatable <em>IAnnotatable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>IAnnotatable</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.IAnnotatable
	 * @generated
	 */
	EClass getIAnnotatable();

	/**
	 * Returns the meta object for the map '{@link org.eclipse.app4mc.amalthea.model.IAnnotatable#getCustomProperties <em>Custom Properties</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the map '<em>Custom Properties</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.IAnnotatable#getCustomProperties()
	 * @see #getIAnnotatable()
	 * @generated
	 */
	EReference getIAnnotatable_CustomProperties();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.ITaggable <em>ITaggable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>ITaggable</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ITaggable
	 * @generated
	 */
	EClass getITaggable();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.app4mc.amalthea.model.ITaggable#getTags <em>Tags</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Tags</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ITaggable#getTags()
	 * @see #getITaggable()
	 * @generated
	 */
	EReference getITaggable_Tags();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.INamed <em>INamed</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>INamed</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.INamed
	 * @generated
	 */
	EClass getINamed();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.INamed#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.INamed#getName()
	 * @see #getINamed()
	 * @generated
	 */
	EAttribute getINamed_Name();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.IReferable <em>IReferable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>IReferable</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.IReferable
	 * @generated
	 */
	EClass getIReferable();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.IReferable#getUniqueName <em>Unique Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Unique Name</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.IReferable#getUniqueName()
	 * @see #getIReferable()
	 * @generated
	 */
	EAttribute getIReferable_UniqueName();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.IReferable#computeUniqueName() <em>Compute Unique Name</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Compute Unique Name</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.IReferable#computeUniqueName()
	 * @generated
	 */
	EOperation getIReferable__ComputeUniqueName();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.IReferable#basicComputeUniqueName() <em>Basic Compute Unique Name</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Basic Compute Unique Name</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.IReferable#basicComputeUniqueName()
	 * @generated
	 */
	EOperation getIReferable__BasicComputeUniqueName();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.IReferable#basicComputeUniqueNameWithPrefix(java.lang.String) <em>Basic Compute Unique Name With Prefix</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Basic Compute Unique Name With Prefix</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.IReferable#basicComputeUniqueNameWithPrefix(java.lang.String)
	 * @generated
	 */
	EOperation getIReferable__BasicComputeUniqueNameWithPrefix__String();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.IReferable#encode(java.lang.String) <em>Encode</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Encode</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.IReferable#encode(java.lang.String)
	 * @generated
	 */
	EOperation getIReferable__Encode__String();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.IDisplayName <em>IDisplay Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>IDisplay Name</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.IDisplayName
	 * @generated
	 */
	EClass getIDisplayName();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.IDisplayName#getDisplayName <em>Display Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Display Name</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.IDisplayName#getDisplayName()
	 * @see #getIDisplayName()
	 * @generated
	 */
	EAttribute getIDisplayName_DisplayName();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.Tag <em>Tag</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Tag</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.Tag
	 * @generated
	 */
	EClass getTag();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.Tag#getTagType <em>Tag Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Tag Type</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.Tag#getTagType()
	 * @see #getTag()
	 * @generated
	 */
	EAttribute getTag_TagType();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.app4mc.amalthea.model.Tag#getTaggedObjects <em>Tagged Objects</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Tagged Objects</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.Tag#getTaggedObjects()
	 * @see #getTag()
	 * @generated
	 */
	EReference getTag_TaggedObjects();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.Classifier <em>Classifier</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Classifier</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.Classifier
	 * @generated
	 */
	EClass getClassifier();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.Classifier#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Description</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.Classifier#getDescription()
	 * @see #getClassifier()
	 * @generated
	 */
	EAttribute getClassifier_Description();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.CoreClassifier <em>Core Classifier</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Core Classifier</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.CoreClassifier
	 * @generated
	 */
	EClass getCoreClassifier();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.MemoryClassifier <em>Memory Classifier</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Memory Classifier</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.MemoryClassifier
	 * @generated
	 */
	EClass getMemoryClassifier();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.TransmissionPolicy <em>Transmission Policy</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Transmission Policy</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.TransmissionPolicy
	 * @generated
	 */
	EClass getTransmissionPolicy();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.app4mc.amalthea.model.TransmissionPolicy#getChunkSize <em>Chunk Size</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Chunk Size</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.TransmissionPolicy#getChunkSize()
	 * @see #getTransmissionPolicy()
	 * @generated
	 */
	EReference getTransmissionPolicy_ChunkSize();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.TransmissionPolicy#getChunkProcessingTicks <em>Chunk Processing Ticks</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Chunk Processing Ticks</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.TransmissionPolicy#getChunkProcessingTicks()
	 * @see #getTransmissionPolicy()
	 * @generated
	 */
	EAttribute getTransmissionPolicy_ChunkProcessingTicks();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.TransmissionPolicy#getTransmitRatio <em>Transmit Ratio</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Transmit Ratio</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.TransmissionPolicy#getTransmitRatio()
	 * @see #getTransmissionPolicy()
	 * @generated
	 */
	EAttribute getTransmissionPolicy_TransmitRatio();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.Quantity <em>Quantity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Quantity</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.Quantity
	 * @generated
	 */
	EClass getQuantity();

	/**
	 * Returns the meta object for class '{@link java.lang.Comparable <em>Time Comparable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Time Comparable</em>'.
	 * @see java.lang.Comparable
	 * @model instanceClass="java.lang.Comparable&lt;org.eclipse.app4mc.amalthea.model.Time&gt;"
	 * @generated
	 */
	EClass getTimeComparable();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.Time <em>Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Time</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.Time
	 * @generated
	 */
	EClass getTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.Time#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.Time#getValue()
	 * @see #getTime()
	 * @generated
	 */
	EAttribute getTime_Value();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.Time#getUnit <em>Unit</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Unit</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.Time#getUnit()
	 * @see #getTime()
	 * @generated
	 */
	EAttribute getTime_Unit();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.Time#toString() <em>To String</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>To String</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.Time#toString()
	 * @generated
	 */
	EOperation getTime__ToString();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.Time#compareTo(org.eclipse.app4mc.amalthea.model.Time) <em>Compare To</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Compare To</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.Time#compareTo(org.eclipse.app4mc.amalthea.model.Time)
	 * @generated
	 */
	EOperation getTime__CompareTo__Time();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.Time#adjustUnit() <em>Adjust Unit</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Adjust Unit</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.Time#adjustUnit()
	 * @generated
	 */
	EOperation getTime__AdjustUnit();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.Time#add(org.eclipse.app4mc.amalthea.model.Time) <em>Add</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Add</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.Time#add(org.eclipse.app4mc.amalthea.model.Time)
	 * @generated
	 */
	EOperation getTime__Add__Time();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.Time#subtract(org.eclipse.app4mc.amalthea.model.Time) <em>Subtract</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Subtract</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.Time#subtract(org.eclipse.app4mc.amalthea.model.Time)
	 * @generated
	 */
	EOperation getTime__Subtract__Time();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.Time#multiply(long) <em>Multiply</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Multiply</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.Time#multiply(long)
	 * @generated
	 */
	EOperation getTime__Multiply__long();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.Time#multiply(double) <em>Multiply</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Multiply</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.Time#multiply(double)
	 * @generated
	 */
	EOperation getTime__Multiply__double();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.Time#divide(org.eclipse.app4mc.amalthea.model.Time) <em>Divide</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Divide</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.Time#divide(org.eclipse.app4mc.amalthea.model.Time)
	 * @generated
	 */
	EOperation getTime__Divide__Time();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.Frequency <em>Frequency</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Frequency</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.Frequency
	 * @generated
	 */
	EClass getFrequency();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.Frequency#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.Frequency#getValue()
	 * @see #getFrequency()
	 * @generated
	 */
	EAttribute getFrequency_Value();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.Frequency#getUnit <em>Unit</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Unit</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.Frequency#getUnit()
	 * @see #getFrequency()
	 * @generated
	 */
	EAttribute getFrequency_Unit();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.Frequency#toString() <em>To String</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>To String</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.Frequency#toString()
	 * @generated
	 */
	EOperation getFrequency__ToString();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.Voltage <em>Voltage</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Voltage</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.Voltage
	 * @generated
	 */
	EClass getVoltage();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.Voltage#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.Voltage#getValue()
	 * @see #getVoltage()
	 * @generated
	 */
	EAttribute getVoltage_Value();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.Voltage#getUnit <em>Unit</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Unit</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.Voltage#getUnit()
	 * @see #getVoltage()
	 * @generated
	 */
	EAttribute getVoltage_Unit();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.Voltage#toString() <em>To String</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>To String</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.Voltage#toString()
	 * @generated
	 */
	EOperation getVoltage__ToString();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.DataSize <em>Data Size</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Data Size</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.DataSize
	 * @generated
	 */
	EClass getDataSize();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.DataSize#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.DataSize#getValue()
	 * @see #getDataSize()
	 * @generated
	 */
	EAttribute getDataSize_Value();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.DataSize#getUnit <em>Unit</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Unit</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.DataSize#getUnit()
	 * @see #getDataSize()
	 * @generated
	 */
	EAttribute getDataSize_Unit();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.DataSize#toString() <em>To String</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>To String</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.DataSize#toString()
	 * @generated
	 */
	EOperation getDataSize__ToString();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.DataSize#getNumberBits() <em>Get Number Bits</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Number Bits</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.DataSize#getNumberBits()
	 * @generated
	 */
	EOperation getDataSize__GetNumberBits();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.DataSize#getNumberBytes() <em>Get Number Bytes</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Number Bytes</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.DataSize#getNumberBytes()
	 * @generated
	 */
	EOperation getDataSize__GetNumberBytes();

	/**
	 * Returns the meta object for class '{@link java.lang.Comparable <em>Data Rate Comparable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Data Rate Comparable</em>'.
	 * @see java.lang.Comparable
	 * @model instanceClass="java.lang.Comparable&lt;org.eclipse.app4mc.amalthea.model.DataRate&gt;"
	 * @generated
	 */
	EClass getDataRateComparable();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.DataRate <em>Data Rate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Data Rate</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.DataRate
	 * @generated
	 */
	EClass getDataRate();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.DataRate#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.DataRate#getValue()
	 * @see #getDataRate()
	 * @generated
	 */
	EAttribute getDataRate_Value();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.DataRate#getUnit <em>Unit</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Unit</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.DataRate#getUnit()
	 * @see #getDataRate()
	 * @generated
	 */
	EAttribute getDataRate_Unit();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.DataRate#toString() <em>To String</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>To String</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.DataRate#toString()
	 * @generated
	 */
	EOperation getDataRate__ToString();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.DataRate#compareTo(org.eclipse.app4mc.amalthea.model.DataRate) <em>Compare To</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Compare To</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.DataRate#compareTo(org.eclipse.app4mc.amalthea.model.DataRate)
	 * @generated
	 */
	EOperation getDataRate__CompareTo__DataRate();

	/**
	 * Returns the meta object for class '{@link java.util.Map.Entry <em>Custom Property</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Custom Property</em>'.
	 * @see java.util.Map.Entry
	 * @model keyUnique="false" keyDataType="org.eclipse.emf.ecore.EString" keyRequired="true"
	 *        valueType="org.eclipse.app4mc.amalthea.model.Value" valueContainment="true"
	 * @generated
	 */
	EClass getCustomProperty();

	/**
	 * Returns the meta object for the attribute '{@link java.util.Map.Entry <em>Key</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Key</em>'.
	 * @see java.util.Map.Entry
	 * @see #getCustomProperty()
	 * @generated
	 */
	EAttribute getCustomProperty_Key();

	/**
	 * Returns the meta object for the containment reference '{@link java.util.Map.Entry <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Value</em>'.
	 * @see java.util.Map.Entry
	 * @see #getCustomProperty()
	 * @generated
	 */
	EReference getCustomProperty_Value();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.Value <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Value</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.Value
	 * @generated
	 */
	EClass getValue();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.ListObject <em>List Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>List Object</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ListObject
	 * @generated
	 */
	EClass getListObject();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.app4mc.amalthea.model.ListObject#getValues <em>Values</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Values</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ListObject#getValues()
	 * @see #getListObject()
	 * @generated
	 */
	EReference getListObject_Values();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.StringObject <em>String Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>String Object</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.StringObject
	 * @generated
	 */
	EClass getStringObject();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.StringObject#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.StringObject#getValue()
	 * @see #getStringObject()
	 * @generated
	 */
	EAttribute getStringObject_Value();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.BigIntegerObject <em>Big Integer Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Big Integer Object</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.BigIntegerObject
	 * @generated
	 */
	EClass getBigIntegerObject();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.BigIntegerObject#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.BigIntegerObject#getValue()
	 * @see #getBigIntegerObject()
	 * @generated
	 */
	EAttribute getBigIntegerObject_Value();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.ReferenceObject <em>Reference Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Reference Object</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ReferenceObject
	 * @generated
	 */
	EClass getReferenceObject();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.app4mc.amalthea.model.ReferenceObject#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Value</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ReferenceObject#getValue()
	 * @see #getReferenceObject()
	 * @generated
	 */
	EReference getReferenceObject_Value();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.IntegerObject <em>Integer Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Integer Object</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.IntegerObject
	 * @generated
	 */
	EClass getIntegerObject();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.IntegerObject#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.IntegerObject#getValue()
	 * @see #getIntegerObject()
	 * @generated
	 */
	EAttribute getIntegerObject_Value();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.LongObject <em>Long Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Long Object</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.LongObject
	 * @generated
	 */
	EClass getLongObject();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.LongObject#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.LongObject#getValue()
	 * @see #getLongObject()
	 * @generated
	 */
	EAttribute getLongObject_Value();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.FloatObject <em>Float Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Float Object</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.FloatObject
	 * @generated
	 */
	EClass getFloatObject();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.FloatObject#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.FloatObject#getValue()
	 * @see #getFloatObject()
	 * @generated
	 */
	EAttribute getFloatObject_Value();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.DoubleObject <em>Double Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Double Object</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.DoubleObject
	 * @generated
	 */
	EClass getDoubleObject();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.DoubleObject#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.DoubleObject#getValue()
	 * @see #getDoubleObject()
	 * @generated
	 */
	EAttribute getDoubleObject_Value();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.BooleanObject <em>Boolean Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Boolean Object</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.BooleanObject
	 * @generated
	 */
	EClass getBooleanObject();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.BooleanObject#isValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.BooleanObject#isValue()
	 * @see #getBooleanObject()
	 * @generated
	 */
	EAttribute getBooleanObject_Value();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.NumericStatistic <em>Numeric Statistic</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Numeric Statistic</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.NumericStatistic
	 * @generated
	 */
	EClass getNumericStatistic();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.MinAvgMaxStatistic <em>Min Avg Max Statistic</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Min Avg Max Statistic</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.MinAvgMaxStatistic
	 * @generated
	 */
	EClass getMinAvgMaxStatistic();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.MinAvgMaxStatistic#getMin <em>Min</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Min</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.MinAvgMaxStatistic#getMin()
	 * @see #getMinAvgMaxStatistic()
	 * @generated
	 */
	EAttribute getMinAvgMaxStatistic_Min();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.MinAvgMaxStatistic#getAvg <em>Avg</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Avg</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.MinAvgMaxStatistic#getAvg()
	 * @see #getMinAvgMaxStatistic()
	 * @generated
	 */
	EAttribute getMinAvgMaxStatistic_Avg();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.MinAvgMaxStatistic#getMax <em>Max</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Max</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.MinAvgMaxStatistic#getMax()
	 * @see #getMinAvgMaxStatistic()
	 * @generated
	 */
	EAttribute getMinAvgMaxStatistic_Max();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.SingleValueStatistic <em>Single Value Statistic</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Single Value Statistic</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.SingleValueStatistic
	 * @generated
	 */
	EClass getSingleValueStatistic();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.SingleValueStatistic#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.SingleValueStatistic#getValue()
	 * @see #getSingleValueStatistic()
	 * @generated
	 */
	EAttribute getSingleValueStatistic_Value();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.ITimeDeviation <em>ITime Deviation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>ITime Deviation</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ITimeDeviation
	 * @generated
	 */
	EClass getITimeDeviation();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.ITimeDeviation#getLowerBound() <em>Get Lower Bound</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Lower Bound</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.ITimeDeviation#getLowerBound()
	 * @generated
	 */
	EOperation getITimeDeviation__GetLowerBound();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.ITimeDeviation#getUpperBound() <em>Get Upper Bound</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Upper Bound</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.ITimeDeviation#getUpperBound()
	 * @generated
	 */
	EOperation getITimeDeviation__GetUpperBound();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.ITimeDeviation#getAverage() <em>Get Average</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Average</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.ITimeDeviation#getAverage()
	 * @generated
	 */
	EOperation getITimeDeviation__GetAverage();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.TimeInterval <em>Time Interval</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Time Interval</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.TimeInterval
	 * @generated
	 */
	EClass getTimeInterval();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.app4mc.amalthea.model.TimeInterval#getLowerBound <em>Lower Bound</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Lower Bound</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.TimeInterval#getLowerBound()
	 * @see #getTimeInterval()
	 * @generated
	 */
	EReference getTimeInterval_LowerBound();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.app4mc.amalthea.model.TimeInterval#getUpperBound <em>Upper Bound</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Upper Bound</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.TimeInterval#getUpperBound()
	 * @see #getTimeInterval()
	 * @generated
	 */
	EReference getTimeInterval_UpperBound();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.TimeInterval#getAverage() <em>Get Average</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Average</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.TimeInterval#getAverage()
	 * @generated
	 */
	EOperation getTimeInterval__GetAverage();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.TimeConstant <em>Time Constant</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Time Constant</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.TimeConstant
	 * @generated
	 */
	EClass getTimeConstant();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.app4mc.amalthea.model.TimeConstant#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Value</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.TimeConstant#getValue()
	 * @see #getTimeConstant()
	 * @generated
	 */
	EReference getTimeConstant_Value();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.TimeConstant#getLowerBound() <em>Get Lower Bound</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Lower Bound</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.TimeConstant#getLowerBound()
	 * @generated
	 */
	EOperation getTimeConstant__GetLowerBound();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.TimeConstant#getUpperBound() <em>Get Upper Bound</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Upper Bound</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.TimeConstant#getUpperBound()
	 * @generated
	 */
	EOperation getTimeConstant__GetUpperBound();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.TimeConstant#getAverage() <em>Get Average</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Average</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.TimeConstant#getAverage()
	 * @generated
	 */
	EOperation getTimeConstant__GetAverage();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.TimeHistogram <em>Time Histogram</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Time Histogram</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.TimeHistogram
	 * @generated
	 */
	EClass getTimeHistogram();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.app4mc.amalthea.model.TimeHistogram#getEntries <em>Entries</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Entries</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.TimeHistogram#getEntries()
	 * @see #getTimeHistogram()
	 * @generated
	 */
	EReference getTimeHistogram_Entries();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.TimeHistogram#getLowerBound() <em>Get Lower Bound</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Lower Bound</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.TimeHistogram#getLowerBound()
	 * @generated
	 */
	EOperation getTimeHistogram__GetLowerBound();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.TimeHistogram#getUpperBound() <em>Get Upper Bound</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Upper Bound</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.TimeHistogram#getUpperBound()
	 * @generated
	 */
	EOperation getTimeHistogram__GetUpperBound();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.TimeHistogram#getAverage() <em>Get Average</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Average</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.TimeHistogram#getAverage()
	 * @generated
	 */
	EOperation getTimeHistogram__GetAverage();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.TimeHistogramEntry <em>Time Histogram Entry</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Time Histogram Entry</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.TimeHistogramEntry
	 * @generated
	 */
	EClass getTimeHistogramEntry();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.TimeHistogramEntry#getOccurrences <em>Occurrences</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Occurrences</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.TimeHistogramEntry#getOccurrences()
	 * @see #getTimeHistogramEntry()
	 * @generated
	 */
	EAttribute getTimeHistogramEntry_Occurrences();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.BoundedTimeDistribution <em>Bounded Time Distribution</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Bounded Time Distribution</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.BoundedTimeDistribution
	 * @generated
	 */
	EClass getBoundedTimeDistribution();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.TruncatedTimeDistribution <em>Truncated Time Distribution</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Truncated Time Distribution</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.TruncatedTimeDistribution
	 * @generated
	 */
	EClass getTruncatedTimeDistribution();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.app4mc.amalthea.model.TruncatedTimeDistribution#getLowerBound <em>Lower Bound</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Lower Bound</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.TruncatedTimeDistribution#getLowerBound()
	 * @see #getTruncatedTimeDistribution()
	 * @generated
	 */
	EReference getTruncatedTimeDistribution_LowerBound();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.app4mc.amalthea.model.TruncatedTimeDistribution#getUpperBound <em>Upper Bound</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Upper Bound</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.TruncatedTimeDistribution#getUpperBound()
	 * @see #getTruncatedTimeDistribution()
	 * @generated
	 */
	EReference getTruncatedTimeDistribution_UpperBound();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.TimeBoundaries <em>Time Boundaries</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Time Boundaries</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.TimeBoundaries
	 * @generated
	 */
	EClass getTimeBoundaries();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.TimeBoundaries#getSamplingType <em>Sampling Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Sampling Type</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.TimeBoundaries#getSamplingType()
	 * @see #getTimeBoundaries()
	 * @generated
	 */
	EAttribute getTimeBoundaries_SamplingType();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.TimeStatistics <em>Time Statistics</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Time Statistics</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.TimeStatistics
	 * @generated
	 */
	EClass getTimeStatistics();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.app4mc.amalthea.model.TimeStatistics#getAverage <em>Average</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Average</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.TimeStatistics#getAverage()
	 * @see #getTimeStatistics()
	 * @generated
	 */
	EReference getTimeStatistics_Average();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.TimeUniformDistribution <em>Time Uniform Distribution</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Time Uniform Distribution</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.TimeUniformDistribution
	 * @generated
	 */
	EClass getTimeUniformDistribution();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.TimeGaussDistribution <em>Time Gauss Distribution</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Time Gauss Distribution</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.TimeGaussDistribution
	 * @generated
	 */
	EClass getTimeGaussDistribution();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.app4mc.amalthea.model.TimeGaussDistribution#getMean <em>Mean</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Mean</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.TimeGaussDistribution#getMean()
	 * @see #getTimeGaussDistribution()
	 * @generated
	 */
	EReference getTimeGaussDistribution_Mean();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.app4mc.amalthea.model.TimeGaussDistribution#getSd <em>Sd</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Sd</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.TimeGaussDistribution#getSd()
	 * @see #getTimeGaussDistribution()
	 * @generated
	 */
	EReference getTimeGaussDistribution_Sd();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.TimeGaussDistribution#getAverage() <em>Get Average</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Average</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.TimeGaussDistribution#getAverage()
	 * @generated
	 */
	EOperation getTimeGaussDistribution__GetAverage();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.TimeWeibullEstimatorsDistribution <em>Time Weibull Estimators Distribution</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Time Weibull Estimators Distribution</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.TimeWeibullEstimatorsDistribution
	 * @generated
	 */
	EClass getTimeWeibullEstimatorsDistribution();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.app4mc.amalthea.model.TimeWeibullEstimatorsDistribution#getAverage <em>Average</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Average</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.TimeWeibullEstimatorsDistribution#getAverage()
	 * @see #getTimeWeibullEstimatorsDistribution()
	 * @generated
	 */
	EReference getTimeWeibullEstimatorsDistribution_Average();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.TimeWeibullEstimatorsDistribution#getPRemainPromille <em>PRemain Promille</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>PRemain Promille</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.TimeWeibullEstimatorsDistribution#getPRemainPromille()
	 * @see #getTimeWeibullEstimatorsDistribution()
	 * @generated
	 */
	EAttribute getTimeWeibullEstimatorsDistribution_PRemainPromille();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.TimeBetaDistribution <em>Time Beta Distribution</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Time Beta Distribution</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.TimeBetaDistribution
	 * @generated
	 */
	EClass getTimeBetaDistribution();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.TimeBetaDistribution#getAlpha <em>Alpha</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Alpha</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.TimeBetaDistribution#getAlpha()
	 * @see #getTimeBetaDistribution()
	 * @generated
	 */
	EAttribute getTimeBetaDistribution_Alpha();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.TimeBetaDistribution#getBeta <em>Beta</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Beta</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.TimeBetaDistribution#getBeta()
	 * @see #getTimeBetaDistribution()
	 * @generated
	 */
	EAttribute getTimeBetaDistribution_Beta();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.TimeBetaDistribution#getAverage() <em>Get Average</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Average</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.TimeBetaDistribution#getAverage()
	 * @generated
	 */
	EOperation getTimeBetaDistribution__GetAverage();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.IDiscreteValueDeviation <em>IDiscrete Value Deviation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>IDiscrete Value Deviation</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.IDiscreteValueDeviation
	 * @generated
	 */
	EClass getIDiscreteValueDeviation();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.IDiscreteValueDeviation#getLowerBound() <em>Get Lower Bound</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Lower Bound</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.IDiscreteValueDeviation#getLowerBound()
	 * @generated
	 */
	EOperation getIDiscreteValueDeviation__GetLowerBound();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.IDiscreteValueDeviation#getUpperBound() <em>Get Upper Bound</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Upper Bound</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.IDiscreteValueDeviation#getUpperBound()
	 * @generated
	 */
	EOperation getIDiscreteValueDeviation__GetUpperBound();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.IDiscreteValueDeviation#getAverage() <em>Get Average</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Average</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.IDiscreteValueDeviation#getAverage()
	 * @generated
	 */
	EOperation getIDiscreteValueDeviation__GetAverage();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.DiscreteValueInterval <em>Discrete Value Interval</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Discrete Value Interval</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.DiscreteValueInterval
	 * @generated
	 */
	EClass getDiscreteValueInterval();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.DiscreteValueInterval#getLowerBound <em>Lower Bound</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Lower Bound</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.DiscreteValueInterval#getLowerBound()
	 * @see #getDiscreteValueInterval()
	 * @generated
	 */
	EAttribute getDiscreteValueInterval_LowerBound();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.DiscreteValueInterval#getUpperBound <em>Upper Bound</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Upper Bound</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.DiscreteValueInterval#getUpperBound()
	 * @see #getDiscreteValueInterval()
	 * @generated
	 */
	EAttribute getDiscreteValueInterval_UpperBound();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.DiscreteValueInterval#getAverage() <em>Get Average</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Average</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.DiscreteValueInterval#getAverage()
	 * @generated
	 */
	EOperation getDiscreteValueInterval__GetAverage();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.DiscreteValueConstant <em>Discrete Value Constant</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Discrete Value Constant</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.DiscreteValueConstant
	 * @generated
	 */
	EClass getDiscreteValueConstant();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.DiscreteValueConstant#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.DiscreteValueConstant#getValue()
	 * @see #getDiscreteValueConstant()
	 * @generated
	 */
	EAttribute getDiscreteValueConstant_Value();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.DiscreteValueConstant#getLowerBound() <em>Get Lower Bound</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Lower Bound</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.DiscreteValueConstant#getLowerBound()
	 * @generated
	 */
	EOperation getDiscreteValueConstant__GetLowerBound();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.DiscreteValueConstant#getUpperBound() <em>Get Upper Bound</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Upper Bound</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.DiscreteValueConstant#getUpperBound()
	 * @generated
	 */
	EOperation getDiscreteValueConstant__GetUpperBound();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.DiscreteValueConstant#getAverage() <em>Get Average</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Average</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.DiscreteValueConstant#getAverage()
	 * @generated
	 */
	EOperation getDiscreteValueConstant__GetAverage();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.DiscreteValueHistogram <em>Discrete Value Histogram</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Discrete Value Histogram</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.DiscreteValueHistogram
	 * @generated
	 */
	EClass getDiscreteValueHistogram();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.app4mc.amalthea.model.DiscreteValueHistogram#getEntries <em>Entries</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Entries</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.DiscreteValueHistogram#getEntries()
	 * @see #getDiscreteValueHistogram()
	 * @generated
	 */
	EReference getDiscreteValueHistogram_Entries();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.DiscreteValueHistogram#getLowerBound() <em>Get Lower Bound</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Lower Bound</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.DiscreteValueHistogram#getLowerBound()
	 * @generated
	 */
	EOperation getDiscreteValueHistogram__GetLowerBound();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.DiscreteValueHistogram#getUpperBound() <em>Get Upper Bound</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Upper Bound</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.DiscreteValueHistogram#getUpperBound()
	 * @generated
	 */
	EOperation getDiscreteValueHistogram__GetUpperBound();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.DiscreteValueHistogram#getAverage() <em>Get Average</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Average</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.DiscreteValueHistogram#getAverage()
	 * @generated
	 */
	EOperation getDiscreteValueHistogram__GetAverage();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.DiscreteValueHistogramEntry <em>Discrete Value Histogram Entry</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Discrete Value Histogram Entry</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.DiscreteValueHistogramEntry
	 * @generated
	 */
	EClass getDiscreteValueHistogramEntry();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.DiscreteValueHistogramEntry#getOccurrences <em>Occurrences</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Occurrences</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.DiscreteValueHistogramEntry#getOccurrences()
	 * @see #getDiscreteValueHistogramEntry()
	 * @generated
	 */
	EAttribute getDiscreteValueHistogramEntry_Occurrences();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.BoundedDiscreteValueDistribution <em>Bounded Discrete Value Distribution</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Bounded Discrete Value Distribution</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.BoundedDiscreteValueDistribution
	 * @generated
	 */
	EClass getBoundedDiscreteValueDistribution();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.TruncatedDiscreteValueDistribution <em>Truncated Discrete Value Distribution</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Truncated Discrete Value Distribution</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.TruncatedDiscreteValueDistribution
	 * @generated
	 */
	EClass getTruncatedDiscreteValueDistribution();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.TruncatedDiscreteValueDistribution#getLowerBound <em>Lower Bound</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Lower Bound</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.TruncatedDiscreteValueDistribution#getLowerBound()
	 * @see #getTruncatedDiscreteValueDistribution()
	 * @generated
	 */
	EAttribute getTruncatedDiscreteValueDistribution_LowerBound();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.TruncatedDiscreteValueDistribution#getUpperBound <em>Upper Bound</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Upper Bound</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.TruncatedDiscreteValueDistribution#getUpperBound()
	 * @see #getTruncatedDiscreteValueDistribution()
	 * @generated
	 */
	EAttribute getTruncatedDiscreteValueDistribution_UpperBound();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.DiscreteValueBoundaries <em>Discrete Value Boundaries</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Discrete Value Boundaries</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.DiscreteValueBoundaries
	 * @generated
	 */
	EClass getDiscreteValueBoundaries();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.DiscreteValueBoundaries#getSamplingType <em>Sampling Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Sampling Type</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.DiscreteValueBoundaries#getSamplingType()
	 * @see #getDiscreteValueBoundaries()
	 * @generated
	 */
	EAttribute getDiscreteValueBoundaries_SamplingType();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.DiscreteValueStatistics <em>Discrete Value Statistics</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Discrete Value Statistics</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.DiscreteValueStatistics
	 * @generated
	 */
	EClass getDiscreteValueStatistics();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.DiscreteValueStatistics#getAverage <em>Average</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Average</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.DiscreteValueStatistics#getAverage()
	 * @see #getDiscreteValueStatistics()
	 * @generated
	 */
	EAttribute getDiscreteValueStatistics_Average();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.DiscreteValueUniformDistribution <em>Discrete Value Uniform Distribution</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Discrete Value Uniform Distribution</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.DiscreteValueUniformDistribution
	 * @generated
	 */
	EClass getDiscreteValueUniformDistribution();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.DiscreteValueGaussDistribution <em>Discrete Value Gauss Distribution</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Discrete Value Gauss Distribution</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.DiscreteValueGaussDistribution
	 * @generated
	 */
	EClass getDiscreteValueGaussDistribution();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.DiscreteValueGaussDistribution#getMean <em>Mean</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Mean</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.DiscreteValueGaussDistribution#getMean()
	 * @see #getDiscreteValueGaussDistribution()
	 * @generated
	 */
	EAttribute getDiscreteValueGaussDistribution_Mean();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.DiscreteValueGaussDistribution#getSd <em>Sd</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Sd</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.DiscreteValueGaussDistribution#getSd()
	 * @see #getDiscreteValueGaussDistribution()
	 * @generated
	 */
	EAttribute getDiscreteValueGaussDistribution_Sd();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.DiscreteValueGaussDistribution#getAverage() <em>Get Average</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Average</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.DiscreteValueGaussDistribution#getAverage()
	 * @generated
	 */
	EOperation getDiscreteValueGaussDistribution__GetAverage();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.DiscreteValueWeibullEstimatorsDistribution <em>Discrete Value Weibull Estimators Distribution</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Discrete Value Weibull Estimators Distribution</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.DiscreteValueWeibullEstimatorsDistribution
	 * @generated
	 */
	EClass getDiscreteValueWeibullEstimatorsDistribution();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.DiscreteValueWeibullEstimatorsDistribution#getAverage <em>Average</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Average</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.DiscreteValueWeibullEstimatorsDistribution#getAverage()
	 * @see #getDiscreteValueWeibullEstimatorsDistribution()
	 * @generated
	 */
	EAttribute getDiscreteValueWeibullEstimatorsDistribution_Average();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.DiscreteValueWeibullEstimatorsDistribution#getPRemainPromille <em>PRemain Promille</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>PRemain Promille</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.DiscreteValueWeibullEstimatorsDistribution#getPRemainPromille()
	 * @see #getDiscreteValueWeibullEstimatorsDistribution()
	 * @generated
	 */
	EAttribute getDiscreteValueWeibullEstimatorsDistribution_PRemainPromille();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.DiscreteValueBetaDistribution <em>Discrete Value Beta Distribution</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Discrete Value Beta Distribution</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.DiscreteValueBetaDistribution
	 * @generated
	 */
	EClass getDiscreteValueBetaDistribution();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.DiscreteValueBetaDistribution#getAlpha <em>Alpha</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Alpha</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.DiscreteValueBetaDistribution#getAlpha()
	 * @see #getDiscreteValueBetaDistribution()
	 * @generated
	 */
	EAttribute getDiscreteValueBetaDistribution_Alpha();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.DiscreteValueBetaDistribution#getBeta <em>Beta</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Beta</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.DiscreteValueBetaDistribution#getBeta()
	 * @see #getDiscreteValueBetaDistribution()
	 * @generated
	 */
	EAttribute getDiscreteValueBetaDistribution_Beta();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.DiscreteValueBetaDistribution#getAverage() <em>Get Average</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Average</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.DiscreteValueBetaDistribution#getAverage()
	 * @generated
	 */
	EOperation getDiscreteValueBetaDistribution__GetAverage();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.IContinuousValueDeviation <em>IContinuous Value Deviation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>IContinuous Value Deviation</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.IContinuousValueDeviation
	 * @generated
	 */
	EClass getIContinuousValueDeviation();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.IContinuousValueDeviation#getLowerBound() <em>Get Lower Bound</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Lower Bound</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.IContinuousValueDeviation#getLowerBound()
	 * @generated
	 */
	EOperation getIContinuousValueDeviation__GetLowerBound();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.IContinuousValueDeviation#getUpperBound() <em>Get Upper Bound</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Upper Bound</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.IContinuousValueDeviation#getUpperBound()
	 * @generated
	 */
	EOperation getIContinuousValueDeviation__GetUpperBound();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.IContinuousValueDeviation#getAverage() <em>Get Average</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Average</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.IContinuousValueDeviation#getAverage()
	 * @generated
	 */
	EOperation getIContinuousValueDeviation__GetAverage();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.ContinuousValueInterval <em>Continuous Value Interval</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Continuous Value Interval</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ContinuousValueInterval
	 * @generated
	 */
	EClass getContinuousValueInterval();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.ContinuousValueInterval#getLowerBound <em>Lower Bound</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Lower Bound</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ContinuousValueInterval#getLowerBound()
	 * @see #getContinuousValueInterval()
	 * @generated
	 */
	EAttribute getContinuousValueInterval_LowerBound();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.ContinuousValueInterval#getUpperBound <em>Upper Bound</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Upper Bound</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ContinuousValueInterval#getUpperBound()
	 * @see #getContinuousValueInterval()
	 * @generated
	 */
	EAttribute getContinuousValueInterval_UpperBound();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.ContinuousValueInterval#getAverage() <em>Get Average</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Average</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.ContinuousValueInterval#getAverage()
	 * @generated
	 */
	EOperation getContinuousValueInterval__GetAverage();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.ContinuousValueConstant <em>Continuous Value Constant</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Continuous Value Constant</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ContinuousValueConstant
	 * @generated
	 */
	EClass getContinuousValueConstant();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.ContinuousValueConstant#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ContinuousValueConstant#getValue()
	 * @see #getContinuousValueConstant()
	 * @generated
	 */
	EAttribute getContinuousValueConstant_Value();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.ContinuousValueConstant#getLowerBound() <em>Get Lower Bound</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Lower Bound</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.ContinuousValueConstant#getLowerBound()
	 * @generated
	 */
	EOperation getContinuousValueConstant__GetLowerBound();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.ContinuousValueConstant#getUpperBound() <em>Get Upper Bound</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Upper Bound</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.ContinuousValueConstant#getUpperBound()
	 * @generated
	 */
	EOperation getContinuousValueConstant__GetUpperBound();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.ContinuousValueConstant#getAverage() <em>Get Average</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Average</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.ContinuousValueConstant#getAverage()
	 * @generated
	 */
	EOperation getContinuousValueConstant__GetAverage();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.ContinuousValueHistogram <em>Continuous Value Histogram</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Continuous Value Histogram</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ContinuousValueHistogram
	 * @generated
	 */
	EClass getContinuousValueHistogram();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.app4mc.amalthea.model.ContinuousValueHistogram#getEntries <em>Entries</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Entries</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ContinuousValueHistogram#getEntries()
	 * @see #getContinuousValueHistogram()
	 * @generated
	 */
	EReference getContinuousValueHistogram_Entries();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.ContinuousValueHistogram#getLowerBound() <em>Get Lower Bound</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Lower Bound</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.ContinuousValueHistogram#getLowerBound()
	 * @generated
	 */
	EOperation getContinuousValueHistogram__GetLowerBound();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.ContinuousValueHistogram#getUpperBound() <em>Get Upper Bound</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Upper Bound</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.ContinuousValueHistogram#getUpperBound()
	 * @generated
	 */
	EOperation getContinuousValueHistogram__GetUpperBound();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.ContinuousValueHistogram#getAverage() <em>Get Average</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Average</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.ContinuousValueHistogram#getAverage()
	 * @generated
	 */
	EOperation getContinuousValueHistogram__GetAverage();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.ContinuousValueHistogramEntry <em>Continuous Value Histogram Entry</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Continuous Value Histogram Entry</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ContinuousValueHistogramEntry
	 * @generated
	 */
	EClass getContinuousValueHistogramEntry();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.ContinuousValueHistogramEntry#getOccurrences <em>Occurrences</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Occurrences</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ContinuousValueHistogramEntry#getOccurrences()
	 * @see #getContinuousValueHistogramEntry()
	 * @generated
	 */
	EAttribute getContinuousValueHistogramEntry_Occurrences();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.BoundedContinuousValueDistribution <em>Bounded Continuous Value Distribution</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Bounded Continuous Value Distribution</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.BoundedContinuousValueDistribution
	 * @generated
	 */
	EClass getBoundedContinuousValueDistribution();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.TruncatedContinuousValueDistribution <em>Truncated Continuous Value Distribution</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Truncated Continuous Value Distribution</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.TruncatedContinuousValueDistribution
	 * @generated
	 */
	EClass getTruncatedContinuousValueDistribution();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.TruncatedContinuousValueDistribution#getLowerBound <em>Lower Bound</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Lower Bound</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.TruncatedContinuousValueDistribution#getLowerBound()
	 * @see #getTruncatedContinuousValueDistribution()
	 * @generated
	 */
	EAttribute getTruncatedContinuousValueDistribution_LowerBound();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.TruncatedContinuousValueDistribution#getUpperBound <em>Upper Bound</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Upper Bound</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.TruncatedContinuousValueDistribution#getUpperBound()
	 * @see #getTruncatedContinuousValueDistribution()
	 * @generated
	 */
	EAttribute getTruncatedContinuousValueDistribution_UpperBound();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.ContinuousValueBoundaries <em>Continuous Value Boundaries</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Continuous Value Boundaries</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ContinuousValueBoundaries
	 * @generated
	 */
	EClass getContinuousValueBoundaries();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.ContinuousValueBoundaries#getSamplingType <em>Sampling Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Sampling Type</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ContinuousValueBoundaries#getSamplingType()
	 * @see #getContinuousValueBoundaries()
	 * @generated
	 */
	EAttribute getContinuousValueBoundaries_SamplingType();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.ContinuousValueStatistics <em>Continuous Value Statistics</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Continuous Value Statistics</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ContinuousValueStatistics
	 * @generated
	 */
	EClass getContinuousValueStatistics();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.ContinuousValueStatistics#getAverage <em>Average</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Average</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ContinuousValueStatistics#getAverage()
	 * @see #getContinuousValueStatistics()
	 * @generated
	 */
	EAttribute getContinuousValueStatistics_Average();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.ContinuousValueUniformDistribution <em>Continuous Value Uniform Distribution</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Continuous Value Uniform Distribution</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ContinuousValueUniformDistribution
	 * @generated
	 */
	EClass getContinuousValueUniformDistribution();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.ContinuousValueGaussDistribution <em>Continuous Value Gauss Distribution</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Continuous Value Gauss Distribution</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ContinuousValueGaussDistribution
	 * @generated
	 */
	EClass getContinuousValueGaussDistribution();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.ContinuousValueGaussDistribution#getMean <em>Mean</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Mean</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ContinuousValueGaussDistribution#getMean()
	 * @see #getContinuousValueGaussDistribution()
	 * @generated
	 */
	EAttribute getContinuousValueGaussDistribution_Mean();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.ContinuousValueGaussDistribution#getSd <em>Sd</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Sd</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ContinuousValueGaussDistribution#getSd()
	 * @see #getContinuousValueGaussDistribution()
	 * @generated
	 */
	EAttribute getContinuousValueGaussDistribution_Sd();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.ContinuousValueGaussDistribution#getAverage() <em>Get Average</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Average</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.ContinuousValueGaussDistribution#getAverage()
	 * @generated
	 */
	EOperation getContinuousValueGaussDistribution__GetAverage();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.ContinuousValueWeibullEstimatorsDistribution <em>Continuous Value Weibull Estimators Distribution</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Continuous Value Weibull Estimators Distribution</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ContinuousValueWeibullEstimatorsDistribution
	 * @generated
	 */
	EClass getContinuousValueWeibullEstimatorsDistribution();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.ContinuousValueWeibullEstimatorsDistribution#getAverage <em>Average</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Average</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ContinuousValueWeibullEstimatorsDistribution#getAverage()
	 * @see #getContinuousValueWeibullEstimatorsDistribution()
	 * @generated
	 */
	EAttribute getContinuousValueWeibullEstimatorsDistribution_Average();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.ContinuousValueWeibullEstimatorsDistribution#getPRemainPromille <em>PRemain Promille</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>PRemain Promille</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ContinuousValueWeibullEstimatorsDistribution#getPRemainPromille()
	 * @see #getContinuousValueWeibullEstimatorsDistribution()
	 * @generated
	 */
	EAttribute getContinuousValueWeibullEstimatorsDistribution_PRemainPromille();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.ContinuousValueBetaDistribution <em>Continuous Value Beta Distribution</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Continuous Value Beta Distribution</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ContinuousValueBetaDistribution
	 * @generated
	 */
	EClass getContinuousValueBetaDistribution();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.ContinuousValueBetaDistribution#getAlpha <em>Alpha</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Alpha</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ContinuousValueBetaDistribution#getAlpha()
	 * @see #getContinuousValueBetaDistribution()
	 * @generated
	 */
	EAttribute getContinuousValueBetaDistribution_Alpha();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.ContinuousValueBetaDistribution#getBeta <em>Beta</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Beta</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ContinuousValueBetaDistribution#getBeta()
	 * @see #getContinuousValueBetaDistribution()
	 * @generated
	 */
	EAttribute getContinuousValueBetaDistribution_Beta();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.ContinuousValueBetaDistribution#getAverage() <em>Get Average</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Average</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.ContinuousValueBetaDistribution#getAverage()
	 * @generated
	 */
	EOperation getContinuousValueBetaDistribution__GetAverage();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.Mode <em>Mode</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Mode</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.Mode
	 * @generated
	 */
	EClass getMode();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.app4mc.amalthea.model.Mode#getLiterals <em>Literals</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Literals</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.Mode#getLiterals()
	 * @see #getMode()
	 * @generated
	 */
	EReference getMode_Literals();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.ModeLiteral <em>Mode Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Mode Literal</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ModeLiteral
	 * @generated
	 */
	EClass getModeLiteral();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.app4mc.amalthea.model.ModeLiteral#getContainingMode <em>Containing Mode</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Containing Mode</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ModeLiteral#getContainingMode()
	 * @see #getModeLiteral()
	 * @generated
	 */
	EReference getModeLiteral_ContainingMode();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.ModeLiteral#computeUniqueName() <em>Compute Unique Name</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Compute Unique Name</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.ModeLiteral#computeUniqueName()
	 * @generated
	 */
	EOperation getModeLiteral__ComputeUniqueName();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.ModeLiteral#toString() <em>To String</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>To String</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.ModeLiteral#toString()
	 * @generated
	 */
	EOperation getModeLiteral__ToString();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.ComponentsModel <em>Components Model</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Components Model</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ComponentsModel
	 * @generated
	 */
	EClass getComponentsModel();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.app4mc.amalthea.model.ComponentsModel#getComponents <em>Components</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Components</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ComponentsModel#getComponents()
	 * @see #getComponentsModel()
	 * @generated
	 */
	EReference getComponentsModel_Components();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.app4mc.amalthea.model.ComponentsModel#getSystems <em>Systems</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Systems</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ComponentsModel#getSystems()
	 * @see #getComponentsModel()
	 * @generated
	 */
	EReference getComponentsModel_Systems();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.ISystem <em>ISystem</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>ISystem</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ISystem
	 * @generated
	 */
	EClass getISystem();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.app4mc.amalthea.model.ISystem#getComponentInstances <em>Component Instances</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Component Instances</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ISystem#getComponentInstances()
	 * @see #getISystem()
	 * @generated
	 */
	EReference getISystem_ComponentInstances();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.app4mc.amalthea.model.ISystem#getConnectors <em>Connectors</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Connectors</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ISystem#getConnectors()
	 * @see #getISystem()
	 * @generated
	 */
	EReference getISystem_Connectors();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.app4mc.amalthea.model.ISystem#getGroundedPorts <em>Grounded Ports</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Grounded Ports</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ISystem#getGroundedPorts()
	 * @see #getISystem()
	 * @generated
	 */
	EReference getISystem_GroundedPorts();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.app4mc.amalthea.model.ISystem#getInnerPorts <em>Inner Ports</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Inner Ports</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ISystem#getInnerPorts()
	 * @see #getISystem()
	 * @generated
	 */
	EReference getISystem_InnerPorts();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.Port <em>Port</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Port</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.Port
	 * @generated
	 */
	EClass getPort();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.app4mc.amalthea.model.Port#getContainingComponent <em>Containing Component</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Containing Component</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.Port#getContainingComponent()
	 * @see #getPort()
	 * @generated
	 */
	EReference getPort_ContainingComponent();

	/**
	 * Returns the meta object for the '{@link org.eclipse.app4mc.amalthea.model.Port#computeUniqueName() <em>Compute Unique Name</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Compute Unique Name</em>' operation.
	 * @see org.eclipse.app4mc.amalthea.model.Port#computeUniqueName()
	 * @generated
	 */
	EOperation getPort__ComputeUniqueName();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.Component <em>Component</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Component</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.Component
	 * @generated
	 */
	EClass getComponent();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.app4mc.amalthea.model.Component#getPorts <em>Ports</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Ports</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.Component#getPorts()
	 * @see #getComponent()
	 * @generated
	 */
	EReference getComponent_Ports();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.app4mc.amalthea.model.Component#getTasks <em>Tasks</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Tasks</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.Component#getTasks()
	 * @see #getComponent()
	 * @generated
	 */
	EReference getComponent_Tasks();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.app4mc.amalthea.model.Component#getRunnables <em>Runnables</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Runnables</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.Component#getRunnables()
	 * @see #getComponent()
	 * @generated
	 */
	EReference getComponent_Runnables();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.app4mc.amalthea.model.Component#getLabels <em>Labels</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Labels</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.Component#getLabels()
	 * @see #getComponent()
	 * @generated
	 */
	EReference getComponent_Labels();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.app4mc.amalthea.model.Component#getSemaphores <em>Semaphores</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Semaphores</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.Component#getSemaphores()
	 * @see #getComponent()
	 * @generated
	 */
	EReference getComponent_Semaphores();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.app4mc.amalthea.model.Component#getOsEvents <em>Os Events</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Os Events</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.Component#getOsEvents()
	 * @see #getComponent()
	 * @generated
	 */
	EReference getComponent_OsEvents();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.Composite <em>Composite</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Composite</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.Composite
	 * @generated
	 */
	EClass getComposite();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.System <em>System</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>System</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.System
	 * @generated
	 */
	EClass getSystem();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.ComponentInstance <em>Component Instance</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Component Instance</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ComponentInstance
	 * @generated
	 */
	EClass getComponentInstance();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.app4mc.amalthea.model.ComponentInstance#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Type</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ComponentInstance#getType()
	 * @see #getComponentInstance()
	 * @generated
	 */
	EReference getComponentInstance_Type();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.Connector <em>Connector</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Connector</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.Connector
	 * @generated
	 */
	EClass getConnector();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.app4mc.amalthea.model.Connector#getSourcePort <em>Source Port</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Source Port</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.Connector#getSourcePort()
	 * @see #getConnector()
	 * @generated
	 */
	EReference getConnector_SourcePort();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.app4mc.amalthea.model.Connector#getTargetPort <em>Target Port</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Target Port</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.Connector#getTargetPort()
	 * @see #getConnector()
	 * @generated
	 */
	EReference getConnector_TargetPort();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.QualifiedPort <em>Qualified Port</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Qualified Port</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.QualifiedPort
	 * @generated
	 */
	EClass getQualifiedPort();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.app4mc.amalthea.model.QualifiedPort#getInstance <em>Instance</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Instance</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.QualifiedPort#getInstance()
	 * @see #getQualifiedPort()
	 * @generated
	 */
	EReference getQualifiedPort_Instance();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.app4mc.amalthea.model.QualifiedPort#getPort <em>Port</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Port</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.QualifiedPort#getPort()
	 * @see #getQualifiedPort()
	 * @generated
	 */
	EReference getQualifiedPort_Port();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.InterfacePort <em>Interface Port</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Interface Port</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.InterfacePort
	 * @generated
	 */
	EClass getInterfacePort();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.InterfacePort#getInterfaceName <em>Interface Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Interface Name</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.InterfacePort#getInterfaceName()
	 * @see #getInterfacePort()
	 * @generated
	 */
	EAttribute getInterfacePort_InterfaceName();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.InterfacePort#getKind <em>Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Kind</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.InterfacePort#getKind()
	 * @see #getInterfacePort()
	 * @generated
	 */
	EAttribute getInterfacePort_Kind();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.ConfigModel <em>Config Model</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Config Model</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ConfigModel
	 * @generated
	 */
	EClass getConfigModel();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.app4mc.amalthea.model.ConfigModel#getEventsToTrace <em>Events To Trace</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Events To Trace</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ConfigModel#getEventsToTrace()
	 * @see #getConfigModel()
	 * @generated
	 */
	EReference getConfigModel_EventsToTrace();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.EventConfig <em>Event Config</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Event Config</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.EventConfig
	 * @generated
	 */
	EClass getEventConfig();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.app4mc.amalthea.model.EventConfig#getEvent <em>Event</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Event</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.EventConfig#getEvent()
	 * @see #getEventConfig()
	 * @generated
	 */
	EReference getEventConfig_Event();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.ConstraintsModel <em>Constraints Model</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Constraints Model</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ConstraintsModel
	 * @generated
	 */
	EClass getConstraintsModel();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.app4mc.amalthea.model.ConstraintsModel#getEventChains <em>Event Chains</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Event Chains</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ConstraintsModel#getEventChains()
	 * @see #getConstraintsModel()
	 * @generated
	 */
	EReference getConstraintsModel_EventChains();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.app4mc.amalthea.model.ConstraintsModel#getTimingConstraints <em>Timing Constraints</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Timing Constraints</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ConstraintsModel#getTimingConstraints()
	 * @see #getConstraintsModel()
	 * @generated
	 */
	EReference getConstraintsModel_TimingConstraints();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.app4mc.amalthea.model.ConstraintsModel#getAffinityConstraints <em>Affinity Constraints</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Affinity Constraints</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ConstraintsModel#getAffinityConstraints()
	 * @see #getConstraintsModel()
	 * @generated
	 */
	EReference getConstraintsModel_AffinityConstraints();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.app4mc.amalthea.model.ConstraintsModel#getRunnableSequencingConstraints <em>Runnable Sequencing Constraints</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Runnable Sequencing Constraints</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ConstraintsModel#getRunnableSequencingConstraints()
	 * @see #getConstraintsModel()
	 * @generated
	 */
	EReference getConstraintsModel_RunnableSequencingConstraints();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.app4mc.amalthea.model.ConstraintsModel#getDataAgeConstraints <em>Data Age Constraints</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Data Age Constraints</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ConstraintsModel#getDataAgeConstraints()
	 * @see #getConstraintsModel()
	 * @generated
	 */
	EReference getConstraintsModel_DataAgeConstraints();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.app4mc.amalthea.model.ConstraintsModel#getRequirements <em>Requirements</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Requirements</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ConstraintsModel#getRequirements()
	 * @see #getConstraintsModel()
	 * @generated
	 */
	EReference getConstraintsModel_Requirements();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.app4mc.amalthea.model.ConstraintsModel#getDataCoherencyGroups <em>Data Coherency Groups</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Data Coherency Groups</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ConstraintsModel#getDataCoherencyGroups()
	 * @see #getConstraintsModel()
	 * @generated
	 */
	EReference getConstraintsModel_DataCoherencyGroups();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.app4mc.amalthea.model.ConstraintsModel#getDataStabilityGroups <em>Data Stability Groups</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Data Stability Groups</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ConstraintsModel#getDataStabilityGroups()
	 * @see #getConstraintsModel()
	 * @generated
	 */
	EReference getConstraintsModel_DataStabilityGroups();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.app4mc.amalthea.model.ConstraintsModel#getPhysicalSectionConstraints <em>Physical Section Constraints</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Physical Section Constraints</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ConstraintsModel#getPhysicalSectionConstraints()
	 * @see #getConstraintsModel()
	 * @generated
	 */
	EReference getConstraintsModel_PhysicalSectionConstraints();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.RunnableSequencingConstraint <em>Runnable Sequencing Constraint</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Runnable Sequencing Constraint</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.RunnableSequencingConstraint
	 * @generated
	 */
	EClass getRunnableSequencingConstraint();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.app4mc.amalthea.model.RunnableSequencingConstraint#getOrderType <em>Order Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Order Type</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.RunnableSequencingConstraint#getOrderType()
	 * @see #getRunnableSequencingConstraint()
	 * @generated
	 */
	EAttribute getRunnableSequencingConstraint_OrderType();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.app4mc.amalthea.model.RunnableSequencingConstraint#getRunnableGroups <em>Runnable Groups</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Runnable Groups</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.RunnableSequencingConstraint#getRunnableGroups()
	 * @see #getRunnableSequencingConstraint()
	 * @generated
	 */
	EReference getRunnableSequencingConstraint_RunnableGroups();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.app4mc.amalthea.model.RunnableSequencingConstraint#getProcessScope <em>Process Scope</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Process Scope</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.RunnableSequencingConstraint#getProcessScope()
	 * @see #getRunnableSequencingConstraint()
	 * @generated
	 */
	EReference getRunnableSequencingConstraint_ProcessScope();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.AffinityConstraint <em>Affinity Constraint</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Affinity Constraint</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.AffinityConstraint
	 * @generated
	 */
	EClass getAffinityConstraint();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.SeparationConstraint <em>Separation Constraint</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Separation Constraint</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.SeparationConstraint
	 * @generated
	 */
	EClass getSeparationConstraint();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.PairingConstraint <em>Pairing Constraint</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Pairing Constraint</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.PairingConstraint
	 * @generated
	 */
	EClass getPairingConstraint();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.ProcessConstraint <em>Process Constraint</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Process Constraint</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ProcessConstraint
	 * @generated
	 */
	EClass getProcessConstraint();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.app4mc.amalthea.model.ProcessConstraint#getTarget <em>Target</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Target</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ProcessConstraint#getTarget()
	 * @see #getProcessConstraint()
	 * @generated
	 */
	EReference getProcessConstraint_Target();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.RunnableConstraint <em>Runnable Constraint</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Runnable Constraint</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.RunnableConstraint
	 * @generated
	 */
	EClass getRunnableConstraint();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.app4mc.amalthea.model.RunnableConstraint#getTarget <em>Target</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Target</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.RunnableConstraint#getTarget()
	 * @see #getRunnableConstraint()
	 * @generated
	 */
	EReference getRunnableConstraint_Target();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.DataConstraint <em>Data Constraint</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Data Constraint</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.DataConstraint
	 * @generated
	 */
	EClass getDataConstraint();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.app4mc.amalthea.model.DataConstraint#getTarget <em>Target</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Target</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.DataConstraint#getTarget()
	 * @see #getDataConstraint()
	 * @generated
	 */
	EReference getDataConstraint_Target();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.RunnableSeparationConstraint <em>Runnable Separation Constraint</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Runnable Separation Constraint</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.RunnableSeparationConstraint
	 * @generated
	 */
	EClass getRunnableSeparationConstraint();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.app4mc.amalthea.model.RunnableSeparationConstraint#getGroups <em>Groups</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Groups</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.RunnableSeparationConstraint#getGroups()
	 * @see #getRunnableSeparationConstraint()
	 * @generated
	 */
	EReference getRunnableSeparationConstraint_Groups();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.ProcessSeparationConstraint <em>Process Separation Constraint</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Process Separation Constraint</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ProcessSeparationConstraint
	 * @generated
	 */
	EClass getProcessSeparationConstraint();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.app4mc.amalthea.model.ProcessSeparationConstraint#getGroups <em>Groups</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Groups</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ProcessSeparationConstraint#getGroups()
	 * @see #getProcessSeparationConstraint()
	 * @generated
	 */
	EReference getProcessSeparationConstraint_Groups();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.DataSeparationConstraint <em>Data Separation Constraint</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Data Separation Constraint</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.DataSeparationConstraint
	 * @generated
	 */
	EClass getDataSeparationConstraint();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.app4mc.amalthea.model.DataSeparationConstraint#getGroups <em>Groups</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Groups</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.DataSeparationConstraint#getGroups()
	 * @see #getDataSeparationConstraint()
	 * @generated
	 */
	EReference getDataSeparationConstraint_Groups();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.RunnablePairingConstraint <em>Runnable Pairing Constraint</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Runnable Pairing Constraint</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.RunnablePairingConstraint
	 * @generated
	 */
	EClass getRunnablePairingConstraint();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.app4mc.amalthea.model.RunnablePairingConstraint#getGroup <em>Group</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Group</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.RunnablePairingConstraint#getGroup()
	 * @see #getRunnablePairingConstraint()
	 * @generated
	 */
	EReference getRunnablePairingConstraint_Group();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.ProcessPairingConstraint <em>Process Pairing Constraint</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Process Pairing Constraint</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ProcessPairingConstraint
	 * @generated
	 */
	EClass getProcessPairingConstraint();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.app4mc.amalthea.model.ProcessPairingConstraint#getGroup <em>Group</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Group</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.ProcessPairingConstraint#getGroup()
	 * @see #getProcessPairingConstraint()
	 * @generated
	 */
	EReference getProcessPairingConstraint_Group();

	/**
	 * Returns the meta object for class '{@link org.eclipse.app4mc.amalthea.model.DataPairingConstraint <em>Data Pairing Constraint</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Data Pairing Constraint</em>'.
	 * @see org.eclipse.app4mc.amalthea.model.DataPairingConstraint
	 * @generated
	 */
	EClass getDataPairingConstraint();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.app4mc.amalthea.model.DataPairingConstraint#getGroup <em>Group</em>}'.
	 * <!-- begin-user