/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters093.impl;

import com.google.common.collect.Iterables;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.LogManager;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters093.impl.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters093.utils.HWCacheBuilder;
import org.eclipse.app4mc.amalthea.converters093.utils.HelperUtils_092_093;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.Parent;

public class SwConverter
extends AbstractConverter {
    private File targetFile;
    private List<ICache> caches;
    private HWCacheBuilder.PUDefinition_IPCData hwCache;

    public SwConverter() {
        this.helper = HelperUtils_092_093.getInstance();
        this.logger = LogManager.getLogger((String)"org.eclipse.app4mc.amalthea.modelmigration");
    }

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) throws Exception {
        this.logger.info((Object)("Migration from 0.9.2 to 0.9.3 : Executing Sw converter for model file : " + targetFile.getName()));
        this.caches = caches;
        this.fileName_documentsMap = fileName_documentsMap;
        this.targetFile = targetFile;
        Document root = fileName_documentsMap.get(this.targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.update_ExecutionNeed(rootElement);
        this.update_ChunkProcessingInstructions(rootElement);
        this.update_activations(rootElement);
    }

    private void update_activations(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("./swModel/activations");
        List activationElements = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getNS_093("am"), this.helper.getGenericNS("xsi")});
        for (Element activationElement : activationElements) {
            Element activationDeviation_Time_deviationElement;
            int indexOf;
            Element migratedElement;
            String activationType = activationElement.getAttributeValue("type", this.helper.getGenericNS("xsi"));
            if (activationType == null) continue;
            if (activationType.equals("am:VariableRateActivation")) {
                Element occurrencesPerStep_double_deviationElement = activationElement.getChild("occurrencesPerStep");
                if (occurrencesPerStep_double_deviationElement == null) continue;
                migratedElement = this.migrateDeviationElement_Containing_DoubleValue(occurrencesPerStep_double_deviationElement, "occurrencesPerStep");
                indexOf = activationElement.indexOf((Content)occurrencesPerStep_double_deviationElement);
                activationElement.removeContent((Content)occurrencesPerStep_double_deviationElement);
                if (migratedElement == null) continue;
                activationElement.addContent(indexOf, (Content)migratedElement);
                continue;
            }
            if (!activationType.equals("am:SporadicActivation") || (activationDeviation_Time_deviationElement = activationElement.getChild("activationDeviation")) == null) continue;
            migratedElement = this.migrateDeviationElement_Containing_TimeValue(activationDeviation_Time_deviationElement, "activationDeviation");
            indexOf = activationElement.indexOf((Content)activationDeviation_Time_deviationElement);
            activationElement.removeContent((Content)activationDeviation_Time_deviationElement);
            if (migratedElement != null) {
                activationElement.addContent(indexOf, (Content)migratedElement);
            }
            migratedElement.setName("occurrence");
        }
    }

    private void update_ChunkProcessingInstructions(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("./swModel/runnables//*[@xsi:type=\"am:LabelAccess\" or @xsi:type=\"am:ChannelSend\" or @xsi:type=\"am:ChannelReceive\"]/transmissionPolicy");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/operatingSystems/taskSchedulers/computationItems[@xsi:type=\"am:LabelAccess\"]/transmissionPolicy");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/operatingSystems/interruptControllers/computationItems[@xsi:type=\"am:LabelAccess\"]/transmissionPolicy");
        List transmissionPolicyElements = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getNS_093("am"), this.helper.getGenericNS("xsi")});
        for (Element transmissionPolicyElement : transmissionPolicyElements) {
            Attribute attribute = transmissionPolicyElement.getAttribute("chunkProcessingInstructions");
            if (attribute == null) continue;
            attribute.setName("chunkProcessingTicks");
        }
    }

    private void update_ExecutionNeed(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("./swModel/runnables//*[@xsi:type=\"am:ExecutionNeed\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/operatingSystems/taskSchedulers/computationItems[@xsi:type=\"am:ExecutionNeed\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/operatingSystems/interruptControllers/computationItems[@xsi:type=\"am:ExecutionNeed\"]");
        List executionNeeds = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getNS_093("am"), this.helper.getGenericNS("xsi")});
        for (Element executionNeedElement : executionNeeds) {
            String containerElementName = null;
            String containerType = "";
            Element parentElement = this.helper.getParentElementOfName(executionNeedElement, new String[]{"runnables", "taskSchedulers", "interruptControllers"});
            if (parentElement != null) {
                containerElementName = parentElement.getAttributeValue("name");
                if (parentElement.getName().equals("runnables")) {
                    containerType = "Runnable";
                } else if (parentElement.getName().equals("taskSchedulers")) {
                    containerType = "TaskScheduler";
                } else if (parentElement.getName().equals("interruptControllers")) {
                    containerType = "InterruptController";
                }
            }
            String nodeName = executionNeedElement.getName();
            List defaultElements = executionNeedElement.getChildren("default");
            LinkedHashMap<String, Element> defaultElementsMap = new LinkedHashMap<String, Element>();
            for (Element defaultElement : defaultElements) {
                String key = defaultElement.getAttributeValue("key");
                if (key == null) continue;
                defaultElementsMap.put(key, defaultElement);
            }
            Element newExecutionTicksElement = null;
            Element newExecutionNeedsElement = null;
            Set entrySet = defaultElementsMap.entrySet();
            for (Map.Entry next : entrySet) {
                Element newNeedElementValue;
                Element valueElement;
                Attribute typeAttribute;
                String key = (String)next.getKey();
                if (key.equals("Instructions")) {
                    Element defaultInstructionsElement = (Element)defaultElementsMap.get("Instructions");
                    newExecutionTicksElement = new Element(nodeName);
                    typeAttribute = new Attribute("type", "am:Ticks", this.helper.getGenericNS("xsi"));
                    newExecutionTicksElement.getAttributes().add(typeAttribute);
                    Element valueElement2 = defaultInstructionsElement.getChild("value");
                    Element default_executionTicksElement = this.createTicksElementFromNeed(valueElement2, "default", 1.0);
                    if (default_executionTicksElement == null) continue;
                    newExecutionTicksElement.addContent((Content)default_executionTicksElement);
                    continue;
                }
                if (containerType.equals("TaskScheduler") || containerType.equals("InterruptController")) {
                    this.logger.warn((Object)("In " + containerType + " : " + containerElementName + ", ExecutionNeed element's NeedEntry (having HwFeatureCategory :  " + key + ")-> can not be migrated. As this is not supported in 0.9.3. \nIn " + containerType + " element only NeedEntry elements having HwFeatureCategory Instructions are migrated to Ticks"));
                    continue;
                }
                Element defaultExecutionNeedElement = (Element)defaultElementsMap.get(key);
                if (newExecutionNeedsElement == null) {
                    newExecutionNeedsElement = new Element(nodeName);
                    typeAttribute = new Attribute("type", "am:ExecutionNeed", this.helper.getGenericNS("xsi"));
                    newExecutionNeedsElement.getAttributes().add(typeAttribute);
                }
                if ((valueElement = defaultExecutionNeedElement.getChild("value")) == null || (newNeedElementValue = this.createTicksElementFromNeed(valueElement, "value", 1.0)) == null) continue;
                Element needsElement = new Element("needs");
                needsElement.setAttribute(new Attribute("key", key));
                needsElement.addContent((Content)newNeedElementValue);
                newExecutionNeedsElement.addContent((Content)needsElement);
            }
            List extendedElements = executionNeedElement.getChildren("extended");
            for (Element extendedElement : extendedElements) {
                Double ipcValue = this.getIPCValue(extendedElement);
                List valueElements = this.helper.getXpathResult(extendedElement, "./value[@key=\"Instructions\"]", Element.class, new Namespace[]{this.helper.getNS_093("am")});
                if (valueElements.size() <= 0) continue;
                Element extended_executionTicksElement = new Element("extended");
                this.helper.copyElement_Attribute_or_Element(extendedElement, extended_executionTicksElement, "key");
                Element valueElement = (Element)valueElements.get(0);
                Element valueValueElement = valueElement.getChild("value");
                Element value_executionTicksElement = this.createTicksElementFromNeed(valueValueElement, "value", ipcValue);
                if (value_executionTicksElement == null) continue;
                extended_executionTicksElement.addContent((Content)value_executionTicksElement);
                if (newExecutionTicksElement == null) {
                    newExecutionTicksElement = new Element(nodeName);
                    Attribute typeAttribute = new Attribute("type", "am:Ticks", this.helper.getGenericNS("xsi"));
                    newExecutionTicksElement.getAttributes().add(typeAttribute);
                }
                newExecutionTicksElement.addContent((Content)extended_executionTicksElement);
            }
            ArrayList<Element> newRunnableItemElementsList = new ArrayList<Element>();
            if (newExecutionTicksElement != null) {
                newRunnableItemElementsList.add(newExecutionTicksElement);
            }
            if (newExecutionNeedsElement != null) {
                newRunnableItemElementsList.add(newExecutionNeedsElement);
            }
            Parent parent = executionNeedElement.getParent();
            int indexOf = parent.indexOf((Content)executionNeedElement);
            if (newRunnableItemElementsList.size() > 0) {
                parent.addContent(indexOf, newRunnableItemElementsList);
            }
            List skippedValuesExtended = this.helper.getXpathResult(executionNeedElement, "./extended/value[not(@key=\"Instructions\")]", Element.class, new Namespace[]{this.helper.getNS_093("am")});
            List skippedValuesDefault = this.helper.getXpathResult(executionNeedElement, "./default[not(@key=\"Instructions\")]", Element.class, new Namespace[]{this.helper.getNS_093("am")});
            StringBuffer extendedElementsbuffer = new StringBuffer();
            for (Element elementKey : skippedValuesExtended) {
                String attributeValue = elementKey.getAttributeValue("key");
                extendedElementsbuffer.append(attributeValue);
                extendedElementsbuffer.append(",");
            }
            StringBuffer defaultElementsbuffer = new StringBuffer();
            for (Element elementKey : skippedValuesDefault) {
                String attributeValue = elementKey.getAttributeValue("key");
                defaultElementsbuffer.append(attributeValue);
                defaultElementsbuffer.append(",");
            }
            if (extendedElementsbuffer.length() > 0) {
                this.logger.info((Object)("In " + containerType + " : \"" + containerElementName + ", \" Entries of ExecutionNeed (extended elements) with following keys can not be migrated : " + extendedElementsbuffer.toString().substring(0, extendedElementsbuffer.length() - 1) + " -> (only supported \"HwFeatureCategory\" as key is : \"Instructions\")"));
            }
            if (defaultElementsbuffer.length() > 0 && (containerType.equals("TaskScheduler") || containerType.equals("InterruptController"))) {
                this.logger.info((Object)("In " + containerType + " : \"" + containerElementName + ", \" Entries of ExecutionNeed (default elements) with following keys can not be migrated : " + defaultElementsbuffer.toString().substring(0, defaultElementsbuffer.length() - 1) + " ->(only supported \"HwFeatureCategory\" as key is : \"Instructions\")"));
            }
            parent.removeContent((Content)executionNeedElement);
        }
    }

    private Double getIPCValue(Element extendedElement) {
        Double ipcValue;
        String ipcFeatureElement;
        String puDefinition = this.helper.getSingleElementNameFromAttributeOrChildeElement("key", extendedElement);
        if (puDefinition != null && (ipcFeatureElement = this.getHWCache().puDefinition_IPCFeatureMap.get(puDefinition)) != null && (ipcValue = this.getHWCache().ipcFeature_valueMap.get(ipcFeatureElement)) != null) {
            return ipcValue;
        }
        return 1.0;
    }

    private Element createTicksElementFromNeed(Element valueElement, String newElementName, double ipcValue) {
        if (valueElement != null) {
            String valueType = valueElement.getAttributeValue("type", this.helper.getGenericNS("xsi"));
            if (valueType != null && valueType.equals("am:NeedConstant")) {
                Element tc_executionTicksElement = new Element(newElementName);
                Attribute default_executionTicksElement_TypeAttribute = new Attribute("type", "am:DiscreteValueConstant", this.helper.getGenericNS("xsi"));
                tc_executionTicksElement.getAttributes().add(default_executionTicksElement_TypeAttribute);
                String valueValue = valueElement.getAttributeValue("value");
                if (valueValue != null) {
                    tc_executionTicksElement.getAttributes().add(new Attribute("value", this.getValueAfterApplyingIPC(valueValue, ipcValue)));
                }
                return tc_executionTicksElement;
            }
            if (valueType != null && valueType.equals("am:NeedDeviation")) {
                Element deviationElement = valueElement.getChild("deviation");
                return this.migrateDeviationElement_Containing_LongValue(deviationElement, newElementName, ipcValue);
            }
        }
        return null;
    }

    private HWCacheBuilder.PUDefinition_IPCData getHWCache() {
        if (this.hwCache == null) {
            for (ICache cache : this.caches) {
                Map map;
                Map cacheMap;
                if (!(cache instanceof HWCacheBuilder) || (cacheMap = cache.getCacheMap()) == null || cacheMap.size() <= 0 || (map = (Map)Iterables.get(cacheMap.values(), (int)0)) == null) continue;
                Object object = map.get("globalCache");
                return (HWCacheBuilder.PUDefinition_IPCData)object;
            }
        }
        return this.hwCache;
    }
}

