/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters093.utils;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters093.utils.HelperUtils_092_093;
import org.jdom2.Document;
import org.jdom2.Element;

public class HWCacheBuilder
implements ICache {
    private final Map<File, Map<String, Object>> map = new HashMap<File, Map<String, Object>>();
    private final HelperUtils_092_093 helper = HelperUtils_092_093.getInstance();
    protected Logger logger = LogManager.getLogger((String)"org.eclipse.app4mc.amalthea.modelmigration");

    public void buildCache(Map<File, Document> fileName_documentsMap) {
        HashMap<String, PUDefinition_IPCData> hashMap = new HashMap<String, PUDefinition_IPCData>();
        PUDefinition_IPCData cache = new PUDefinition_IPCData();
        hashMap.put("globalCache", cache);
        for (File targetFile : fileName_documentsMap.keySet()) {
            Element hWModelElement;
            Element rootElement;
            this.getCacheMap().put(targetFile, hashMap);
            Document document1 = fileName_documentsMap.get(targetFile);
            if (document1 == null || (rootElement = document1.getRootElement()) == null || (hWModelElement = rootElement.getChild("hwModel")) == null) continue;
            List featureCategoriesList = hWModelElement.getChildren("featureCategories");
            for (Element featureCategoriesElement : featureCategoriesList) {
                String featureCategoryName = featureCategoriesElement.getAttributeValue("name");
                List featuresList = featureCategoriesElement.getChildren("features");
                for (Element featureElement : featuresList) {
                    String featureName = featureElement.getAttributeValue("name");
                    String featureValue = featureElement.getAttributeValue("value");
                    String ipcFeatureKey = String.valueOf(this.helper.encodeName(featureCategoryName)) + "/" + this.helper.encodeName(featureName) + "?type=HwFeature";
                    double parseDouble = Double.parseDouble(featureValue);
                    cache.ipcFeature_valueMap.put(ipcFeatureKey, parseDouble);
                }
            }
            List definitionsList = hWModelElement.getChildren("definitions");
            for (Element definitionsElement : definitionsList) {
                String puDefinitionName = definitionsElement.getAttributeValue("name");
                Map features = this.helper.getMultipleElementsNameandTypeFromAttributeOrChildeElement("features", definitionsElement);
                Set keySet = features.keySet();
                List ipcHwFeatures = keySet.stream().filter(st -> st.startsWith("Instructions/IPC") || st.startsWith("Instructions/ipc")).collect(Collectors.toList());
                if (ipcHwFeatures.size() <= 0) continue;
                if (ipcHwFeatures.size() > 1) {
                    this.logger.error((Object)("ProcessingUnitDefinition : \"" + puDefinitionName + "\" contains multiple HwFeatures of type IPC. In this case, only the first HwFeature : " + (String)ipcHwFeatures.get(0) + " will be considered for runtime info calculation"));
                }
                cache.puDefinition_IPCFeatureMap.put(this.helper.encodeName(puDefinitionName), String.valueOf((String)ipcHwFeatures.get(0)) + "?type=HwFeature");
            }
        }
    }

    public Map<File, Map<String, Object>> getCacheMap() {
        return this.map;
    }

    public void clearCacheMap() {
        this.map.clear();
    }

    public class PUDefinition_IPCData {
        public Map<String, Double> ipcFeature_valueMap = new HashMap<String, Double>();
        public Map<String, String> puDefinition_IPCFeatureMap = new HashMap<String, String>();
    }
}

