/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.hardware;

import java.util.List;
import org.eclipse.app4mc.amalthea.model.HwConnection;
import org.eclipse.app4mc.amalthea.model.HwPort;
import org.eclipse.app4mc.amalthea.model.IReferable;
import org.eclipse.app4mc.amalthea.model.PortInterface;
import org.eclipse.app4mc.amalthea.validations.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.Result;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;

@Validation(id="AM-HW-Connection")
public class AmHwConnection
extends AmaltheaValidation {
    public EClassifier getEClassifier() {
        return ePackage.getHwConnection();
    }

    public void validate(EObject object, List<Result> results) {
        if (object instanceof HwConnection) {
            HwConnection connection = (HwConnection)object;
            boolean continueChecks = true;
            HwPort port1 = connection.getPort1();
            HwPort port2 = connection.getPort2();
            if (port1 == null) {
                this.addIssue(results, (EObject)connection, "HW Connection " + this.longName((IReferable)connection) + ": Port 1 is missing");
                continueChecks = false;
            }
            if (port2 == null) {
                this.addIssue(results, (EObject)connection, "HW Connection " + this.longName((IReferable)connection) + ": Port 2 is missing");
                continueChecks = false;
            }
            if (port1 != null && port1 == port2) {
                this.addIssue(results, (EObject)connection, "HW Connection " + this.longName((IReferable)connection) + ": Port 1 equals port 2");
                continueChecks = false;
            }
            if (!continueChecks) {
                return;
            }
            if (!connection.isInternal() && port1.getPortInterface() != PortInterface._UNDEFINED_ && port2.getPortInterface() != PortInterface._UNDEFINED_ && port1.getPortInterface() != port2.getPortInterface()) {
                this.addIssue(results, (EObject)connection, "HW Connection " + this.longName((IReferable)connection) + ": Port interfaces do not match");
            }
        }
    }
}

