/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.hardware;

import java.util.List;
import org.eclipse.app4mc.amalthea.model.Cache;
import org.eclipse.app4mc.amalthea.model.ConnectionHandler;
import org.eclipse.app4mc.amalthea.model.HwModule;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.amalthea.model.Memory;
import org.eclipse.app4mc.amalthea.model.ProcessingUnit;
import org.eclipse.app4mc.amalthea.validations.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.Result;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;

@Validation(id="AM-HW-Module-Definition")
public class AmHwModuleDefinition
extends AmaltheaValidation {
    public EClassifier getEClassifier() {
        return ePackage.getHwModule();
    }

    public void validate(EObject object, List<Result> results) {
        if (object instanceof HwModule) {
            HwModule module = (HwModule)object;
            if (module instanceof Memory && ((Memory)module).getDefinition() == null) {
                this.addIssue(results, (EObject)module, "HW Module (Memory) " + this.name((INamed)module) + ": missing definition");
            }
            if (module instanceof ProcessingUnit && ((ProcessingUnit)module).getDefinition() == null) {
                this.addIssue(results, (EObject)module, "HW Module (ProcessingUnit) " + this.name((INamed)module) + ": missing definition");
            }
            if (module instanceof ConnectionHandler && ((ConnectionHandler)module).getDefinition() == null) {
                this.addIssue(results, (EObject)module, "HW Module (ConnectionHandler) " + this.name((INamed)module) + ": missing definition");
            }
            if (module instanceof Cache && ((Cache)module).getDefinition() == null) {
                this.addIssue(results, (EObject)module, "HW Module (Cache) " + this.name((INamed)module) + ": missing definition");
            }
        }
    }
}

