/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.misc;

import java.util.ArrayList;
import org.eclipse.app4mc.amalthea.model.AbstractEventChain;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.ConstraintsModel;
import org.eclipse.app4mc.amalthea.model.EventChain;
import org.eclipse.app4mc.amalthea.model.EventChainItem;
import org.eclipse.app4mc.amalthea.model.SubEventChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class TODO_ConstraintsModelCheck {
    public void checkEventChains(ConstraintsModel constraintsModel) {
        if (constraintsModel != null) {
            for (EventChain eventChain : constraintsModel.getEventChains()) {
                this.checkChainConsistency((AbstractEventChain)eventChain);
            }
        }
    }

    private void checkChainConsistency(AbstractEventChain eventChain) {
        if (eventChain == null) {
            return;
        }
        this.checkChainConsistency(eventChain, (EList<EventChainItem>)eventChain.getSegments());
        this.checkChainConsistency(eventChain, (EList<EventChainItem>)eventChain.getStrands());
    }

    private void checkChainConsistency(AbstractEventChain pEventChain, EList<EventChainItem> pSubEventChains) {
        ArrayList<AbstractEventChain> subEventChains = new ArrayList<AbstractEventChain>();
        for (EventChainItem subEventChainItem : pSubEventChains) {
            AbstractEventChain subChain = subEventChainItem.getEventChain();
            if (subChain == null) continue;
            subEventChains.add(subChain);
            if (!(subChain instanceof SubEventChain)) continue;
            this.checkChainConsistency(subChain);
        }
        if (subEventChains.isEmpty()) {
            return;
        }
        int chainnedEventsCnt = -1;
        for (AbstractEventChain subEventChain : subEventChains) {
            if (subEventChain.getStimulus() != pEventChain.getStimulus()) continue;
            chainnedEventsCnt = 0;
            AbstractEventChain chainingEvent = subEventChain;
            StringBuilder completeChainBuilder = new StringBuilder();
            completeChainBuilder.append("EventChain: [ --> {" + this.getStimulusEvent(pEventChain) + "}" + pEventChain.getName() + "{" + this.getResponseEvent(pEventChain) + "} --> ]\n");
            completeChainBuilder.append("  SubEventChain: (");
            while (chainingEvent.getResponse() != pEventChain.getResponse()) {
                boolean hasChained = false;
                for (AbstractEventChain subEvent : subEventChains) {
                    if (chainingEvent.getResponse() != subEvent.getStimulus()) continue;
                    completeChainBuilder.append(" --> {" + this.getStimulusEvent(chainingEvent) + "}" + chainingEvent.getName() + "{" + this.getResponseEvent(chainingEvent) + "}");
                    chainingEvent = subEvent;
                    ++chainnedEventsCnt;
                    hasChained = true;
                }
                if (hasChained || chainingEvent.getResponse() == pEventChain.getResponse()) continue;
                this.issue((EObject)chainingEvent, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getEventChainContainer_EventChain(), "No successor found for EventChain '" + chainingEvent.getName() + "'");
                break;
            }
            completeChainBuilder.append(" --> {" + this.getStimulusEvent(chainingEvent) + "}" + chainingEvent.getName() + "{" + this.getResponseEvent(chainingEvent) + "}" + " --> )");
            if (chainingEvent.getResponse() != pEventChain.getResponse()) continue;
            if (chainnedEventsCnt < subEventChains.size() - 1) {
                this.issue((EObject)pEventChain, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getEventChainContainer_EventChain(), "SubChain complete BUT unconnected SubEventChains left for EventChain " + pEventChain.getName());
            }
            if (chainnedEventsCnt <= subEventChains.size()) continue;
            this.issue((EObject)pEventChain, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getEventChainContainer_EventChain(), "Cycle found for EventChain " + pEventChain.getName());
        }
        if (chainnedEventsCnt == -1) {
            this.issue((EObject)pEventChain, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getEventChainContainer_EventChain(), "Beginning SubEventChain not found; EventChain's stimulus does not match with SubEventChain's stimulus " + pEventChain.getName());
        }
    }

    private String getResponseEvent(AbstractEventChain eventChain) {
        if (eventChain == null || eventChain.getResponse() == null) {
            return "MISSING";
        }
        return eventChain.getResponse().getName();
    }

    private String getStimulusEvent(AbstractEventChain eventChain) {
        if (eventChain == null || eventChain.getStimulus() == null) {
            return "MISSING";
        }
        return eventChain.getStimulus().getName();
    }

    private void issue(EObject object, EStructuralFeature feature, Object ... messageArguments) {
    }
}

