/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.software;

import java.util.List;
import org.eclipse.app4mc.amalthea.model.CallArgument;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableParameter;
import org.eclipse.app4mc.amalthea.validations.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.Result;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;

@Validation(id="AM-SW-CallArgument")
public class AmSwCallArgument
extends AmaltheaValidation {
    public EClassifier getEClassifier() {
        return ePackage.getCallArgument();
    }

    public void validate(EObject object, List<Result> results) {
        if (object instanceof CallArgument) {
            CallArgument argument = (CallArgument)object;
            Runnable calledRunnable = argument.getContainingCall().getRunnable();
            RunnableParameter parameter = argument.getParameter();
            if (parameter == null) {
                this.addIssue(results, (EObject)argument, "Call argument: Parameter of argument is undefined");
            }
            if (calledRunnable == null) {
                this.addIssue(results, (EObject)argument.getContainingCall(), "Call argument: Called runnable is undefined");
            }
            if (parameter == null || calledRunnable == null) {
                return;
            }
            if (!calledRunnable.getParameters().contains((Object)parameter)) {
                this.addIssue(results, (EObject)argument, "Call argument: Called Runnable \"" + calledRunnable.getName() + "\" does not match Parameter \"" + parameter.toString() + "\"");
            }
        }
    }
}

