/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.software;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.app4mc.amalthea.model.CallArgument;
import org.eclipse.app4mc.amalthea.model.DataDependency;
import org.eclipse.app4mc.amalthea.model.DirectionType;
import org.eclipse.app4mc.amalthea.model.LabelAccess;
import org.eclipse.app4mc.amalthea.model.LabelAccessEnum;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableCall;
import org.eclipse.app4mc.amalthea.model.RunnableParameter;
import org.eclipse.app4mc.amalthea.model.util.SoftwareUtil;
import org.eclipse.app4mc.amalthea.validations.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.Result;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;

@Validation(id="AM-SW-DataDependency")
public class AmSwDataDependency
extends AmaltheaValidation {
    public EClassifier getEClassifier() {
        return ePackage.getDataDependency();
    }

    public void validate(EObject object, List<Result> results) {
        if (object instanceof DataDependency) {
            List<CallArgument> localCallArguments;
            List<RunnableParameter> localParameters;
            DirectionType direction;
            RunnableParameter parameter;
            DirectionType direction2;
            LabelAccessEnum accessType;
            DataDependency dependency = (DataDependency)object;
            Runnable runnable = dependency.getContainingRunnable();
            if (runnable == null) {
                return;
            }
            EObject container = dependency.eContainer();
            if (container instanceof LabelAccess && (accessType = ((LabelAccess)container).getAccess()) != LabelAccessEnum.WRITE) {
                this.addIssue(results, container, "Data dependency: A data dependency can only be defined for WRITE label accesses");
            }
            if (container instanceof RunnableParameter && (direction2 = ((RunnableParameter)container).getDirection()) != DirectionType.OUT && direction2 != DirectionType.INOUT) {
                this.addIssue(results, container, "Data dependency: A data dependency can only be defined for OUT/INOUT parameters");
            }
            if (container instanceof CallArgument && (parameter = ((CallArgument)container).getParameter()) != null && (direction = parameter.getDirection()) != DirectionType.IN && direction != DirectionType.INOUT) {
                this.addIssue(results, container, "Data dependency: A data dependency can only be defined for IN/INOUT call arguments");
            }
            if (!(localParameters = this.getSuitableParameters(runnable)).containsAll((Collection<?>)dependency.getParameters())) {
                this.addIssue(results, (EObject)dependency, "Data dependency: A data dependency can only refer to local IN/INOUT parameters");
            }
            if (!(localCallArguments = this.getSuitableCallArguments(runnable)).containsAll((Collection<?>)dependency.getCallArguments())) {
                this.addIssue(results, (EObject)dependency, "Data dependency: A data dependency can only refer to local OUT/INOUT call arguments");
            }
        }
    }

    private List<RunnableParameter> getSuitableParameters(Runnable runnable) {
        if (runnable == null) {
            return Collections.emptyList();
        }
        return runnable.getParameters().stream().filter(e -> e.getDirection() == DirectionType.IN || e.getDirection() == DirectionType.INOUT).collect(Collectors.toList());
    }

    private List<CallArgument> getSuitableCallArguments(Runnable runnable) {
        if (runnable == null) {
            return Collections.emptyList();
        }
        List<DirectionType> possibleDirections = Arrays.asList(DirectionType.OUT, DirectionType.INOUT);
        return SoftwareUtil.collectRunnableItems((Runnable)runnable, null, e -> e instanceof RunnableCall).stream().flatMap(e -> ((RunnableCall)e).getArguments().stream()).filter(e -> e.getParameter() != null).filter(e -> possibleDirections.contains(e.getParameter().getDirection())).collect(Collectors.toList());
    }
}

