/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validation.ta.checks.impl;

import java.math.BigInteger;
import java.util.HashSet;
import org.eclipse.app4mc.amalthea.model.AbstractProcess;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.DataAgeTime;
import org.eclipse.app4mc.amalthea.model.DelayConstraint;
import org.eclipse.app4mc.amalthea.model.EarliestDeadlineFirst;
import org.eclipse.app4mc.amalthea.model.EventChainLatencyConstraint;
import org.eclipse.app4mc.amalthea.model.LimitType;
import org.eclipse.app4mc.amalthea.model.ProcessRequirement;
import org.eclipse.app4mc.amalthea.model.RepetitionConstraint;
import org.eclipse.app4mc.amalthea.model.RequirementLimit;
import org.eclipse.app4mc.amalthea.model.SynchronizationConstraint;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.model.TaskAllocation;
import org.eclipse.app4mc.amalthea.model.TaskScheduler;
import org.eclipse.app4mc.amalthea.model.TaskSchedulingAlgorithm;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.TimeMetric;
import org.eclipse.app4mc.amalthea.model.TimeRequirementLimit;
import org.eclipse.app4mc.amalthea.model.TimeUnit;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.AbstractValidatorImpl;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IEObjectHelper;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IssueCreator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ConstraintsModelValidatorImpl
extends AbstractValidatorImpl {
    public ConstraintsModelValidatorImpl(IssueCreator issueCreator) {
        super(issueCreator);
    }

    public ConstraintsModelValidatorImpl(IssueCreator issueCreator, IEObjectHelper objectHelper) {
        super(issueCreator, objectHelper);
    }

    public void checkEDFDeadlineAvailability(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        HashSet<Task> tasks = new HashSet<Task>();
        HashSet<Task> tasksWithDeadlines = new HashSet<Task>();
        while (amaIter.hasNext()) {
            ProcessRequirement requirement;
            AbstractProcess process;
            EObject elem = (EObject)amaIter.next();
            if (elem instanceof TaskAllocation) {
                Task task;
                TaskSchedulingAlgorithm schedulingAlgorithm;
                TaskAllocation taskAllocation = (TaskAllocation)elem;
                TaskScheduler taskScheduler = taskAllocation.getScheduler();
                if (taskScheduler == null || !((schedulingAlgorithm = taskScheduler.getSchedulingAlgorithm()) instanceof EarliestDeadlineFirst) || (task = taskAllocation.getTask()) == null) continue;
                tasks.add(task);
                continue;
            }
            if (!(elem instanceof ProcessRequirement) || !((process = (requirement = (ProcessRequirement)elem).getProcess()) instanceof Task)) continue;
            Task task = (Task)process;
            RequirementLimit limit = requirement.getLimit();
            if (limit == null || LimitType.UPPER_LIMIT != limit.getLimitType()) continue;
            tasksWithDeadlines.add(task);
        }
        HashSet tasksMissingDeadline = new HashSet(tasks);
        tasksMissingDeadline.removeAll(tasksWithDeadlines);
        for (Task task : tasksMissingDeadline) {
            this.issueCreator.issue((EObject)task, null, new Object[]{task.getName()});
        }
    }

    public void checkDeadlineValue(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            Time time;
            TimeRequirementLimit timeRequirementLimit;
            TimeMetric metric;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof TimeRequirementLimit) || TimeMetric.RESPONSE_TIME != (metric = (timeRequirementLimit = (TimeRequirementLimit)elem).getMetric()) || (time = timeRequirementLimit.getLimitValue()) == null) continue;
            BigInteger value = time.getValue();
            TimeUnit unit = time.getUnit();
            if (value.signum() > 0 && TimeUnit._UNDEFINED_ != unit) continue;
            this.issueCreator.issue((EObject)timeRequirementLimit, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getTimeRequirementLimit_LimitValue(), new Object[]{value, unit});
        }
    }

    public void checkSynchronizationConstraintToleranceUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            BigInteger value;
            SynchronizationConstraint synchronizationConstraint;
            Time tolerance;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof SynchronizationConstraint) || (tolerance = (synchronizationConstraint = (SynchronizationConstraint)elem).getTolerance()) == null || (value = tolerance.getValue()).signum() >= 0) continue;
            this.issueCreator.issue((EObject)tolerance, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getSynchronizationConstraint_Tolerance(), new Object[]{value});
        }
    }

    public void checkDelayConstraintUpperUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            BigInteger value;
            DelayConstraint delayConstraint;
            Time upper;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof DelayConstraint) || (upper = (delayConstraint = (DelayConstraint)elem).getUpper()) == null || (value = upper.getValue()).signum() >= 0) continue;
            this.issueCreator.issue((EObject)upper, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getDelayConstraint_Upper(), new Object[]{value});
        }
    }

    public void checkDelayConstraintLowerUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            BigInteger value;
            DelayConstraint delayConstraint;
            Time lower;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof DelayConstraint) || (lower = (delayConstraint = (DelayConstraint)elem).getLower()) == null || (value = lower.getValue()).signum() >= 0) continue;
            this.issueCreator.issue((EObject)lower, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getDelayConstraint_Lower(), new Object[]{value});
        }
    }

    public void checkEventChainLatencyConstraintMinimumUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            BigInteger value;
            EventChainLatencyConstraint eventChainLatencyConstraint;
            Time minimum;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof EventChainLatencyConstraint) || (minimum = (eventChainLatencyConstraint = (EventChainLatencyConstraint)elem).getMinimum()) == null || (value = minimum.getValue()).signum() >= 0) continue;
            this.issueCreator.issue((EObject)minimum, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getEventChainLatencyConstraint_Minimum(), new Object[]{value});
        }
    }

    public void checkEventChainLatencyConstraintMaximumUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            BigInteger value;
            EventChainLatencyConstraint eventChainLatencyConstraint;
            Time maximum;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof EventChainLatencyConstraint) || (maximum = (eventChainLatencyConstraint = (EventChainLatencyConstraint)elem).getMaximum()) == null || (value = maximum.getValue()).signum() >= 0) continue;
            this.issueCreator.issue((EObject)maximum, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getEventChainLatencyConstraint_Maximum(), new Object[]{value});
        }
    }

    public void checkRepetitionConstraintLowerUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            BigInteger value;
            RepetitionConstraint repetitionConstraint;
            Time lower;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof RepetitionConstraint) || (lower = (repetitionConstraint = (RepetitionConstraint)elem).getLower()) == null || (value = lower.getValue()).signum() >= 0) continue;
            this.issueCreator.issue((EObject)lower, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getRepetitionConstraint_Lower(), new Object[]{value});
        }
    }

    public void checkRepetitionConstraintUpperUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            BigInteger value;
            RepetitionConstraint repetitionConstraint;
            Time upper;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof RepetitionConstraint) || (upper = (repetitionConstraint = (RepetitionConstraint)elem).getUpper()) == null || (value = upper.getValue()).signum() >= 0) continue;
            this.issueCreator.issue((EObject)upper, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getRepetitionConstraint_Upper(), new Object[]{value});
        }
    }

    public void checkRepetitionConstraintJitterUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            BigInteger value;
            RepetitionConstraint repetitionConstraint;
            Time jitter;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof RepetitionConstraint) || (jitter = (repetitionConstraint = (RepetitionConstraint)elem).getJitter()) == null || (value = jitter.getValue()).signum() >= 0) continue;
            this.issueCreator.issue((EObject)jitter, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getRepetitionConstraint_Jitter(), new Object[]{value});
        }
    }

    public void checkRepetitionConstraintPeriodUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            BigInteger value;
            RepetitionConstraint repetitionConstraint;
            Time period;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof RepetitionConstraint) || (period = (repetitionConstraint = (RepetitionConstraint)elem).getPeriod()) == null || (value = period.getValue()).signum() >= 0) continue;
            this.issueCreator.issue((EObject)period, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getRepetitionConstraint_Period(), new Object[]{value});
        }
    }

    public void checkDataAgeTimeMinimumUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            BigInteger value;
            DataAgeTime dataAgeTime;
            Time minimum;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof DataAgeTime) || (minimum = (dataAgeTime = (DataAgeTime)elem).getMinimumTime()) == null || (value = minimum.getValue()).signum() >= 0) continue;
            this.issueCreator.issue((EObject)minimum, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getDataAgeTime_MinimumTime(), new Object[]{value});
        }
    }

    public void checkDataAgeTimeMaximumUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            BigInteger value;
            DataAgeTime dataAgeTime;
            Time maximum;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof DataAgeTime) || (maximum = (dataAgeTime = (DataAgeTime)elem).getMaximumTime()) == null || (value = maximum.getValue()).signum() >= 0) continue;
            this.issueCreator.issue((EObject)maximum, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getDataAgeTime_MaximumTime(), new Object[]{value});
        }
    }
}

