/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validation.ta.checks.impl;

import java.math.BigInteger;
import java.util.HashSet;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.ArrivalCurveEntry;
import org.eclipse.app4mc.amalthea.model.Clock;
import org.eclipse.app4mc.amalthea.model.ClockMultiplierList;
import org.eclipse.app4mc.amalthea.model.ClockMultiplierListEntry;
import org.eclipse.app4mc.amalthea.model.ClockSinusFunction;
import org.eclipse.app4mc.amalthea.model.ClockTriangleFunction;
import org.eclipse.app4mc.amalthea.model.PeriodicStimulus;
import org.eclipse.app4mc.amalthea.model.PeriodicSyntheticStimulus;
import org.eclipse.app4mc.amalthea.model.Scenario;
import org.eclipse.app4mc.amalthea.model.SingleStimulus;
import org.eclipse.app4mc.amalthea.model.StimuliModel;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.TimeUnit;
import org.eclipse.app4mc.amalthea.model.VariableRateStimulus;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.AbstractValidatorImpl;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IEObjectHelper;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IssueCreator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class StimuliModelValidatorImpl
extends AbstractValidatorImpl {
    public StimuliModelValidatorImpl(IssueCreator issueCreator) {
        super(issueCreator);
    }

    public StimuliModelValidatorImpl(IssueCreator issueCreator, IEObjectHelper objectHelper) {
        super(issueCreator, objectHelper);
    }

    public void checkPeriodicRecurrence(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            PeriodicStimulus periodic;
            Time recurrence;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof PeriodicStimulus) || (recurrence = (periodic = (PeriodicStimulus)elem).getRecurrence()) == null) continue;
            BigInteger value = recurrence.getValue();
            TimeUnit unit = recurrence.getUnit();
            if (value.signum() > 0 && TimeUnit._UNDEFINED_ != unit) continue;
            this.issueCreator.issue((EObject)periodic, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getFixedPeriodic_Recurrence(), new Object[]{value, unit});
        }
    }

    public void checkVariableRateScenario(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            VariableRateStimulus vr;
            Scenario sc;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof VariableRateStimulus) || (sc = (vr = (VariableRateStimulus)elem).getScenario()) != null) continue;
            this.issueCreator.issue((EObject)vr, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getVariableRateStimulus_Scenario(), new Object[0]);
        }
    }

    public void checkScenarioRecurrence(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            Scenario sc;
            Time recurrence;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof Scenario) || (recurrence = (sc = (Scenario)elem).getRecurrence()) == null) continue;
            BigInteger value = recurrence.getValue();
            TimeUnit unit = recurrence.getUnit();
            if (value.signum() > 0 && TimeUnit._UNDEFINED_ != unit) continue;
            this.issueCreator.issue((EObject)sc, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getScenario_Recurrence(), new Object[]{value, unit});
        }
    }

    public void checkScenarioClock(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        HashSet<VariableRateStimulus> stimuliSet = new HashSet<VariableRateStimulus>();
        HashSet<Clock> clockSet = new HashSet<Clock>();
        while (amaIter.hasNext()) {
            EObject elem = (EObject)amaIter.next();
            if (elem instanceof VariableRateStimulus) {
                VariableRateStimulus vr = (VariableRateStimulus)elem;
                stimuliSet.add(vr);
                continue;
            }
            if (!(elem instanceof StimuliModel)) continue;
            StimuliModel stimuliModel = (StimuliModel)elem;
            EList clockList = stimuliModel.getClocks();
            for (Clock clock : clockList) {
                if (clock == null) continue;
                clockSet.add(clock);
            }
        }
        for (VariableRateStimulus vr : stimuliSet) {
            Scenario sc;
            Clock clock;
            if (vr == null || (sc = vr.getScenario()) == null || (clock = sc.getClock()) != null && clockSet.contains(clock)) continue;
            this.issueCreator.issue((EObject)sc, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getScenario_Clock(), new Object[0]);
        }
    }

    public void checkClockTriangleFunction(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof ClockTriangleFunction)) continue;
            ClockTriangleFunction clockTriangleFunction = (ClockTriangleFunction)elem;
            double min = clockTriangleFunction.getMin();
            double max = clockTriangleFunction.getMax();
            if (min < 0.0) {
                this.issueCreator.issue((EObject)clockTriangleFunction, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockTriangleFunction_Min(), new Object[0]);
                continue;
            }
            if (max <= 0.0) {
                this.issueCreator.issue((EObject)clockTriangleFunction, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockTriangleFunction_Max(), new Object[0]);
                continue;
            }
            if (!(min > max)) continue;
            this.issueCreator.issue((EObject)clockTriangleFunction, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockTriangleFunction_Min(), new Object[0]);
        }
    }

    public void checkClockSinusFunction(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof ClockSinusFunction)) continue;
            ClockSinusFunction clockSinusFunction = (ClockSinusFunction)elem;
            double amplitude = clockSinusFunction.getAmplitude();
            double yOffset = clockSinusFunction.getYOffset();
            if (amplitude < 0.0) {
                this.issueCreator.issue((EObject)clockSinusFunction, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockSinusFunction_Amplitude(), new Object[0]);
                continue;
            }
            if (yOffset <= 0.0) {
                this.issueCreator.issue((EObject)clockSinusFunction, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockSinusFunction_YOffset(), new Object[0]);
                continue;
            }
            if (!(amplitude > yOffset)) continue;
            this.issueCreator.issue((EObject)clockSinusFunction, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockSinusFunction_Amplitude(), new Object[0]);
        }
    }

    public void checkClockMultiplierList(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof ClockMultiplierList)) continue;
            ClockMultiplierList clock = (ClockMultiplierList)elem;
            for (ClockMultiplierListEntry entry : clock.getEntries()) {
                double value = entry.getMultiplier();
                if (!(value < 0.0)) continue;
                this.issueCreator.issue((EObject)clock, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockMultiplierListEntry_Multiplier(), new Object[0]);
            }
        }
    }

    public void checkPeriodicOffsetUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            BigInteger value;
            PeriodicStimulus periodic;
            Time offset;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof PeriodicStimulus) || (offset = (periodic = (PeriodicStimulus)elem).getOffset()) == null || (value = offset.getValue()).signum() >= 0) continue;
            this.issueCreator.issue((EObject)offset, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getFixedPeriodic_Offset(), new Object[]{value});
        }
    }

    public void checkPeriodicRecurrenceUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            BigInteger value;
            PeriodicStimulus periodic;
            Time recurrence;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof PeriodicStimulus) || (recurrence = (periodic = (PeriodicStimulus)elem).getRecurrence()) == null || (value = recurrence.getValue()).signum() >= 0) continue;
            this.issueCreator.issue((EObject)recurrence, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getFixedPeriodic_Recurrence(), new Object[]{value});
        }
    }

    public void checkSyntheticOffsetUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            BigInteger value;
            PeriodicSyntheticStimulus synthetic;
            Time offset;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof PeriodicSyntheticStimulus) || (offset = (synthetic = (PeriodicSyntheticStimulus)elem).getOffset()) == null || (value = offset.getValue()).signum() >= 0) continue;
            this.issueCreator.issue((EObject)offset, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getFixedPeriodic_Offset(), new Object[]{value});
        }
    }

    public void checkSyntheticRecurrenceUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            BigInteger value;
            PeriodicSyntheticStimulus synthetic;
            Time period;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof PeriodicSyntheticStimulus) || (period = (synthetic = (PeriodicSyntheticStimulus)elem).getRecurrence()) == null || (value = period.getValue()).signum() >= 0) continue;
            this.issueCreator.issue((EObject)period, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getFixedPeriodic_Recurrence(), new Object[]{value});
        }
    }

    public void checkSyntheticTimestampsUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof PeriodicSyntheticStimulus)) continue;
            for (Time timestamp : ((PeriodicSyntheticStimulus)elem).getOccurrenceTimes()) {
                BigInteger value;
                if (timestamp == null || (value = timestamp.getValue()).signum() >= 0) continue;
                this.issueCreator.issue((EObject)timestamp, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getPeriodicSyntheticStimulus_OccurrenceTimes(), new Object[]{value});
            }
        }
    }

    public void checkSingleOccurrenceUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            BigInteger value;
            SingleStimulus single;
            Time activation;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof SingleStimulus) || (activation = (single = (SingleStimulus)elem).getOccurrence()) == null || (value = activation.getValue()).signum() >= 0) continue;
            this.issueCreator.issue((EObject)activation, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getSingleStimulus_Occurrence(), new Object[]{value});
        }
    }

    public void checkArrivalCurveEntryLowerUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            BigInteger value;
            ArrivalCurveEntry arrivalCurveEntry;
            Time lowerTimeBorder;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof ArrivalCurveEntry) || (lowerTimeBorder = (arrivalCurveEntry = (ArrivalCurveEntry)elem).getLowerTimeBorder()) == null || (value = lowerTimeBorder.getValue()).signum() >= 0) continue;
            this.issueCreator.issue((EObject)lowerTimeBorder, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getArrivalCurveEntry_LowerTimeBorder(), new Object[]{value});
        }
    }

    public void checkArrivalCurveEntryUpperUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            BigInteger value;
            ArrivalCurveEntry arrivalCurveEntry;
            Time upperTimeBorder;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof ArrivalCurveEntry) || (upperTimeBorder = (arrivalCurveEntry = (ArrivalCurveEntry)elem).getUpperTimeBorder()) == null || (value = upperTimeBorder.getValue()).signum() >= 0) continue;
            this.issueCreator.issue((EObject)upperTimeBorder, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getArrivalCurveEntry_UpperTimeBorder(), new Object[]{value});
        }
    }

    public void checkClockTriangleFunctionPeriodUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            BigInteger value;
            ClockTriangleFunction clockTriangleFunction;
            Time period;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof ClockTriangleFunction) || (period = (clockTriangleFunction = (ClockTriangleFunction)elem).getPeriod()) == null || (value = period.getValue()).signum() >= 0) continue;
            this.issueCreator.issue((EObject)period, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockTriangleFunction_Period(), new Object[]{value});
        }
    }

    public void checkClockSinusFunctionPeriodUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            BigInteger value;
            ClockSinusFunction clockSinusFunction;
            Time period;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof ClockSinusFunction) || (period = (clockSinusFunction = (ClockSinusFunction)elem).getPeriod()) == null || (value = period.getValue()).signum() >= 0) continue;
            this.issueCreator.issue((EObject)period, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockSinusFunction_Period(), new Object[]{value});
        }
    }

    public void checkClockMultiplierListEntryTimeUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            BigInteger value;
            ClockMultiplierListEntry clockMultiplierListEntry;
            Time time;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof ClockMultiplierListEntry) || (time = (clockMultiplierListEntry = (ClockMultiplierListEntry)elem).getTime()) == null || (value = time.getValue()).signum() >= 0) continue;
            this.issueCreator.issue((EObject)time, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockMultiplierListEntry_Time(), new Object[]{value});
        }
    }

    public void checkModeValueProviderConstraint(Amalthea amalthea) {
    }
}

