/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters081.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters081.impl.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters081.utils.HelperUtils_080_081;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class OSConverter
extends AbstractConverter {
    public OSConverter() {
        this.helper = HelperUtils_080_081.getInstance();
        this.logger = LogManager.getLogger((String)"org.eclipse.app4mc.amalthea.modelmigration");
    }

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) throws Exception {
        this.logger.info((Object)("Migration from 0.8.0 to 0.8.1  : Executing OS converter for model file : " + targetFile.getName()));
        Document root = fileName_documentsMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.updateOSModel(rootElement);
        fileName_documentsMap.put(targetFile.getCanonicalFile(), root);
    }

    private void updateOSModel(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("./osModel/operatingSystems/interruptControllers");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/operatingSystems/taskSchedulers");
        List sourceElements = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi")});
        for (Element schedulerElement : sourceElements) {
            List algorithmParameterElements = this.helper.getXpathResult(schedulerElement, "./schedulingAlgorithm[@xsi:type=\"am:UserSpecificSchedulingAlgorithm\"]/parameter", Element.class, new Namespace[]{this.helper.getGenericNS("xsi")});
            for (Element algorithmParameterElement : algorithmParameterElements) {
                algorithmParameterElement.setName("parameterExtensions");
            }
            String scheduleUnitPriority = schedulerElement.getAttributeValue("scheduleUnitPriority");
            if (scheduleUnitPriority != null && !scheduleUnitPriority.equals("0")) {
                this.addCustomProperty(schedulerElement, "scheduleUnitPriority", schedulerElement.getAttributeValue("scheduleUnitPriority"));
            }
            schedulerElement.removeAttribute("scheduleUnitPriority");
            Element schedulingUnitElement = schedulerElement.getChild("schedulingUnit");
            if (schedulingUnitElement == null) continue;
            this.logger.warn((Object)("SchedulingUnit removed from Scheduler : " + schedulerElement.getAttributeValue("name")));
            String schedulingUnitType = schedulingUnitElement.getAttributeValue("type", this.helper.getGenericNS("xsi"));
            if (schedulingUnitType != null) {
                if (schedulingUnitType.equals("am:SchedulingHWUnit")) {
                    this.moveCustomPropertiesOfSchedulingUnit(schedulerElement, schedulingUnitElement, "SchedulingHWUnit_CustomProperty__");
                    Element delayElement = schedulingUnitElement.getChild("delay");
                    if (delayElement != null) {
                        delayElement.detach();
                        Element customPropertiesElement = new Element("customProperties");
                        customPropertiesElement.setAttribute("key", "SchedulingHWUnit___delay");
                        delayElement.setName("value");
                        delayElement.setAttribute("type", "am:TimeObject", this.helper.getGenericNS("xsi"));
                        customPropertiesElement.addContent((Content)delayElement);
                        schedulerElement.addContent((Content)customPropertiesElement);
                        this.addCustomProperty(schedulerElement, "SchedulingHWUnit___delay", schedulerElement.getAttributeValue("delay"));
                    }
                } else if (schedulingUnitType.equals("am:SchedulingSWUnit")) {
                    this.moveCustomPropertiesOfSchedulingUnit(schedulerElement, schedulingUnitElement, "SchedulingSWUnit_CustomProperty__");
                    List instructionElements = schedulingUnitElement.getChildren("instructions");
                    if (instructionElements.size() > 0) {
                        this.logger.warn((Object)"-- Instructions inside SchedulingSWUnit are migrated to RunnableInstructions element");
                    }
                    for (Element instructionElement : instructionElements) {
                        Element clone = instructionElement.clone();
                        clone.setName("default");
                        Element computationItemElement = new Element("computationItems");
                        computationItemElement.setAttribute("type", "am:RunnableInstructions", this.helper.getGenericNS("xsi"));
                        computationItemElement.addContent((Content)clone);
                        schedulerElement.addContent((Content)computationItemElement);
                    }
                    String priority = schedulingUnitElement.getAttributeValue("priority");
                    if (priority != null && !priority.equals("0")) {
                        this.addCustomProperty(schedulerElement, "SchedulingSWUnit___priority", priority);
                    }
                    if (schedulingUnitElement.removeAttribute("interruptController") || schedulingUnitElement.removeChild("interruptController")) {
                        this.logger.warn((Object)"-- InterruptController inside SchedulingSWUnit is removed, as there is no equivalent element for it in AMALTHEA 0.8.1");
                    }
                }
            }
            schedulerElement.removeChild("schedulingUnit");
        }
    }

    private void moveCustomPropertiesOfSchedulingUnit(Element schedulerElement, Element schedulingUnitElement, String prefix) {
        List customPropertyElements = schedulingUnitElement.getChildren("customProperties");
        for (Element customProperty : customPropertyElements) {
            Element cloneCustomProperty = customProperty.clone();
            Attribute keyAttribute = cloneCustomProperty.getAttribute("key");
            if (keyAttribute != null) {
                String value = keyAttribute.getValue();
                keyAttribute.setValue(String.valueOf(prefix) + value);
            }
            schedulerElement.addContent((Content)cloneCustomProperty);
        }
    }
}

