/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.jdt.annotation.NonNull;

public class AmaltheaCrossReferenceAdapter
extends ECrossReferenceAdapter {
    private static final String ARG_NAME_MESSAGE = "Name argument is null, expected: String";
    private static final String ARG_PATTERN_MESSAGE = "Pattern argument is null, expected: Pattern";
    private static final String ARG_CLASS_MESSAGE = "Class argument is null, expected: Class<T extends INamed>";
    private final Map<String, Set<INamed>> nameIndex = new HashMap<String, Set<INamed>>();

    public @NonNull Set<@NonNull ? extends INamed> getElements(@NonNull String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)ARG_NAME_MESSAGE);
        return this.getElements(name, INamed.class);
    }

    public <T extends INamed> @NonNull Set<@NonNull ? extends T> getElements(@NonNull String name, @NonNull Class<T> targetClass) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)ARG_NAME_MESSAGE);
        Preconditions.checkArgument((targetClass != null ? 1 : 0) != 0, (Object)ARG_CLASS_MESSAGE);
        HashSet<INamed> result = new HashSet<INamed>();
        Set<INamed> values = this.nameIndex.get(name);
        if (values != null) {
            for (INamed namedObject : values) {
                if (!targetClass.isInstance(namedObject)) continue;
                result.add((INamed)targetClass.cast(namedObject));
            }
        }
        return result;
    }

    public @NonNull Set<@NonNull ? extends INamed> getElements(@NonNull Pattern namePattern) {
        Preconditions.checkArgument((namePattern != null ? 1 : 0) != 0, (Object)ARG_PATTERN_MESSAGE);
        return this.getElements(namePattern, INamed.class);
    }

    public <T extends INamed> @NonNull Set<@NonNull ? extends T> getElements(@NonNull Pattern namePattern, @NonNull Class<T> targetClass) {
        Preconditions.checkArgument((namePattern != null ? 1 : 0) != 0, (Object)ARG_PATTERN_MESSAGE);
        Preconditions.checkArgument((targetClass != null ? 1 : 0) != 0, (Object)ARG_CLASS_MESSAGE);
        HashSet<INamed> result = new HashSet<INamed>();
        for (Map.Entry<String, Set<INamed>> entry : this.nameIndex.entrySet()) {
            if (!namePattern.matcher(entry.getKey()).matches()) continue;
            for (INamed namedObject : entry.getValue()) {
                if (!targetClass.isInstance(namedObject)) continue;
                result.add((INamed)targetClass.cast(namedObject));
            }
        }
        return result;
    }

    protected void selfAdapt(Notification notification) {
        Object notifier = notification.getNotifier();
        if (notifier instanceof INamed && notification.getFeature() == AmaltheaPackage.eINSTANCE.getINamed_Name()) {
            INamed namedObj = (INamed)notifier;
            switch (notification.getEventType()) {
                case 2: {
                    String oldValue = notification.getOldStringValue();
                    this.removeFromNameIndex(namedObj, oldValue);
                    break;
                }
                case 1: {
                    String oldValue = notification.getOldStringValue();
                    this.removeFromNameIndex(namedObj, oldValue);
                    String newValue = notification.getNewStringValue();
                    this.addToNameIndex(namedObj, newValue);
                }
            }
        } else {
            super.selfAdapt(notification);
        }
    }

    protected void setTarget(EObject target) {
        super.setTarget(target);
        if (target instanceof INamed) {
            INamed namedObj = (INamed)target;
            this.addToNameIndex(namedObj, namedObj.getName());
        }
    }

    protected void unsetTarget(EObject target) {
        super.unsetTarget(target);
        if (target instanceof INamed) {
            INamed namedObj = (INamed)target;
            this.removeFromNameIndex(namedObj, namedObj.getName());
        }
    }

    private void addToNameIndex(INamed eObject, String name) {
        if (name != null) {
            Set<INamed> objSet = this.nameIndex.get(name);
            if (objSet == null) {
                objSet = new HashSet<INamed>();
                this.nameIndex.put(name, objSet);
            }
            objSet.add(eObject);
        }
    }

    private void removeFromNameIndex(INamed eObject, String name) {
        Set<INamed> objSet;
        if (name != null && (objSet = this.nameIndex.get(name)) != null) {
            objSet.remove(eObject);
            if (objSet.isEmpty()) {
                this.nameIndex.remove(name);
            }
        }
    }

    protected void handleContainment(Notification notification) {
        switch (notification.getEventType()) {
            case 9: {
                Notifier oldValue = (Notifier)notification.getOldValue();
                if (!oldValue.eAdapters().contains((Object)this)) break;
                this.removeAdapter(oldValue);
                Notifier newValue = (Notifier)notification.getNewValue();
                this.addAdapter(newValue);
                break;
            }
            case 2: {
                Notifier newValue;
                Object oldValue = notification.getOldValue();
                if (oldValue == Boolean.TRUE || oldValue == Boolean.FALSE) break;
                if (oldValue != null) {
                    this.removeAdapter((Notifier)oldValue);
                }
                if ((newValue = (Notifier)notification.getNewValue()) == null) break;
                this.addAdapter(newValue);
                break;
            }
            case 1: {
                Notifier newValue;
                Notifier oldValue = (Notifier)notification.getOldValue();
                if (oldValue != null) {
                    this.removeAdapter(oldValue);
                }
                if ((newValue = (Notifier)notification.getNewValue()) == null) break;
                this.addAdapter(newValue);
                break;
            }
            case 3: {
                Notifier newValue = (Notifier)notification.getNewValue();
                if (newValue == null) break;
                this.addAdapter(newValue);
                break;
            }
            case 5: {
                Collection newValues = (Collection)notification.getNewValue();
                for (Notifier newValue : newValues) {
                    this.addAdapter(newValue);
                }
                break;
            }
            case 4: {
                Notifier oldValue = (Notifier)notification.getOldValue();
                if (oldValue == null) break;
                this.removeAdapter(oldValue);
                break;
            }
            case 6: {
                Collection oldValues = (Collection)notification.getOldValue();
                for (Notifier oldContentValue : oldValues) {
                    this.removeAdapter(oldContentValue);
                }
                break;
            }
        }
    }
}

